/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting.volume;

import com.itextpdf.licensing.base.reporting.volume.VolumeData;
import com.itextpdf.licensing.base.reporting.volume.VolumeEventDataHandler;
import com.itextpdf.licensing.base.util.InterruptibleThread;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

public final class VolumeEventDataHandlerUtil {
    private static final ConcurrentHashMap<Object, Thread> shutdownHooks = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Object, InterruptibleThread> scheduledTasks = new ConcurrentHashMap();

    private VolumeEventDataHandlerUtil() {
    }

    public static void registerProcessAllShutdownHook(VolumeEventDataHandler dataHandler) {
        if (shutdownHooks.containsKey(dataHandler)) {
            return;
        }
        Thread shutdownHook = new Thread(dataHandler::tryProcessRest);
        shutdownHooks.put(dataHandler, shutdownHook);
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
        catch (SecurityException security) {
            LoggerFactory.getLogger(VolumeEventDataHandlerUtil.class).error("Unable to register event data handler shutdown hook because of security reasons.");
            shutdownHooks.remove(dataHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void disableShutdownHooks(VolumeEventDataHandler dataHandler) {
        Thread toDisable = shutdownHooks.remove(dataHandler);
        if (toDisable != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(toDisable);
            }
            catch (SecurityException security) {
                LoggerFactory.getLogger(VolumeEventDataHandlerUtil.class).error("Unable to unregister event data handler shutdown hook because of security permissions.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void registerTimedProcessing(VolumeEventDataHandler dataHandler) {
        if (scheduledTasks.containsKey(dataHandler)) {
            return;
        }
        InterruptibleThread.InterruptibleTask task = new InterruptibleThread.InterruptibleTask(() -> dataHandler.tryProcessNextAsync(Boolean.FALSE), () -> dataHandler.getWaitTime().getTime());
        InterruptibleThread thread = new InterruptibleThread(task);
        scheduledTasks.put(dataHandler, thread);
        thread.setDaemon(true);
        thread.start();
    }

    public static void disableTimedProcessing(VolumeEventDataHandler dataHandler) {
        InterruptibleThread toDisable = scheduledTasks.remove(dataHandler);
        if (toDisable != null) {
            toDisable.interrupt();
        }
    }

    public static class BiggerCountComparator
    implements Comparator<VolumeData> {
        @Override
        public int compare(VolumeData o1, VolumeData o2) {
            return Long.compare(o2.getCount(), o1.getCount());
        }
    }
}

