/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.storage;

import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.reporting.AwsResourcesCreator;
import com.itextpdf.licensing.base.storage.ILicenseFileStorageClient;
import com.itextpdf.licensing.base.util.JsonMapperUtil;
import com.itextpdf.licensing.remote.LoggingUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayClient;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RemoteLicenseFileStorageClient
implements ILicenseFileStorageClient {
    private static final int HTTP_OK_STATUS = 200;
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteLicenseFileStorageClient.class);
    private static final String AWS_API_LICENSE_UPDATE_HOST = "sdk-login.licensing.itextpdf.com";
    private static final String AWS_API_LICENSE_UPDATE_PATH_PATH = "/v1/license-update";
    private final ApiGatewayClient updateLicenseRequestClient = AwsResourcesCreator.createApiGatewayClientWithoutAuth("sdk-login.licensing.itextpdf.com", "/v1/license-update");

    RemoteLicenseFileStorageClient() {
    }

    @Override
    public List<LicenseFile> getLicenseFilesFromStorage(LicenseFile sourceLicenseFile) {
        String jsonRequestBody = JsonMapperUtil.serializeToMinimalString(sourceLicenseFile);
        ApiGatewayResponse response = null;
        try {
            LoggingUtil.traceLog((Logger)LOGGER, (String)"Attempt to make post request to remote storage with body: {0}", (Object[])new Object[]{jsonRequestBody});
            response = this.updateLicenseRequestClient.makePostRequest(jsonRequestBody);
            LoggingUtil.traceLog((Logger)LOGGER, (String)"Successfully made post request to remote storage, response: {0}", (Object[])new Object[]{response.getBody()});
        }
        catch (Exception ignore) {
            LoggingUtil.traceLog((Logger)LOGGER, (String)"Failed to make post request to remote storage", (Exception)ignore, (Object[])new Object[0]);
        }
        if (response == null || response.getStatus() != 200 || response.getBody() == null) {
            LOGGER.info("Exception during http request to license file remote storage.");
            return Collections.emptyList();
        }
        return Arrays.asList(JsonMapperUtil.deserializeLicenseFileArrayFromString(response.getBody()));
    }
}

