/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.actions.sequence.SequenceId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class ReportedEventsSet {
    private final WeakHashMap<SequenceId, Map<String, Set<String>>> eventsMap = new WeakHashMap();

    public void putEvent(AbstractProductProcessITextEvent event) {
        String productName;
        Set<String> eventTypesSet;
        SequenceId sequenceId = event.getSequenceId();
        if (sequenceId == null) {
            return;
        }
        Map<String, Set<String>> productsMap = this.eventsMap.get(sequenceId);
        if (productsMap == null) {
            productsMap = new HashMap<String, Set<String>>();
            this.eventsMap.put(sequenceId, productsMap);
        }
        if ((eventTypesSet = productsMap.get(productName = event.getProductName())) == null) {
            eventTypesSet = new HashSet<String>();
            productsMap.put(productName, eventTypesSet);
        }
        eventTypesSet.add(event.getEventType());
    }

    public boolean containsEvent(AbstractProductProcessITextEvent event) {
        String productName;
        SequenceId sequenceId = event.getSequenceId();
        if (sequenceId == null) {
            return false;
        }
        if (!this.eventsMap.containsKey(sequenceId)) {
            return false;
        }
        Map<String, Set<String>> productsMap = this.eventsMap.get(sequenceId);
        if (!productsMap.containsKey(productName = event.getProductName())) {
            return false;
        }
        return productsMap.get(productName).contains(event.getEventType());
    }
}

