/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote.auth;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.licensing.remote.LoggingUtil;
import com.itextpdf.licensing.remote.PortingUtil;
import com.itextpdf.licensing.remote.auth.AwsCredentialsData;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AwsSign4 {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwsSign4.class);
    public static final String HOST_HEADER = "Host";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String X_AMZ_DATE_HEADER = "X-Amz-Date";
    public static final String X_AMZ_SECURITY_TOKEN_HEADER = "X-Amz-Security-Token";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String HASHING_ALGORITHM = "AWS4-HMAC-SHA256";
    private static final String AWS4_REQUEST = "aws4_request";
    private static final String STANDARDIZED_QUERY_STRING = "";

    private AwsSign4() {
    }

    public static void applyAwsSign4(String host, String path, String httpMethod, String serviceName, TreeMap<String, String> headers, String body, AwsCredentialsData credentialsData) {
        if (credentialsData == null) {
            return;
        }
        if (!headers.containsKey(CONTENT_TYPE_HEADER)) {
            throw new IllegalArgumentException("Content-Type header is required for signing.");
        }
        String timestamp = PortingUtil.getAwsCurrentUtcTimestamp();
        String datestamp = timestamp.substring(0, timestamp.indexOf(84));
        headers.put(HOST_HEADER, host);
        headers.put(X_AMZ_DATE_HEADER, timestamp);
        String session = credentialsData.getSession();
        if (session != null) {
            headers.put(X_AMZ_SECURITY_TOKEN_HEADER, session);
        }
        String awsSign = AwsSign4.getSignature(path, httpMethod, serviceName, headers, body, credentialsData, datestamp, timestamp);
        headers.put(AUTHORIZATION_HEADER, awsSign);
        LoggingUtil.traceLog(LOGGER, "AWS Signature headers:\nHost: {0}\nX-Amz-Date: {1}\nX-Amz-Security-Token: {2}\nAuthorization: {3}", host, timestamp, session, LoggingUtil.redactPii(awsSign));
    }

    private static String getSignature(String path, String httpMethod, String serviceName, TreeMap<String, String> headers, String body, AwsCredentialsData credentialsData, String datestamp, String timestamp) {
        LoggingUtil.traceLog(LOGGER, "AWS Signature path: {0}, httpMethod: {1}, serviceName: {2}", path, httpMethod, serviceName);
        StringBuilder standardizedHeadersBuilder = new StringBuilder();
        StringBuilder signedHeadersBuilder = new StringBuilder();
        for (Map.Entry<String, String> header : headers.entrySet()) {
            standardizedHeadersBuilder.append(StringNormalizer.toLowerCase((String)header.getKey())).append(':').append(header.getValue()).append('\n');
            signedHeadersBuilder.append(StringNormalizer.toLowerCase((String)header.getKey())).append(';');
        }
        String standardizedHeaders = standardizedHeadersBuilder.toString();
        LoggingUtil.traceLog(LOGGER, "AWS Signature standardized headers: {0}", standardizedHeaders);
        String signedHeaders = signedHeadersBuilder.toString();
        signedHeaders = signedHeaders.substring(0, signedHeaders.length() - 1);
        String payloadHash = PortingUtil.sha256HashCalculate(body.getBytes(StandardCharsets.UTF_8));
        String standardizedRequest = httpMethod + "\n" + path + "\n" + STANDARDIZED_QUERY_STRING + "\n" + standardizedHeaders + "\n" + signedHeaders + "\n" + payloadHash;
        String regionName = credentialsData.getRegion().id();
        String credentialScope = datestamp + "/" + regionName + "/" + serviceName + "/" + AWS4_REQUEST;
        String sts = "AWS4-HMAC-SHA256\n" + timestamp + "\n" + credentialScope + "\n" + PortingUtil.sha256HashCalculate(standardizedRequest.getBytes(StandardCharsets.UTF_8));
        byte[] signatureKey = AwsSign4.createSignatureKey(credentialsData.getSecret(), datestamp, regionName, serviceName);
        String signature = PortingUtil.toHexString(PortingUtil.hmacSha256HashCalculate(signatureKey, sts));
        return "AWS4-HMAC-SHA256 Credential=" + credentialsData.getAccess() + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
    }

    private static byte[] createSignatureKey(String key, String datestamp, String region, String service) {
        byte[] keyDate = PortingUtil.hmacSha256HashCalculate(("AWS4" + key).getBytes(StandardCharsets.UTF_8), datestamp);
        byte[] keyString = PortingUtil.hmacSha256HashCalculate(keyDate, region);
        byte[] keyService = PortingUtil.hmacSha256HashCalculate(keyString, service);
        return PortingUtil.hmacSha256HashCalculate(keyService, AWS4_REQUEST);
    }
}

