/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.filters;

import com.itextpdf.io.source.ByteBuffer;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.pdf.MemoryLimitsAwareFilter;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import java.io.ByteArrayOutputStream;

public class ASCIIHexDecodeFilter
extends MemoryLimitsAwareFilter {
    public static byte[] ASCIIHexDecode(byte[] in) {
        return ASCIIHexDecodeFilter.ASCIIHexDecodeInternal(in, new ByteArrayOutputStream());
    }

    @Override
    public byte[] decode(byte[] b, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) {
        ByteArrayOutputStream outputStream = this.enableMemoryLimitsAwareHandler(streamDictionary);
        b = ASCIIHexDecodeFilter.ASCIIHexDecodeInternal(b, outputStream);
        return b;
    }

    private static byte[] ASCIIHexDecodeInternal(byte[] in, ByteArrayOutputStream out) {
        int ch;
        boolean first = true;
        int n1 = 0;
        for (int k = 0; k < in.length && (ch = in[k] & 0xFF) != 62; ++k) {
            if (PdfTokenizer.isWhitespace(ch)) continue;
            int n = ByteBuffer.getHex(ch);
            if (n == -1) {
                throw new PdfException("illegal character in ASCIIHexDecode.");
            }
            if (first) {
                n1 = n;
            } else {
                out.write((byte)((n1 << 4) + n));
            }
            first = !first;
        }
        if (!first) {
            out.write((byte)(n1 << 4));
        }
        return out.toByteArray();
    }
}

