/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssFile;
import com.itextpdf.tool.xml.css.CssFileProcessor;
import com.itextpdf.tool.xml.css.CssFiles;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.CssInheritanceRules;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.DefaultCssInheritanceRules;
import com.itextpdf.tool.xml.exceptions.CssResolverException;
import com.itextpdf.tool.xml.net.FileRetrieve;
import com.itextpdf.tool.xml.net.FileRetrieveImpl;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class StyleAttrCSSResolver
implements CSSResolver {
    public static final String STYLE = "style";
    private final CssUtils utils;
    private CssInheritanceRules inherit;
    private final CssFiles cssFiles;
    private FileRetrieve retrieve;

    public StyleAttrCSSResolver() {
        this((CssFiles)new CssFilesImpl(), CssUtils.getInstance());
    }

    public StyleAttrCSSResolver(CssFiles cssFiles) {
        this(cssFiles, CssUtils.getInstance());
    }

    public StyleAttrCSSResolver(CssFiles cssFiles, CssUtils utils) {
        this(new DefaultCssInheritanceRules(), cssFiles, utils);
    }

    public StyleAttrCSSResolver(CssInheritanceRules rules, CssFiles cssFiles, CssUtils utils) {
        this(rules, cssFiles, utils, new FileRetrieveImpl());
    }

    public StyleAttrCSSResolver(CssInheritanceRules rules, CssFiles cssFiles, CssUtils utils, FileRetrieve fileRetrieve) {
        this.utils = utils;
        this.cssFiles = cssFiles;
        this.inherit = rules;
        this.retrieve = fileRetrieve;
    }

    public StyleAttrCSSResolver(CssFiles cssFiles, FileRetrieve r) {
        this(new DefaultCssInheritanceRules(), cssFiles, CssUtils.getInstance(), r);
    }

    @Override
    public void resolveStyles(Tag t) {
        Map<Object, Object> tagCss = new LinkedHashMap();
        Map<String, String> listCss = null;
        if (null != this.cssFiles && this.cssFiles.hasFiles()) {
            tagCss = this.cssFiles.getCSS(t);
            if (t.getName().equalsIgnoreCase("p") || t.getName().equalsIgnoreCase("td")) {
                listCss = this.cssFiles.getCSS(new Tag("ul"));
            }
        }
        if (null != t.getAttributes() && !t.getAttributes().isEmpty()) {
            String styleAtt;
            if (t.getAttributes().get("cellpadding") != null) {
                tagCss.putAll(this.utils.parseBoxValues(t.getAttributes().get("cellpadding"), "cellpadding-", ""));
            }
            if (t.getAttributes().get("cellspacing") != null) {
                tagCss.putAll(this.utils.parseBoxValues(t.getAttributes().get("cellspacing"), "cellspacing-", ""));
            }
            if (null != (styleAtt = t.getAttributes().get(STYLE)) && styleAtt.length() > 0) {
                LinkedHashMap tagAttrCss = new LinkedHashMap();
                String[] stringArray = styleAtt.split(";");
                for (String s : stringArray) {
                    String[] part = s.split(":", 2);
                    if (part.length != 2) continue;
                    String key = this.utils.stripDoubleSpacesTrimAndToLowerCase(part[0]);
                    String value = this.utils.stripDoubleSpacesAndTrim(part[1]);
                    this.splitRules(tagAttrCss, key, value);
                }
                for (Map.Entry entry : tagAttrCss.entrySet()) {
                    tagCss.put(entry.getKey(), entry.getValue());
                }
            }
        }
        Map<String, String> css = t.getCSS();
        if (t.getName() != null) {
            if (t.getName().equalsIgnoreCase("i") || t.getName().equalsIgnoreCase("cite") || t.getName().equalsIgnoreCase("em") || t.getName().equalsIgnoreCase("var") || t.getName().equalsIgnoreCase("dfn") || t.getName().equalsIgnoreCase("address")) {
                tagCss.put("font-style", "italic");
            } else if (t.getName().equalsIgnoreCase("b") || t.getName().equalsIgnoreCase("strong")) {
                tagCss.put("font-weight", "bold");
            } else if (t.getName().equalsIgnoreCase("u") || t.getName().equalsIgnoreCase("ins")) {
                tagCss.put("text-decoration", "underline");
            } else if (t.getName().equalsIgnoreCase("s") || t.getName().equalsIgnoreCase("strike") || t.getName().equalsIgnoreCase("del")) {
                tagCss.put("text-decoration", "line-through");
            } else if (t.getName().equalsIgnoreCase("big")) {
                tagCss.put("font-size", "larger");
            } else if (t.getName().equalsIgnoreCase("small")) {
                tagCss.put("font-size", "smaller");
            }
        }
        if (listCss != null && listCss.containsKey("list-style-type")) {
            css.put("list-style-type", (String)listCss.get("list-style-type"));
        }
        if (this.mustInherit(t.getName()) && null != t.getParent() && null != t.getParent().getCSS()) {
            if (null != this.inherit) {
                for (Map.Entry entry : t.getParent().getCSS().entrySet()) {
                    String key = (String)entry.getKey();
                    if ((!tagCss.containsKey(key) || !"inherit".equals(tagCss.get(key))) && !this.canInherite(t, key)) continue;
                    if (key.contains("cellpadding") && ("td".equals(t.getName()) || "th".equals(t.getName()))) {
                        String string = key.replace("cellpadding", "padding");
                        tagCss.put(string, entry.getValue());
                        continue;
                    }
                    css.put(key, (String)entry.getValue());
                }
            } else {
                css.putAll(t.getParent().getCSS());
            }
        }
        if (t.getName() != null) {
            if (t.getName().equals("font")) {
                String size;
                String string;
                String font_family = t.getAttributes().get("face");
                if (font_family != null) {
                    css.put("font-family", font_family);
                }
                if ((string = t.getAttributes().get("color")) != null) {
                    css.put("color", string);
                }
                if ((size = t.getAttributes().get("size")) != null) {
                    if (size.equals("1")) {
                        css.put("font-size", "xx-small");
                    } else if (size.equals("2")) {
                        css.put("font-size", "x-small");
                    } else if (size.equals("3")) {
                        css.put("font-size", "small");
                    } else if (size.equals("4")) {
                        css.put("font-size", "medium");
                    } else if (size.equals("5")) {
                        css.put("font-size", "large");
                    } else if (size.equals("6")) {
                        css.put("font-size", "x-large");
                    } else if (size.equals("7")) {
                        css.put("font-size", "xx-large");
                    }
                }
            } else if (t.getName().equals("a")) {
                css.put("text-decoration", "underline");
                css.put("color", "blue");
            }
        }
        for (Map.Entry<Object, Object> entry : tagCss.entrySet()) {
            if ("inherit".equalsIgnoreCase((String)entry.getValue())) continue;
            if (((String)entry.getKey()).equals("text-decoration")) {
                String oldValue = css.get(entry.getKey());
                css.put((String)entry.getKey(), this.mergeTextDecorationRules(oldValue, (String)entry.getValue()));
                continue;
            }
            css.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private String mergeTextDecorationRules(String oldRule, String newRule) {
        if ("none".equals(newRule)) {
            return newRule;
        }
        TreeSet attrSet = new TreeSet();
        if (oldRule != null) {
            Collections.addAll(attrSet, oldRule.split("\\s+"));
        }
        if (newRule != null) {
            Collections.addAll(attrSet, newRule.split("\\s+"));
        }
        StringBuilder resultantStr = new StringBuilder();
        for (String attr : attrSet) {
            if (attr.equals("none") || attr.equals("inherit")) continue;
            if (resultantStr.length() > 0) {
                resultantStr.append(' ');
            }
            resultantStr.append(attr);
        }
        return resultantStr.length() == 0 ? null : resultantStr.toString();
    }

    private void splitRules(Map<String, String> css, String key, String value) {
        if ("border".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBorder(value));
        } else if ("border-top".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBorder(value, "border-top"));
        } else if ("border-bottom".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBorder(value, "border-bottom"));
        } else if ("border-left".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBorder(value, "border-left"));
        } else if ("border-right".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBorder(value, "border-right"));
        } else if ("margin".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "margin-", ""));
        } else if ("border-width".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "border-", "-width"));
        } else if ("border-style".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "border-", "-style"));
        } else if ("border-color".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "border-", "-color"));
        } else if ("padding".equalsIgnoreCase(key)) {
            css.putAll(this.utils.parseBoxValues(value, "padding-", ""));
        } else if ("font".equalsIgnoreCase(key)) {
            css.putAll(this.utils.processFont(value));
        } else if ("list-style".equalsIgnoreCase(key)) {
            css.putAll(this.utils.processListStyle(value));
        } else if (key.toLowerCase().contains("background")) {
            Map<String, String> backgroundStyles = this.utils.processBackground(value);
            for (String backgroundKey : backgroundStyles.keySet()) {
                if (css.containsKey(backgroundKey)) continue;
                css.put(backgroundKey, backgroundStyles.get(backgroundKey));
            }
        } else {
            css.put(key, value);
        }
    }

    public void setCssInheritance(CssInheritanceRules cssInheritanceRules) {
        this.inherit = cssInheritanceRules;
    }

    private boolean canInherite(Tag t, String property) {
        if (null != this.inherit) {
            return this.inherit.inheritCssSelector(t, property);
        }
        return true;
    }

    private boolean mustInherit(String tag) {
        if (null != this.inherit) {
            return this.inherit.inheritCssTag(tag);
        }
        return true;
    }

    @Override
    public void addCss(String content, String charSet, boolean isPersistent) throws CssResolverException {
        CssFileProcessor proc = new CssFileProcessor();
        try {
            this.retrieve.processFromStream(new ByteArrayInputStream(content.getBytes(charSet)), proc);
            CssFile css = proc.getCss();
            css.isPersistent(isPersistent);
            this.cssFiles.add(css);
        }
        catch (UnsupportedEncodingException e) {
            throw new CssResolverException(e);
        }
        catch (IOException e) {
            throw new CssResolverException(e);
        }
    }

    @Override
    public void addCssFile(String href, boolean isPersistent) throws CssResolverException {
        CssFileProcessor cssFileProcessor = new CssFileProcessor();
        try {
            this.retrieve.processFromHref(href, cssFileProcessor);
        }
        catch (IOException e) {
            throw new CssResolverException(e);
        }
        CssFile css = cssFileProcessor.getCss();
        css.isPersistent(isPersistent);
        this.cssFiles.add(css);
    }

    @Override
    public void addCss(CssFile file) {
        this.cssFiles.add(file);
    }

    @Override
    public void addCss(String content, boolean isPersistent) throws CssResolverException {
        CssFileProcessor proc = new CssFileProcessor();
        FileRetrieveImpl retrieve = new FileRetrieveImpl();
        try {
            retrieve.processFromStream(new ByteArrayInputStream(content.getBytes()), proc);
            CssFile css = proc.getCss();
            css.isPersistent(isPersistent);
            this.cssFiles.add(css);
        }
        catch (UnsupportedEncodingException e) {
            throw new CssResolverException(e);
        }
        catch (IOException e) {
            throw new CssResolverException(e);
        }
    }

    public void setCssInheritanceRules(CssInheritanceRules inherit) {
        this.inherit = inherit;
    }

    @Override
    public void setFileRetrieve(FileRetrieve retrieve) {
        this.retrieve = retrieve;
    }

    @Override
    public CSSResolver clear() throws CssResolverException {
        this.cssFiles.clear();
        return this;
    }
}

