/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.parser;

import com.itextpdf.text.xml.XMLUtil;
import com.itextpdf.text.xml.simpleparser.IanaEncodings;
import com.itextpdf.tool.xml.parser.State;
import com.itextpdf.tool.xml.parser.StateController;
import com.itextpdf.tool.xml.parser.TagState;
import com.itextpdf.tool.xml.parser.XMLParserListener;
import com.itextpdf.tool.xml.parser.XMLParserMemory;
import com.itextpdf.tool.xml.parser.io.EncodingUtil;
import com.itextpdf.tool.xml.parser.io.MonitorInputReader;
import com.itextpdf.tool.xml.parser.io.ParserMonitor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

@Deprecated
public class XMLParser {
    private State state;
    private final StateController controller;
    private final List<XMLParserListener> listeners;
    private final XMLParserMemory memory;
    private ParserMonitor monitor;
    private String text = null;
    private TagState tagState;
    private Charset charset;
    private boolean decodeSpecialChars = true;

    public XMLParser() {
        this(true, Charset.defaultCharset());
    }

    public XMLParser(boolean isHtml, Charset charset) {
        this.charset = charset;
        this.controller = new StateController(this, isHtml);
        this.controller.unknown();
        this.memory = new XMLParserMemory(isHtml);
        this.listeners = new CopyOnWriteArrayList<XMLParserListener>();
    }

    public XMLParser(XMLParserListener listener, Charset charset) {
        this(true, charset);
        this.listeners.add(listener);
    }

    public XMLParser(boolean isHtml, XMLParserListener listener, Charset charset) {
        this(isHtml, charset);
        this.listeners.add(listener);
    }

    public XMLParser(boolean b, XMLParserListener listener) {
        this(b, Charset.defaultCharset());
        this.listeners.add(listener);
    }

    public XMLParser(XMLParserListener listener) {
        this(true, Charset.defaultCharset());
        this.listeners.add(listener);
    }

    public XMLParser addListener(XMLParserListener pl) {
        this.listeners.add(pl);
        return this;
    }

    public XMLParser removeListener(XMLParserListener pl) {
        this.listeners.remove(pl);
        return this;
    }

    public void parse(InputStream in) throws IOException {
        this.parse(new InputStreamReader(in));
    }

    public void parse(InputStream in, boolean detectEncoding) throws IOException {
        if (detectEncoding) {
            this.parse(this.detectEncoding(new BufferedInputStream(in)));
        } else {
            this.parse(in);
        }
    }

    public void parse(InputStream in, Charset charSet) throws IOException {
        this.charset = charSet;
        InputStreamReader reader = new InputStreamReader(in, charSet);
        this.parse(reader);
    }

    public void parse(Reader reader) throws IOException {
        this.parseWithReader(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseWithReader(Reader reader) throws IOException {
        for (XMLParserListener l : this.listeners) {
            l.init();
        }
        Reader r = this.monitor != null ? new MonitorInputReader(reader, this.monitor) : reader;
        char[] read = new char[1];
        try {
            while (-1 != r.read(read)) {
                this.state.process(read[0]);
            }
        }
        finally {
            for (XMLParserListener l : this.listeners) {
                l.close();
            }
            r.close();
        }
    }

    public InputStreamReader detectEncoding(InputStream in) throws IOException, UnsupportedEncodingException {
        in.mark(1028);
        byte[] b4 = new byte[4];
        int count = in.read(b4);
        if (count != 4) {
            throw new IOException("Insufficient length");
        }
        String encoding = XMLUtil.getEncodingName(b4);
        String decl = null;
        if (encoding.equals("UTF-8")) {
            int c;
            StringBuffer sb = new StringBuffer();
            while ((c = in.read()) != -1 && c != 62) {
                sb.append((char)c);
            }
            decl = sb.toString();
        } else if (encoding.equals("CP037")) {
            int c;
            ByteArrayOutputStream bi = new ByteArrayOutputStream();
            while ((c = in.read()) != -1 && c != 110) {
                bi.write(c);
            }
            decl = new String(bi.toByteArray(), "CP037");
        }
        if (decl != null && (decl = EncodingUtil.getDeclaredEncoding(decl)) != null) {
            encoding = decl;
        }
        in.reset();
        return new InputStreamReader(in, IanaEncodings.getJavaEncoding(encoding));
    }

    protected void setState(State state) {
        this.state = state;
    }

    public XMLParser append(char character) {
        this.memory.current().append(character);
        return this;
    }

    public StateController selectState() {
        return this.controller;
    }

    public void unknownData() {
        for (XMLParserListener l : this.listeners) {
            l.unknownText(this.memory.current().toString());
        }
    }

    public void flush() {
        this.memory.resetBuffer();
    }

    public String current() {
        return this.memory.current().toString();
    }

    public XMLParserMemory memory() {
        return this.memory;
    }

    public void startElement() {
        this.currentTagState(TagState.OPEN);
        String tagName = this.memory.getCurrentTag();
        Map<String, String> attributes = this.memory.getAttributes();
        if (tagName.startsWith("?")) {
            this.memory().processingInstruction().setLength(0);
        }
        this.callText();
        for (XMLParserListener l : this.listeners) {
            l.startElement(tagName, attributes, this.memory.getNameSpace());
        }
        this.memory().flushNameSpace();
    }

    private void callText() {
        if (null != this.text && this.text.length() > 0) {
            for (XMLParserListener l : this.listeners) {
                l.text(this.text);
            }
            this.text = null;
        }
    }

    public void endElement() {
        this.currentTagState(TagState.CLOSE);
        this.callText();
        for (XMLParserListener l : this.listeners) {
            l.endElement(this.memory.getCurrentTag(), this.memory.getNameSpace());
        }
    }

    public void text(String bs) {
        this.text = bs;
    }

    public void comment() {
        this.callText();
        for (XMLParserListener l : this.listeners) {
            l.comment(this.memory.current().toString());
        }
    }

    public char currentLastChar() {
        int length;
        StringBuilder current2 = this.memory.current();
        CharSequence current = current2.subSequence((length = current2.length()) - 2, length - 1);
        if (current.length() > 0) {
            return (char)(current.length() - 1);
        }
        return ' ';
    }

    public String currentTag() {
        return this.memory.getCurrentTag();
    }

    public TagState currentTagState() {
        return this.tagState;
    }

    private void currentTagState(TagState state) {
        this.tagState = state;
    }

    public void setMonitor(ParserMonitor monitor) {
        this.monitor = monitor;
    }

    public void setDecodeSpecialChars(boolean decodeSpecialChars) {
        this.decodeSpecialChars = decodeSpecialChars;
    }

    public boolean isDecodeSpecialChars() {
        return this.decodeSpecialChars;
    }

    public String bufferToString() {
        return this.memory.current().toString();
    }

    public XMLParser append(char[] bytes) {
        this.memory.current().append(bytes);
        return this;
    }

    public int bufferSize() {
        return null != this.memory.current() ? this.memory.current().length() : 0;
    }

    public XMLParser append(String string) {
        this.memory.current().append(string);
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

