/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.awt.geom.Point;
import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.licensekey.LicenseKey;
import com.itextpdf.licensekey.LicenseKeyProduct;
import com.itextpdf.licensekey.LicenseKeyProductFeature;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PRAcroForm;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfAWriter;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.security.ExternalDecryptionProcess;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.css.apply.XFAChunkCssApplier;
import com.itextpdf.tool.xml.css.apply.XFACssAppliersImpl;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.CssAppliersAware;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.pipeline.ctx.ObjectContext;
import com.itextpdf.tool.xml.xtra.xfa.MetaData;
import com.itextpdf.tool.xml.xtra.xfa.SettableLatch;
import com.itextpdf.tool.xml.xtra.xfa.XFAFlattenerProperties;
import com.itextpdf.tool.xml.xtra.xfa.XFAFormStateApplier;
import com.itextpdf.tool.xml.xtra.xfa.XFAWorker;
import com.itextpdf.tool.xml.xtra.xfa.checksum.XFAChecksumCalculator;
import com.itextpdf.tool.xml.xtra.xfa.checksum.XFANormalizer;
import com.itextpdf.tool.xml.xtra.xfa.config.AppConfig;
import com.itextpdf.tool.xml.xtra.xfa.config.HostConfig;
import com.itextpdf.tool.xml.xtra.xfa.element.BreakConditions;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentArea;
import com.itextpdf.tool.xml.xtra.xfa.element.PageArea;
import com.itextpdf.tool.xml.xtra.xfa.element.PageSet;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.element.TrailerLeaderElement;
import com.itextpdf.tool.xml.xtra.xfa.exceptions.IncorrectXFAStructureException;
import com.itextpdf.tool.xml.xtra.xfa.exceptions.XFAFlattenerUnexpectedUsageException;
import com.itextpdf.tool.xml.xtra.xfa.font.NoAcroFormFound;
import com.itextpdf.tool.xml.xtra.xfa.font.XFAFontProvider;
import com.itextpdf.tool.xml.xtra.xfa.font.XFAFontSettings;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataGroup;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataModel;
import com.itextpdf.tool.xml.xtra.xfa.js.JsForm;
import com.itextpdf.tool.xml.xtra.xfa.js.JsInstanceManager;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.JsTemplate;
import com.itextpdf.tool.xml.xtra.xfa.js.JsXfa;
import com.itextpdf.tool.xml.xtra.xfa.pipe.ConfigPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.DataPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.FormBuilder;
import com.itextpdf.tool.xml.xtra.xfa.pipe.FormBuilderPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.LocalePipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.PdfPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.TemplateBuilderPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.XFAFlattenerData;
import com.itextpdf.tool.xml.xtra.xfa.pipe.XdpPipeline;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubFormPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.TableLayoutManager;
import com.itextpdf.tool.xml.xtra.xfa.resolver.ConfigResolver;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.resolver.HrefResolver;
import com.itextpdf.tool.xml.xtra.xfa.resolver.IHrefResolver;
import com.itextpdf.tool.xml.xtra.xfa.resolver.LocaleResolver;
import com.itextpdf.tool.xml.xtra.xfa.tags.DataTag;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAPageAnnotationsCopier;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFAFlattener
implements CssAppliersAware {
    private static final int checkEveryN = 20;
    private static final String productName = "pdfXfa";
    private static final int productMajor = 2;
    private static final int productMinor = 0;
    private static final Set<String> entries = new HashSet<String>(Arrays.asList("preamble", "config", "template", "connectionSets", "localeSet", "xmpmeta", "postamble", "datasets", "form"));
    private XFAFlattenerProperties flattenerProperties;
    private XFAFontSettings fontSettings;
    private XFAFontProvider fontProvider;
    private XFATemplateTag formDom;
    private XFATemplateTag templateDom;
    private CssAppliers cssAppliers;
    private LocaleResolver localeResolver;
    private Locale defaultLocale = Locale.US;
    private IHrefResolver hrefResolver = new HrefResolver(null);
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private int counter = 0;
    private LicenseKeyProduct product;
    private SubFormPositioner formDomPositioner;
    private PdfWriter writer;
    private Document document;
    private PdfReader reader = null;
    private PdfArray xfaImagesArr = null;
    private FlattenerContext flattenerContext = null;
    private ViewMode viewMode = ViewMode.ALL;
    private JsXfa jsXfa;
    private PageSet pageSet;
    private List<String> extraEventList;
    private boolean addStaticContent = false;
    private XFAPageAnnotationsCopier pageAnnotationsCopier = null;
    private AppConfig appConfig;
    private HostConfig hostConfig;
    private boolean applyFormState;
    private boolean flatteningIsCompleted = false;

    public XFAFlattener() {
        this.product = new LicenseKeyProduct(productName, 2, 0, new LicenseKeyProductFeature[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flatten(PdfReader reader, DataPipeline dataPipeline) throws IOException, InterruptedException {
        try {
            PdfObject xfaPackage = this.initFlattener(reader).getDirectObject(PdfName.XFA);
            PdfDictionary info = this.writer.getInfo();
            PdfDictionary origInfo = reader.getTrailer().getAsDict(PdfName.INFO);
            for (PdfName name : new PdfName[]{PdfName.TITLE, PdfName.AUTHOR, PdfName.SUBJECT, PdfName.KEYWORDS}) {
                PdfObject obj;
                if (info.get(name) != null || (obj = origInfo.get(name)) == null) continue;
                info.put(name, obj);
            }
            ConcurrentHashMap<String, ByteArrayInputStream> data = new ConcurrentHashMap<String, ByteArrayInputStream>();
            String normalizedTemplate = null;
            String normalizedDatasets = null;
            if (xfaPackage instanceof PdfArray) {
                XFAFlattenerData xfd;
                ObjectContext objectContext;
                XMLParser parser;
                XFAWorker worker;
                int i;
                boolean extractXdpStreamsConcurrently = false;
                if (extractXdpStreamsConcurrently) {
                    i = 0;
                    ArrayList<ExtractStreamRunner> list = new ArrayList<ExtractStreamRunner>();
                    SettableLatch sl = new SettableLatch();
                    for (Object o : (PdfArray)xfaPackage) {
                        String string;
                        if (o instanceof PdfString && entries.contains(string = ((PdfObject)o).toString())) {
                            int index = i + 1;
                            list.add(new ExtractStreamRunner(string, index, reader, (PdfArray)xfaPackage, sl, data));
                        }
                        ++i;
                    }
                    sl.set(list.size());
                    ExecutorService exec = Executors.newCachedThreadPool();
                    for (Runnable runnable : list) {
                        exec.submit(runnable);
                    }
                    sl.await();
                    exec.shutdown();
                } else {
                    i = 0;
                    PdfArray asArray = (PdfArray)xfaPackage;
                    for (PdfObject o : asArray) {
                        String str;
                        if (o instanceof PdfString && entries.contains(str = o.toString())) {
                            int n = i + 1;
                            PdfObject pdfObject2 = asArray.getPdfObject(n);
                            try {
                                data.put(str, this.getStreamContents(reader, pdfObject2));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        ++i;
                    }
                }
                if (this.localeResolver == null && data.containsKey("localeSet")) {
                    LocalePipeline locale = new LocalePipeline(null, this.defaultLocale);
                    worker = new XFAWorker(locale);
                    parser = new XMLParser(false, worker);
                    parser.parse((InputStream)data.get("localeSet"), true);
                    try {
                        this.localeResolver = (LocaleResolver)worker.getWorkerContext().get(locale.getContextKey());
                    }
                    catch (NoCustomContextException e) {
                        throw new RuntimeWorkerException(e);
                    }
                    data.remove("localeSet");
                }
                if (this.templateDom == null && data.containsKey("template")) {
                    TemplateBuilderPipeline template = new TemplateBuilderPipeline(this.cssAppliers);
                    worker = new XFAWorker(template);
                    parser = new XMLParser(false, worker);
                    parser.parse((InputStream)data.get("template"), true);
                    try {
                        objectContext = (ObjectContext)worker.getWorkerContext().get(template.getContextKey());
                        xfd = (XFAFlattenerData)objectContext.get();
                        this.templateDom = xfd.getTemplateDom();
                    }
                    catch (NoCustomContextException e) {
                        throw new RuntimeWorkerException(e);
                    }
                    normalizedTemplate = XFANormalizer.getNormalizedXml((ByteArrayInputStream)data.get("template"));
                    data.remove("template");
                    this.flattenerContext.setLegacyPlusPrint(template.isLegacyPlusPrint());
                    this.flattenerContext.setXfaVersion(template.getXfaVersion());
                }
                if (this.formDom == null && data.containsKey("form")) {
                    FormBuilderPipeline form = new FormBuilderPipeline(this.cssAppliers);
                    worker = new XFAWorker(form);
                    parser = new XMLParser(false, worker);
                    parser.parse((InputStream)data.get("form"), true);
                    try {
                        objectContext = (ObjectContext)worker.getWorkerContext().get(form.getContextKey());
                        xfd = (XFAFlattenerData)objectContext.get();
                        this.formDom = xfd.getTemplateDom();
                    }
                    catch (NoCustomContextException e) {
                        throw new RuntimeWorkerException(e);
                    }
                    data.remove("form");
                }
                if (dataPipeline == null && data.containsKey("datasets")) {
                    dataPipeline = new DataPipeline(null, this.cssAppliers, this.jsXfa);
                    XFAWorker worker2 = new XFAWorker(dataPipeline);
                    XMLParser parser2 = new XMLParser(false, worker2);
                    parser2.parse((InputStream)data.get("datasets"), true);
                    normalizedDatasets = XFANormalizer.getNormalizedXml((ByteArrayInputStream)data.get("datasets"));
                    data.remove("datasets");
                }
                if (data.containsKey("config")) {
                    ConfigPipeline configPipeline = new ConfigPipeline(null);
                    worker = new XFAWorker(configPipeline);
                    parser = new XMLParser(false, worker);
                    parser.parse((InputStream)data.get("config"), true);
                    try {
                        ConfigResolver configResolver = (ConfigResolver)worker.getWorkerContext().get(configPipeline.getContextKey());
                        this.flattenerContext.setConfigResolver(configResolver);
                    }
                    catch (NoCustomContextException e) {
                        throw new RuntimeWorkerException(e);
                    }
                    data.remove("config");
                }
            } else if (xfaPackage instanceof PdfStream) {
                byte[] b = PdfReader.getStreamBytes((PRStream)xfaPackage);
                DataPipeline xdpDataPipeline = this.processXDP(b);
                if (dataPipeline == null) {
                    dataPipeline = xdpDataPipeline;
                }
            }
            String baseProfile = this.templateDom.getAttributes().get("baseProfile");
            if (baseProfile != null && baseProfile.equalsIgnoreCase("interactiveForms")) {
                this.addStaticContent = true;
            }
            if (this.formDom != null && normalizedTemplate != null && normalizedDatasets != null && this.formDom.retrieveAttribute("checksum") != null) {
                String checkSum = XFAChecksumCalculator.calculate(normalizedTemplate, normalizedDatasets);
                String formCheckSum = this.formDom.retrieveAttribute("checksum");
                this.applyFormState = checkSum.equals(formCheckSum);
            }
            this.flatten(dataPipeline);
        }
        finally {
            XFAWorker.closeWorkerContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flattenXDP(InputStream xdpStream, OutputStream pdfOutputStream) throws IOException {
        if (this.flatteningIsCompleted) {
            throw new XFAFlattenerUnexpectedUsageException("The flatten method can only be called once in a single instance of the XFAFlattener class.");
        }
        this.initialize(pdfOutputStream);
        try {
            this.initFlattener(null);
            DataPipeline dataPipeline = this.processXDP(XFAUtil.inputStreamToByteArray(xdpStream));
            if (this.flattenerContext.getReader() != null) {
                this.reader = this.flattenerContext.getReader();
                try {
                    this.flatten(this.reader, dataPipeline);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                this.flatten(dataPipeline);
            }
        }
        finally {
            this.flatteningIsCompleted = true;
            XFAWorker.closeWorkerContext();
        }
    }

    public void flatten(InputStream xfaInputStream, OutputStream pdfOutputStream) throws IOException, InterruptedException {
        if (this.flatteningIsCompleted) {
            throw new XFAFlattenerUnexpectedUsageException("The flatten method can only be called once in a single instance of the XFAFlattener class.");
        }
        this.initialize(pdfOutputStream);
        XFAFlattenerProperties.ReaderProperties readerProperties = this.flattenerProperties.getReaderProperties();
        PdfReader reader = readerProperties.password != null ? new PdfReader(xfaInputStream, readerProperties.password) : (readerProperties.certificate != null ? new PdfReader(xfaInputStream, readerProperties.certificate, (ExternalDecryptionProcess)readerProperties.externalDecryptionProcess) : new PdfReader(xfaInputStream));
        this.flatten(reader, null);
        this.flatteningIsCompleted = true;
    }

    private void initialize(OutputStream pdfOutputStream) throws IOException {
        if (this.flattenerProperties == null) {
            this.flattenerProperties = new XFAFlattenerProperties();
        }
        this.document = new Document();
        try {
            if (this.flattenerProperties.getConformanceLevel() != null) {
                switch (this.flattenerProperties.getConformanceLevel()) {
                    case PDF_A_1B: 
                    case PDF_A_2B: 
                    case PDF_A_3B: 
                    case PDF_A_2U: 
                    case PDF_A_3U: {
                        this.writer = PdfAWriter.getInstance(this.document, pdfOutputStream, this.flattenerProperties.getConformanceLevel().getNormalizedLevel());
                        this.writer.createXmpMetadata();
                        break;
                    }
                    case PDF_A_1A: 
                    case PDF_A_2A: 
                    case PDF_A_3A: {
                        this.writer = PdfAWriter.getInstance(this.document, pdfOutputStream, this.flattenerProperties.getConformanceLevel().getNormalizedLevel());
                        this.writer.createXmpMetadata();
                        this.writer.setTagged();
                        break;
                    }
                    default: {
                        this.writer = PdfWriter.getInstance(this.document, pdfOutputStream);
                        break;
                    }
                }
            } else {
                this.writer = PdfWriter.getInstance(this.document, pdfOutputStream);
            }
        }
        catch (DocumentException exc) {
            throw new RuntimeException(exc);
        }
        if (this.flattenerProperties.getMetaData() != null) {
            MetaData metaData = this.flattenerProperties.getMetaData();
            if (metaData.getAuthor() != null) {
                this.document.addAuthor(metaData.getAuthor());
            }
            this.document.addCreationDate();
            if (metaData.getCreator() != null) {
                this.document.addCreator(metaData.getCreator());
            }
            if (metaData.getKeywords() != null) {
                this.document.addKeywords(metaData.getKeywords());
            }
            if (metaData.getLanguage() != null) {
                this.document.addLanguage(metaData.getLanguage());
            }
            if (metaData.getSubject() != null) {
                this.document.addSubject(metaData.getSubject());
            }
            if (metaData.getTitle() != null) {
                this.document.addTitle(metaData.getTitle());
            }
        }
        if (this.flattenerProperties.needsXmpMetaData()) {
            this.writer.createXmpMetadata();
        }
        if (this.flattenerProperties.isTagged()) {
            this.writer.setTagged();
        }
        if (this.flattenerProperties.getPfdVersion() != '4') {
            this.writer.setPdfVersion(this.flattenerProperties.getPfdVersion());
        }
        this.document.open();
        if (this.flattenerProperties.getOutputIntent() != null) {
            XFAFlattenerProperties.OutputIntent outputIntent = this.flattenerProperties.getOutputIntent();
            this.writer.setOutputIntents(outputIntent.getOutputConditionIdentifier(), outputIntent.getOutputCondition(), outputIntent.getRegistryName(), outputIntent.getInfo(), outputIntent.getIcc());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flattenXDP(org.w3c.dom.Document xdpData, OutputStream pdfOutputStream) throws IOException {
        if (this.flatteningIsCompleted) {
            throw new XFAFlattenerUnexpectedUsageException("The flatten method can only be called once in a single instance of the XFAFlattener class.");
        }
        this.initialize(pdfOutputStream);
        try {
            this.initFlattener(null);
            DOMSource source = new DOMSource(xdpData);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                Transformer transformer = factory.newTransformer();
                transformer.transform(source, result);
            }
            catch (Exception e) {
                this.flatteningIsCompleted = true;
                XFAWorker.closeWorkerContext();
                return;
            }
            DataPipeline dataPipeline = this.processXDP(out.toByteArray());
            this.flatten(dataPipeline);
        }
        finally {
            this.flatteningIsCompleted = true;
            XFAWorker.closeWorkerContext();
        }
    }

    @Override
    public void setCssAppliers(CssAppliers cssAppliers) {
        this.cssAppliers = cssAppliers;
    }

    @Override
    public CssAppliers getCssAppliers() {
        return this.cssAppliers;
    }

    public ViewMode getViewMode() {
        return this.viewMode;
    }

    public XFAFlattener setViewMode(ViewMode viewMode) {
        this.viewMode = viewMode;
        return this;
    }

    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    public XFAFlattener setAppConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
        return this;
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public XFAFlattener setHostConfig(HostConfig hostConfig) {
        this.hostConfig = hostConfig;
        return this;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public XFAFlattener setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
        return this;
    }

    public List<String> getExtraEventList() {
        return this.extraEventList;
    }

    public XFAFlattener setExtraEventList(List<String> extraEventList) {
        this.extraEventList = extraEventList;
        return this;
    }

    public IHrefResolver getHrefResolver() {
        return this.hrefResolver;
    }

    public XFAFlattener setHrefResolver(IHrefResolver hrefResolver) {
        this.hrefResolver = hrefResolver;
        return this;
    }

    public XFAFontSettings getFontSettings() {
        return this.fontSettings;
    }

    public XFAFlattener setFontSettings(XFAFontSettings fontSettings) {
        this.fontSettings = fontSettings;
        return this;
    }

    public XFAFlattenerProperties getFlattenerProperties() {
        return this.flattenerProperties;
    }

    public XFAFlattener setFlattenerProperties(XFAFlattenerProperties flattenerProperties) {
        this.flattenerProperties = flattenerProperties;
        return this;
    }

    private PRAcroForm initFlattener(PdfReader reader) {
        if (this.counter == 0) {
            LicenseKey.scheduledCheck((LicenseKeyProduct)this.product);
        } else if (this.counter == 20) {
            this.counter = -1;
        }
        ++this.counter;
        PRAcroForm acroForm = null;
        if (reader != null) {
            PdfDictionary xfaImagesDict;
            acroForm = reader.getAcroForm();
            if (null == acroForm) {
                throw new NoAcroFormFound();
            }
            PdfDictionary catalog = reader.getCatalog();
            PdfDictionary names = catalog.getAsDict(PdfName.NAMES);
            if (names != null && (xfaImagesDict = names.getAsDict(new PdfName("XFAImages"))) != null) {
                this.xfaImagesArr = xfaImagesDict.getAsArray(PdfName.NAMES);
            }
        }
        this.fontProvider = new XFAFontProvider(acroForm, this.fontSettings);
        if (this.fontSettings != null && this.fontSettings.isUseDocumentNotXFAFonts()) {
            for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                PdfDictionary fontDictionary;
                PdfDictionary pageResources = reader.getPageResources(i);
                if (pageResources == null || (fontDictionary = pageResources.getAsDict(PdfName.FONT)) == null) continue;
                this.fontProvider.addFonts(fontDictionary);
            }
        }
        this.cssAppliers = new XFACssAppliersImpl();
        this.cssAppliers.setChunkCssAplier(new XFAChunkCssApplier(this.fontProvider));
        this.flattenerContext = new FlattenerContext(this.fontProvider, this.document, this.xfaImagesArr);
        this.reader = reader;
        this.flattenerContext.setReader(reader);
        if (this.hostConfig == null) {
            this.hostConfig = new HostConfig();
        }
        this.flattenerContext.setHostConfig(this.hostConfig);
        if (this.appConfig == null) {
            this.appConfig = new AppConfig();
        }
        this.flattenerContext.setAppConfig(this.appConfig);
        this.jsXfa = new JsXfa(this.flattenerContext);
        this.applyFormState = false;
        return acroForm;
    }

    private DataPipeline processXDP(byte[] b) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        TemplateBuilderPipeline template = new TemplateBuilderPipeline(this.cssAppliers, this.hrefResolver);
        FormBuilderPipeline form = new FormBuilderPipeline(this.cssAppliers);
        DataPipeline dataPipeline = new DataPipeline(null, this.cssAppliers, this.jsXfa);
        LocalePipeline locale = new LocalePipeline(null, this.defaultLocale);
        XdpPipeline xdpPipeline = new XdpPipeline(locale, template, form, dataPipeline, new PdfPipeline(null, this.flattenerContext));
        XFAWorker worker = new XFAWorker(xdpPipeline);
        XMLParser parser = new XMLParser(false, worker);
        parser.parse((InputStream)bin, true);
        try {
            XFAFlattenerData xfd;
            ObjectContext objectContext;
            if (xdpPipeline.wasLocale()) {
                this.localeResolver = (LocaleResolver)worker.getWorkerContext().get(locale.getContextKey());
            }
            if (xdpPipeline.wasTemplate()) {
                objectContext = (ObjectContext)worker.getWorkerContext().get(template.getContextKey());
                xfd = (XFAFlattenerData)objectContext.get();
                this.templateDom = xfd.getTemplateDom();
                this.flattenerContext.setLegacyPlusPrint(template.isLegacyPlusPrint());
                this.flattenerContext.setXfaVersion(template.getXfaVersion());
            }
            if (xdpPipeline.wasForm()) {
                objectContext = (ObjectContext)worker.getWorkerContext().get(form.getContextKey());
                xfd = (XFAFlattenerData)objectContext.get();
                this.formDom = xfd.getTemplateDom();
            }
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(e);
        }
        return dataPipeline;
    }

    private void flatten(DataPipeline dataPipeline) {
        if (dataPipeline == null) {
            dataPipeline = new DataPipeline(null, this.cssAppliers, this.jsXfa);
        }
        if (dataPipeline.getDataDom() == null) {
            dataPipeline.setDataDom(new DataTag(UUID.randomUUID().toString()));
            JsDataModel datasetsNodeDom = new JsDataModel("datasets", this.jsXfa);
            dataPipeline.setDataSetsNodeDom(datasetsNodeDom);
            DataTag rootDataTag = new DataTag("data");
            JsDataGroup dataNode = new JsDataGroup(rootDataTag, (JsNode)datasetsNodeDom);
            rootDataTag.setNode(dataNode);
            datasetsNodeDom.addChild(dataNode);
            dataPipeline.setDataNodeDom(dataNode);
        }
        this.jsXfa.addChild(dataPipeline.getDataNodeDom());
        this.jsXfa.defineProperty("$data", dataPipeline.getDataNodeDom());
        this.jsXfa.addChild(dataPipeline.getDatasetsNodeDom());
        if (this.localeResolver == null) {
            this.localeResolver = new LocaleResolver();
            this.localeResolver.setDefaultLocale(this.defaultLocale);
        }
        this.flattenerContext.setLocaleResolver(this.localeResolver);
        JsForm jsForm = new JsForm(this.jsXfa);
        if (this.templateDom == null) {
            throw new IncorrectXFAStructureException("Template dom could not be found. Please check if your input document contains a template element.");
        }
        FormBuilder jsFormBuilder = new FormBuilder((XFATemplateTag)this.templateDom.getChild("subform", ""), dataPipeline.getDataDom(), jsForm, this.flattenerContext);
        this.flattenerContext.setFormBuilder(jsFormBuilder);
        this.formDomPositioner = (SubFormPositioner)jsFormBuilder.getFormDom();
        jsForm.addChild(this.formDomPositioner);
        this.jsXfa.addChild(jsForm);
        this.flattenerContext.evaluateScriptVariables();
        if (!"template".equals(this.formDomPositioner.retrieveName())) {
            JsTemplate templateJsObject = new JsTemplate(this.jsXfa);
            templateJsObject.defineProperty(this.formDomPositioner.retrieveName(), this.formDomPositioner);
            this.jsXfa.addChild(templateJsObject);
        }
        this.pageSet = (PageSet)this.formDomPositioner.searchNodeByClassName("pageSet");
        try {
            if (this.pageSet != null) {
                this.flattenerContext.setPageSet(this.pageSet);
                this.flattenerContext.setDomPositioner(this.formDomPositioner);
                if (this.writer.isTagged()) {
                    String locale = (String)this.formDomPositioner.getOwnProperty("locale");
                    if (locale == null) {
                        locale = "en_US";
                    }
                    this.document.addLanguage(locale);
                    this.document.setAccessibleAttribute(PdfName.LANG, new PdfString(locale));
                    PdfDictionary info = this.writer.getInfo();
                    if (info.get(PdfName.TITLE) == null) {
                        String title = this.formDomPositioner.getName();
                        if (title == null) {
                            title = "untitled";
                        }
                        info.put(PdfName.TITLE, new PdfString(title));
                    }
                    this.writer.setViewerPreferences(131072);
                }
                this.writer.createXmpMetadata();
                this.flattenerContext.setViewMode(this.viewMode);
                this.flattenerContext.setExtraEventList(this.extraEventList);
                this.placeFormDom();
                this.positionElements();
                while (this.addStaticContent && this.writer.getCurrentPageNumber() <= this.reader.getNumberOfPages()) {
                    this.processBreak();
                }
            }
            this.document.close();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ByteArrayInputStream getStreamContents(PdfReader reader, PdfObject pdfObject2) throws IOException {
        byte[] streamBytes = null;
        if (pdfObject2.isIndirect()) {
            streamBytes = this.getStreamFromIndirectReference(reader, (PdfIndirectReference)pdfObject2);
        } else if (pdfObject2 instanceof PRStream) {
            streamBytes = PdfReader.getStreamBytes((PRStream)pdfObject2);
        } else if (pdfObject2.isStream()) {
            throw new RuntimeException("PdfStream found");
        }
        return new ByteArrayInputStream(streamBytes);
    }

    private byte[] getStreamFromIndirectReference(PdfReader reader, PdfIndirectReference ir) throws IOException {
        int nr = ir.getNumber();
        PdfObject pdfObject = reader.getPdfObject(nr);
        return PdfReader.getStreamBytes((PRStream)pdfObject);
    }

    private void updatePageNumber(Positioner pageArea) {
        boolean numbered = pageArea == null || !"0".equals(pageArea.retrieveAttribute("numbered"));
        this.flattenerContext.moveToNextPage(numbered);
    }

    private void positionElements() throws DocumentException, IOException {
        if (this.formDomPositioner != null) {
            ArrayList<Positioner> pageAreas = new ArrayList<Positioner>();
            if (this.pageSet.getCurrentPageArea() != null) {
                this.updatePageNumber(this.pageSet.getCurrentPageArea());
                XFARectangle boundingContentArea = this.pageSet.getCurrentPageArea().getCurrentContentArea().getRect().clone();
                float pageContentAreaShift = boundingContentArea.getUry().floatValue();
                this.formDomPositioner.applyTranslation(0.0f, pageContentAreaShift);
                AffineTransform matrix = (AffineTransform)this.formDomPositioner.getTransformation().clone();
                this.formDomPositioner.applyTranslation(boundingContentArea.getLlx().floatValue(), 0.0f);
                boundingContentArea.setUry(Float.valueOf(boundingContentArea.getUry().floatValue() - pageContentAreaShift));
                Positioner overflowPositioner = this.formDomPositioner.position(this.writer.getDirectContent(), boundingContentArea, this.pageSet.getCurrentPageArea(), true, 0.0f);
                BreakConditions breakConditions = null;
                BreakConditions previousBreakConditions = null;
                BreakConditions breakAfterConditions = null;
                while (overflowPositioner != null) {
                    Positioner leaderParentPositioner;
                    TrailerLeaderElement leader;
                    TrailerLeaderElement trailer;
                    BreakConditions breakConditions2 = breakAfterConditions = overflowPositioner instanceof SubFormPositioner ? ((SubFormPositioner)overflowPositioner).getFirstBreakAfter() : null;
                    if (overflowPositioner.getOverflowConditions() != null && (trailer = overflowPositioner.getOverflowConditions().getCurrentTrailer()) != null) {
                        Positioner trailerParentPositioner = overflowPositioner.getOverflowConditions().getTrailerParent();
                        XFARectangle trailerParentPositionerAbsoluteBbox = trailerParentPositioner.getAbsoluteBbox();
                        XFARectangle overflowAbsoluteBbox = overflowPositioner.getAbsoluteBbox();
                        Positioner positionerWithData = trailerParentPositioner;
                        while (positionerWithData.getData() == null && positionerWithData.getParent() != null) {
                            positionerWithData = positionerWithData.getParent();
                        }
                        DataTag dt = positionerWithData.getData();
                        Positioner trailerPositioner = (Positioner)this.flattenerContext.getFormBuilder().buildSubformInstance(trailer.getFormTag(), null, dt, true);
                        trailerPositioner.place(trailerParentPositionerAbsoluteBbox.getLlx(), overflowAbsoluteBbox.getUry());
                        if (trailerPositioner.isVisible() || trailerPositioner.isInvisible()) {
                            trailerPositioner.position(this.writer.getDirectContent(), null, null, false, 0.0f);
                        }
                        overflowPositioner.getOverflowConditions().getNextTrailer();
                    }
                    float shift = pageContentAreaShift + boundingContentArea.getUry().floatValue() - this.pageSet.getCurrentPageArea().getCurrentContentArea().getRect().getUry().floatValue();
                    previousBreakConditions = breakConditions;
                    breakConditions = overflowPositioner.getBreakConditions();
                    overflowPositioner.setBreakConditions(null);
                    ContentArea nextContentArea = this.pageSet.nextContentArea(breakConditions);
                    if (nextContentArea == null || nextContentArea.getPageArea() != this.pageSet.getCurrentPageArea() || this.pageSet.getCurrentPageArea().getCurrentContentArea() == nextContentArea) {
                        boolean pageNumberDoesNotMatchOddEvenBreakType;
                        PageArea nextArea;
                        boolean forcePageNumberUpdate = false;
                        boolean pageAreaWasUnused = false;
                        if (!this.writer.isPageEmpty() || breakConditions != null && breakConditions.evaluate() && this.writer.getPageNumber() > 1 && breakConditions.getTarget() != null && previousBreakConditions != null && !BreakConditions.targetsEqual(previousBreakConditions, breakConditions) || breakConditions != null && breakConditions.evaluate() && this.writer.getPageNumber() == 1 && "before".equals(breakConditions.getSubType()) && (breakConditions.getTarget() == null || "pageArea".equals(breakConditions.getType()) && breakConditions.getStartNew() && this.pageSet.getCurrentPageArea() != null && !this.pageSet.getCurrentPageArea().retrieveName().equals(breakConditions.getTarget())) || breakConditions != null && breakConditions.evaluate() && previousBreakConditions != null && previousBreakConditions.evaluate() && "before".equals(breakConditions.getSubType()) && "after".equals(previousBreakConditions.getSubType()) && !BreakConditions.targetsEqual(previousBreakConditions, breakConditions) || breakConditions != null && breakConditions.evaluate() && previousBreakConditions != null && previousBreakConditions.evaluate() && "before".equals(breakConditions.getSubType()) && "before".equals(previousBreakConditions.getSubType()) && breakConditions.getPositioner() == previousBreakConditions.getPositioner()) {
                            this.processNewPageArea(pageAreas);
                        } else if (this.writer.getPageNumber() == 1) {
                            this.flattenerContext.resetPageNumbers();
                            forcePageNumberUpdate = true;
                        } else {
                            pageAreaWasUnused = true;
                            if (breakConditions != null && previousBreakConditions != null && pageAreas.contains(this.pageSet.getCurrentPageArea())) {
                                this.pageSet.getNewInstanceOfCurrentPageArea();
                            }
                        }
                        PageArea previousPageArea = this.pageSet.getCurrentPageArea();
                        if (pageAreaWasUnused) {
                            this.pageSet.nextPageArea(previousBreakConditions, nextContentArea, this.writer.getCurrentPageNumber());
                            nextArea = this.pageSet.getNewInstanceOfCurrentPageArea();
                        } else {
                            nextArea = this.pageSet.nextPageArea(breakConditions, nextContentArea, this.writer.getCurrentPageNumber() + 1);
                        }
                        boolean nextPageAreaDoesNotMatchOddEvenCondition = breakConditions != null && breakConditions.getTarget() != null && this.pageSet.isDuplexPagination() && (breakConditions.getStartNew() || PageArea.arePartsOfDifferentPageSets(previousPageArea, nextArea)) && ("odd".equals(nextArea.retrieveAttribute("oddOrEven")) && this.writer.getCurrentPageNumber() % 2 == 1 || "even".equals(nextArea.retrieveAttribute("oddOrEven")) && this.writer.getCurrentPageNumber() % 2 == 0);
                        boolean bl = pageNumberDoesNotMatchOddEvenBreakType = breakConditions != null && breakConditions.evaluate() && ("pageOdd".equals(breakConditions.getType()) && this.writer.getCurrentPageNumber() % 2 == 1 || "pageEven".equals(breakConditions.getType()) && this.writer.getCurrentPageNumber() % 2 == 0);
                        if ((nextPageAreaDoesNotMatchOddEvenCondition || pageNumberDoesNotMatchOddEvenBreakType) && this.pageSet.isDuplexPagination()) {
                            PageArea blankPageArea = this.pageSet.nextBlankPageArea(previousPageArea, this.writer.getCurrentPageNumber() + 1);
                            if (blankPageArea != null) {
                                this.pageSet.setCurrentPageArea(blankPageArea);
                                this.processBreak();
                                this.updatePageNumber(blankPageArea);
                                this.processNewPageArea(pageAreas);
                            }
                            nextArea.setOccured(nextArea.getOccured() - 1);
                            this.pageSet.nextPageArea(breakConditions, nextContentArea, this.writer.getCurrentPageNumber() + 1);
                        }
                        int previousPageNumber = this.writer.getPageNumber();
                        this.processBreak();
                        if (this.writer.getPageNumber() > previousPageNumber || forcePageNumberUpdate) {
                            this.updatePageNumber(this.pageSet.getCurrentPageArea());
                        }
                    } else {
                        this.pageSet.getCurrentPageArea().setCurrentContentArea(nextContentArea);
                    }
                    if (this.pageSet.getCurrentPageArea() == null) break;
                    boundingContentArea = this.pageSet.getCurrentPageArea().getCurrentContentArea().getRect().clone();
                    if (overflowPositioner.getOverflowConditions() != null && (leader = overflowPositioner.getOverflowConditions().getCurrentLeader()) != null && ((leaderParentPositioner = overflowPositioner.getOverflowConditions().getLeaderParent()).getPositionState() == PositionResult.State.CONTENT_PART || "position".equals(leaderParentPositioner.getLayout()))) {
                        float leaderParentAbsoluteLlx = 0.0f;
                        if (overflowPositioner.getParent() != null) {
                            XFARectangle overflowPositionerParentBbox = overflowPositioner.getParent().getAbsoluteBbox(true);
                            overflowPositioner.getParent().applyMargins(overflowPositionerParentBbox);
                            leaderParentAbsoluteLlx = overflowPositionerParentBbox.getLlx().floatValue();
                        } else {
                            leaderParentAbsoluteLlx = leaderParentPositioner.getAbsoluteBbox(true).getLlx().floatValue();
                        }
                        Positioner positionerWithData = leaderParentPositioner;
                        while (positionerWithData.getData() == null && positionerWithData.getParent() != null) {
                            positionerWithData = positionerWithData.getParent();
                        }
                        DataTag dt = positionerWithData.getData();
                        Positioner leaderPositioner = null;
                        try {
                            leaderPositioner = (Positioner)this.flattenerContext.getFormBuilder().buildSubformInstance(leader.getFormTag(), null, dt, true);
                        }
                        catch (Exception exc) {
                            this.logger.warn("Building leader positioner went wrong. Please check your form for irregularities.");
                        }
                        if (leaderPositioner != null) {
                            if ("table".equals(leaderParentPositioner.getLayout())) {
                                TableLayoutManager tableLayoutManager = new TableLayoutManager(leaderParentPositioner);
                                tableLayoutManager.preprocessHorizontalCellLayout(leaderPositioner);
                            }
                            leaderPositioner.defineProperty("y", null);
                            leaderPositioner.defineProperty("x", null);
                            leaderPositioner.place(Float.valueOf(boundingContentArea.getLlx().floatValue() + leaderParentAbsoluteLlx), Float.valueOf(boundingContentArea.getUry().floatValue() + shift));
                            leaderPositioner.setParentScope((Scriptable)leaderParentPositioner);
                            leaderPositioner.execEvent("initialize", null);
                            leaderPositioner.execCalculate();
                            leaderPositioner.execEvent("ready", "$form");
                            leaderPositioner.execEvent("ready", "$layout");
                            if (leaderPositioner.isVisible() || leaderPositioner.isInvisible()) {
                                leaderPositioner.position(this.writer.getDirectContent(), null, null, false, 0.0f);
                            }
                            if (!leaderPositioner.isHidden() && !leaderPositioner.isInactive()) {
                                shift -= leaderPositioner.getBBox().getHeight().floatValue();
                            }
                            overflowPositioner.getOverflowConditions().getNextLeader();
                        }
                    }
                    if (!overflowPositioner.isHidden() && !overflowPositioner.isInactive()) {
                        shift += boundingContentArea.getUry().floatValue() - (overflowPositioner.getAbsoluteBbox(true).getUry().floatValue() + pageContentAreaShift);
                    }
                    boundingContentArea.setUry(Float.valueOf(boundingContentArea.getUry().floatValue() - pageContentAreaShift - shift));
                    this.formDomPositioner.setTransformation(matrix);
                    this.formDomPositioner.applyTranslation(0.0f, shift);
                    matrix = (AffineTransform)this.formDomPositioner.getTransformation().clone();
                    this.formDomPositioner.applyTranslation(boundingContentArea.getLlx().floatValue(), 0.0f);
                    pageContentAreaShift += shift;
                    overflowPositioner = this.formDomPositioner.position(this.writer.getDirectContent(), boundingContentArea, this.pageSet.getCurrentPageArea(), true, 0.0f);
                }
                this.normalizePageCount();
                if (this.flattenerContext.getPageCount() > 1 && this.writer.isPageEmpty() && breakConditions == null && this.flattenerContext.getCurrentPageNumber() != null) {
                    this.flattenerContext.setPageCount(this.flattenerContext.getPageCount() - 1);
                    this.flattenerContext.setSheetCount(this.flattenerContext.getSheetCount() - 1);
                } else {
                    if (this.writer.isPageEmpty()) {
                        this.writer.getDirectContent().getInternalBuffer().append("%blank page");
                    }
                    if (this.pageSet.getCurrentPageArea() != null) {
                        this.processNewPageArea(pageAreas);
                    }
                }
                if (this.pageSet.isDuplexPagination() && this.writer.getPageNumber() % 2 != 0) {
                    PageArea lastPageArea = this.pageSet.findPageAreaWithLastPagePosition();
                    boolean foundMatchingLastPageArea = false;
                    if (lastPageArea != null) {
                        this.pageSet.setCurrentPageArea(lastPageArea);
                        foundMatchingLastPageArea = true;
                    } else if (breakAfterConditions != null) {
                        this.pageSet.nextPageArea(breakAfterConditions, null, this.writer.getCurrentPageNumber() + 1);
                        foundMatchingLastPageArea = true;
                    }
                    if (foundMatchingLastPageArea) {
                        this.updatePageNumber(this.pageSet.getCurrentPageArea());
                        this.normalizePageCount();
                        this.processBreak();
                        this.processNewPageArea(pageAreas);
                    }
                }
                this.flattenerContext.resetPageNumbers();
                this.flushPageAreas(pageAreas);
                this.flattenerContext.setCurrentPageNumber(this.flattenerContext.getPageCount());
                this.flattenerContext.setCurrentSheetNumber(this.writer.getPageNumber());
                this.flattenerContext.setCurrentAbsPageNumber(this.writer.getPageNumber());
                this.flattenerContext.drawUnresolvedTextDrawers();
                this.formDomPositioner = null;
            }
        }
    }

    private void normalizePageCount() {
        int pageCount = this.flattenerContext.getCurrentPageNumber() != null && this.flattenerContext.getCurrentPageNumber() != 0 ? this.flattenerContext.getCurrentPageNumber() : (this.flattenerContext.getLastNumberedPage() != null ? this.flattenerContext.getLastNumberedPage().intValue() : this.writer.getPageNumber());
        this.flattenerContext.setPageCount(pageCount);
        this.flattenerContext.setSheetCount(this.writer.getPageNumber());
    }

    private void flushPageAreas(List<Positioner> pageAreas) throws DocumentException, IOException {
        Iterator<Positioner> positionItr = pageAreas.iterator();
        while (positionItr.hasNext()) {
            Positioner pageAreaPositioner = positionItr.next();
            this.updatePageNumber(pageAreaPositioner);
            pageAreaPositioner.execEvent("initialize", null);
            pageAreaPositioner.execCalculate();
            pageAreaPositioner.execEvent("ready", null);
            pageAreaPositioner.execEvent("docReady", null);
            pageAreaPositioner.execValidate();
            if (this.extraEventList != null) {
                for (String event : this.extraEventList) {
                    pageAreaPositioner.execEvent(event, null);
                }
            }
            pageAreaPositioner.place();
            pageAreaPositioner.position(pageAreaPositioner.getCanvas(), null, null, false, 0.0f);
            positionItr.remove();
        }
    }

    private void processNewPageArea(List<Positioner> pageAreas) throws IOException, DocumentException {
        SubFormPositioner pageAreaPositioner = this.ensurePageAreaNotRepeated(pageAreas);
        float width = this.pageSet.getCurrentPageArea().getCurrentContentArea() != null ? this.pageSet.getCurrentPageArea().getCurrentContentArea().getRect().getWidth().floatValue() : this.writer.getPageSize().getWidth();
        float height = this.pageSet.getCurrentPageArea().getCurrentContentArea() != null ? this.pageSet.getCurrentPageArea().getCurrentContentArea().getRect().getHeight().floatValue() : this.writer.getPageSize().getHeight();
        PdfTemplate pdfTemplate = this.writer.getDirectContentUnder().createTemplate(width, height);
        pdfTemplate.setBoundingBox(this.writer.getPageSize());
        this.writer.getDirectContentUnder().addTemplate(pdfTemplate, 0.0f, 0.0f, true);
        pageAreaPositioner.setCanvas(pdfTemplate);
        pageAreaPositioner.setStartPageNumber(this.flattenerContext.getCurrentPageNumber());
        pageAreaPositioner.setStartAbsPageNumber(this.flattenerContext.getCurrentAbsPageNumber());
        pageAreas.add(pageAreaPositioner);
        this.addWatermark();
    }

    private SubFormPositioner ensurePageAreaNotRepeated(List<Positioner> pageAreas) {
        PageArea pageAreaPositioner = this.pageSet.getCurrentPageArea();
        while (pageAreas.contains(pageAreaPositioner)) {
            pageAreaPositioner = this.pageSet.getNewInstanceOfCurrentPageArea();
        }
        return pageAreaPositioner;
    }

    private void processBreak() {
        if (!this.document.isOpen()) {
            this.document.open();
        }
        if (this.pageSet.getCurrentPageArea() != null) {
            JsInstanceManager instanceManager;
            this.document.setPageSize(this.pageSet.getCurrentPageArea().getPageSize());
            this.document.newPage();
            if (this.addStaticContent && this.writer.getCurrentPageNumber() <= this.reader.getNumberOfPages()) {
                this.addStaticPageContent();
            }
            if ((instanceManager = this.pageSet.getInstanceManagerByTemplate(this.pageSet.getCurrentPageArea().getTemplate())) != null) {
                instanceManager.decCount();
            }
            Positioner pageAreaPositioner = (Positioner)this.flattenerContext.getFormBuilder().buildSubForm(this.pageSet.getCurrentPageArea().getTemplate(), this.pageSet.getCurrentPageArea().getData(), this.pageSet);
            pageAreaPositioner.setStartPageNumber(this.flattenerContext.getCurrentPageNumber());
            pageAreaPositioner.setStartAbsPageNumber(this.flattenerContext.getCurrentAbsPageNumber());
            pageAreaPositioner.execEvent("initialize", null);
            pageAreaPositioner.execEvent("ready", null);
            pageAreaPositioner.execEvent("docReady", null);
            pageAreaPositioner.execValidate();
            if (this.extraEventList != null) {
                for (String event : this.extraEventList) {
                    pageAreaPositioner.execEvent(event, null);
                }
            }
        }
    }

    private void addStaticPageContent() {
        PdfImportedPage page = this.writer.getImportedPage(this.reader, this.writer.getCurrentPageNumber());
        if (this.pageAnnotationsCopier == null) {
            this.pageAnnotationsCopier = new XFAPageAnnotationsCopier(this.writer, true);
        }
        int rotationAngle = page.getRotation();
        if ((rotationAngle %= 360) != 0) {
            Point2D lowLeft = new Point(page.getBoundingBox().getLeft(), page.getBoundingBox().getBottom());
            Point2D upperRight = new Point(page.getBoundingBox().getRight(), page.getBoundingBox().getTop());
            AffineTransform rotation = AffineTransform.getRotateInstance(Math.toRadians(-rotationAngle));
            lowLeft = rotation.transform(lowLeft, null);
            upperRight = rotation.transform(upperRight, null);
            Rectangle transformedRectangle = new Rectangle((float)lowLeft.getX(), (float)lowLeft.getY(), (float)upperRight.getX(), (float)upperRight.getY());
            transformedRectangle.normalize();
            AffineTransform transformation = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -transformedRectangle.getLeft(), -transformedRectangle.getBottom());
            transformation.concatenate(rotation);
            double[] transformationMatrix = new double[6];
            transformation.getMatrix(transformationMatrix);
            page.setMatrix((float)transformationMatrix[0], (float)transformationMatrix[1], (float)transformationMatrix[2], (float)transformationMatrix[3], (float)transformationMatrix[4], (float)transformationMatrix[5]);
        }
        this.writer.getDirectContent().addTemplate((PdfTemplate)page, 0.0f, 0.0f);
        this.pageAnnotationsCopier.copySupportedAnnotations(this.reader, this.writer.getCurrentPageNumber());
    }

    private void addWatermark() throws IOException, DocumentException {
        if (this.isTrialLicense()) {
            String text = "TRIAL VERSION";
            PdfContentByte canvas = this.writer.getDirectContent();
            canvas.saveState();
            Rectangle pageSize = this.writer.getPageSize();
            float textLine = (float)Math.sqrt(pageSize.getWidth() * pageSize.getWidth() + pageSize.getHeight() * pageSize.getHeight());
            float fontSize = textLine / 10.0f;
            float t = pageSize.getHeight() / pageSize.getWidth();
            canvas.concatCTM(AffineTransform.getRotateInstance((float)Math.atan(t)));
            canvas.beginText();
            PdfGState gs = new PdfGState();
            gs.setFillOpacity(0.5f);
            canvas.setGState(gs);
            canvas.setRGBColorFill(255, 0, 0);
            BaseFont bf = BaseFont.createFont("Helvetica-Bold", "Cp1252", false);
            canvas.setFontAndSize(bf, fontSize);
            float textwidth = canvas.getEffectiveStringWidth(text, false);
            float asc = bf.getAscentPoint(text, fontSize);
            float desc = bf.getDescentPoint(text, fontSize);
            canvas.moveText((textLine - textwidth) / 2.0f, -(asc + desc) / 2.0f);
            canvas.showText(text);
            canvas.endText();
            canvas.restoreState();
        }
    }

    private void placeFormDom() {
        this.pageSet.nextPageArea(null, null, 1);
        this.processBreak();
        this.formDomPositioner.execEvent("initialize", null);
        this.formDomPositioner.execCalculate();
        this.formDomPositioner.execEvent("ready", "$form");
        this.formDomPositioner.execEvent("docReady", null);
        this.formDomPositioner.execValidate();
        if (this.extraEventList != null) {
            for (String event : this.extraEventList) {
                this.formDomPositioner.execEvent(event, null);
            }
        }
        if (this.applyFormState && this.formDom.getChildren().size() > 0 && this.formDom.getChildren().get(0) instanceof XFATemplateTag) {
            XFAFormStateApplier applier = new XFAFormStateApplier(this.formDomPositioner, this.formDom);
            applier.applyFormState();
        }
        this.formDomPositioner.place();
        this.flattenerContext.setValidateLayout(true);
        this.formDomPositioner.execEvent("ready", "$layout");
        this.flattenerContext.setValidateLayout(false);
        this.formDomPositioner.relayout(false);
    }

    private boolean isTrialLicense() {
        try {
            String key = LicenseKey.getLicenseeInfoForVersion((String)"7.1")[3];
            return key == null || key.trim().length() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private final class ExtractStreamRunner
    implements Runnable {
        private final int index;
        private final PdfReader reader;
        private final PdfArray asArray;
        private final SettableLatch latch;
        private final String key;
        private final Map<String, ByteArrayInputStream> map;

        private ExtractStreamRunner(String key, int index, PdfReader reader, PdfArray asArray, SettableLatch sl, Map<String, ByteArrayInputStream> map) {
            this.key = key;
            this.index = index;
            this.reader = reader;
            this.asArray = asArray;
            this.latch = sl;
            this.map = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PdfObject pdfObject2 = this.asArray.getPdfObject(this.index);
            try {
                PdfReader pdfReader = this.reader;
                synchronized (pdfReader) {
                    this.map.put(this.key, XFAFlattener.this.getStreamContents(this.reader, pdfObject2));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.latch.decrement();
            }
        }
    }

    public static enum ViewMode {
        ALL,
        PRINT,
        SCREEN;

    }
}

