/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.bind;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.bind.DataBindReference;
import com.itextpdf.tool.xml.xtra.xfa.bind.DataTreeResolverContext;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataGroup;
import com.itextpdf.tool.xml.xtra.xfa.tags.DataTag;
import java.util.LinkedList;
import java.util.List;

public class DataTreeResolver {
    private DataTreeResolver() {
    }

    public static void fillDataList(List<Tag> dataList, DataBindReference reference, int dataStructureIndex, DataTag dataTag, boolean createIfNotExist, DataTreeResolverContext context) {
        if (dataStructureIndex < reference.size()) {
            DataTag d1;
            String dataRefItem = reference.getItem(dataStructureIndex);
            String[] splittedDataRefItem = DataTreeResolver.splitDataRefItem(dataRefItem);
            int index = 0;
            if (!"*".equals(splittedDataRefItem[1])) {
                try {
                    index = Integer.parseInt(splittedDataRefItem[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((d1 = DataTreeResolver.getChildDataTag(dataTag, dataRefItem = splittedDataRefItem[0], index, false)) == null && dataStructureIndex < 2 && !dataRefItem.equals(dataTag.getName())) {
                d1 = DataTreeResolver.getChildDataTag((DataTag)dataTag.getParent(), dataRefItem, index, true);
            }
            if (d1 == null) {
                int dataListSize = dataList.size();
                DataTreeResolver.fillDataList(dataList, reference, dataStructureIndex + 1, dataTag, createIfNotExist, context);
                if (dataList.size() == dataListSize && createIfNotExist && DataTreeResolver.isValidToCreateDataNode(dataTag, dataRefItem)) {
                    DataTag newDataTag = new DataTag(dataRefItem);
                    newDataTag.setFictive();
                    context.getFictiveDataTags().add(newDataTag);
                    dataTag.addChild(newDataTag);
                    if (dataTag.getNode() != null) {
                        JsDataGroup newDataGroup = new JsDataGroup(newDataTag, dataTag.getNode());
                        newDataTag.setNode(newDataGroup);
                        newDataGroup.defineProperty("value", null);
                        dataTag.getNode().addChild(newDataGroup);
                    }
                    if ((d1 = DataTreeResolver.getChildDataTag(dataTag, dataRefItem, index, false)) != null) {
                        if (dataStructureIndex == reference.size() - 1) {
                            dataList.add(d1);
                            return;
                        }
                        DataTreeResolver.fillDataList(dataList, reference, dataStructureIndex + 1, d1, createIfNotExist, context);
                        return;
                    }
                }
            } else {
                Tag d2 = d1.getParent();
                List<Tag> dl = d2.getChildren(splittedDataRefItem[0]);
                int dlSize = dl.size();
                if (dlSize > 0) {
                    if ("*".equals(splittedDataRefItem[1])) {
                        if (dataStructureIndex == reference.size() - 1) {
                            for (Tag d : dl) {
                                dataList.add(d);
                            }
                        } else {
                            for (Tag d : dl) {
                                DataTreeResolver.fillDataList(dataList, reference, dataStructureIndex + 1, (DataTag)d, false, context);
                            }
                        }
                    } else {
                        DataTag d = dlSize > index ? (DataTag)dl.get(index) : (DataTag)dl.get(dlSize - 1);
                        if (dataStructureIndex == reference.size() - 1) {
                            dataList.add(d);
                        } else {
                            DataTreeResolver.fillDataList(dataList, reference, dataStructureIndex + 1, d, createIfNotExist, context);
                        }
                    }
                }
            }
        }
    }

    private static boolean isValidToCreateDataNode(DataTag dataTag, String dataRefItem) {
        if (dataTag.getNode() != null && dataTag.getNode().getProtoTemplate() != null) {
            LinkedList<Tag> search = new LinkedList<Tag>();
            search.addAll(dataTag.getNode().getProtoTemplate().getChildren());
            while (!search.isEmpty()) {
                Tag currentTag = (Tag)search.poll();
                if (currentTag.getName().equals(dataRefItem)) {
                    if (currentTag.getParent().getName().equals("group") && currentTag.getParent().getNameSpace().equals("dd") && "choice".equals(currentTag.getParent().getAttributes().get("dd:model"))) {
                        boolean anythingOccurred = false;
                        for (Tag sibling : currentTag.getParent().getChildren()) {
                            if (dataTag.getChild(sibling.getName(), "") == null) continue;
                            anythingOccurred = true;
                        }
                        return !anythingOccurred;
                    }
                    return true;
                }
                if (!currentTag.getName().equals("group") || !currentTag.getNameSpace().equals("dd")) continue;
                search.addAll(currentTag.getChildren());
            }
            return false;
        }
        return true;
    }

    public static String[] splitDataRefItem(String dataRefItem) {
        String[] result = new String[]{"", ""};
        boolean parseIndex = false;
        for (int i = 0; i < dataRefItem.length(); ++i) {
            char c = dataRefItem.charAt(i);
            if (c == '[') {
                parseIndex = true;
                continue;
            }
            if (c == ']') {
                parseIndex = false;
                continue;
            }
            if (parseIndex) {
                result[1] = result[1] + c;
                continue;
            }
            result[0] = result[0] + c;
        }
        if (result[1].length() == 0) {
            result[1] = "0";
        }
        return result;
    }

    private static DataTag getChildDataTag(DataTag dataTag, String name, int index, boolean recursively) {
        if (dataTag == null) {
            return null;
        }
        Tag d1 = null;
        List<Tag> children = dataTag.getChildren(name);
        if (children != null && children.size() > index) {
            d1 = children.get(index);
        }
        if (d1 == null && recursively) {
            if (name.equals(dataTag.getName()) || dataTag.isFictive()) {
                return null;
            }
            return DataTreeResolver.getChildDataTag((DataTag)dataTag.getParent(), name, index, true);
        }
        return (DataTag)d1;
    }
}

