/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.font;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactoryImp;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PRAcroForm;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.tool.xml.xtra.xfa.font.StyleWrapper;
import com.itextpdf.tool.xml.xtra.xfa.font.XFAFont;
import com.itextpdf.tool.xml.xtra.xfa.font.XFAFontSettings;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class XFAFontProvider
extends FontFactoryImp {
    private final Map<String, BaseFont> fonts = new ConcurrentHashMap<String, BaseFont>();
    private final Map<String, BaseFont> unicodeFonts = new ConcurrentHashMap<String, BaseFont>();
    private Map<String, String> fontNamesMap = new HashMap<String, String>();
    private Map<String, PdfDictionary> fontDescriptors = new HashMap<String, PdfDictionary>();
    private XFAFontSettings fontSettings;

    public XFAFontProvider(PRAcroForm acroForm) {
        this(acroForm, null);
    }

    public XFAFontProvider(PRAcroForm acroForm, XFAFontSettings fontSettings) {
        this.fontSettings = fontSettings;
        if (fontSettings != null && fontSettings.getFontsPath() != null && fontSettings.getFontsPath().length() > 0) {
            super.registerDirectory(fontSettings.getFontsPath(), true);
        }
        if (acroForm != null) {
            PdfDictionary fontsDict;
            PdfDictionary drFontDict = acroForm.getAsDict(PdfName.DR);
            PdfDictionary pdfDictionary = fontsDict = drFontDict != null ? drFontDict.getAsDict(PdfName.FONT) : null;
            if (fontsDict != null) {
                this.addFonts(fontsDict);
            }
        }
    }

    public void addFonts(PdfDictionary fontsDict) {
        for (PdfName key : fontsDict.getKeys()) {
            String fontFamily;
            PdfObject indRef = fontsDict.get(key);
            if (indRef == null || !(indRef instanceof PRIndirectReference)) continue;
            ArrayList<PdfDictionary> fontDescriptorList = new ArrayList<PdfDictionary>(1);
            PdfDictionary fontDictionary = (PdfDictionary)PdfReader.getPdfObject(indRef);
            if (fontDictionary != null) {
                PdfDictionary fontDescriptor = fontDictionary.getAsDict(PdfName.FONTDESCRIPTOR);
                if (fontDescriptor == null) {
                    PdfArray descendantFonts = fontDictionary.getAsArray(PdfName.DESCENDANTFONTS);
                    if (descendantFonts != null) {
                        for (int i = 0; i < descendantFonts.length(); ++i) {
                            fontDictionary = descendantFonts.getAsDict(0);
                            fontDescriptor = fontDictionary.getAsDict(PdfName.FONTDESCRIPTOR);
                            if (fontDescriptor == null) continue;
                            fontDescriptorList.add(fontDescriptor);
                        }
                    }
                } else {
                    fontDescriptorList.add(fontDescriptor);
                }
            }
            BaseFont baseFont = BaseFont.createFont((PRIndirectReference)indRef);
            String fontName = null;
            if (baseFont != null) {
                fontName = baseFont.getFamilyFontName()[0][3];
                if (this.fontSettings != null && this.fontSettings.getFontsPath() != null && this.fontSettings.isEmbedExternalFonts()) {
                    BaseFont externalFont = null;
                    for (PdfDictionary fontDescriptor : fontDescriptorList) {
                        fontFamily = fontDescriptor.getAsString(PdfName.FONTFAMILY).toUnicodeString();
                        if (fontFamily == null) {
                            fontFamily = fontName;
                        }
                        try {
                            externalFont = super.getBaseFont(fontFamily, baseFont.getEncoding(), true, true);
                            if (externalFont == null && this.fontSettings.getFontSubstitutionMap() != null && (fontFamily = this.fontSettings.getSubstitutedFontName(fontFamily)) != null) {
                                externalFont = super.getBaseFont(fontFamily, baseFont.getEncoding(), true, true);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (externalFont == null) continue;
                        baseFont = externalFont;
                        if (fontFamily == null || fontName == null) continue;
                        this.fontNamesMap.put(fontName, fontFamily);
                    }
                }
                this.fonts.put(fontName, baseFont);
            }
            for (PdfDictionary fontDescriptor : fontDescriptorList) {
                PdfString fontFamilyPdfStr = fontDescriptor.getAsString(PdfName.FONTFAMILY);
                String string = fontFamily = fontFamilyPdfStr != null ? fontFamilyPdfStr.toUnicodeString() : null;
                if (fontFamily == null) {
                    fontFamily = fontName.substring(fontName.indexOf(43) + 1);
                    fontFamily = fontFamily.substring(fontName.toLowerCase().indexOf("bold") + 1);
                    fontFamily = fontFamily.substring(fontName.toLowerCase().indexOf("italic") + 1);
                    fontFamily = fontFamily.substring(fontName.toLowerCase().indexOf("normal") + 1);
                }
                this.fontDescriptors.put(fontFamily, fontDescriptor);
                PRStream prs = (PRStream)PdfReader.getPdfObject(fontDescriptor.get(PdfName.FONTFILE2));
                if (prs == null) {
                    prs = (PRStream)PdfReader.getPdfObject(fontDescriptor.get(PdfName.FONTFILE3));
                }
                if (prs != null) {
                    try {
                        String fName = key.toString();
                        fName = fName.substring(1, fName.length());
                        BaseFont baseUnicodeFont = BaseFont.createFont(fName + ".ttf", "Identity-H", true, false, PdfReader.getStreamBytes(prs), null);
                        fName = baseUnicodeFont.getFullFontName()[0][3];
                        this.unicodeFonts.put(fName, baseUnicodeFont);
                        fName = fName.toLowerCase();
                        this.unicodeFonts.put(fName, baseUnicodeFont);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (fontFamily == null || fontName == null) continue;
                this.fontNamesMap.put(fontName, fontFamily);
            }
        }
    }

    public ArrayList<BaseFont> getAcroFormFontsList(boolean unicodeFonts) {
        ArrayList<BaseFont> list = new ArrayList<BaseFont>();
        if (unicodeFonts) {
            for (BaseFont bf : this.unicodeFonts.values()) {
                list.add(bf);
            }
        } else {
            for (BaseFont bf : this.fonts.values()) {
                list.add(bf);
            }
        }
        return list;
    }

    @Override
    public XFAFont getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color) {
        XFAFont font = this.getFont(fontname, encoding, size, style);
        font.setColor(color);
        return font;
    }

    @Override
    public XFAFont getFont(String fontname, String encoding, float size, int style) {
        BaseFont baseFont;
        if (fontname == null) {
            return new XFAFont(Font.FontFamily.UNDEFINED, size, style, (FontProvider)this);
        }
        String resolvedFontName = this.resolveFontName(fontname);
        StyleWrapper wrapper = new StyleWrapper().setStyle(style);
        wrapper.setStyleName(this.getStyleString(style));
        Map<String, BaseFont> searchIn = this.fonts;
        if (encoding.equals("Identity-H")) {
            searchIn = this.unicodeFonts;
            BaseFont unicodeBaseFont = this.getUnicodeBaseFont(resolvedFontName, size, style);
            String unicodeFontName = null;
            if (unicodeBaseFont != null) {
                unicodeFontName = unicodeBaseFont.getFullFontName()[0][3];
            }
            if (unicodeFontName != null && this.unicodeFonts.get(unicodeFontName) == null) {
                this.unicodeFonts.put(unicodeFontName, unicodeBaseFont);
            }
        }
        if ((baseFont = this.getBaseFont(resolvedFontName, wrapper, searchIn)) == null && this.fontSettings != null && this.fontSettings.getFontsPath() != null) {
            try {
                baseFont = super.getBaseFont(resolvedFontName, encoding, this.fontSettings.isEmbedExternalFonts(), true);
                if (baseFont == null) {
                    baseFont = super.getBaseFont(this.fontSettings.getSubstitutedFontName(resolvedFontName), encoding, this.fontSettings.isEmbedExternalFonts(), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new XFAFont(baseFont, size, (int)wrapper.getStyle(), (FontProvider)this);
    }

    public BaseFont getBaseFont(String typeFaceValue, StyleWrapper wrapper, Map<String, BaseFont> searchIn, boolean searchThroughFontFamilies) {
        if (searchIn == null) {
            searchIn = this.fonts;
        }
        int style = wrapper.getStyle();
        int firstSuitableFontStyle = wrapper.getStyle();
        BaseFont firstSuitableFont = null;
        boolean isRegular = (style & 1) == 0 && (style & 2) == 0;
        boolean isStyleUndefined = style == -1;
        List<String> matchingFonts = this.getMatchingFonts(typeFaceValue, searchIn, searchThroughFontFamilies, false);
        matchingFonts.addAll(this.getMatchingFonts(typeFaceValue, searchIn, searchThroughFontFamilies, true));
        for (String key : matchingFonts) {
            boolean italic;
            boolean bold;
            BaseFont font = searchIn.get(key);
            if (isStyleUndefined && key.equalsIgnoreCase(typeFaceValue)) {
                return font;
            }
            float italicAngle = font.getFontDescriptor(4, 1000.0f);
            float weight = font.getFontDescriptor(23, 1000.0f);
            if (weight == 0.0f) {
                weight = font.getFontDescriptor(21, 1000.0f);
            }
            boolean bl = weight != 0.0f ? weight > 500.0f : (bold = key.toLowerCase().contains("bold"));
            if (!bold && font.getSubfamily().equals("Bold")) {
                bold = true;
            }
            boolean bl2 = italic = italicAngle != 0.0f;
            if ((isRegular || isStyleUndefined) && !bold && !italic || !isRegular && !isStyleUndefined && bold == ((style & 1) != 0) && italic == ((style & 2) != 0)) {
                if (style != -1) {
                    if (bold && (style & 1) != 0) {
                        style &= 0xFFFFFFFE;
                        style |= 0x10;
                    }
                    if (italic && (style & 2) != 0) {
                        style &= 0xFFFFFFFD;
                        style |= 0x20;
                    }
                    wrapper.setStyle(style);
                }
                return font;
            }
            if (firstSuitableFont != null) continue;
            firstSuitableFont = font;
            firstSuitableFontStyle = wrapper.getStyle();
            if (firstSuitableFontStyle == -1) continue;
            if (bold && (style & 1) != 0) {
                firstSuitableFontStyle &= 0xFFFFFFFE;
                firstSuitableFontStyle |= 0x10;
            }
            if (!italic || (style & 2) == 0) continue;
            firstSuitableFontStyle &= 0xFFFFFFFD;
            firstSuitableFontStyle |= 0x20;
        }
        wrapper.setStyle(firstSuitableFontStyle);
        return firstSuitableFont;
    }

    private List<String> getMatchingFonts(String typeFaceValue, Map<String, BaseFont> searchIn, boolean searchThroughFontFamilies, boolean fontFaceEqualityStrip) {
        ArrayList<String> fontFaces = new ArrayList<String>();
        TreeSet<String> searchKeys = new TreeSet<String>(searchIn.keySet());
        for (ComparableKey cmpKey : this.getComparableKeySet(searchKeys)) {
            String fontFamily;
            String key = cmpKey.getKey();
            boolean fontFacesEqual = searchThroughFontFamilies ? (fontFamily = this.fontNamesMap.get(key)) != null && fontFamily.equalsIgnoreCase(typeFaceValue) : (fontFaceEqualityStrip ? XFAFontProvider.isFontFacesEqual(key, typeFaceValue) : key.trim().equalsIgnoreCase(typeFaceValue.trim()));
            if (!fontFacesEqual) continue;
            fontFaces.add(key);
        }
        return fontFaces;
    }

    public BaseFont getBaseFont(String typeFaceValue, StyleWrapper wrapper, Map<String, BaseFont> searchIn) {
        String substFontName;
        BaseFont font = null;
        if (wrapper.getStyle() != -1 && (wrapper.getStyle() & 1) != 0 && !typeFaceValue.toLowerCase().contains("bold")) {
            font = this.getBaseFont(typeFaceValue + " Bold", wrapper, searchIn, true);
        }
        if (font == null) {
            font = this.getBaseFont(typeFaceValue, wrapper, searchIn, true);
        }
        if (font == null) {
            font = this.getBaseFont(typeFaceValue, wrapper, searchIn, false);
        }
        if (font == null && this.fontSettings != null && (substFontName = this.fontSettings.getSubstitutedFontName(typeFaceValue)) != null && substFontName.length() > 0 && (font = this.getBaseFont(substFontName, wrapper, searchIn, true)) == null) {
            font = this.getBaseFont(substFontName, wrapper, searchIn, false);
        }
        return font;
    }

    private BaseFont getUnicodeBaseFont(String fontName, float size, int style) {
        PdfDictionary fontDesc;
        String substFontName;
        BaseFont baseFont;
        String fontNameAndStyle = fontName;
        String styleString = this.getStyleString(style);
        if (styleString != null && styleString.length() > 0) {
            fontNameAndStyle = fontNameAndStyle + " " + styleString;
        }
        if ((baseFont = this.unicodeFonts.get(fontNameAndStyle = fontNameAndStyle.toLowerCase())) == null) {
            baseFont = this.createUnicodeBaseFont(fontName, size, style);
        }
        if (baseFont == null && this.fontSettings != null && (substFontName = this.fontSettings.getSubstitutedFontName(fontName)) != null && substFontName.length() > 0) {
            baseFont = this.createUnicodeBaseFont(substFontName, size, style);
        }
        if (baseFont == null && (fontDesc = this.fontDescriptors.get(fontName)) != null) {
            PdfNumber flagsObject = fontDesc.getAsNumber(PdfName.FLAGS);
            int flags = flagsObject == null ? 0 : flagsObject.intValue();
            String substFontName2 = "Liberation";
            substFontName2 = (flags & 1) != 0 ? substFontName2 + "Mono" : ((flags & 2) != 0 ? substFontName2 + "Serif" : substFontName2 + "Sans");
            if (style == 3) {
                substFontName2 = substFontName2 + "BoldItalic";
            } else if (style == 1) {
                substFontName2 = substFontName2 + "Bold";
            } else if (style == 2) {
                substFontName2 = substFontName2 + "Italic";
            }
            substFontName2 = substFontName2 + ".ttf";
            InputStream is = this.getClass().getResourceAsStream("/fonts/" + substFontName2);
            if (is != null) {
                try {
                    baseFont = BaseFont.createFont(substFontName2, "Identity-H", true, true, XFAUtil.inputStreamToByteArray(is), null, true, false);
                }
                catch (IOException iOException) {
                }
                catch (DocumentException documentException) {
                    // empty catch block
                }
            }
        }
        if (baseFont != null && this.unicodeFonts.get(fontNameAndStyle) == null) {
            this.unicodeFonts.put(fontNameAndStyle, baseFont);
        }
        return baseFont;
    }

    private BaseFont createUnicodeBaseFont(String fontName, float size, int style) {
        BaseFont baseFont = null;
        Font f = null;
        try {
            f = super.getFont(fontName, "Identity-H", true, size, style, null);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        if (f != null) {
            baseFont = f.getBaseFont();
        }
        return baseFont;
    }

    private String resolveFontName(String fontname) {
        String resolved;
        if (fontname.startsWith("'") && fontname.endsWith("'")) {
            fontname = fontname.substring(1, fontname.length() - 1);
        }
        if ((resolved = this.fontNamesMap.get(fontname)) != null && resolved.length() > 0) {
            return resolved;
        }
        return fontname;
    }

    private static String trimFontName(String fontName) {
        char c;
        fontName = fontName.toLowerCase();
        String s = "";
        for (int i = 0; i < fontName.length() && (c = fontName.charAt(i)) != ' ' && c != '-'; ++i) {
            s = s + c;
        }
        return s;
    }

    private static boolean isFontFacesEqual(String s1, String s2) {
        String trimmedS1 = XFAFontProvider.trimFontName(s1);
        String trimmedS2 = XFAFontProvider.trimFontName(s2);
        return trimmedS1.equals(trimmedS2);
    }

    private String getStyleString(Integer style) {
        String styleName = "";
        if (style != -1) {
            if ((style & 1) != 0 && (style & 2) != 0) {
                styleName = "bold italic";
            } else if ((style & 1) != 0) {
                styleName = "bold";
            } else if ((style & 2) != 0) {
                styleName = "italic";
            }
        }
        return styleName;
    }

    private Set<ComparableKey> getComparableKeySet(Set<String> keySet) {
        TreeSet<ComparableKey> set = new TreeSet<ComparableKey>();
        for (String key : keySet) {
            set.add(new ComparableKey(key));
        }
        return set;
    }

    private static class ComparableKey
    implements Comparable {
        private String key;
        private String compareKey;

        public ComparableKey(String key) {
            this.key = key;
            this.compareKey = key.toLowerCase();
        }

        public String getKey() {
            return this.key;
        }

        public int compareTo(Object o) {
            String key = this.compareKey;
            if (o instanceof ComparableKey) {
                String k = ((ComparableKey)o).compareKey;
                key = this.prepareKeyForComparison(key);
                k = this.prepareKeyForComparison(k);
                return key.compareTo(k);
            }
            return -1;
        }

        private String prepareKeyForComparison(String compareKey) {
            if ((compareKey.contains("bold") || compareKey.contains("black")) && (compareKey.contains("italic") || compareKey.contains("oblique"))) {
                return "d.bold.italic." + compareKey;
            }
            if (compareKey.contains("bold") || compareKey.contains("black")) {
                return "c.bold." + compareKey;
            }
            if (compareKey.contains("italic") || compareKey.contains("oblique")) {
                return "b.italic." + compareKey;
            }
            return "a.regular." + compareKey;
        }

        public String toString() {
            return this.prepareKeyForComparison(this.compareKey);
        }
    }
}

