/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.formcalc;

import com.itextpdf.tool.xml.xtra.xfa.formcalc.FormCalcBaseVisitor;
import com.itextpdf.tool.xml.xtra.xfa.formcalc.FormCalcLexer;
import com.itextpdf.tool.xml.xtra.xfa.formcalc.FormCalcParser;
import com.itextpdf.tool.xml.xtra.xfa.formcalc.XFAFormCalcInputStream;
import com.itextpdf.tool.xml.xtra.xfa.js.JsXfa;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class FormCalc2JavaScriptConverter
extends FormCalcBaseVisitor<String> {
    @Override
    public String visitIfStatement(@NotNull FormCalcParser.IfStatementContext ctx) {
        String obj = "if ";
        obj = obj + (String)this.visit((ParseTree)ctx.parExpression());
        FormCalcParser.ThenStatementContext then = ctx.thenStatement();
        if (then != null) {
            obj = obj + (String)this.visit((ParseTree)then);
        }
        for (FormCalcParser.ElseIfStatementContext elseIf : ctx.elseIfStatement()) {
            obj = obj + (String)this.visit((ParseTree)elseIf);
        }
        FormCalcParser.ElseStatementContext elseSt = ctx.elseStatement();
        if (elseSt != null) {
            obj = obj + (String)this.visit((ParseTree)elseSt);
        }
        obj = obj + (!obj.endsWith("\n") ? "\n" : "") + "}\n";
        return obj;
    }

    @Override
    public String visitThenStatement(@NotNull FormCalcParser.ThenStatementContext ctx) {
        String obj = " {\n";
        for (FormCalcParser.StatementContext statament : ctx.statement()) {
            obj = obj + (String)this.visit((ParseTree)statament);
        }
        return obj;
    }

    @Override
    public String visitElseIfStatement(@NotNull FormCalcParser.ElseIfStatementContext ctx) {
        String obj = "\n} else if ";
        obj = obj + (String)this.visit((ParseTree)ctx.parExpression());
        FormCalcParser.ThenStatementContext then = ctx.thenStatement();
        if (then != null) {
            obj = obj + (String)this.visit((ParseTree)then);
        }
        return obj;
    }

    @Override
    public String visitElseStatement(@NotNull FormCalcParser.ElseStatementContext ctx) {
        String obj = "\n} else {\n";
        for (FormCalcParser.StatementContext statament : ctx.statement()) {
            obj = obj + (String)this.visit((ParseTree)statament);
        }
        return obj;
    }

    @Override
    public String visitForUpToStatement(@NotNull FormCalcParser.ForUpToStatementContext ctx) {
        String obj = "for (";
        if (ctx.variableAssign() != null) {
            obj = obj + (String)this.visit((ParseTree)ctx.variableAssign());
        } else if (ctx.assign() != null && ctx.assign().accessor() != null) {
            obj = obj + (String)this.visitAccessor(ctx.assign().accessor());
            obj = obj + " = ";
            obj = obj + "fc2jsHelperFuncValueOf(" + this.visitExpression(ctx.assign().expression()) + ")";
        }
        obj = obj + ";";
        String varName = null;
        if (ctx.variableAssign() != null) {
            FormCalcParser.PrimaryContext primaryContext = ctx.variableAssign().variableDeclarator().variableDeclaratorId(0).primary();
            if (primaryContext != null) {
                varName = primaryContext.getText();
            }
        } else if (ctx.assign() != null) {
            varName = ctx.assign().accessor().getText();
        }
        List<FormCalcParser.ExpressionContext> expressions = ctx.expression();
        obj = obj + " " + varName + " < " + (String)this.visit((ParseTree)expressions.get(0));
        obj = obj + ";";
        obj = expressions.size() > 1 ? obj + varName + " = " + varName + " + " + (String)this.visit((ParseTree)expressions.get(1)) : obj + varName + " = " + varName + " + 1";
        obj = obj + ") {\n";
        if (ctx.statement() != null) {
            obj = obj + (String)this.visit((ParseTree)ctx.statement());
        }
        obj = obj + "}\n";
        return obj;
    }

    @Override
    public String visitForDownToStatement(@NotNull FormCalcParser.ForDownToStatementContext ctx) {
        String obj = "for (";
        if (ctx.variableAssign() != null) {
            obj = obj + (String)this.visit((ParseTree)ctx.variableAssign());
        } else if (ctx.assign() != null && ctx.assign().accessor() != null) {
            obj = obj + (String)this.visitAccessor(ctx.assign().accessor());
            obj = obj + " = ";
            obj = obj + "fc2jsHelperFuncValueOf(" + this.visitExpression(ctx.assign().expression()) + ")";
        }
        obj = obj + ";";
        String varName = null;
        if (ctx.variableAssign() != null) {
            FormCalcParser.PrimaryContext primaryContext = ctx.variableAssign().variableDeclarator().variableDeclaratorId(0).primary();
            if (primaryContext != null) {
                varName = primaryContext.getText();
            }
        } else if (ctx.assign() != null) {
            varName = ctx.assign().accessor().getText();
        }
        List<FormCalcParser.ExpressionContext> expressions = ctx.expression();
        obj = obj + " " + varName + " > " + (String)this.visit((ParseTree)expressions.get(0));
        obj = obj + ";";
        obj = expressions.size() > 1 ? obj + varName + " = " + varName + " - " + (String)this.visit((ParseTree)expressions.get(1)) : obj + varName + " = " + varName + " - 1";
        obj = obj + ") {\n";
        if (ctx.statement() != null) {
            obj = obj + (String)this.visit((ParseTree)ctx.statement());
        }
        obj = obj + "}\n";
        return obj;
    }

    @Override
    public String visitWhileStatement(@NotNull FormCalcParser.WhileStatementContext ctx) {
        return "while " + (String)this.visit((ParseTree)ctx.parExpression()) + " {\n" + (String)this.visit((ParseTree)ctx.statement()) + "}\n";
    }

    @Override
    public String visitStatementExpression(@NotNull FormCalcParser.StatementExpressionContext ctx) {
        return (String)super.visitStatementExpression(ctx) + ";\n";
    }

    @Override
    public String visitExpression(@NotNull FormCalcParser.ExpressionContext ctx) {
        if (ctx.numericOperators() != null) {
            return "fc2jsHelperFuncNumericValueOf(" + (String)this.visit((ParseTree)ctx.expression().get(0)) + ") " + (String)this.visit((ParseTree)ctx.numericOperators()) + " fc2jsHelperFuncNumericValueOf(" + (String)this.visit((ParseTree)ctx.expression().get(1)) + ")";
        }
        return (String)super.visitExpression(ctx);
    }

    @Override
    public String visitWildcardExpression(@NotNull FormCalcParser.WildcardExpressionContext ctx) {
        return "resolveNodes(" + FormCalc2JavaScriptConverter.wrapAccessor((String)super.visitWildcardExpression(ctx)) + ")";
    }

    @Override
    public String visitVariableDeclarator(@NotNull FormCalcParser.VariableDeclaratorContext ctx) {
        String obj = "";
        String space = "var ";
        for (FormCalcParser.VariableDeclaratorIdContext variableDeclaratorIdContext : ctx.variableDeclaratorId()) {
            obj = obj + space + (String)this.visit((ParseTree)variableDeclaratorIdContext.primary());
            space = ", ";
        }
        return obj;
    }

    @Override
    public String visitVariableInitializer(@NotNull FormCalcParser.VariableInitializerContext ctx) {
        if (ctx.expression() != null) {
            return "fc2jsHelperFuncValueOf(" + (String)this.visit((ParseTree)ctx.expression()) + ")";
        }
        return (String)super.visitVariableInitializer(ctx);
    }

    @Override
    public String visitFuncCallExpression(@NotNull FormCalcParser.FuncCallExpressionContext ctx) {
        int endIndex;
        String funcCallExp = (String)super.visitFuncCallExpression(ctx);
        int startIndex = funcCallExp.lastIndexOf(46, endIndex = funcCallExp.indexOf("("));
        startIndex = startIndex == -1 ? 0 : ++startIndex;
        String funcName = funcCallExp.substring(startIndex, endIndex);
        funcName = funcName.toLowerCase();
        if (JsXfa.formCalcFunc.containsKey(funcName)) {
            String mappedFunctionName = JsXfa.formCalcFunc.get(funcName);
            if ("exists".equals(funcName)) {
                return funcCallExp.substring(0, startIndex) + mappedFunctionName + "(" + FormCalc2JavaScriptConverter.wrapAccessor(funcCallExp.substring(endIndex + 1, funcCallExp.length() - 1)) + ")";
            }
            return funcCallExp.substring(0, startIndex) + mappedFunctionName + "(" + funcCallExp.substring(endIndex + 1, funcCallExp.length() - 1) + ")";
        }
        return funcCallExp;
    }

    @Override
    public String visitParExpression(@NotNull FormCalcParser.ParExpressionContext ctx) {
        return (String)super.visitParExpression(ctx);
    }

    public String visitTerminal(@NotNull TerminalNode node) {
        return node.getText();
    }

    protected String aggregateResult(String aggregate, String nextResult) {
        return aggregate != null ? aggregate + nextResult : nextResult;
    }

    @Override
    public String visitOrOperators(@NotNull FormCalcParser.OrOperatorsContext ctx) {
        return "||";
    }

    @Override
    public String visitAndOperators(@NotNull FormCalcParser.AndOperatorsContext ctx) {
        return "&&";
    }

    @Override
    public String visitEqualityOperators(@NotNull FormCalcParser.EqualityOperatorsContext ctx) {
        String obj = (String)super.visitEqualityOperators(ctx);
        return obj.replace("<>", "!=").replace("ne", "!=").replace("eq", "==");
    }

    @Override
    public String visitRelationalOperators(@NotNull FormCalcParser.RelationalOperatorsContext ctx) {
        String obj = (String)super.visitRelationalOperators(ctx);
        return obj.replace("le", "<=").replace("ge", ">=").replace("lt", "<").replace("gt", ">");
    }

    @Override
    public String visitAssign(@NotNull FormCalcParser.AssignContext ctx) {
        String left = null;
        left = ctx.accessor() != null ? (String)this.visit((ParseTree)ctx.accessor()) : (String)this.visit((ParseTree)ctx.funcCallExpression());
        String right = (String)this.visit((ParseTree)ctx.expression());
        if ("this".equals(left)) {
            left = "$";
        }
        String tempVarName = "fc2jsTempVar" + Math.round(Math.random() * 100000.0);
        return String.format("var %s = typeof(%s) == \"undefined\" ? null : %s; ", tempVarName, left, left) + String.format("fc2jsHelperFuncIsRef(%s) ? %s.rawValue = fc2jsHelperFuncValueOf(%s) : %s = fc2jsHelperFuncValueOf(%s)", tempVarName, tempVarName, right, left, right);
    }

    @Override
    public String visitNullEqualityExpression(@NotNull FormCalcParser.NullEqualityExpressionContext ctx) {
        String value = ctx.accessor() != null ? (String)this.visit((ParseTree)ctx.accessor()) : (String)this.visit((ParseTree)ctx.funcCallExpression());
        return "fc2jsHelperFuncValueOf(" + value + ") " + (String)this.visit((ParseTree)ctx.equalityOperators()) + " null";
    }

    public static String wrapAccessor(String accessor) {
        if (!accessor.startsWith("\"")) {
            String[] accessorItemsOrIndexes = accessor.split("[\\[|\\]]");
            boolean isIndex = false;
            String wrappedAccessor = "\"";
            for (String accessorItemOrIndex : accessorItemsOrIndexes) {
                if (isIndex) {
                    wrappedAccessor = "*".equals(accessorItemOrIndex) ? wrappedAccessor + "[*]" : wrappedAccessor + "[\" + " + accessorItemOrIndex + " + \"]";
                    isIndex = false;
                    continue;
                }
                wrappedAccessor = wrappedAccessor + accessorItemOrIndex;
                isIndex = true;
            }
            return wrappedAccessor + "\"";
        }
        return accessor;
    }

    public static String convert(String formCalcScript) {
        FormCalcLexer lexer = new FormCalcLexer((CharStream)new XFAFormCalcInputStream(formCalcScript));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FormCalcParser parser = new FormCalcParser((TokenStream)tokens);
        FormCalcParser.CompilationUnitContext tree = parser.compilationUnit();
        FormCalc2JavaScriptConverter extractor = new FormCalc2JavaScriptConverter();
        return (String)extractor.visit((ParseTree)tree);
    }
}

