/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.js;

import com.itextpdf.tool.xml.xtra.xfa.XFALocale;
import com.itextpdf.tool.xml.xtra.xfa.js.JsAcrobatUtil;
import com.itextpdf.tool.xml.xtra.xfa.js.JsApp;
import com.itextpdf.tool.xml.xtra.xfa.js.JsConsole;
import com.itextpdf.tool.xml.xtra.xfa.js.JsEvent;
import com.itextpdf.tool.xml.xtra.xfa.js.JsHost;
import com.itextpdf.tool.xml.xtra.xfa.js.JsLayout;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.JsTree;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoExecutionError;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoJsNodeList;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;

public class JsXfa
extends JsNode {
    private static final String FORM_CALC_FUNCTION_PREFIX = "formCalcFunction_";
    public static final HashMap<String, String> formCalcFunc = new HashMap<String, String>(){
        {
            this.put("abs", "formCalcFunction_abs");
            this.put("concat", "formCalcFunction_concat");
            this.put("date", "formCalcFunction_date");
            this.put("datefmt", "formCalcFunction_datefmt");
            this.put("exists", "formCalcFunction_exists");
            this.put("hasvalue", "formCalcFunction_hasvalue");
            this.put("left", "formCalcFunction_left");
            this.put("len", "formCalcFunction_len");
            this.put("num2date", "formCalcFunction_num2date");
            this.put("num2time", "formCalcFunction_num2time");
            this.put("num2gmtime", "formCalcFunction_num2gmtime");
            this.put("date2num", "formCalcFunction_date2num");
            this.put("time", "formCalcFunction_time");
            this.put("time2num", "formCalcFunction_time2num");
            this.put("timefmt", "formCalcFunction_timefmt");
            this.put("replace", "formCalcFunction_replace");
            this.put("right", "formCalcFunction_right");
            this.put("round", "formCalcFunction_round");
            this.put("space", "formCalcFunction_space");
            this.put("sum", "formCalcFunction_sum");
            this.put("upper", "formCalcFunction_upper");
        }
    };

    public JsXfa(FlattenerContext flattenerContext) {
        super("xfa");
        this.flattenerContext = flattenerContext;
        this.defineProperty("xfa", this);
        this.defineProperty("util", (Object)new JsAcrobatUtil(flattenerContext));
        this.defineProperty("layout", (Object)new JsLayout(flattenerContext));
        this.defineProperty("host", (Object)new JsHost(flattenerContext.getHostConfig(), this));
        this.defineProperty("event", (Object)new JsEvent(flattenerContext));
        this.defineProperty("console", new JsConsole());
        this.defineProperty("record", JsXfa.class, 1);
        this.defineProperty("$record", JsXfa.class, 1);
        this.defineProperty("Null", null);
        this.defineProperty("app", (Object)new JsApp(flattenerContext.getAppConfig()));
        this.defineProperty("$host", JsXfa.class, 1);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("abs")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("num2date")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("date2num")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("date")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("num2time")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("num2gmtime")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("time2num")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("time")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("timefmt")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("datefmt")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("round")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("exists")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("hasvalue")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("upper")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("left")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("right")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("replace")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("space")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{formCalcFunc.get("len")}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{"fc2jsHelperFuncIsRef"}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{"fc2jsHelperFuncValueOf"}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{"fc2jsHelperFuncNumericValueOf"}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{"fc2jsHelperConcat"}, JsXfa.class, 4);
        this.defineFunctionProperties(new String[]{"fc2jsHelperNumericSum"}, JsXfa.class, 4);
        try {
            this.evaluateScript("function formCalcFunction_sum() {\n            var sumValue = 0;\n            for (var i = 0; i < arguments.length; i++) {\n               sumValue += fc2jsHelperNumericSum(arguments[i]);\n            }\n            return sumValue;\n        }");
            this.evaluateScript("function formCalcFunction_concat() {\n            var sumValue = \"\";\n            for (var i = 0; i < arguments.length; i++) {\n               sumValue += fc2jsHelperConcat(arguments[i]);\n            }\n            return sumValue;\n        }");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public JsTree resolveNodeInt(String somExpressions) {
        JsTree node = null;
        if (this.flattenerContext.getCurrentNode() != null) {
            node = this.flattenerContext.getCurrentNode().searchNode(somExpressions, true);
        }
        if (node == null) {
            node = this.searchNode(somExpressions, false);
        }
        return node;
    }

    @Override
    public RhinoJsNodeList resolveNodesInt(String somExpressions) {
        return this.searchNodes(somExpressions, false);
    }

    public String formCalcFunction_num2date(Integer numDays, Object picture, Object localeName) {
        XFATemplateTag template = this.flattenerContext.getCurrentNode().getTemplate();
        if (numDays != null && numDays > 0) {
            if (!(localeName instanceof String) || ((String)localeName).length() == 0) {
                localeName = template.getAttributes().get("locale");
            }
            XFALocale xfaLocale = this.flattenerContext.getLocaleResolver().getLocale((String)localeName);
            Calendar epoch = Calendar.getInstance();
            epoch.set(1900, 0, 1);
            epoch.add(5, numDays - 1);
            try {
                return this.flattenerContext.getFormatResolver().formatDate(epoch.getTime(), picture instanceof String ? (String)picture : "D MMM YYYY", xfaLocale);
            }
            catch (Exception exception) {
                return epoch.toString();
            }
        }
        return "";
    }

    public Long formCalcFunction_date2num(Object date, Object format, Object locale) {
        if (date instanceof JsNode) {
            date = ((JsNode)date).getProperty("rawValue");
        }
        if ((date = JsXfa.unwrap(date)) instanceof String && !((String)date).isEmpty()) {
            if (!(locale instanceof String) || ((String)locale).length() == 0) {
                XFATemplateTag template = this.flattenerContext.getCurrentNode().getTemplate();
                locale = template.getAttributes().get("locale");
            }
            XFALocale xfaLocale = this.flattenerContext.getLocaleResolver().getLocale((String)locale);
            try {
                Date parsedDate = this.flattenerContext.getFormatResolver().parseDate((String)date, format instanceof String ? (String)format : "MMM D, YYYY", xfaLocale);
                Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                now.setTime(parsedDate);
                now.setTimeInMillis(now.getTimeInMillis() - (long)(parsedDate.getTimezoneOffset() * 60 * 1000));
                Calendar epoch = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                epoch.set(1900, 0, 1, 0, 0, 0);
                epoch.set(14, 0);
                return (now.getTime().getTime() - epoch.getTime().getTime()) / 1000L / 60L / 60L / 24L + 1L;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public String formCalcFunction_datefmt(Integer pictureNumber, Object localeName) {
        if (this.flattenerContext.getCurrentNode() == null) {
            return null;
        }
        XFATemplateTag template = this.flattenerContext.getCurrentNode().getTemplate();
        if (!(localeName instanceof String) || ((String)localeName).length() == 0) {
            localeName = template.getAttributes().get("locale");
        }
        XFALocale xfaLocale = this.flattenerContext.getLocaleResolver().getLocale((String)localeName);
        switch (pictureNumber) {
            case 0: 
            case 2: {
                return xfaLocale.getDatePattern().get("med");
            }
            case 1: {
                return xfaLocale.getDatePattern().get("short");
            }
            case 3: {
                return xfaLocale.getDatePattern().get("long");
            }
            case 4: {
                return xfaLocale.getDatePattern().get("full");
            }
        }
        return null;
    }

    public String formCalcFunction_timefmt(Integer pictureNumber, Object localeName) {
        if (this.flattenerContext.getCurrentNode() == null) {
            return null;
        }
        XFATemplateTag template = this.flattenerContext.getCurrentNode().getTemplate();
        if (!(localeName instanceof String) || ((String)localeName).length() == 0) {
            localeName = template.getAttributes().get("locale");
        }
        XFALocale xfaLocale = this.flattenerContext.getLocaleResolver().getLocale((String)localeName);
        switch (pictureNumber) {
            case 0: 
            case 2: {
                return xfaLocale.getTimePattern().get("med");
            }
            case 1: {
                return xfaLocale.getTimePattern().get("short");
            }
            case 3: {
                return xfaLocale.getTimePattern().get("long");
            }
            case 4: {
                return xfaLocale.getTimePattern().get("full");
            }
        }
        return null;
    }

    public Object getRecord() {
        return this.getChild("data").retrieveChildren().get(0);
    }

    public Object get$record() {
        return this.getRecord();
    }

    public Integer formCalcFunction_date() {
        Calendar epoch = Calendar.getInstance();
        epoch.set(1900, 0, 1);
        Calendar now = Calendar.getInstance();
        int days = 1;
        while (epoch.before(now)) {
            ++days;
            epoch.add(5, 1);
        }
        return days;
    }

    public Long formCalcFunction_time() {
        Calendar epoch = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        epoch.set(epoch.get(1), epoch.get(2), epoch.get(5), 0, 0, 0);
        epoch.add(14, 1);
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        epoch.setTimeZone(TimeZone.getTimeZone("GMT"));
        return now.getTime().getTime() - epoch.getTime().getTime();
    }

    public String formCalcFunction_num2time(Object time, Object picture, Object localeName) {
        return this.formCalcFunction_num2gmtime(time, picture, localeName);
    }

    public String formCalcFunction_num2gmtime(Object time, Object picture, Object localeName) {
        if (time instanceof JsNode) {
            time = ((JsNode)time).getProperty("rawValue");
        }
        if ((time = JsXfa.unwrap(time)) instanceof Long && (Long)time > 0L) {
            if (!(localeName instanceof String) || ((String)localeName).length() == 0) {
                XFATemplateTag template = this.flattenerContext.getCurrentNode().getTemplate();
                localeName = template.getAttributes().get("locale");
            }
            XFALocale xfaLocale = this.flattenerContext.getLocaleResolver().getLocale((String)localeName);
            Calendar epoch = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            epoch.set(epoch.get(1), epoch.get(2), epoch.get(5), 0, 0, 0);
            Date date = epoch.getTime();
            date.setTime(date.getTime() + (Long)time);
            try {
                return this.flattenerContext.getFormatResolver().formatTime(date, picture instanceof String ? (String)picture : "h:MM:SS A", xfaLocale);
            }
            catch (Exception exception) {
                return epoch.toString();
            }
        }
        return "";
    }

    public Long formCalcFunction_time2num(Object time, Object picture, Object localeName) {
        if (time instanceof JsNode) {
            time = ((JsNode)time).getProperty("rawValue");
        }
        if ((time = JsXfa.unwrap(time)) instanceof String && !((String)time).isEmpty()) {
            if (!(localeName instanceof String) || ((String)localeName).length() == 0) {
                XFATemplateTag template = this.flattenerContext.getCurrentNode().getTemplate();
                localeName = template.getAttributes().get("locale");
            }
            XFALocale xfaLocale = this.flattenerContext.getLocaleResolver().getLocale((String)localeName);
            try {
                Date date = this.flattenerContext.getFormatResolver().parseTime((String)time, picture instanceof String ? (String)picture : "h:MM:SS A", xfaLocale);
                Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                now.setTime(date);
                Calendar epoch = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                epoch.set(epoch.get(1), epoch.get(2), epoch.get(5), 0, 0, 0);
                epoch.set(14, 0);
                now.set(epoch.get(1), epoch.get(2), epoch.get(5));
                return now.getTime().getTime() - epoch.getTime().getTime();
            }
            catch (Exception exc) {
                boolean bl = true;
            }
        }
        return null;
    }

    public Object formCalcFunction_abs(Object number) {
        number = this.fc2jsHelperFuncNumericValueOf(number);
        Double numberValue = null;
        if (number instanceof Number) {
            numberValue = ((Number)number).doubleValue();
        } else if (number instanceof String) {
            numberValue = Double.valueOf((String)number);
        }
        if (numberValue != null && !numberValue.isNaN()) {
            return Math.abs(numberValue);
        }
        return number;
    }

    public Object formCalcFunction_round(Object number, Integer i) {
        number = this.fc2jsHelperFuncNumericValueOf(number);
        Double numberValue = null;
        if (number instanceof Number) {
            numberValue = ((Number)number).doubleValue();
        } else if (number instanceof String) {
            numberValue = Double.valueOf((String)number);
        }
        if (numberValue != null && !numberValue.isNaN()) {
            if (i > 0) {
                numberValue = numberValue * (double)(i * 10);
            }
            Long roundedNumber = Math.round(numberValue);
            if (i > 0) {
                roundedNumber = roundedNumber / (long)(i * 10);
            }
            return roundedNumber.intValue();
        }
        return number;
    }

    public Object formCalcFunction_exists(Object accessor) {
        return this.resolveNodeInt((String)accessor) != null;
    }

    public Boolean formCalcFunction_hasvalue(Object obj) {
        if (obj instanceof JsNode) {
            obj = ((JsNode)obj).getProperty("rawValue");
        }
        if (obj instanceof String) {
            return !((String)obj).trim().isEmpty();
        }
        return obj != null;
    }

    public String formCalcFunction_upper(Object obj) {
        if (obj instanceof JsNode) {
            obj = ((JsNode)obj).getProperty("rawValue");
        }
        if (obj instanceof String) {
            return ((String)obj).toUpperCase();
        }
        return null;
    }

    public String formCalcFunction_left(Object obj, Object charNum) {
        if (obj instanceof JsNode) {
            obj = ((JsNode)obj).getProperty("rawValue");
        }
        if (obj instanceof String && charNum instanceof Number) {
            String str = (String)obj;
            return str.substring(0, Math.min(str.length(), ((Number)charNum).intValue()));
        }
        return null;
    }

    public String formCalcFunction_right(Object obj, Object charNum) {
        if (obj instanceof JsNode) {
            obj = ((JsNode)obj).getProperty("rawValue");
        }
        if (obj instanceof String && charNum instanceof Number) {
            String str = (String)obj;
            int actualCharNum = Math.min(str.length(), ((Number)charNum).intValue());
            return str.substring(str.length() - actualCharNum, str.length());
        }
        return null;
    }

    public String formCalcFunction_replace(Object source, Object toReplace, Object replacement) {
        if (source instanceof JsNode) {
            source = ((JsNode)source).getProperty("rawValue");
        }
        if (source instanceof String && toReplace instanceof String) {
            if (!(replacement instanceof String)) {
                replacement = "";
            }
            return ((String)source).replace((String)toReplace, (String)replacement);
        }
        return null;
    }

    public String formCalcFunction_space(Object numOfSpaces) {
        if (numOfSpaces instanceof JsNode) {
            numOfSpaces = ((JsNode)numOfSpaces).getProperty("rawValue");
        }
        if (numOfSpaces instanceof Number) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ((Number)numOfSpaces).intValue(); ++i) {
                sb.append(" ");
            }
            return sb.toString();
        }
        return null;
    }

    public Integer formCalcFunction_len(Object str) {
        if (str instanceof JsNode) {
            str = ((JsNode)str).getProperty("rawValue");
        }
        if (str instanceof String) {
            return ((String)str).length();
        }
        return 0;
    }

    public Object get$host() {
        return this.getProperty("host");
    }

    public Boolean fc2jsHelperFuncIsRef(Object obj) {
        return obj instanceof JsNode;
    }

    public Object fc2jsHelperFuncValueOf(Object obj) {
        if (obj instanceof JsNode) {
            return ((JsNode)obj).getProperty("rawValue");
        }
        return obj;
    }

    public String fc2jsHelperConcat(Object obj) {
        String result = "";
        if (obj instanceof String) {
            result = result + (String)obj;
        } else if (obj instanceof JsNode) {
            result = result + this.fc2jsHelperConcat(((JsNode)obj).getProperty("rawValue"));
        } else if (obj instanceof NativeArray) {
            int i = 0;
            while ((long)i < ((NativeArray)obj).getLength()) {
                result = result + this.fc2jsHelperConcat(((NativeArray)obj).get(i, (Scriptable)((NativeArray)obj)));
                ++i;
            }
        } else if (obj instanceof Number) {
            String value = null;
            try {
                DecimalFormat df = new DecimalFormat();
                df.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
                df.setGroupingUsed(false);
                value = df.format(obj);
            }
            catch (Exception exc) {
                value = null;
            }
            if (value != null) {
                result = result + value;
            }
        } else if (obj instanceof Boolean) {
            result = (Boolean)obj != false ? result + "1" : result + "0";
        }
        return result;
    }

    public double fc2jsHelperNumericSum(Object obj) {
        obj = JsXfa.unwrap(obj);
        Double result = 0.0;
        if (obj instanceof Number) {
            result = result + ((Number)obj).doubleValue();
        } else if (obj instanceof JsNode) {
            result = result + this.fc2jsHelperNumericSum(((JsNode)obj).getProperty("rawValue"));
        } else if (obj instanceof NativeArray) {
            int i = 0;
            while ((long)i < ((NativeArray)obj).getLength()) {
                result = result + this.fc2jsHelperNumericSum(((NativeArray)obj).get(i, (Scriptable)((NativeArray)obj)));
                ++i;
            }
        } else if (obj instanceof String) {
            Number value = null;
            try {
                ParsePosition pos = new ParsePosition(0);
                value = new DecimalFormat().parse((String)obj, pos);
                if (pos.getIndex() != ((String)obj).length() || pos.getErrorIndex() != -1) {
                    value = null;
                }
            }
            catch (Exception parsExc) {
                value = null;
            }
            if (value != null) {
                result = result + value.doubleValue();
            }
        } else if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            result = result + 1.0;
        }
        return result;
    }

    public double fc2jsHelperFuncNumericValueOf(Object obj) {
        if ((obj = JsXfa.unwrap(obj)) instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof JsNode) {
            return this.fc2jsHelperFuncNumericValueOf(((JsNode)obj).getProperty("rawValue"));
        }
        if (obj instanceof NativeArray) {
            throw new RhinoExecutionError("Attempt to get value from an array during FormCalc evaluation");
        }
        if (obj instanceof String) {
            Number value = null;
            try {
                ParsePosition pos = new ParsePosition(0);
                value = new DecimalFormat().parse((String)obj, pos);
                if (pos.getIndex() != ((String)obj).length() || pos.getErrorIndex() != -1) {
                    value = null;
                }
            }
            catch (Exception parsExc) {
                value = null;
            }
            if (value != null) {
                return value.doubleValue();
            }
        } else if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            return 1.0;
        }
        return 0.0;
    }
}

