/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.GposValueRecord;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OtfReadCommon;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GposLookupType1
extends OpenTableLookup {
    private static final long serialVersionUID = 4562279115440679363L;
    private Map<Integer, GposValueRecord> valueRecordMap = new HashMap<Integer, GposValueRecord>();

    public GposLookupType1(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.readSubTables();
    }

    @Override
    public boolean transformOne(GlyphLine line) {
        if (line.idx >= line.end) {
            return false;
        }
        if (this.openReader.isSkip(line.get(line.idx).getCode(), this.lookupFlag)) {
            ++line.idx;
            return false;
        }
        int glyphCode = line.get(line.idx).getCode();
        boolean positionApplied = false;
        GposValueRecord valueRecord = this.valueRecordMap.get(glyphCode);
        if (valueRecord != null) {
            Glyph newGlyph = new Glyph(line.get(line.idx));
            newGlyph.xAdvance = (short)(newGlyph.xAdvance + (short)valueRecord.XAdvance);
            newGlyph.yAdvance = (short)(newGlyph.yAdvance + (short)valueRecord.YAdvance);
            line.set(line.idx, newGlyph);
            positionApplied = true;
        }
        ++line.idx;
        return positionApplied;
    }

    @Override
    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        this.openReader.rf.readShort();
        int coverage = this.openReader.rf.readUnsignedShort();
        int valueFormat = this.openReader.rf.readUnsignedShort();
        GposValueRecord valueRecord = OtfReadCommon.readGposValueRecord(this.openReader, valueFormat);
        List<Integer> coverageGlyphIds = this.openReader.readCoverageFormat(subTableLocation + coverage);
        for (Integer glyphId : coverageGlyphIds) {
            this.valueRecordMap.put((int)glyphId, valueRecord);
        }
    }
}

