/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.font;

import com.itextpdf.io.font.FontNames;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.kernel.font.Type3Glyph;
import java.util.HashMap;
import java.util.Map;

public class Type3Font
extends FontProgram {
    private static final long serialVersionUID = 1027076515537536993L;
    private final Map<Integer, Type3Glyph> type3Glyphs = new HashMap<Integer, Type3Glyph>();
    private boolean colorized = false;
    private int flags = 0;

    Type3Font(boolean colorized) {
        this.colorized = colorized;
        this.fontNames = new FontNames();
        this.getFontMetrics().setBbox(0, 0, 0, 0);
    }

    public Type3Glyph getType3Glyph(int unicode) {
        return this.type3Glyphs.get(unicode);
    }

    @Override
    public int getPdfFontFlags() {
        return this.flags;
    }

    @Override
    public boolean isFontSpecific() {
        return false;
    }

    public boolean isColorized() {
        return this.colorized;
    }

    @Override
    public int getKerning(Glyph glyph1, Glyph glyph2) {
        return 0;
    }

    public int getNumberOfGlyphs() {
        return this.type3Glyphs.size();
    }

    @Override
    protected void setFontName(String fontName) {
        super.setFontName(fontName);
    }

    @Override
    protected void setFontFamily(String fontFamily) {
        super.setFontFamily(fontFamily);
    }

    @Override
    protected void setFontWeight(int fontWeight) {
        super.setFontWeight(fontWeight);
    }

    @Override
    protected void setFontStretch(String fontWidth) {
        super.setFontStretch(fontWidth);
    }

    @Override
    protected void setItalicAngle(int italicAngle) {
        super.setItalicAngle(italicAngle);
    }

    void setPdfFontFlags(int flags) {
        this.flags = flags;
    }

    void addGlyph(int code, int unicode, int width, int[] bbox, Type3Glyph type3Glyph) {
        Glyph glyph = new Glyph(code, width, unicode, bbox);
        this.codeToGlyph.put(code, glyph);
        this.unicodeToGlyph.put(unicode, glyph);
        this.type3Glyphs.put(unicode, type3Glyph);
        this.recalculateAverageWidth();
    }

    private void recalculateAverageWidth() {
        int widthSum = 0;
        for (Glyph glyph : this.codeToGlyph.values()) {
            widthSum += glyph.getWidth();
        }
        this.avgWidth = widthSum / this.codeToGlyph.size();
    }
}

