/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.Paragraph;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.css.apply.PageSizeContainable;
import com.itextpdf.tool.xml.css.apply.ParagraphCssApplier;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.pdfelement.XFAParagraph;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.HashMap;

public class XFAParagraphCssApplier
extends ParagraphCssApplier {
    public XFAParagraphCssApplier(CssAppliers appliers) {
        super(appliers);
    }

    @Override
    public Paragraph apply(Paragraph p, Tag t, MarginMemory configuration, PageSizeContainable psc, HtmlPipelineContext ctx) {
        if (p instanceof XFAParagraph) {
            ((XFAParagraph)p).setUserStyles((HashMap)t.getCSS());
        }
        Paragraph result = super.apply(p, t, configuration, psc, ctx);
        String textIndent = t.getCSS().get("text-indent");
        if (textIndent != null && !textIndent.isEmpty()) {
            float ti = CssUtils.getInstance().parsePxInCmMmPcToPt(textIndent, "pt");
            if (ti > 0.0f) {
                result.setFirstLineIndent(ti);
            } else if (ti < 0.0f) {
                result.setIndentationLeft(result.getIndentationLeft() + Math.abs(ti));
                result.setFirstLineIndent(ti);
            }
        }
        return result;
    }
}

