/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.xtra.xfa.element.AbstractDrawer;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import java.util.HashMap;
import java.util.Map;

public class MarkDrawer
extends AbstractDrawer {
    private final float size;
    private final String shape;
    private final String mark;
    private final boolean hasEmbossedStyle;
    private final float thickness;
    private final BaseColor markColor;
    private Map<Character, PdfTemplate> symbols;

    public MarkDrawer(float size, String shape, String mark, boolean hasLoweredStyle, float thickness, BaseColor markColor) {
        this.size = size;
        this.mark = mark;
        this.shape = shape;
        this.hasEmbossedStyle = hasLoweredStyle;
        this.thickness = thickness;
        this.markColor = markColor;
    }

    @Override
    public void draw(PdfContentByte canvas, XFARectangle rec) {
        if ("default".equalsIgnoreCase(this.mark)) {
            this.drawDefaultMark(canvas, rec);
        } else if ("check".equalsIgnoreCase(this.mark)) {
            this.drawCheckMark(canvas, rec);
        } else if ("circle".equalsIgnoreCase(this.mark)) {
            this.drawCircleMark(canvas, rec);
        } else if ("cross".equalsIgnoreCase(this.mark)) {
            this.drawCrossMark(canvas, rec);
        } else if ("diamond".equalsIgnoreCase(this.mark)) {
            this.drawDiamondMark(canvas, rec);
        } else if ("square".equalsIgnoreCase(this.mark)) {
            this.drawSquareMark(canvas, rec);
        } else if ("star".equalsIgnoreCase(this.mark)) {
            this.drawStarMark(canvas, rec);
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    protected void drawDefaultRectangleMark(PdfContentByte canvas, XFARectangle rec) {
        canvas.setLineWidth(this.thickness);
        float markSize = this.hasEmbossedStyle ? this.size - this.thickness * 5.0f : this.size - this.thickness * 2.0f;
        canvas.moveTo(rec.getLlx().floatValue() + (rec.getWidth().floatValue() - markSize) / 2.0f, rec.getUry().floatValue() - rec.getHeight().floatValue() + (rec.getHeight().floatValue() - markSize) / 2.0f);
        canvas.lineTo(rec.getLlx().floatValue() + rec.getWidth().floatValue() - (rec.getWidth().floatValue() - markSize) / 2.0f, rec.getUry().floatValue() - (rec.getHeight().floatValue() - markSize) / 2.0f);
        canvas.stroke();
        canvas.moveTo(rec.getLlx().floatValue() + (rec.getWidth().floatValue() - markSize) / 2.0f, rec.getUry().floatValue() - (rec.getHeight().floatValue() - markSize) / 2.0f);
        canvas.lineTo(rec.getLlx().floatValue() + rec.getWidth().floatValue() - (rec.getWidth().floatValue() - markSize) / 2.0f, rec.getUry().floatValue() - rec.getHeight().floatValue() + (rec.getHeight().floatValue() - markSize) / 2.0f);
        canvas.stroke();
    }

    protected void drawDefaultRoundMark(PdfContentByte canvas, XFARectangle rec) {
        float markSize = this.size;
        markSize = this.hasEmbossedStyle ? this.size * 0.2f : this.size * 0.25f;
        canvas.circle(rec.getLlx().floatValue() + this.size / 2.0f, rec.getUry().floatValue() - this.size / 2.0f, markSize);
        canvas.fill();
    }

    protected void drawDefaultMark(PdfContentByte canvas, XFARectangle rec) {
        if (canvas.isTagged()) {
            canvas.openMCBlock(this);
        }
        canvas.saveState();
        if (this.markColor != null) {
            canvas.setColorStroke(this.markColor);
            canvas.setColorFill(this.markColor);
        }
        if ("rectangle".equalsIgnoreCase(this.shape)) {
            this.drawDefaultRectangleMark(canvas, rec);
        } else if ("round".equalsIgnoreCase(this.shape)) {
            this.drawDefaultRoundMark(canvas, rec);
        }
        canvas.restoreState();
        if (canvas.isTagged()) {
            canvas.closeMCBlock(this);
        }
    }

    protected void drawCheckMark(PdfContentByte canvas, XFARectangle rec) {
        this.drawSymbolicMark(canvas, rec, '4', 0.7f);
    }

    protected void drawCircleMark(PdfContentByte canvas, XFARectangle rec) {
        this.drawSymbolicMark(canvas, rec, 'l');
    }

    protected void drawCrossMark(PdfContentByte canvas, XFARectangle rec) {
        this.drawSymbolicMark(canvas, rec, '6');
    }

    protected void drawDiamondMark(PdfContentByte canvas, XFARectangle rec) {
        this.drawSymbolicMark(canvas, rec, 'u');
    }

    protected void drawSquareMark(PdfContentByte canvas, XFARectangle rec) {
        this.drawSymbolicMark(canvas, rec, 'n');
    }

    protected void drawStarMark(PdfContentByte canvas, XFARectangle rec) {
        this.drawSymbolicMark(canvas, rec, 'H');
    }

    protected void drawSymbolicMark(PdfContentByte canvas, XFARectangle rec, char symbol) {
        this.drawSymbolicMark(canvas, rec, symbol, 0.8f);
    }

    protected PdfTemplate getSymbolTemplate(char symbol, PdfWriter writer) {
        if (this.symbols == null) {
            this.symbols = new HashMap<Character, PdfTemplate>();
        }
        if (!this.symbols.containsKey(Character.valueOf(symbol))) {
            PdfTemplate newSymbolTemplate = PdfTemplate.createTemplate(writer, 0.0f, 0.0f);
            switch (symbol) {
                case '4': {
                    newSymbolTemplate.setBoundingBox(new Rectangle(29.0f, -149.849f, 817.0f, 783.128f));
                    newSymbolTemplate.moveTo(119.0f, 292.0f);
                    newSymbolTemplate.curveTo(95.0f, 284.0f, 48.0f, 251.0f, 29.0f, 235.0f);
                    newSymbolTemplate.curveTo(80.0f, 157.0f, 154.0f, 1.0f, 188.0f, -104.0f);
                    newSymbolTemplate.curveTo(193.0f, -120.0f, 262.0f, -166.0f, 272.0f, -144.0f);
                    newSymbolTemplate.curveTo(372.0f, 88.0f, 658.0f, 602.0f, 817.0f, 781.0f);
                    newSymbolTemplate.curveTo(793.0f, 785.0f, 737.0f, 783.0f, 719.0f, 778.0f);
                    newSymbolTemplate.curveTo(695.0f, 771.0f, 685.0f, 763.0f, 668.0f, 750.0f);
                    newSymbolTemplate.curveTo(576.0f, 680.0f, 376.0f, 372.0f, 255.0f, 143.0f);
                    newSymbolTemplate.curveTo(241.0f, 182.0f, 207.0f, 236.0f, 185.0f, 266.0f);
                    newSymbolTemplate.curveTo(167.0f, 290.0f, 140.0f, 298.0f, 119.0f, 292.0f);
                    newSymbolTemplate.closePath();
                    newSymbolTemplate.fill();
                    break;
                }
                case 'l': {
                    newSymbolTemplate.setBoundingBox(new Rectangle(35.0f, -14.0f, 757.0f, 708.0f));
                    newSymbolTemplate.moveTo(402.0f, 708.0f);
                    newSymbolTemplate.curveTo(595.0f, 708.0f, 757.0f, 544.0f, 757.0f, 347.0f);
                    newSymbolTemplate.curveTo(757.0f, 148.0f, 595.0f, -14.0f, 396.0f, -14.0f);
                    newSymbolTemplate.curveTo(196.0f, -14.0f, 35.0f, 148.0f, 35.0f, 350.0f);
                    newSymbolTemplate.curveTo(35.0f, 549.0f, 198.0f, 708.0f, 402.0f, 708.0f);
                    newSymbolTemplate.closePath();
                    newSymbolTemplate.fill();
                    break;
                }
                case '6': {
                    newSymbolTemplate.setBoundingBox(new Rectangle(29.0f, 5.0f, 732.0f, 698.0f));
                    newSymbolTemplate.moveTo(720.0f, 672.0f);
                    newSymbolTemplate.lineTo(729.0f, 658.0f);
                    newSymbolTemplate.curveTo(713.0f, 617.0f, 556.0f, 432.0f, 471.0f, 345.0f);
                    newSymbolTemplate.curveTo(537.0f, 255.0f, 695.0f, 68.0f, 732.0f, 34.0f);
                    newSymbolTemplate.lineTo(730.0f, 19.0f);
                    newSymbolTemplate.curveTo(720.0f, 14.0f, 604.0f, 5.0f, 592.0f, 5.0f);
                    newSymbolTemplate.curveTo(568.0f, 5.0f, 538.0f, 18.0f, 495.0f, 57.0f);
                    newSymbolTemplate.curveTo(470.0f, 80.0f, 416.0f, 141.0f, 369.0f, 192.0f);
                    newSymbolTemplate.curveTo(360.0f, 201.0f, 343.0f, 203.0f, 338.0f, 196.0f);
                    newSymbolTemplate.curveTo(253.0f, 89.0f, 214.0f, 62.0f, 194.0f, 50.0f);
                    newSymbolTemplate.curveTo(158.0f, 27.0f, 63.0f, 12.0f, 35.0f, 9.0f);
                    newSymbolTemplate.lineTo(29.0f, 24.0f);
                    newSymbolTemplate.curveTo(59.0f, 51.0f, 217.0f, 239.0f, 253.0f, 285.0f);
                    newSymbolTemplate.curveTo(258.0f, 290.0f, 260.0f, 305.0f, 255.0f, 311.0f);
                    newSymbolTemplate.curveTo(164.0f, 414.0f, 108.0f, 482.0f, 90.0f, 514.0f);
                    newSymbolTemplate.curveTo(69.0f, 551.0f, 67.0f, 568.0f, 74.0f, 586.0f);
                    newSymbolTemplate.curveTo(82.0f, 604.0f, 162.0f, 687.0f, 186.0f, 698.0f);
                    newSymbolTemplate.lineTo(200.0f, 698.0f);
                    newSymbolTemplate.curveTo(229.0f, 642.0f, 322.0f, 514.0f, 391.0f, 445.0f);
                    newSymbolTemplate.curveTo(445.0f, 499.0f, 518.0f, 596.0f, 549.0f, 645.0f);
                    newSymbolTemplate.curveTo(553.0f, 652.0f, 680.0f, 669.0f, 720.0f, 672.0f);
                    newSymbolTemplate.closePath();
                    newSymbolTemplate.fill();
                    break;
                }
                case 'u': {
                    newSymbolTemplate.setBoundingBox(new Rectangle(35.0f, -14.0f, 754.0f, 705.0f));
                    newSymbolTemplate.moveTo(395.0f, -14.0f);
                    newSymbolTemplate.lineTo(35.0f, 346.0f);
                    newSymbolTemplate.lineTo(395.0f, 705.0f);
                    newSymbolTemplate.lineTo(754.0f, 346.0f);
                    newSymbolTemplate.lineTo(395.0f, -14.0f);
                    newSymbolTemplate.closePath();
                    newSymbolTemplate.fill();
                    break;
                }
                case 'n': {
                    newSymbolTemplate.setBoundingBox(new Rectangle(35.0f, 0.0f, 726.0f, 691.0f));
                    newSymbolTemplate.moveTo(726.0f, 0.0f);
                    newSymbolTemplate.lineTo(35.0f, 0.0f);
                    newSymbolTemplate.lineTo(35.0f, 691.0f);
                    newSymbolTemplate.lineTo(726.0f, 691.0f);
                    newSymbolTemplate.lineTo(726.0f, 0.0f);
                    newSymbolTemplate.closePath();
                    newSymbolTemplate.fill();
                    break;
                }
                case 'H': {
                    newSymbolTemplate.setBoundingBox(new Rectangle(35.0f, -13.0f, 782.0f, 707.0f));
                    newSymbolTemplate.moveTo(409.0f, 707.0f);
                    newSymbolTemplate.lineTo(494.0f, 437.0f);
                    newSymbolTemplate.lineTo(782.0f, 437.0f);
                    newSymbolTemplate.lineTo(551.0f, 263.0f);
                    newSymbolTemplate.lineTo(640.0f, -13.0f);
                    newSymbolTemplate.lineTo(409.0f, 157.0f);
                    newSymbolTemplate.lineTo(179.0f, -13.0f);
                    newSymbolTemplate.lineTo(269.0f, 263.0f);
                    newSymbolTemplate.lineTo(35.0f, 437.0f);
                    newSymbolTemplate.lineTo(322.0f, 437.0f);
                    newSymbolTemplate.lineTo(409.0f, 707.0f);
                    newSymbolTemplate.closePath();
                    newSymbolTemplate.fill();
                }
            }
            this.symbols.put(Character.valueOf(symbol), newSymbolTemplate);
        }
        return this.symbols.get(Character.valueOf(symbol));
    }

    protected void drawSymbolicMark(PdfContentByte canvas, XFARectangle rec, char symbol, float fontSizeScaler) {
        Paragraph mcBlockParagraph = null;
        if (canvas.isTagged()) {
            mcBlockParagraph = new Paragraph();
            canvas.openMCBlock(mcBlockParagraph);
            canvas.openMCBlock(this);
        }
        float fontSize = this.size * fontSizeScaler;
        PdfTemplate symbolTemplate = this.getSymbolTemplate(symbol, canvas.getPdfWriter());
        float scale = fontSize / 1000.0f;
        float scaledWidth = symbolTemplate.getWidth() * scale;
        float scaledHeight = symbolTemplate.getHeight() * scale;
        canvas.fill();
        canvas.addTemplate(symbolTemplate, scale, 0.0f, 0.0f, scale, rec.getLlx().floatValue() + (rec.getWidth().floatValue() - scaledWidth) / 2.0f - symbolTemplate.getBoundingBox().getLeft() * scale, rec.getUry().floatValue() - (rec.getHeight().floatValue() + scaledHeight) / 2.0f - symbolTemplate.getBoundingBox().getBottom() * scale);
        if (canvas.isTagged()) {
            canvas.closeMCBlock(mcBlockParagraph);
            canvas.closeMCBlock(this);
        }
    }
}

