/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.xtra.xfa.element.BorderDrawer;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;

public class RoundBorderDrawer
extends BorderDrawer {
    private float borderWidth = 1.0f;
    private String stroke = "solid";
    private BaseColor strokeColor = new BaseColor(0, 0, 0);

    public RoundBorderDrawer(FormNode border) {
        super(border);
        FormNode edgeTag = border.retrieveChild("edge");
        if (edgeTag != null) {
            String colorValue;
            FormNode colorTag;
            String strokeAttr = edgeTag.retrieveAttribute("stroke");
            if (strokeAttr != null) {
                this.stroke = strokeAttr;
            }
            if ((colorTag = edgeTag.retrieveChild("color")) != null && (colorValue = colorTag.retrieveAttribute("value")) != null && colorValue.length() > 0) {
                this.strokeColor = XFAUtil.parseXfaColor(colorValue);
            }
        }
    }

    @Override
    public void draw(PdfContentByte canvas, XFARectangle borderArea) {
        this.updateBorderLinesPoints(borderArea);
        float size = borderArea.getWidth().floatValue();
        float radius = borderArea.getWidth().floatValue() / 2.0f;
        if (canvas.isTagged()) {
            canvas.openMCBlock(this);
        }
        canvas.saveState();
        canvas.setLineWidth(this.borderWidth * 0.5f);
        canvas.setColorFill(new BaseColor(255, 255, 255));
        canvas.circle(borderArea.getLlx().floatValue() + radius, borderArea.getUry().floatValue() - radius, radius);
        canvas.fill();
        canvas.restoreState();
        if (this.stroke.equalsIgnoreCase("lowered") || this.stroke.equalsIgnoreCase("etched") || this.stroke.equalsIgnoreCase("raised") || this.stroke.equalsIgnoreCase("embossed")) {
            canvas.saveState();
            canvas.setLineWidth(this.borderWidth * 0.5f);
            canvas.setColorStroke(new BaseColor(212, 208, 200));
            canvas.circle(borderArea.getLlx().floatValue() + radius, borderArea.getUry().floatValue() - radius, radius - this.borderWidth * 0.75f);
            canvas.stroke();
            canvas.setColorStroke(new BaseColor(128, 128, 128));
            canvas.arc(borderArea.getLlx().floatValue() + this.borderWidth * 0.25f, borderArea.getUry().floatValue() - this.borderWidth * 0.25f, borderArea.getLlx().floatValue() + borderArea.getWidth().floatValue() - this.borderWidth * 0.25f, borderArea.getUry().floatValue() - borderArea.getHeight().floatValue() + this.borderWidth * 0.25f, 45.0f + 30.0f / size, 180.0f - 60.0f / size);
            canvas.stroke();
            canvas.setColorStroke(new BaseColor(64, 64, 64));
            canvas.arc(borderArea.getLlx().floatValue() + this.borderWidth * 0.75f, borderArea.getUry().floatValue() - this.borderWidth * 0.75f, borderArea.getLlx().floatValue() + borderArea.getWidth().floatValue() - this.borderWidth * 0.75f, borderArea.getUry().floatValue() - borderArea.getHeight().floatValue() + this.borderWidth * 0.75f, 45.0f - 30.0f / size, 180.0f + 60.0f / size);
            canvas.stroke();
            canvas.restoreState();
        } else {
            canvas.saveState();
            canvas.setLineWidth(this.borderWidth * 0.5f);
            canvas.setColorStroke(this.strokeColor);
            canvas.circle(borderArea.getLlx().floatValue() + radius, borderArea.getUry().floatValue() - radius, radius);
            canvas.stroke();
            canvas.restoreState();
        }
        if (canvas.isTagged()) {
            canvas.closeMCBlock(this);
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

