/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.positioner;

import com.itextpdf.tool.xml.xtra.xfa.positioner.ExclGroupPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.FieldPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;

class ExclGroupValueResolver {
    private boolean isInPropagationProcess;
    private ExclGroupPositioner exclGroupPositioner;

    public ExclGroupValueResolver(ExclGroupPositioner exclGroupPositioner) {
        this.exclGroupPositioner = exclGroupPositioner;
    }

    void propagateValueFromChildToParent(Object rawValue, Object prevValue, FieldPositioner fieldPositioner) {
        if (this.isInPropagationProcess) {
            return;
        }
        this.isInPropagationProcess = true;
        if (fieldPositioner.correspondsToOnValue(rawValue)) {
            this.exclGroupPositioner.setRawValue(rawValue);
            this.propagateValueToChildren(rawValue);
        } else if (fieldPositioner.correspondsToOnValue(prevValue)) {
            this.exclGroupPositioner.setRawValue("");
        }
        this.isInPropagationProcess = false;
    }

    boolean propagateValueFromParentToChildren(Object rawValue) {
        if (this.isInPropagationProcess) {
            return true;
        }
        this.isInPropagationProcess = true;
        boolean foundChildWithCorrespondingOnValue = this.propagateValueToChildren(rawValue);
        this.isInPropagationProcess = false;
        return foundChildWithCorrespondingOnValue;
    }

    private boolean propagateValueToChildren(Object rawValue) {
        boolean foundChildWithCorrespondingOnValue = false;
        for (Positioner child : this.exclGroupPositioner.childElements) {
            FieldPositioner fieldPos;
            if (!(child instanceof FieldPositioner) || !(fieldPos = (FieldPositioner)child).isCheckButtonInsideRadioButtonList()) continue;
            if (fieldPos.correspondsToOnValue(rawValue)) {
                fieldPos.setRawValue(rawValue);
                foundChildWithCorrespondingOnValue = true;
                continue;
            }
            fieldPos.setRawValue(null);
        }
        return foundChildWithCorrespondingOnValue;
    }
}

