/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.resolver;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.CustomContext;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.xtra.xfa.XFAConstants;
import com.itextpdf.tool.xml.xtra.xfa.XFAFlattener;
import com.itextpdf.tool.xml.xtra.xfa.config.AppConfig;
import com.itextpdf.tool.xml.xtra.xfa.config.HostConfig;
import com.itextpdf.tool.xml.xtra.xfa.element.PageSet;
import com.itextpdf.tool.xml.xtra.xfa.element.TextDrawer;
import com.itextpdf.tool.xml.xtra.xfa.font.XFAFont;
import com.itextpdf.tool.xml.xtra.xfa.js.JsContainer;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.JsScript;
import com.itextpdf.tool.xml.xtra.xfa.js.JsTree;
import com.itextpdf.tool.xml.xtra.xfa.pipe.FormBuilder;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubFormPositioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.ConfigResolver;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FormatResolver;
import com.itextpdf.tool.xml.xtra.xfa.resolver.LocaleResolver;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class FlattenerContext
implements CustomContext {
    private static final int JS_EVENTS_STACK_SIZE_LIMIT = 100;
    private Stack<JsEventsStackEntry> jsEventsStack = new Stack();
    private final FormatResolver formatResolver;
    private FontProvider fontProvider;
    private List<TextDrawer> unresolvedTextDrawers = new ArrayList<TextDrawer>();
    private SubFormPositioner domPositioner;
    private Positioner currentNode;
    private Document document;
    protected Integer currentSheetNumber = null;
    protected Integer currentPageNumber = null;
    protected Integer currentAbsPageNumber = null;
    private Integer lastNumberedPage = null;
    protected Integer pageCount = null;
    protected Integer sheetCount = null;
    private LocaleResolver localeResolver;
    private XFAFlattener.ViewMode viewMode;
    private boolean legacyPlusPrint = false;
    private Map<String, PdfObject> xfaImages = new HashMap<String, PdfObject>();
    private FormBuilder formBuilder;
    private List<String> extraEventList;
    private PdfReader reader;
    private Map<String, PdfDictionary> signatureFields = null;
    private PageSet pageSet;
    private boolean validateLayout;
    private AppConfig appConfig;
    private HostConfig hostConfig;
    private ConfigResolver configResolver;
    private float xfaVersion = 3.3f;
    private List<JsScript> scriptVariablesToBeEvaluated = new ArrayList<JsScript>();
    private PdfWriter voidPdfWriter = FlattenerContext.createDummyPdfWriter();

    public FlattenerContext(FontProvider fontProvider, Document document, PdfArray xfaImagesArr) {
        this.formatResolver = new FormatResolver(this);
        this.fontProvider = fontProvider;
        this.document = document;
        if (xfaImagesArr != null) {
            String imageRef = null;
            for (PdfObject img : xfaImagesArr) {
                if (img.isString()) {
                    imageRef = img.toString();
                    continue;
                }
                if (img.isIndirect()) {
                    try {
                        this.xfaImages.put(imageRef, img);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                imageRef = null;
            }
        }
    }

    public FormatResolver getFormatResolver() {
        return this.formatResolver;
    }

    public Integer getLastNumberedPage() {
        return this.lastNumberedPage;
    }

    public void resetPageNumbers() {
        this.currentPageNumber = null;
        this.lastNumberedPage = null;
        this.currentSheetNumber = null;
        this.currentAbsPageNumber = null;
    }

    public Integer getCurrentPageNumber() {
        return this.currentPageNumber;
    }

    public void setCurrentPageNumber(Integer currentPageNumber) {
        this.currentPageNumber = currentPageNumber;
    }

    public Integer getCurrentAbsPageNumber() {
        return this.currentAbsPageNumber;
    }

    public void setCurrentAbsPageNumber(Integer currentAbsPageNumber) {
        this.currentAbsPageNumber = currentAbsPageNumber;
    }

    public Integer getCurrentSheetNumber() {
        return this.currentSheetNumber;
    }

    public void setCurrentSheetNumber(Integer currentSheetNumber) {
        this.currentSheetNumber = currentSheetNumber;
    }

    public void moveToNextPage(boolean numbered) {
        Integer n;
        Integer n2;
        if (this.currentPageNumber != null && this.currentPageNumber != 0) {
            this.lastNumberedPage = this.currentPageNumber;
        }
        this.currentPageNumber = numbered ? (this.lastNumberedPage == null ? Integer.valueOf(1) : Integer.valueOf(this.lastNumberedPage + 1)) : Integer.valueOf(0);
        if (this.currentSheetNumber == null) {
            this.currentSheetNumber = 1;
        } else {
            n2 = this.currentSheetNumber;
            n = this.currentSheetNumber = Integer.valueOf(this.currentSheetNumber + 1);
        }
        if (this.currentAbsPageNumber == null) {
            this.currentAbsPageNumber = 1;
        } else {
            n2 = this.currentAbsPageNumber;
            n = this.currentAbsPageNumber = Integer.valueOf(this.currentAbsPageNumber + 1);
        }
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public Integer getSheetCount() {
        return this.sheetCount;
    }

    public void setSheetCount(Integer sheetCount) {
        this.sheetCount = sheetCount;
    }

    public SubFormPositioner getDomPositioner() {
        return this.domPositioner;
    }

    public void setDomPositioner(SubFormPositioner domPositioner) {
        this.domPositioner = domPositioner;
    }

    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    public ConfigResolver getConfigResolver() {
        return this.configResolver;
    }

    public void setConfigResolver(ConfigResolver configResolver) {
        this.configResolver = configResolver;
    }

    public XFAFlattener.ViewMode getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(XFAFlattener.ViewMode viewMode) {
        this.viewMode = viewMode;
    }

    public AppConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public void setHostConfig(HostConfig hostConfig) {
        this.hostConfig = hostConfig;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public Positioner getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Positioner currentNode) {
        this.currentNode = currentNode;
    }

    public FormBuilder getFormBuilder() {
        return this.formBuilder;
    }

    public void setFormBuilder(FormBuilder formBuilder) {
        this.formBuilder = formBuilder;
    }

    public List<String> getExtraEventList() {
        return this.extraEventList;
    }

    public void setExtraEventList(List<String> extraEventList) {
        this.extraEventList = extraEventList;
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public void setReader(PdfReader reader) {
        this.reader = reader;
    }

    public PageSet getPageSet() {
        return this.pageSet;
    }

    public void setPageSet(PageSet pageSet) {
        this.pageSet = pageSet;
    }

    public boolean isValidateLayout() {
        return this.validateLayout;
    }

    public void setValidateLayout(boolean validateLayout) {
        this.validateLayout = validateLayout;
    }

    public FontProvider getFontProvider() {
        return this.fontProvider;
    }

    public PdfWriter getVoidPdfWriter() {
        return this.voidPdfWriter;
    }

    public Positioner resolvePositioner(String somExpressions) {
        JsTree node = null;
        if (this.currentNode != null) {
            node = this.currentNode.resolveNode(somExpressions);
        }
        if (node == null) {
            node = this.domPositioner.searchNodeDown(somExpressions);
        }
        return node instanceof Positioner ? (Positioner)node : null;
    }

    public Font getFont(FormNode node, String encoding) {
        FormNode font = this.getFontNode(node);
        return this.createFont(font, encoding);
    }

    public FormNode getFontNode(FormNode node) {
        JsNode resolvedHrefFont;
        String use;
        FormNode parent;
        FormNode font = node.retrieveChild("font");
        if (font == null && (parent = node.retrieveParent()) != null) {
            font = parent.retrieveChild("font");
        }
        if (font != null && (use = font.retrieveAttribute("use")) != null && (resolvedHrefFont = (JsNode)this.domPositioner.searchNodeDown(use)) != null) {
            font = resolvedHrefFont;
        }
        return font;
    }

    private Font createFont(FormNode fontNode, String encoding) {
        Font font = null;
        if (fontNode != null) {
            String colorValue;
            FormNode colorNode;
            String typeface = fontNode.retrieveAttribute("typeface");
            String sizeValue = fontNode.retrieveAttribute("size");
            String weightValue = fontNode.retrieveAttribute("weight");
            String postureValue = fontNode.retrieveAttribute("posture");
            if (typeface == null) {
                typeface = "Courier";
            }
            if (sizeValue == null) {
                sizeValue = "10";
            }
            int style = -1;
            if ("bold".equalsIgnoreCase(weightValue) && "italic".equalsIgnoreCase(postureValue)) {
                style = 3;
            } else if ("italic".equalsIgnoreCase(postureValue)) {
                style = 2;
            } else if ("bold".equalsIgnoreCase(weightValue)) {
                style = 1;
            }
            BaseColor color = BaseColor.BLACK;
            FormNode fillNode = fontNode.retrieveChild("fill");
            if (fillNode != null && (colorNode = fillNode.retrieveChild("color")) != null && (colorValue = colorNode.retrieveAttribute("value")) != null) {
                color = XFAUtil.parseXfaColor(colorValue);
            }
            font = encoding.equals("Identity-H") ? this.fontProvider.getFont(typeface, "Identity-H", false, CssUtils.getInstance().parsePxInCmMmPcToPt(sizeValue, "pt"), style, color) : this.fontProvider.getFont(typeface, "Cp1252", false, CssUtils.getInstance().parsePxInCmMmPcToPt(sizeValue, "pt"), style, color);
        }
        if (font == null) {
            font = new XFAFont(XFAConstants.DEFAULT_FONTFAMILY, Float.parseFloat("10"), this.fontProvider);
        }
        return font;
    }

    public void addUnresolvedTextDrawer(TextDrawer textDrawer) {
        this.unresolvedTextDrawers.add(textDrawer);
    }

    public void drawUnresolvedTextDrawers() throws DocumentException {
        for (TextDrawer unresolvedTextDrawer : this.unresolvedTextDrawers) {
            unresolvedTextDrawer.resolveEmbeddedElementsAndDraw(true);
        }
    }

    public PdfObject getImage(String imgRef) {
        return this.xfaImages.get(imgRef);
    }

    public boolean isLegacyPlusPrint() {
        return this.legacyPlusPrint;
    }

    public void setLegacyPlusPrint(boolean legacyPlusPrint) {
        this.legacyPlusPrint = legacyPlusPrint;
    }

    public float getXfaVersion() {
        return this.xfaVersion;
    }

    public void setXfaVersion(float xfaVersion) {
        this.xfaVersion = xfaVersion;
    }

    public Map<String, PdfDictionary> getSignatureFields() {
        if (this.signatureFields == null && this.reader != null) {
            this.signatureFields = new HashMap<String, PdfDictionary>();
            AcroFields acroFields = this.reader.getAcroFields();
            if (acroFields.getFields() != null) {
                ArrayList<String> signatureNames = acroFields.getSignatureNames();
                for (String signatureName : signatureNames) {
                    AcroFields.Item item = acroFields.getFields().get(signatureName);
                    if (item == null) continue;
                    this.signatureFields.put(signatureName, item.getWidget(0));
                }
            }
        }
        return this.signatureFields;
    }

    public void addScriptVariableToBeEvaluated(JsScript script) {
        if (this.scriptVariablesToBeEvaluated != null) {
            this.scriptVariablesToBeEvaluated.add(script);
        } else {
            script.evaluate();
        }
    }

    public void evaluateScriptVariables() {
        for (JsScript script : this.scriptVariablesToBeEvaluated) {
            script.evaluate();
        }
        this.scriptVariablesToBeEvaluated = null;
    }

    public void pushJsEventCallStack(JsContainer eventOwner, String activity, String script) {
        JsEventsStackEntry item = new JsEventsStackEntry(eventOwner, activity, script);
        boolean stackOverflow = this.jsEventsStack.size() > 100 && this.jsEventsStack.contains(item);
        this.jsEventsStack.push(item);
        if (stackOverflow) {
            throw new IllegalStateException("JS recursive event calls stack overflow.");
        }
    }

    public void popJsEventCallStack() {
        this.jsEventsStack.pop();
    }

    private static PdfWriter createDummyPdfWriter() {
        Document document = new Document();
        try {
            PdfWriter writer = PdfWriter.getInstance(document, new ByteArrayOutputStream());
            document.open();
            document.newPage();
            return writer;
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private static class JsEventsStackEntry {
        private final JsContainer eventOwner;
        private final String activity;
        private final String script;

        JsEventsStackEntry(JsContainer eventOwner, String activity, String script) {
            this.eventOwner = eventOwner;
            this.activity = activity;
            this.script = script;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsEventsStackEntry that = (JsEventsStackEntry)o;
            return (this.eventOwner == null ? that.eventOwner == null : this.eventOwner.equals(that.eventOwner)) && (this.activity == null ? that.activity == null : this.activity.equals(that.activity)) && (this.script == null ? that.script == null : this.script.equals(that.script));
        }

        public int hashCode() {
            Object[] objs = new Object[]{this.eventOwner, this.activity, this.script};
            int result = 1;
            for (Object element : objs) {
                result = 31 * result + (element == null ? 0 : element.hashCode());
            }
            return result;
        }
    }
}

