/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.util;

import com.itextpdf.text.BaseColor;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;

public final class XFAUtil {
    public static final float DEVIATION = 0.1f;
    public static final int MATCH_ALL_NODES = -1;
    public static final CssUtils cssUtils = CssUtils.getInstance();

    public static String getAttributeValue(String attributeName, Map<String, String> attributes) {
        String value = null;
        if (attributes != null) {
            value = attributes.get(attributeName);
        }
        return value;
    }

    public static Float parseFloat(String s) {
        Float parseInt = null;
        if (null != s) {
            try {
                parseInt = Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException e) {
                parseInt = Float.valueOf(cssUtils.parsePxInCmMmPcToPt(s));
            }
        }
        return parseInt;
    }

    public static Float parseFloatToPt(String s) {
        Float parseInt = null;
        if (null != s) {
            try {
                parseInt = Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException e) {
                parseInt = Float.valueOf(cssUtils.parsePxInCmMmPcToPt(s, "pt"));
            }
        }
        return parseInt;
    }

    public static Float parsePercent(String s) {
        if (!s.endsWith("%")) {
            return null;
        }
        Float parsed = null;
        try {
            parsed = Float.valueOf(Float.parseFloat(s.substring(0, s.length() - 1)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return parsed;
    }

    public static Float parsePxInCmMmPcToPt(String length) {
        if (length == null) {
            return null;
        }
        try {
            return Float.valueOf(cssUtils.parsePxInCmMmPcToPt(length, "in"));
        }
        catch (NumberFormatException exc) {
            return null;
        }
    }

    public static Integer parseInt(String s) {
        Integer parsedInt = null;
        if (s != null) {
            try {
                parsedInt = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                parsedInt = null;
            }
        }
        return parsedInt;
    }

    public static Integer parseInt(String s, Integer defaultValue) {
        Integer parsedInt = null;
        if (s != null) {
            try {
                parsedInt = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                parsedInt = null;
            }
        }
        return parsedInt != null ? parsedInt : defaultValue;
    }

    public static float reverseX(Float originX, Float x) {
        if (x == null) {
            return originX.floatValue();
        }
        return originX.floatValue() + x.floatValue();
    }

    public static float reverseY(Float originY, Float y, Float heigth) {
        if (null == heigth && null != y) {
            return originY.floatValue() - y.floatValue();
        }
        if (null == y && null != heigth) {
            return originY.floatValue() - heigth.floatValue();
        }
        if (null == y && null == heigth) {
            return originY.floatValue();
        }
        return originY.floatValue() - y.floatValue() - heigth.floatValue();
    }

    public static XFARectangle extractRectangleFromAttributes(Map<String, String> attributes) {
        Float y;
        XFARectangle r = null;
        Float x = XFAUtil.parsePxInCmMmPcToPt(attributes.get("x"));
        if (x == null) {
            x = Float.valueOf(0.0f);
        }
        if ((y = XFAUtil.parsePxInCmMmPcToPt(attributes.get("y"))) == null) {
            y = Float.valueOf(0.0f);
        }
        Float w = XFAUtil.parsePxInCmMmPcToPt(attributes.get("w"));
        Float h = XFAUtil.parsePxInCmMmPcToPt(attributes.get("h"));
        r = new XFARectangle(x, y, w, h);
        if (w == null) {
            Float minW = XFAUtil.parsePxInCmMmPcToPt(attributes.get("minW"));
            r.setMinW(minW);
            Float maxW = XFAUtil.parsePxInCmMmPcToPt(attributes.get("maxW"));
            r.setMaxW(maxW);
        }
        if (h == null) {
            Float minH = XFAUtil.parsePxInCmMmPcToPt(attributes.get("minH"));
            r.setMinH(minH);
            Float maxH = XFAUtil.parsePxInCmMmPcToPt(attributes.get("maxH"));
            r.setMaxH(maxH);
        }
        return r;
    }

    public static void setMinAsDefault(XFARectangle contentArea) {
        Float height = contentArea.getHeight();
        Float minH = contentArea.getMinH();
        if (height == null && minH != null) {
            contentArea.setHeight(minH);
        }
        Float width = contentArea.getWidth();
        Float minW = contentArea.getMinW();
        if (width == null && minW != null) {
            contentArea.setWidth(minW);
        }
    }

    public static String checkSomExpression(String refValue) {
        String result = null;
        if (refValue != null && !refValue.equals("")) {
            String[] dataStructure = refValue.split("\\.");
            result = dataStructure[dataStructure.length - 1];
        }
        return result;
    }

    public static ArrayList<Float> parseNumArray(String source) {
        ArrayList<Float> result = new ArrayList<Float>();
        String s = source + " ";
        if (source.length() > 0) {
            String curNumber = "";
            for (int curPosition = 0; curPosition < s.length(); ++curPosition) {
                char curPosChar = s.charAt(curPosition);
                if (curPosChar != ' ') {
                    curNumber = curNumber + curPosChar;
                    continue;
                }
                XFAUtil.addNumberToList(curNumber, result);
                curNumber = "";
            }
        }
        return result;
    }

    public static BaseColor parseXfaColor(String xfaColor) {
        String s;
        ArrayList<Float> colorValueList;
        BaseColor result = null;
        if (xfaColor != null && (colorValueList = XFAUtil.parseNumArray(s = xfaColor.replaceAll(",", " "))).size() > 2) {
            result = new BaseColor(colorValueList.get(0).intValue() & 0xFF, colorValueList.get(1).intValue() & 0xFF, colorValueList.get(2).intValue() & 0xFF);
        }
        return result;
    }

    public static boolean lt(float a, float b) {
        return b - a > 0.1f;
    }

    public static boolean gt(float a, float b) {
        return a - b > 0.1f;
    }

    public static boolean lte(float a, float b) {
        float c = b - a;
        return c > 0.1f || c > -0.1f;
    }

    public static boolean gte(float a, float b) {
        float c = a - b;
        return c > 0.1f || c > -0.1f;
    }

    public static boolean equal(float a, float b) {
        return Math.abs(a - b) < 0.1f;
    }

    private static void addNumberToList(String s, ArrayList<Float> numbers) {
        if ((s = s.replaceAll(" ", "")).length() > 0) {
            float num = CssUtils.getInstance().parsePxInCmMmPcToPt(s, "pt");
            numbers.add(Float.valueOf(num));
        }
    }

    public static byte[] inputStreamToByteArray(InputStream stream) throws IOException {
        int read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = stream.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, read);
        }
        out.flush();
        return out.toByteArray();
    }

    public static NameIndexPair splitNameIndexPair(String nameIndexPair) {
        int nodeIndexValue = 0;
        if (nameIndexPair.matches(".+\\[(\\d+|\\*)\\]$")) {
            String nodeIndex = nameIndexPair.replaceAll(".+\\[", "");
            nodeIndex = nodeIndex.replaceAll("\\]$", "");
            nameIndexPair = nameIndexPair.replaceAll("\\[(\\d+|\\*)\\]$", "");
            if (!nodeIndex.equals("*")) {
                try {
                    nodeIndexValue = Integer.parseInt(nodeIndex);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                nodeIndexValue = -1;
            }
        }
        return new NameIndexPair(nameIndexPair, nodeIndexValue);
    }

    public static class NameIndexPair {
        public String name;
        public int index;

        public NameIndexPair(String name, int index) {
            this.name = name;
            this.index = index;
        }
    }
}

