/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactoryImp;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.css.apply.PageSizeContainable;
import com.itextpdf.tool.xml.html.CssApplier;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Deprecated
public class ChunkCssApplier
implements CssApplier<Chunk> {
    public static final List<String> BOLD = Arrays.asList("bold", "bolder", "600", "700", "800", "900");
    protected final CssUtils utils = CssUtils.getInstance();
    protected FontProvider fontProvider;

    public ChunkCssApplier() {
        this(null);
    }

    public ChunkCssApplier(FontProvider fontProvider) {
        this.fontProvider = fontProvider != null ? fontProvider : new FontFactoryImp();
    }

    public Chunk apply(Chunk c, Tag t) {
        return this.apply(c, t, (MarginMemory)null, (PageSizeContainable)null, (HtmlPipelineContext)null);
    }

    @Override
    public Chunk apply(Chunk c, Tag t, MarginMemory mm, PageSizeContainable psc, HtmlPipelineContext ctx) {
        String xfaVertScale;
        Font f = this.applyFontStyles(t);
        float size = f.getSize();
        Map<String, String> rules = t.getCSS();
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            String[] key = entry.getKey();
            String value = entry.getValue();
            if ("font-style".equalsIgnoreCase((String)key)) {
                if (!value.equalsIgnoreCase("oblique")) continue;
                c.setSkew(0.0f, 12.0f);
                continue;
            }
            if ("letter-spacing".equalsIgnoreCase((String)key)) {
                String letterSpacing = rules.get("letter-spacing");
                float letterSpacingValue = 0.0f;
                if (this.utils.isRelativeValue(value)) {
                    letterSpacingValue = this.utils.parseRelativeValue(letterSpacing, f.getSize());
                } else if (this.utils.isMetricValue(value)) {
                    letterSpacingValue = this.utils.parsePxInCmMmPcToPt(letterSpacing);
                }
                c.setCharacterSpacing(letterSpacingValue);
                continue;
            }
            if (null == rules.get("xfa-font-horizontal-scale")) continue;
            c.setHorizontalScaling(Float.parseFloat(rules.get("xfa-font-horizontal-scale").replace("%", "")) / 100.0f);
        }
        if (null != rules.get("vertical-align")) {
            String value = rules.get("vertical-align");
            if (value.equalsIgnoreCase("super") || value.equalsIgnoreCase("top") || value.equalsIgnoreCase("text-top")) {
                c.setTextRise((float)((double)(size / 2.0f) + 0.5));
            } else if (value.equalsIgnoreCase("sub") || value.equalsIgnoreCase("bottom") || value.equalsIgnoreCase("text-bottom")) {
                c.setTextRise(-size / 2.0f);
            } else {
                c.setTextRise(this.utils.parsePxInCmMmPcToPt(value));
            }
        }
        if (null != (xfaVertScale = rules.get("xfa-font-vertical-scale")) && xfaVertScale.contains("%")) {
            size *= Float.parseFloat(xfaVertScale.replace("%", "")) / 100.0f;
            c.setHorizontalScaling(100.0f / Float.parseFloat(xfaVertScale.replace("%", "")));
        }
        if (null != rules.get("text-decoration")) {
            String[] splitValues;
            for (String value : splitValues = rules.get("text-decoration").split("\\s+")) {
                if ("underline".equalsIgnoreCase(value)) {
                    c.setUnderline(null, 0.75f, 0.0f, 0.0f, -0.125f, 0);
                }
                if (!"line-through".equalsIgnoreCase(value)) continue;
                c.setUnderline(null, 0.75f, 0.0f, 0.0f, 0.25f, 0);
            }
        }
        if (null != rules.get("background-color")) {
            c.setBackground(HtmlUtilities.decodeColor(rules.get("background-color")));
        }
        f.setSize(size);
        c.setFont(f);
        Float leading = null;
        if (rules.get("line-height") != null) {
            String value = rules.get("line-height");
            if (this.utils.isNumericValue(value)) {
                leading = Float.valueOf(Float.parseFloat(value) * c.getFont().getSize());
            } else if (this.utils.isRelativeValue(value)) {
                leading = Float.valueOf(this.utils.parseRelativeValue(value, c.getFont().getSize()));
            } else if (this.utils.isMetricValue(value)) {
                leading = Float.valueOf(this.utils.parsePxInCmMmPcToPt(value));
            }
        }
        if (leading != null) {
            c.setLineHeight(leading.floatValue());
        }
        return c;
    }

    public Font applyFontStyles(Tag t) {
        String fontName = null;
        String encoding = "Cp1252";
        float size = FontSizeTranslator.getInstance().getFontSize(t);
        if (size == -1.0f) {
            size = 12.0f;
        }
        int style = -1;
        BaseColor color = null;
        Map<String, String> rules = t.getCSS();
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("font-weight".equalsIgnoreCase(key)) {
                if (this.isBoldValue(value)) {
                    if (style == 2) {
                        style = 3;
                        continue;
                    }
                    style = 1;
                    continue;
                }
                if (style == 3) {
                    style = 2;
                    continue;
                }
                if (style != 1) continue;
                style = 0;
                continue;
            }
            if ("font-style".equalsIgnoreCase(key)) {
                if (!value.equalsIgnoreCase("italic")) continue;
                if (style == 1) {
                    style = 3;
                    continue;
                }
                style = 2;
                continue;
            }
            if ("font-family".equalsIgnoreCase(key)) {
                fontName = value;
                continue;
            }
            if (!"color".equalsIgnoreCase(key)) continue;
            color = HtmlUtilities.decodeColor(value);
        }
        if (fontName != null) {
            if (fontName.contains(",")) {
                String[] fonts = fontName.split(",");
                Font firstFont = null;
                for (String s : fonts) {
                    if (!this.fontProvider.isRegistered(s = this.utils.trimAndRemoveQuoutes(s))) continue;
                    Font f = this.fontProvider.getFont(s, encoding, true, size, style, color);
                    if (f != null && (style == 0 || style == -1 || (f.getStyle() & style) == 0)) {
                        return f;
                    }
                    if (firstFont != null) continue;
                    firstFont = f;
                }
                if (firstFont != null) {
                    return firstFont;
                }
                fontName = fonts.length > 0 ? this.utils.trimAndRemoveQuoutes(fontName.split(",")[0]) : null;
            } else {
                fontName = this.utils.trimAndRemoveQuoutes(fontName);
            }
        }
        return this.fontProvider.getFont(fontName, encoding, true, size, style, color);
    }

    public float getWidestWord(Chunk c) {
        String[] words = c.getContent().split("\\s");
        float widestWord = 0.0f;
        for (int i = 0; i < words.length; ++i) {
            Chunk word = new Chunk(words[i]);
            this.copyChunkStyles(c, word);
            if (!(word.getWidthPoint() > widestWord)) continue;
            widestWord = word.getWidthPoint();
        }
        return widestWord;
    }

    public void copyChunkStyles(Chunk source, Chunk target) {
        target.setFont(source.getFont());
        target.setAttributes(source.getAttributes());
        target.setCharacterSpacing(source.getCharacterSpacing());
        target.setHorizontalScaling(source.getHorizontalScaling());
        target.setHorizontalScaling(source.getHorizontalScaling());
    }

    public FontProvider getFontProvider() {
        return this.fontProvider;
    }

    public void setFontProvider(FontProvider fontProvider) {
        this.fontProvider = fontProvider;
    }

    protected boolean isBoldValue(String value) {
        return "bold".contains(value = value.trim()) || value.length() == 3 && value.endsWith("00") && value.charAt(0) >= '6' && value.charAt(0) <= '9';
    }
}

