/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.tool.xml.xtra.xfa.element.ArcDrawer;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentElement;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;

public class ArcElement
extends ContentElement {
    private ArcDrawer arcDrawer;

    public ArcElement(FormNode elementTag, XFARectangle elementRec, Document document) {
        super(elementTag, elementRec, document);
        this.arcDrawer = new ArcDrawer(elementTag);
    }

    @Override
    public PositionResult.State draw(PdfContentByte canvas, XFARectangle parentBoundingBox) {
        XFARectangle rec = this.elementRec.clone();
        if (parentBoundingBox != null) {
            float ury = rec.getUry().floatValue();
            ury = Math.min(ury, parentBoundingBox.getUry().floatValue());
            float lly = rec.getUry().floatValue() - rec.getHeight().floatValue();
            lly = Math.max(lly, parentBoundingBox.getUry().floatValue() - parentBoundingBox.getHeight().floatValue());
            float height = ury - lly;
            rec.setUry(Float.valueOf(ury));
            rec.setHeight(Float.valueOf(height));
        }
        this.arcDrawer.draw(canvas, rec);
        return PositionResult.State.FULL_CONTENT;
    }

    @Override
    public boolean isEmpty() {
        return this.arcDrawer.isEmpty();
    }

    @Override
    public boolean isTagged() {
        return super.isTagged() && this.arcDrawer.getRole() != PdfName.ARTIFACT;
    }
}

