/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.xtra.xfa.element.CaptionElement;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentElement;
import com.itextpdf.tool.xml.xtra.xfa.element.MarkDrawer;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.element.RoundBorderDrawer;
import com.itextpdf.tool.xml.xtra.xfa.element.TextElement;
import com.itextpdf.tool.xml.xtra.xfa.element.UiElement;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.ArrayList;
import java.util.List;

public class CheckButtonElement
extends UiElement {
    private float size = 10.0f;
    private String shape = "rectangle";
    private String mark = "default";
    private boolean hasEmbossedStyle = false;
    private Float thickness = Float.valueOf(0.5f);
    private String onValue = null;
    private String hAlign;

    public CheckButtonElement(FormNode elementTag, XFARectangle elementRec, Document document, ContentElement contentElement, String hAlign, CaptionElement captionElement) {
        super(elementTag, elementRec, document, contentElement);
        String sizeAttr;
        this.hAlign = hAlign;
        if (this.hAlign == null) {
            this.hAlign = (String)this.para.get("hAlign");
        }
        if ((sizeAttr = (String)this.attributes.get("size")) != null && sizeAttr.length() > 0) {
            this.size = CssUtils.getInstance().parsePxInCmMmPcToPt(sizeAttr, "pt");
        }
        if (this.attributes.get("shape") != null) {
            FormNode border = elementTag.retrieveChild("border");
            this.shape = (String)this.attributes.get("shape");
            if (border != null && "round".equalsIgnoreCase(this.shape)) {
                this.borderDrawer = new RoundBorderDrawer(border);
            }
        }
        if (this.borderDrawer != null) {
            this.hasEmbossedStyle = this.borderDrawer.hasEmbossedStyle();
            if (this.borderDrawer.borderEdges != null && !this.borderDrawer.borderEdges.isEmpty()) {
                this.thickness = this.borderDrawer.borderEdges.get(0).getThickness();
            }
        }
        if (this.attributes.get("mark") != null) {
            this.mark = (String)this.attributes.get("mark");
        }
        if (elementRec.getWidth() == null) {
            if (elementRec.getMinW() != null) {
                elementRec.setWidth(Float.valueOf(Math.max(elementRec.getMinW().floatValue(), this.size)));
            } else if (elementRec.getMaxW() != null) {
                elementRec.setWidth(Float.valueOf(Math.min(elementRec.getMaxW().floatValue(), this.size)));
            } else {
                elementRec.setWidth(Float.valueOf(this.size));
            }
        }
        if (elementRec.getHeight() == null) {
            if (elementRec.getMinH() != null) {
                elementRec.setHeight(Float.valueOf(Math.max(elementRec.getMinH().floatValue(), this.size)));
            } else if (elementRec.getMaxH() != null) {
                elementRec.setHeight(Float.valueOf(Math.min(elementRec.getMaxH().floatValue(), this.size)));
            } else {
                elementRec.setHeight(Float.valueOf(this.size));
            }
        }
        if (captionElement != null && captionElement.getReserve() == null) {
            elementRec.setHeight(Float.valueOf(this.size));
            elementRec.setWidth(Float.valueOf(this.size));
        }
        this.initOnValue();
    }

    @Override
    public PositionResult.State draw(PdfContentByte canvas, XFARectangle parentBoundingBox) {
        String content;
        ArrayList<Element> paragraphs;
        XFARectangle rec = this.elementRec.clone();
        String vAlign = (String)this.para.get("vAlign");
        if ("bottom".equalsIgnoreCase(vAlign)) {
            rec.setUry(Float.valueOf(rec.getUry().floatValue() - (rec.getHeight().floatValue() - this.size)));
        } else if ("middle".equalsIgnoreCase(vAlign)) {
            rec.setUry(Float.valueOf(rec.getUry().floatValue() - (rec.getHeight().floatValue() - this.size) / 2.0f));
        } else if ("top".equalsIgnoreCase(vAlign)) {
            // empty if block
        }
        if ("right".equalsIgnoreCase(this.hAlign)) {
            rec.setLlx(Float.valueOf(rec.getLlx().floatValue() + rec.getWidth().floatValue() - this.size));
        } else if ("center".equalsIgnoreCase(this.hAlign)) {
            rec.setLlx(Float.valueOf(rec.getLlx().floatValue() + (rec.getWidth().floatValue() - this.size) / 2.0f));
        } else if ("left".equalsIgnoreCase(this.hAlign)) {
            // empty if block
        }
        rec.setHeight(Float.valueOf(this.size));
        rec.setWidth(Float.valueOf(this.size));
        if (this.borderDrawer != null) {
            this.borderDrawer.draw(canvas, rec);
        }
        if (this.onValue != null && this.contentElement != null && this.contentElement instanceof TextElement && (paragraphs = ((TextElement)this.contentElement).getContent()).size() == 1 && paragraphs.get(0) instanceof Paragraph && this.onValue.equalsIgnoreCase(content = ((Paragraph)paragraphs.get(0)).getContent())) {
            MarkDrawer markDrawer = new MarkDrawer(this.size, this.shape, this.mark, this.hasEmbossedStyle, this.thickness.floatValue(), this.retrieveMarkColor());
            markDrawer.draw(canvas, rec);
        }
        return PositionResult.State.FULL_CONTENT;
    }

    public PositionResult.State drawAsField(PdfContentByte canvas, XFARectangle parentBoundingBox, String alternateText, String name) {
        String content;
        ArrayList<Element> paragraphs;
        XFARectangle rec = this.elementRec.clone();
        String vAlign = (String)this.para.get("vAlign");
        if ("bottom".equalsIgnoreCase(vAlign)) {
            rec.setUry(Float.valueOf(rec.getUry().floatValue() - (rec.getHeight().floatValue() - this.size)));
        } else if ("middle".equalsIgnoreCase(vAlign)) {
            rec.setUry(Float.valueOf(rec.getUry().floatValue() - (rec.getHeight().floatValue() - this.size) / 2.0f));
        } else if ("top".equalsIgnoreCase(vAlign)) {
            // empty if block
        }
        if ("right".equalsIgnoreCase(this.hAlign)) {
            rec.setLlx(Float.valueOf(rec.getLlx().floatValue() + rec.getWidth().floatValue() - this.size));
        } else if ("center".equalsIgnoreCase(this.hAlign)) {
            rec.setLlx(Float.valueOf(rec.getLlx().floatValue() + (rec.getWidth().floatValue() - this.size) / 2.0f));
        } else if ("left".equalsIgnoreCase(this.hAlign)) {
            // empty if block
        }
        rec.setHeight(Float.valueOf(this.size));
        rec.setWidth(Float.valueOf(this.size));
        Rectangle widgetRect = new Rectangle(rec.getLlx().floatValue() - 1.0f, rec.getUry().floatValue() - rec.getHeight().floatValue() - 1.0f, rec.getLlx().floatValue() + rec.getWidth().floatValue() + 1.0f, rec.getUry().floatValue() + 1.0f);
        PdfFormField field = PdfFormField.createCheckBox(canvas.getPdfWriter());
        field.setWidget(widgetRect, PdfAnnotation.HIGHLIGHT_INVERT);
        field.setFlags(708);
        field.setFieldFlags(1);
        field.setPage();
        field.put(PdfName.NM, new PdfString(name));
        field.put(PdfName.T, new PdfString(name));
        field.put(PdfName.TU, new PdfString(alternateText));
        PdfAppearance as = null;
        if (this.onValue != null && this.contentElement != null && this.contentElement instanceof TextElement && (paragraphs = ((TextElement)this.contentElement).getContent()).size() == 1 && paragraphs.get(0) instanceof Paragraph && this.onValue.equalsIgnoreCase(content = ((Paragraph)paragraphs.get(0)).getContent())) {
            MarkDrawer markDrawer = new MarkDrawer(this.size, this.shape, this.mark, this.hasEmbossedStyle, this.thickness.floatValue(), this.retrieveMarkColor());
            as = PdfAppearance.createAppearance(canvas.getPdfWriter(), widgetRect.getWidth(), widgetRect.getHeight());
            as.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -widgetRect.getLeft(), -widgetRect.getBottom()));
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "1", as);
            if (this.borderDrawer != null) {
                this.borderDrawer.draw(as, rec);
            }
            markDrawer.draw(as, rec);
            PdfAppearance.createAppearance(canvas.getPdfWriter(), widgetRect.getWidth(), widgetRect.getHeight());
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", as);
            field.setAppearanceState("1");
            field.setValueAsName("1");
        }
        if (as == null) {
            as = PdfAppearance.createAppearance(canvas.getPdfWriter(), widgetRect.getWidth(), widgetRect.getHeight());
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "1", as);
            as = PdfAppearance.createAppearance(canvas.getPdfWriter(), widgetRect.getWidth(), widgetRect.getHeight());
            as.transform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, -widgetRect.getLeft(), -widgetRect.getBottom()));
            field.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", as);
            if (this.borderDrawer != null) {
                this.borderDrawer.draw(as, rec);
            }
            field.setAppearanceState("Off");
            field.setValueAsName("Off");
        }
        canvas.addAnnotation(field, true);
        return PositionResult.State.FULL_CONTENT;
    }

    private BaseColor retrieveMarkColor() {
        FormNode colorNode = this.elementTag.retrieveParent().retrieveParent().retrieveChild("font", "fill", "color");
        BaseColor markColor = colorNode != null ? XFAUtil.parseXfaColor(colorNode.retrieveValue()) : null;
        return markColor;
    }

    @Override
    public boolean isEmpty() {
        String content;
        ArrayList<Element> paragraphs;
        if (this.onValue != null && this.contentElement instanceof TextElement && (paragraphs = ((TextElement)this.contentElement).getContent()).size() == 1 && paragraphs.get(0) instanceof Paragraph && this.onValue.equalsIgnoreCase(content = ((Paragraph)paragraphs.get(0)).getContent())) {
            return false;
        }
        return this.borderDrawer == null || this.borderDrawer.isEmpty();
    }

    @Override
    protected boolean isTextWidget() {
        return false;
    }

    private void initOnValue() {
        FormNode p = this.elementTag.retrieveParent();
        if (p != null) {
            p = p.retrieveParent();
        }
        this.onValue = CheckButtonElement.getOnValue(p);
    }

    public static String getOnValue(FormNode checkButtonField) {
        List<String> content;
        FormNode item;
        if (checkButtonField == null) {
            return null;
        }
        FormNode items = checkButtonField.retrieveChild("items");
        if (items != null && items.retrieveChildren().size() != 0 && (item = items.retrieveChildren().get(0)) != null && (content = item.retrieveContent()) != null && content.size() == 1) {
            return content.get(0);
        }
        return null;
    }
}

