/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.TextElementArray;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.FontSelector;
import com.itextpdf.text.pdf.PdfEncodings;
import java.util.ArrayList;
import java.util.List;

public class XFAFontSelector
extends FontSelector {
    protected static final char[] symbolBytesToUni;
    protected static final char[] zapfDingbatsToUni;
    protected List<Chunk> chunkList;

    @Override
    public Phrase process(String text) {
        if (this.getSize() == 0) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("no.font.is.defined", new Object[0]));
        }
        char[] cc = text.toCharArray();
        int len = cc.length;
        StringBuffer sb = new StringBuffer();
        Phrase ret = new Phrase();
        this.currentFont = null;
        this.chunkList = new ArrayList<Chunk>();
        Chunk newChunk = null;
        for (int k = 0; k < len; ++k) {
            newChunk = this.processChar(cc, k, sb, ret);
            if (newChunk == null) continue;
            this.addChunk(newChunk, ret);
        }
        if (this.currentFont == null) {
            this.currentFont = this.getFont(0);
        }
        if (sb.length() > 0) {
            newChunk = new Chunk(sb.toString(), this.currentFont);
            sb.setLength(0);
        } else {
            newChunk = null;
        }
        this.addChunk(newChunk, ret);
        return ret;
    }

    protected Chunk processChar(char[] cc, int k, StringBuffer sb, Phrase ret) {
        Chunk newChunk = null;
        char c = cc[k];
        if (c == '\u2029') {
            sb.append('\n');
        }
        if (c == '\t') {
            Chunk tab = new Chunk(Chunk.SPACETABBING);
            if (sb.length() > 0) {
                newChunk = new Chunk(sb.toString(), this.currentFont);
                sb.setLength(0);
            }
            if (this.currentFont != null) {
                if (newChunk != null) {
                    this.addChunk(newChunk, ret);
                }
                tab.setFont(this.currentFont);
                ret.add(tab);
            } else {
                if (newChunk != null) {
                    this.chunkList.add(newChunk);
                }
                this.chunkList.add(tab);
            }
            newChunk = null;
        } else {
            newChunk = this.processChar(cc, k, sb);
        }
        return newChunk;
    }

    @Override
    protected Chunk processChar(char[] cc, int k, StringBuffer sb) {
        Chunk newChunk = null;
        char c = cc[k];
        if (c == '\n' || c == '\r') {
            sb.append(c);
        } else {
            Font font = null;
            if (Utilities.isSurrogatePair(cc, k)) {
                int u = Utilities.convertToUtf32(cc, k);
                for (int f = 0; f < this.getSize(); ++f) {
                    font = this.getFont(f);
                    if ("Symbol".equals(font.getBaseFont().getEncoding()) || "ZapfDingbats".equals(font.getBaseFont().getEncoding()) || !font.getBaseFont().charExists(u) && Character.getType(u) != 16) continue;
                    if (this.currentFont != font) {
                        if (sb.length() > 0 && this.currentFont != null) {
                            newChunk = new Chunk(sb.toString(), this.currentFont);
                            sb.setLength(0);
                        }
                        this.currentFont = font;
                    }
                    sb.append(c);
                    sb.append(cc[++k]);
                    break;
                }
            } else {
                for (int f = 0; f < this.getSize(); ++f) {
                    char fallbackC;
                    boolean charExists;
                    font = this.getFont(f);
                    char[] symbolEnc = null;
                    if ("Symbol".equals(font.getBaseFont().getEncoding())) {
                        symbolEnc = symbolBytesToUni;
                    } else if ("ZapfDingbats".equals(font.getBaseFont().getEncoding())) {
                        symbolEnc = zapfDingbatsToUni;
                    }
                    char uniC = c;
                    if (symbolEnc != null && (uniC >= '\u0100' || (uniC = symbolEnc[c & 0xFF]) == '\u0000')) continue;
                    boolean bl = charExists = font.getBaseFont().charExists(uniC) || Character.getType(uniC) == 16;
                    if (!charExists && (fallbackC = XFAFontSelector.getSimilarFallbackChar(uniC)) > '\u0000') {
                        uniC = fallbackC;
                        charExists = true;
                    }
                    if (!charExists) continue;
                    if (this.currentFont != font) {
                        if (sb.length() > 0 && this.currentFont != null) {
                            newChunk = new Chunk(sb.toString(), this.currentFont);
                            sb.setLength(0);
                        }
                        this.currentFont = font;
                    }
                    sb.append(uniC);
                    break;
                }
            }
        }
        return newChunk;
    }

    protected void addChunk(Chunk chunk, TextElementArray resultantChunk) {
        for (Chunk tab : this.chunkList) {
            tab.setFont(this.currentFont);
            resultantChunk.add(tab);
        }
        this.chunkList.clear();
        if (chunk != null) {
            resultantChunk.add(chunk);
        }
    }

    private static char getSimilarFallbackChar(char uniC) {
        if (uniC == '\u2010') {
            return '-';
        }
        return '\u0000';
    }

    static {
        byte[] b = new byte[256];
        for (int k = 0; k < 256; ++k) {
            b[k] = (byte)k;
        }
        symbolBytesToUni = PdfEncodings.convertToString(b, "Symbol").toCharArray();
        zapfDingbatsToUni = PdfEncodings.convertToString(b, "ZapfDingbats").toCharArray();
    }
}

