/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.js;

import com.itextpdf.tool.xml.xtra.xfa.js.IJsObject;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoJsNodeList;
import com.itextpdf.tool.xml.xtra.xfa.js.ScriptString;
import com.itextpdf.tool.xml.xtra.xfa.positioner.FieldPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubFormPositioner;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsContainer
extends JsNode {
    static final Logger logger = LoggerFactory.getLogger(JsContainer.class);
    protected static JsContainer containerJsObject = new JsContainer("container");
    private static final String CALCULATE_ACTIVITY = "CALCULATE";
    private static final String VALIDATE_ACTIVITY = "VALIDATE";

    public JsContainer(String className) {
        super(className);
        this.setPrototype((Scriptable)nodeJsObject);
        this.defineConstantProperty("presence", "visible");
        this.defineConstantProperty("layout", "position");
        this.defineConstantProperty("rawValue", null);
        this.defineProperty("formattedValue", JsContainer.class, 1);
        this.defineProperty("dataNode", JsContainer.class, 1);
        this.defineProperty("fillColor", JsContainer.class, 0);
        this.defineFunctionProperties(new String[]{"execEvent"}, JsContainer.class, 4);
        this.defineFunctionProperties(new String[]{"execInitialize"}, JsContainer.class, 4);
        this.defineFunctionProperties(new String[]{"execCalculate"}, JsContainer.class, 4);
        this.defineProperty("$", JsContainer.class, 1);
    }

    public JsContainer(XFATemplateTag tag, JsNode parent) {
        super(tag, (IJsObject)parent);
        this.setPrototype((Scriptable)containerJsObject);
    }

    public void execEvent(String activity, String ref) {
        this.execOwnEvent(activity, ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execOwnEvent(String activity, String ref) {
        List<ScriptString> scripts = this.getScriptsByActivity(activity, ref);
        if (scripts != null) {
            for (ScriptString script : scripts) {
                try {
                    this.flattenerContext.pushJsEventCallStack(this, activity, script.content);
                    this.evaluateScript(script);
                }
                catch (Exception exc) {
                    String errorMessage = "Java Script event evaluation failed\n";
                    errorMessage = errorMessage + "XFA form element: " + this.getSomExpression() + "\n";
                    errorMessage = errorMessage + "Event '";
                    if (ref != null && !ref.isEmpty() && !ref.equals("undefined")) {
                        errorMessage = errorMessage + ref + ": ";
                    }
                    errorMessage = errorMessage + activity + "'";
                    logger.error(errorMessage, (Throwable)exc);
                }
                finally {
                    this.flattenerContext.popJsEventCallStack();
                }
            }
        }
    }

    public void execInitialize() {
        this.execEvent("initialize", null);
    }

    public List<ScriptString> getScriptsByActivity(String activity, String ref) {
        ArrayList<ScriptString> scripts = null;
        RhinoJsNodeList eventNodes = this.getNodes();
        if (eventNodes != null) {
            int i = 0;
            while ((long)i < eventNodes.getLength()) {
                JsNode eventNode = (JsNode)eventNodes.item(i);
                if ("event".equals(eventNode.getProperty("className"))) {
                    ScriptString scriptString;
                    String eventActivity = eventNode.retrieveAttribute("activity");
                    String eventRef = eventNode.retrieveAttribute("ref");
                    if ((eventActivity == null || activity.equals(eventActivity)) && (ref == null || "undefined".equals(ref) || ref.equals(eventRef)) && (scriptString = ScriptString.createScriptString(eventNode.getChild("script"))) != null) {
                        if (scripts == null) {
                            scripts = new ArrayList<ScriptString>();
                        }
                        scripts.add(scriptString);
                    }
                }
                ++i;
            }
        }
        return scripts;
    }

    public Object get$() {
        return this;
    }

    public Object getFormattedValue() {
        return "";
    }

    public Object getDataNode() {
        return this.fetchDataNode(true);
    }

    public Object fetchDataNode(boolean createNewIfNotExists) {
        return null;
    }

    public void setFillColor(String color) {
        JsNode borderNode = (JsNode)this.get("border", (Scriptable)this);
        JsNode fillNode = (JsNode)borderNode.get("fill", (Scriptable)borderNode);
        JsNode colorNode = (JsNode)fillNode.get("color", (Scriptable)fillNode);
        colorNode.defineProperty("value", color);
    }

    public String getFillColor() {
        FormNode colorNode;
        FormNode fillNode;
        FormNode borderNode = this.retrieveChild("border");
        if (borderNode != null && (fillNode = borderNode.retrieveChild("fill")) != null && (colorNode = fillNode.retrieveChild("color")) != null) {
            return colorNode.retrieveAttribute("value");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execCalculate() {
        List<ScriptString> scripts = this.getCalculationScripts();
        Object result = null;
        if (scripts != null) {
            for (ScriptString script : scripts) {
                try {
                    this.flattenerContext.pushJsEventCallStack(this, CALCULATE_ACTIVITY, script.content);
                    result = this.evaluateScript(script);
                }
                catch (Exception exc) {
                    String errorMessage = "Java Script calculation evaluation failed\n";
                    errorMessage = errorMessage + "XFA form element: " + this.getSomExpression();
                    logger.error(errorMessage, (Throwable)exc);
                }
                finally {
                    this.flattenerContext.popJsEventCallStack();
                }
                if (!(result == null || this instanceof SubFormPositioner || this.isUndefined(result) || result instanceof NativeFunction)) {
                    if (!(result instanceof JsNode)) continue;
                    Object rawValue = ((JsNode)result).getProperty("rawValue");
                    if (result instanceof FieldPositioner && result != this && rawValue == null) {
                        result = ((FieldPositioner)result).execCalculate();
                        continue;
                    }
                    result = rawValue;
                    continue;
                }
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execValidate() {
        List<ScriptString> scripts = this.getValidateScripts();
        if (scripts != null) {
            for (ScriptString script : scripts) {
                try {
                    this.flattenerContext.pushJsEventCallStack(this, VALIDATE_ACTIVITY, script.content);
                    this.evaluateScript(script);
                }
                catch (Exception exc) {
                    String errorMessage = "Java Script validation evaluation failed\n";
                    errorMessage = errorMessage + "XFA form element: " + this.getSomExpression();
                    logger.error(errorMessage, (Throwable)exc);
                }
                finally {
                    this.flattenerContext.popJsEventCallStack();
                }
            }
        }
    }

    protected List<ScriptString> getCalculationScripts() {
        ArrayList<ScriptString> scripts = null;
        RhinoJsNodeList nodes = this.getNodes();
        if (nodes != null) {
            int i = 0;
            while ((long)i < nodes.getLength()) {
                ScriptString scriptString;
                JsNode calculateNode = (JsNode)nodes.item(i);
                if ("calculate".equals(calculateNode.getProperty("className")) && (scriptString = ScriptString.createScriptString(calculateNode.getChild("script"))) != null) {
                    if (scripts == null) {
                        scripts = new ArrayList<ScriptString>();
                    }
                    scripts.add(scriptString);
                }
                ++i;
            }
        }
        return scripts;
    }

    protected List<ScriptString> getValidateScripts() {
        ArrayList<ScriptString> scripts = null;
        RhinoJsNodeList nodes = this.getNodes();
        if (nodes != null) {
            int i = 0;
            while ((long)i < nodes.getLength()) {
                ScriptString scriptString;
                JsNode validateNode = (JsNode)nodes.item(i);
                if ("validate".equals(validateNode.getProperty("className")) && (scriptString = ScriptString.createScriptString(validateNode.getChild("script"))) != null) {
                    if (scripts == null) {
                        scripts = new ArrayList<ScriptString>();
                    }
                    scripts.add(scriptString);
                }
                ++i;
            }
        }
        return scripts;
    }
}

