/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.pipe;

import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.xtra.xfa.XFALocale;
import com.itextpdf.tool.xml.xtra.xfa.resolver.LocaleResolver;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;

public class LocalePipeline
extends AbstractPipeline<LocaleResolver> {
    private XFALocale currentLocale;
    private Locale defaultLocale;

    public LocalePipeline(Pipeline<?> next, Locale defaultLocale) {
        super(next);
        this.defaultLocale = defaultLocale;
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        String tag = t.getName();
        LocaleResolver localeResolver = (LocaleResolver)this.getLocalContext(context);
        if ("locale".equalsIgnoreCase(tag)) {
            this.currentLocale = localeResolver.addLocale(t.getAttributes().get("name"));
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(WorkerContext context, Tag t, String content, ProcessObject po) {
        if (t instanceof XFATemplateTag && content.trim().length() > 0) {
            ((XFATemplateTag)t).addContent(content);
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) {
        block8: {
            String tag;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                if (this.currentLocale == null) break block8;
                                                tag = t.getName();
                                                if (!"locale".equalsIgnoreCase(tag)) break block9;
                                                this.currentLocale = null;
                                                break block8;
                                            }
                                            if (!"monthNames".equalsIgnoreCase(tag)) break block10;
                                            String[] months = this.collectStringValues(t, 12);
                                            String abbrAtt = t.getAttributes().get("abbr");
                                            if ("1".equals(abbrAtt)) {
                                                this.currentLocale.getDateFormatSymbols().setShortMonths(months);
                                            } else {
                                                this.currentLocale.getDateFormatSymbols().setMonths(months);
                                            }
                                            break block8;
                                        }
                                        if (!"dayNames".equalsIgnoreCase(tag)) break block11;
                                        String[] days = this.collectStringValues(t, 7);
                                        String[] days8 = new String[8];
                                        days8[0] = "";
                                        System.arraycopy(days, 0, days8, 1, 7);
                                        String abbrAtt = t.getAttributes().get("abbr");
                                        if ("1".equals(abbrAtt)) {
                                            this.currentLocale.getDateFormatSymbols().setShortWeekdays(days8);
                                        } else {
                                            this.currentLocale.getDateFormatSymbols().setWeekdays(days8);
                                        }
                                        break block8;
                                    }
                                    if (!"meridiemNames".equalsIgnoreCase(tag)) break block12;
                                    String[] meridiemNames = this.collectStringValues(t, 2);
                                    this.currentLocale.getDateFormatSymbols().setAmPmStrings(meridiemNames);
                                    break block8;
                                }
                                if (!"eraNames".equalsIgnoreCase(tag)) break block13;
                                String[] eraNames = this.collectStringValues(t, 2);
                                this.currentLocale.getDateFormatSymbols().setEras(eraNames);
                                break block8;
                            }
                            if (!"datePatterns".equalsIgnoreCase(tag)) break block14;
                            this.collectNamedValues(t, this.currentLocale.getDatePattern());
                            break block8;
                        }
                        if (!"timePatterns".equalsIgnoreCase(tag)) break block15;
                        this.collectNamedValues(t, this.currentLocale.getTimePattern());
                        break block8;
                    }
                    if (!"numberPatterns".equalsIgnoreCase(tag)) break block16;
                    this.collectNamedValues(t, this.currentLocale.getNumberPattern());
                    break block8;
                }
                if (!"numberSymbols".equalsIgnoreCase(tag)) break block17;
                for (Tag child : t.getChildren()) {
                    XFATemplateTag contentTag = child instanceof XFATemplateTag ? (XFATemplateTag)child : null;
                    if (contentTag == null || contentTag.getContent().size() <= 0) continue;
                    String valueName = contentTag.getAttributes().get("name");
                    String separator = contentTag.getContent().get(0);
                    if (separator.length() <= 0 || valueName == null) continue;
                    if (valueName.equals("grouping")) {
                        this.currentLocale.getDecimalFormatSymbols().setGroupingSeparator(separator.charAt(0));
                        continue;
                    }
                    if (!valueName.equals("decimal")) continue;
                    this.currentLocale.getDecimalFormatSymbols().setDecimalSeparator(separator.charAt(0));
                }
                break block8;
            }
            if (!"currencySymbols".equalsIgnoreCase(tag)) break block8;
            for (Tag child : t.getChildren()) {
                XFATemplateTag contentTag = child instanceof XFATemplateTag ? (XFATemplateTag)child : null;
                if (contentTag == null || contentTag.getContent().size() <= 0) continue;
                String valueName = contentTag.getAttributes().get("name");
                String value = contentTag.getContent().get(0);
                if (valueName.equals("symbol")) {
                    this.currentLocale.getDecimalFormatSymbols().setCurrencySymbol(value);
                    break;
                }
                if (!valueName.equals("isoname")) continue;
                this.currentLocale.getDecimalFormatSymbols().setCurrency(Currency.getInstance(value));
            }
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        LocaleResolver localeResolver = new LocaleResolver();
        localeResolver.setDefaultLocale(this.defaultLocale);
        context.put(this.getContextKey(), localeResolver);
        return super.init(context);
    }

    private String[] collectStringValues(Tag t, int expectedSize) {
        String[] values = new String[expectedSize];
        int index = 0;
        for (Tag child : t.getChildren()) {
            XFATemplateTag contentTag;
            XFATemplateTag xFATemplateTag = contentTag = child instanceof XFATemplateTag ? (XFATemplateTag)child : null;
            if (contentTag != null && contentTag.getContent().size() > 0) {
                values[index] = contentTag.getContent().get(0);
                ++index;
            }
            if (index < expectedSize) continue;
            break;
        }
        return values;
    }

    private void collectNamedValues(Tag t, Map<String, String> values) {
        for (Tag child : t.getChildren()) {
            String valueName;
            XFATemplateTag contentTag = child instanceof XFATemplateTag ? (XFATemplateTag)child : null;
            if (contentTag == null || contentTag.getContent() == null || contentTag.getContent().size() <= 0 || (valueName = contentTag.getAttributes().get("name")) == null) continue;
            values.put(valueName, contentTag.getContent().get(0));
        }
    }
}

