/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.resolver;

import com.itextpdf.tool.xml.CustomContext;
import com.itextpdf.tool.xml.xtra.xfa.XFALocale;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LocaleResolver
implements CustomContext {
    final Map<String, XFALocale> locales = new HashMap<String, XFALocale>();
    private Locale defaultLocale;

    public XFALocale addLocale(String name) {
        XFALocale locale = this.locales.get(name);
        if (locale != null) {
            return locale;
        }
        locale = new XFALocale(name, this.defaultLocale);
        this.locales.put(name, locale);
        return locale;
    }

    public XFALocale getLocale(String name) {
        XFALocale xfaLocale = null;
        if (name != null) {
            xfaLocale = this.locales.get(name);
            if (xfaLocale == null) {
                String defaultLocaleName = this.defaultLocale.getLanguage() + "_" + this.defaultLocale.getCountry();
                xfaLocale = this.locales.get(defaultLocaleName);
                if (xfaLocale == null) {
                    xfaLocale = new XFALocale(name, this.defaultLocale);
                }
                this.locales.put(name, xfaLocale);
            }
        } else {
            xfaLocale = new XFALocale(null, this.defaultLocale);
        }
        return xfaLocale;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }
}

