/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.util;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.Rectangle;
import java.util.List;

public class XFARectangle
implements Cloneable {
    private static float MIN_VALUE = 1.0E-6f;
    private Float h;
    private Float minH;
    private Float maxH;
    private Float w;
    private Float minW;
    private Float maxW;
    private Float ury;
    private Float llx;

    public static XFARectangle getCommonRectangle(List<XFARectangle> rectangles) {
        Float ury = Float.valueOf(-3.4028235E38f);
        Float llx = Float.valueOf(Float.MAX_VALUE);
        Float lly = Float.valueOf(Float.MAX_VALUE);
        Float urx = Float.valueOf(-3.4028235E38f);
        for (XFARectangle rectangle : rectangles) {
            XFARectangle rec = rectangle.clone();
            if (rec.getHeight() == null) {
                rec.setHeight(Float.valueOf(0.0f));
            }
            if (rec.getWidth() == null) {
                rec.setWidth(Float.valueOf(0.0f));
            }
            if (rec.getUry().floatValue() > ury.floatValue()) {
                ury = rec.getUry();
            }
            if (rec.getLlx().floatValue() < llx.floatValue()) {
                llx = rec.getLlx();
            }
            if (rec.getUry().floatValue() - rec.getHeight().floatValue() < lly.floatValue()) {
                lly = Float.valueOf(rec.getUry().floatValue() - rec.getHeight().floatValue());
            }
            if (!(rec.getLlx().floatValue() + rec.getWidth().floatValue() > urx.floatValue())) continue;
            urx = Float.valueOf(rec.getLlx().floatValue() + rec.getWidth().floatValue());
        }
        return new XFARectangle(llx, ury, Float.valueOf(urx.floatValue() - llx.floatValue()), Float.valueOf(ury.floatValue() - lly.floatValue()));
    }

    public static void applyMargins(XFARectangle rec, float topIndent, float rightIndent, float bottomIndent, float leftIndent, boolean reverse) {
        Float x = rec.getLlx();
        Float y = rec.getUry();
        Float w = rec.getWidth();
        Float minW = rec.getMinW();
        Float maxW = rec.getMaxW();
        Float h = rec.getHeight();
        Float minH = rec.getMinH();
        Float maxH = rec.getMaxH();
        if (null != x) {
            if (reverse) {
                rec.setLlx(Float.valueOf(x.floatValue() - leftIndent));
            } else {
                rec.setLlx(Float.valueOf(x.floatValue() + leftIndent));
            }
            if (Math.abs(rec.getLlx().floatValue()) < MIN_VALUE) {
                rec.setLlx(Float.valueOf(0.0f));
            }
        }
        if (null != y) {
            if (reverse) {
                rec.setUry(Float.valueOf(y.floatValue() + topIndent));
            } else {
                rec.setUry(Float.valueOf(y.floatValue() - topIndent));
            }
            if (Math.abs(rec.getUry().floatValue()) < MIN_VALUE) {
                rec.setUry(Float.valueOf(0.0f));
            }
        }
        if (null != w) {
            if (reverse) {
                rec.setWidth(Float.valueOf(w.floatValue() + (rightIndent + leftIndent)));
            } else {
                rec.setWidth(Float.valueOf(w.floatValue() - (rightIndent + leftIndent)));
            }
            if (Math.abs(rec.getWidth().floatValue()) < MIN_VALUE) {
                rec.setWidth(Float.valueOf(0.0f));
            }
        }
        if (null != minW) {
            if (reverse) {
                rec.setMinW(Float.valueOf(minW.floatValue() + (rightIndent + leftIndent)));
            } else {
                rec.setMinW(Float.valueOf(minW.floatValue() - (rightIndent + leftIndent)));
            }
            if (Math.abs(rec.getMinW().floatValue()) < MIN_VALUE) {
                rec.setMinW(Float.valueOf(0.0f));
            }
        }
        if (null != maxW) {
            if (reverse) {
                rec.setMaxW(Float.valueOf(maxW.floatValue() + (rightIndent + leftIndent)));
            } else {
                rec.setMaxW(Float.valueOf(maxW.floatValue() - (rightIndent + leftIndent)));
            }
            if (Math.abs(rec.getMaxW().floatValue()) < MIN_VALUE) {
                rec.setMaxW(Float.valueOf(0.0f));
            }
        }
        if (null != h) {
            if (reverse) {
                rec.setHeight(Float.valueOf(h.floatValue() + (topIndent + bottomIndent)));
            } else {
                rec.setHeight(Float.valueOf(h.floatValue() - (topIndent + bottomIndent)));
            }
            if (Math.abs(rec.getHeight().floatValue()) < MIN_VALUE) {
                rec.setHeight(Float.valueOf(0.0f));
            }
        }
        if (null != minH) {
            if (reverse) {
                rec.setMinH(Float.valueOf(minH.floatValue() + (topIndent + bottomIndent)));
            } else {
                rec.setMinH(Float.valueOf(minH.floatValue() - (topIndent + bottomIndent)));
            }
            if (Math.abs(rec.getMinH().floatValue()) < MIN_VALUE) {
                rec.setMinH(Float.valueOf(0.0f));
            }
        }
        if (null != maxH) {
            if (reverse) {
                rec.setMaxH(Float.valueOf(maxH.floatValue() + (topIndent + bottomIndent)));
            } else {
                rec.setMaxH(Float.valueOf(maxH.floatValue() - (topIndent + bottomIndent)));
            }
            if (Math.abs(rec.getMaxH().floatValue()) < MIN_VALUE) {
                rec.setMaxH(Float.valueOf(0.0f));
            }
        }
    }

    public static void setUndefinedSizes(XFARectangle contentArea) {
        Float height = contentArea.getHeight();
        Float minH = contentArea.getMinH();
        if (height == null) {
            if (minH != null) {
                contentArea.setHeight(minH);
            } else {
                contentArea.setHeight(Float.valueOf(0.0f));
            }
        }
        Float width = contentArea.getWidth();
        Float minW = contentArea.getMinW();
        if (width == null) {
            if (minW != null) {
                contentArea.setWidth(minW);
            } else {
                contentArea.setWidth(Float.valueOf(0.0f));
            }
        }
    }

    public XFARectangle(Float llx, Float ury, Float w, Float h) {
        this.llx = llx;
        this.ury = ury;
        this.w = w;
        this.h = h;
    }

    public XFARectangle(int llx, int ury, int w, int h) {
        this(Float.valueOf(llx), Float.valueOf(ury), Float.valueOf(w), Float.valueOf(h));
    }

    public XFARectangle(Float llx, Float ury, Float w, Float minW, Float maxW, Float h, Float minH, Float maxH) {
        this(llx, ury, w, h);
        this.minW = minW;
        this.maxW = maxW;
        this.minH = minH;
        this.maxH = maxH;
    }

    public XFARectangle(Rectangle rectangle) {
        this(Float.valueOf(rectangle.getLeft()), Float.valueOf(rectangle.getBottom()), Float.valueOf(rectangle.getWidth()), Float.valueOf(rectangle.getHeight()));
    }

    public void setHeight(Float h) {
        this.h = h;
    }

    public Float getHeight() {
        return this.h;
    }

    public Float getMinH() {
        return this.minH;
    }

    public void setMinH(Float minH) {
        this.minH = minH;
    }

    public Float getMaxH() {
        return this.maxH;
    }

    public void setMaxH(Float maxH) {
        this.maxH = maxH;
    }

    public void setWidth(Float w) {
        this.w = w;
    }

    public Float getWidth() {
        return this.w;
    }

    public Float getMinW() {
        return this.minW;
    }

    public void setMinW(Float minW) {
        this.minW = minW;
    }

    public Float getMaxW() {
        return this.maxW;
    }

    public void setMaxW(Float maxW) {
        this.maxW = maxW;
    }

    public void setUry(Float ury) {
        this.ury = ury;
    }

    public Float getUry() {
        return this.ury;
    }

    public void setLlx(Float llx) {
        this.llx = llx;
    }

    public Float getLlx() {
        return this.llx;
    }

    public Rectangle toRectangle() {
        if (null == this.llx || null == this.ury || null == this.w || null == this.h) {
            throw new UnsupportedOperationException("Cannot create a com.itextpdf.text.Rectangle if some parameters are 'null'");
        }
        return new Rectangle(this.llx.floatValue(), this.ury.floatValue() - this.h.floatValue(), this.llx.floatValue() + this.w.floatValue(), this.ury.floatValue());
    }

    public XFARectangle clone() {
        return new XFARectangle(this.llx, this.ury, this.w, this.minW, this.maxW, this.h, this.minH, this.maxH);
    }

    public XFARectangle applyTransformation(AffineTransform transformation) {
        float[] rectPoints = new float[]{this.getLlx().floatValue(), this.getUry().floatValue() - this.getHeight().floatValue(), this.getLlx().floatValue() + this.getWidth().floatValue(), this.getUry().floatValue()};
        transformation.transform(rectPoints, 0, rectPoints, 0, 2);
        return new XFARectangle(Float.valueOf(rectPoints[0] < rectPoints[2] ? rectPoints[0] : rectPoints[2]), Float.valueOf(rectPoints[3] > rectPoints[1] ? rectPoints[3] : rectPoints[1]), Float.valueOf(Math.abs(rectPoints[2] - rectPoints[0])), Float.valueOf(Math.abs(rectPoints[3] - rectPoints[1])));
    }

    public boolean contains(XFARectangle other, float padding) {
        return this.llx != null && other.llx != null && other.llx.floatValue() > this.llx.floatValue() + padding && this.w != null && other.w != null && other.llx.floatValue() + other.w.floatValue() < this.llx.floatValue() + this.w.floatValue() - padding && this.ury != null && other.ury != null && other.ury.floatValue() < this.ury.floatValue() - padding && this.h != null && other.h != null && this.ury.floatValue() - this.h.floatValue() + padding < other.ury.floatValue() - other.h.floatValue();
    }

    public boolean contains(XFARectangle other) {
        return this.contains(other, 0.1f);
    }
}

