/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassWriter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.AbstractImplementationClassTransformer;
import com.newrelic.agent.instrumentation.AddInterfaceAdapter;
import com.newrelic.agent.instrumentation.MethodMappersAdapter;
import com.newrelic.agent.instrumentation.PointCutClassTransformer;
import com.newrelic.agent.instrumentation.RequireMethodsAdapter;
import com.newrelic.agent.instrumentation.StartableClassFileTransformer;
import com.newrelic.agent.instrumentation.pointcuts.InterfaceMapper;
import com.newrelic.agent.util.Annotations;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

public class InterfaceImplementationClassTransformer
extends AbstractImplementationClassTransformer {
    private final Map<Method, java.lang.reflect.Method> methods;
    private final boolean genericInterfaceSupportEnabled;

    public static StartableClassFileTransformer[] getClassTransformers(PointCutClassTransformer classTransformer) {
        Collection<Class<?>> interfaces = new Annotations().getInterfaceMapperClasses();
        ArrayList<InterfaceImplementationClassTransformer> transformers = new ArrayList<InterfaceImplementationClassTransformer>(interfaces.size());
        for (Class<?> interfaceClass : interfaces) {
            transformers.add(new InterfaceImplementationClassTransformer(classTransformer, true, interfaceClass));
        }
        return transformers.toArray(new StartableClassFileTransformer[0]);
    }

    public InterfaceImplementationClassTransformer(PointCutClassTransformer classTransformer, boolean enabled, Class interfaceToImplement) {
        super(classTransformer, enabled, interfaceToImplement);
        boolean genericInterfaceSupportEnabled = true;
        Map<Object, Object> methods2 = Collections.emptyMap();
        InterfaceMapper mapper = interfaceToImplement.getAnnotation(InterfaceMapper.class);
        Class<Object> visitorClass = mapper.classVisitor();
        if (visitorClass == Object.class) {
            visitorClass = InterfaceImplementationClassVisitor.class;
        }
        if (visitorClass == InterfaceImplementationClassVisitor.class) {
            genericInterfaceSupportEnabled = false;
            methods2 = MethodMappersAdapter.getMethodMappers(interfaceToImplement);
        }
        this.methods = Collections.unmodifiableMap(methods2);
        this.genericInterfaceSupportEnabled = genericInterfaceSupportEnabled && mapper.className().length == 0;
    }

    @Override
    protected boolean isGenericInterfaceSupportEnabled() {
        return this.genericInterfaceSupportEnabled;
    }

    @Override
    protected ClassVisitor createClassVisitor(ClassReader cr, ClassWriter cw, String className, ClassLoader loader) {
        InterfaceMapper mapper = this.interfaceToImplement.getAnnotation(InterfaceMapper.class);
        HashSet<Method> methods2 = new HashSet<Method>(this.methods.keySet());
        Class<Object> classVisitorClass = mapper.classVisitor();
        if (classVisitorClass == Object.class) {
            classVisitorClass = InterfaceImplementationClassVisitor.class;
        }
        if (InterfaceImplementationClassVisitor.class == classVisitorClass) {
            ClassVisitor classVisitor = new AddInterfaceAdapter(cw, className, this.interfaceToImplement);
            classVisitor = RequireMethodsAdapter.getRequireMethodsAdaptor(classVisitor, methods2, className, this.interfaceToImplement.getName(), loader);
            classVisitor = MethodMappersAdapter.getMethodMappersAdapter(classVisitor, this.methods, this.originalInterface, className);
            return classVisitor;
        }
        if (ClassVisitor.class.isAssignableFrom(mapper.classVisitor())) {
            try {
                Constructor<?> constructor = mapper.classVisitor().getConstructor(ClassVisitor.class, String.class);
                return (ClassVisitor)constructor.newInstance(cw, className);
            }
            catch (Throwable e) {
                Agent.LOG.log(Level.FINEST, "while creating ClassVisitor for InterfaceMapper transformation", e);
            }
        }
        Agent.LOG.log(Level.FINEST, "Unable to create ClassVisitor (type {0}) for {1} with loader {2}", classVisitorClass, className, loader);
        return cw;
    }

    public class InterfaceImplementationClassVisitor
    extends ClassVisitor {
        public InterfaceImplementationClassVisitor(int api) {
            super(api);
        }
    }
}

