/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.values;

import com.newrelic.agent.jmx.metrics.BaseJmxValue;
import com.newrelic.agent.jmx.metrics.DataSourceJmxMetricGenerator;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.jmx.metrics.JmxMetric;
import java.util.ArrayList;
import java.util.List;

public class EmbeddedTomcatDataSourceJmxValues
extends JmxFrameworkValues {
    public static final String PREFIX = "org.apache.tomcat.jdbc.pool.jmx";
    private static final int METRIC_COUNT = 1;
    private static final JmxMetric CONNECTIONS_ACTIVE = DataSourceJmxMetricGenerator.CONNECTIONS_ACTIVE.createMetric("NumActive");
    private static final JmxMetric CONNECTIONS_IDLE = DataSourceJmxMetricGenerator.CONNECTIONS_IDLE.createMetric("NumIdle");
    private static final JmxMetric CONNECTIONS_MAX = DataSourceJmxMetricGenerator.CONNECTIONS_MAX.createMetric("MaxActive");
    private static final JmxMetric CONNECTIONS_CREATED = DataSourceJmxMetricGenerator.CONNECTIONS_CREATED.createMetric("CreatedCount");
    private final List<BaseJmxValue> metrics = new ArrayList<BaseJmxValue>(1);

    public EmbeddedTomcatDataSourceJmxValues() {
        this.createMetrics("*");
    }

    public EmbeddedTomcatDataSourceJmxValues(String name) {
        this.createMetrics(name);
    }

    private void createMetrics(String name) {
        this.metrics.add(new BaseJmxValue("org.apache.tomcat.jdbc.pool.jmx:name=*,type=ConnectionPool", "JmxBuiltIn/DataSources/{name}/", new JmxMetric[]{CONNECTIONS_ACTIVE, CONNECTIONS_IDLE, CONNECTIONS_MAX, CONNECTIONS_CREATED}));
    }

    @Override
    public List<BaseJmxValue> getFrameworkMetrics() {
        return this.metrics;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }
}

