/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.xml;

import com.newrelic.agent.extension.beans.Extension;
import com.newrelic.agent.extension.beans.MethodParameters;
import com.newrelic.agent.xml.XmlInstrumentValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class MethodHolder {
    private final Map<String, List<String>> nameToMethods = new HashMap<String, List<String>>();
    private final boolean isDebug;

    public MethodHolder(boolean pDebug) {
        this.isDebug = pDebug;
    }

    protected void addMethods(List<Extension.Instrumentation.Pointcut.Method> methods) {
        if (methods != null) {
            for (Extension.Instrumentation.Pointcut.Method m4 : methods) {
                if (m4 == null || m4.getParameters() == null) continue;
                this.addMethod(m4.getName(), MethodParameters.getDescriptor(m4.getParameters()));
            }
        }
    }

    private void addMethod(String name, String descr) {
        name = name.trim();
        descr = descr.trim();
        List<String> value = this.nameToMethods.get(name);
        if (value == null) {
            value = new ArrayList<String>();
            this.nameToMethods.put(name, value);
        }
        if (!value.contains(descr)) {
            value.add(descr);
        }
    }

    protected boolean isMethodPresent(String name, String descr, boolean remove) {
        name = name.trim();
        descr = descr.trim();
        List<String> value = this.nameToMethods.get(name);
        if (value != null) {
            if (this.isDebug) {
                XmlInstrumentValidator.printMessage(MessageFormat.format("Found the method {0} from the xml in the list of class methods. Checking method parameters.", name));
            }
            Iterator<String> it = value.iterator();
            while (it.hasNext()) {
                String xmlDesc = it.next();
                if (descr.startsWith(xmlDesc)) {
                    XmlInstrumentValidator.printMessage(MessageFormat.format("Matched Method: {0} {1}", name, descr));
                    if (remove) {
                        it.remove();
                        if (value.isEmpty()) {
                            this.nameToMethods.remove(name);
                        }
                    }
                    return true;
                }
                if (!this.isDebug) continue;
                XmlInstrumentValidator.printMessage(MessageFormat.format("Descriptors for method {0} did not match. Xml descriptor: {1}, Method descriptor: {2} ", name, xmlDesc, descr));
            }
        }
        return false;
    }

    protected boolean hasMethods() {
        Iterator<Map.Entry<String, List<String>>> it = this.nameToMethods.entrySet().iterator();
        return it.hasNext();
    }

    protected String getCurrentMethods() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> values2 : this.nameToMethods.entrySet()) {
            List<String> descriptors = values2.getValue();
            if (descriptors == null || descriptors.isEmpty()) continue;
            sb.append("\nMethod Name: ");
            sb.append(values2.getKey());
            sb.append(" Param Descriptors: ");
            for (String v : descriptors) {
                sb.append(v);
                sb.append(" ");
            }
        }
        return sb.toString();
    }
}

