/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleConnectionStringBuilder;
import oracle.net.url.builder.ConnectDescriptorBuilder;
import oracle.net.url.builder.URLBuilder;
import oracle.net.url.common.DriverType;

class OracleConnectionStringBuilderImpl
implements OracleConnectionStringBuilder {
    private List<OracleConnectionStringBuilder.ConnectInfo> addressInfoList = new ArrayList<OracleConnectionStringBuilder.ConnectInfo>();
    private String serviceName;
    private String serverMode;
    private String instanceName;
    private String serverDN;
    private String walletDirectory;
    private int connectTimeout;
    private int transportConnectTimeout;
    private int retryCount;
    private int retryDelay;
    private boolean loadBalance = true;

    OracleConnectionStringBuilderImpl() {
    }

    @Override
    public OracleConnectionStringBuilder addConnectInfo(OracleConnectionStringBuilder.ConnectInfo addressInfo) {
        this.addressInfoList.add(addressInfo);
        return this;
    }

    @Override
    public OracleConnectionStringBuilder addConnectInfo(String host, int port) {
        this.addressInfoList.add(new OracleConnectionStringBuilder.ConnectInfo().host(host).port(port));
        return this;
    }

    @Override
    public OracleConnectionStringBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder instanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder serverMode(String serverMode) {
        this.serverMode = serverMode;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder serverDN(String serverDN) {
        this.serverDN = serverDN;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder walletDirectory(String walletDirectory) {
        this.walletDirectory = walletDirectory;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder loadBalance(boolean loadBalance) {
        this.loadBalance = loadBalance;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder transportConnectTimeout(int transportConnectTimeout) {
        this.transportConnectTimeout = transportConnectTimeout;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder retryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }

    @Override
    public OracleConnectionStringBuilder retryCount(int retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    @Override
    public String build() throws IllegalStateException {
        this.validateParams();
        return this.buildConnectionString(false);
    }

    @Override
    public String buildThinStyleURL() throws IllegalStateException {
        return this.buildConnectionString(true);
    }

    private String buildConnectionString(boolean isThinStyle) {
        return URLBuilder.newInstance(ConnectDescriptorBuilder.class).driverType(isThinStyle ? DriverType.THIN : DriverType.DEFAULT).rootNode(ConnectDescriptorBuilder.DescriptionNode.class, this::addDescriptionParams).build();
    }

    private void addDescriptionParams(ConnectDescriptorBuilder.DescriptionNode descriptionNode) {
        if (this.connectTimeout > 0) {
            descriptionNode.connectTimeout(this.connectTimeout);
        }
        if (this.transportConnectTimeout > 0) {
            descriptionNode.transportTimeout(this.transportConnectTimeout);
        }
        if (this.retryCount > 0) {
            descriptionNode.retryCount(this.retryCount);
        }
        if (this.retryDelay > 0) {
            descriptionNode.retryDelay(this.retryDelay);
        }
        if (this.addressInfoList.size() == 1) {
            descriptionNode.addChild(ConnectDescriptorBuilder.AddressNode.class, addressNode -> this.addAddressParam((ConnectDescriptorBuilder.AddressNode)addressNode, this.addressInfoList.get(0)));
        } else {
            descriptionNode.addChild(ConnectDescriptorBuilder.AddressListNode.class, addressList -> {
                addressList.failOver(this.loadBalance);
                this.addressInfoList.forEach(addressInfo -> addressList.addChild(ConnectDescriptorBuilder.AddressNode.class, addrNode -> this.addAddressParam((ConnectDescriptorBuilder.AddressNode)addrNode, (OracleConnectionStringBuilder.ConnectInfo)addressInfo)));
            });
        }
        descriptionNode.addChild(ConnectDescriptorBuilder.ConnectDataNode.class, this::addConnectDataParams);
        this.addSecurityNode(descriptionNode);
    }

    private void addAddressParam(ConnectDescriptorBuilder.AddressNode address, OracleConnectionStringBuilder.ConnectInfo connectInfo) {
        address.host(connectInfo.getDbHostName(), connectInfo.getDbPort());
        address.protocol(connectInfo.getProtocol());
        if (connectInfo.getWebSocketURI() != null) {
            address.websocketURI(connectInfo.getWebSocketURI());
        }
        if (connectInfo.getProxyHost() != null && connectInfo.getProxyPort() != -1) {
            address.httpProxy(connectInfo.getProxyHost(), connectInfo.getProxyPort());
        }
    }

    private void addConnectDataParams(ConnectDescriptorBuilder.ConnectDataNode connectDataNode) {
        if (this.serviceName != null) {
            connectDataNode.serviceName(this.serviceName);
        }
        if (this.serverMode != null) {
            connectDataNode.serverMode(this.serverMode);
        }
        if (this.instanceName != null) {
            connectDataNode.instanceName(this.instanceName);
        }
    }

    private void addSecurityNode(ConnectDescriptorBuilder.DescriptionNode descriptionNode) {
        if (this.serverDN == null && this.walletDirectory == null) {
            return;
        }
        descriptionNode.addChild(ConnectDescriptorBuilder.SecurityNode.class, securityNode -> {
            securityNode.enableDNMatch(Boolean.parseBoolean(this.serverDN));
            if (this.walletDirectory != null) {
                securityNode.wallet(this.walletDirectory);
            }
        });
    }

    private void validateParams() throws IllegalStateException {
        if (this.addressInfoList == null || this.addressInfoList.size() == 0) {
            throw new IllegalStateException("AddressInfo cannot be empty");
        }
        for (OracleConnectionStringBuilder.ConnectInfo addrInfo : this.addressInfoList) {
            addrInfo.validate();
        }
        if (this.serviceName == null) {
            throw new IllegalStateException("ServiceName can not be null");
        }
        if (this.connectTimeout < 0) {
            throw new IllegalStateException("Invalid ConnectTimeout value : " + this.connectTimeout);
        }
        if (this.transportConnectTimeout < 0) {
            throw new IllegalStateException("Invalid TransportConnectTimeout value : " + this.transportConnectTimeout);
        }
        if (this.retryCount < 0) {
            throw new IllegalStateException("Invalid RetryCount value : " + this.retryCount);
        }
        if (this.retryDelay < 0) {
            throw new IllegalStateException("Invalid RetryDelay value : " + this.retryDelay);
        }
    }
}

