/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDatabaseException;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.NTFPDBChangeEvent;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CBanner;
import oracle.jdbc.driver.T2CError;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.driver.utils.ThrowingRunnable;
import oracle.jdbc.internal.AbstractConnectionBuilder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.net.resolver.NameResolver;
import oracle.net.resolver.NameResolverFactory;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.Datum;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.NCLOB;
import oracle.sql.SQLName;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

public class T2CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    static final long JDBC_OCI_LIBRARY_VERSION = Long.parseLong("23.26.0.0.0".replaceAll("\\.", ""));
    short[] queryMetaData1 = null;
    byte[] queryMetaData2 = null;
    int queryMetaData1Offset = 0;
    int queryMetaData2Offset = 0;
    private OpaqueString password;
    int fatalErrorNumber = 0;
    String fatalErrorMessage = null;
    static final int QMD_dbtype = 0;
    static final int QMD_dbsize = 1;
    static final int QMD_nullok = 2;
    static final int QMD_precision = 3;
    static final int QMD_scale = 4;
    static final int QMD_formOfUse = 5;
    static final int QMD_columnNameLength = 6;
    static final int QMD_tdo0 = 7;
    static final int QMD_tdo1 = 8;
    static final int QMD_tdo2 = 9;
    static final int QMD_tdo3 = 10;
    static final int QMD_charLength = 11;
    static final int QMD_schemaNameLength = 12;
    static final int QMD_typeNameLength = 13;
    static final int QMD_columnInvisible = 14;
    static final int QMD_columnJSON = 15;
    static final int T2C_LOCATOR_MAX_LEN = 16;
    static final int T2C_LINEARIZED_LOCATOR_MAX_LEN = 4000;
    static final int T2C_LINEARIZED_BFILE_LOCATOR_MAX_LEN = 530;
    static final int METADATA1_INDICES_PER_COLUMN = 16;
    protected static final int SIZEOF_QUERYMETADATA2 = 8;
    static final String defaultDriverNameAttribute = "jdbcoci";
    int queryMetaData1Size = 100;
    int queryMetaData2Size = 800;
    long m_nativeState;
    short m_clientCharacterSet;
    byte byteAlign;
    static final byte[] EMPTY_BYTES = new byte[0];
    private static final int EOJ_SUCCESS = 0;
    private static final int EOJ_ERROR = -1;
    private static final int EOJ_WARNING = 1;
    private static final int EOJ_GET_STORAGE_ERROR = -4;
    private static final int EOJ_ORA3113_SERVER_NORMAL = -6;
    private static final String OCILIBRARY = "ocijdbc23";
    private static final String CLASS_NAME = T2CConnection.class.getName();
    private int logon_mode = 0;
    static final int LOGON_MODE_DEFAULT = 0;
    static final int LOGON_MODE_SYSDBA = 2;
    static final int LOGON_MODE_SYSOPER = 4;
    static final int LOGON_MODE_SYSASM = 32768;
    static final int LOGON_MODE_SYSBKP = 131072;
    static final int LOGON_MODE_SYSDGD = 262144;
    static final int LOGON_MODE_SYSKMT = 524288;
    static final int LOGON_MODE_CONNECTION_POOL = 5;
    static final int LOGON_MODE_CONNPOOL_CONNECTION = 6;
    static final int LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
    static final int LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
    static final int T2C_PROXYTYPE_NONE = 0;
    static final int T2C_PROXYTYPE_USER_NAME = 1;
    static final int T2C_PROXYTYPE_DISTINGUISHED_NAME = 2;
    static final int T2C_PROXYTYPE_CERTIFICATE = 3;
    static final int T2C_CONNECTION_FLAG_DEFAULT_LOB_PREFETCH = 0;
    static final int T2C_CONNECTION_FLAG_PRELIM_AUTH = 1;
    static final int T2C_CONNECTION_FLAG_CHARSET = 2;
    static final int T2C_CONNECTION_FLAG_NCHARSET = 3;
    static final int T2C_CONNECTION_FLAG_BYTE_ALIGN = 4;
    static final int T2C_CONNECTION_FLAG_SERVER_TZ_VERSION = 5;
    static final int T2C_CONNECTION_FLAG_TAF_ENABLED = 6;
    static final int T2C_CONNECTION_TAG_MATCHED = 7;
    static final int T2C_CONNECTION_FLAG_MAXLEN_COMPAT = 8;
    private static final int OCI_ATTR_PURITY_DEFAULT = 0;
    private static final int OCI_ATTR_PURITY_NEW = 1;
    private static final int OCI_ATTR_PURITY_SELF = 2;
    static final int T2C_MAX_SCHEMA_NAME_LENGTH = 258;
    private static boolean isLibraryLoaded;
    private static final Monitor LOAD_LIBRARY_MONITOR;
    private static final Monitor SET_TIMEZONE_MONITOR;
    static final Map<String, String> cachedVersionTable;
    static final int T2C_LOGON_OUT_BUFFER_LENGTH = 256;
    static final int EOO_LOGIN_OUT_TYPE_DBID = 1;
    static final int EOO_LOGIN_OUT_INST_START_TIME = 2;
    String databaseUniqueIdentifier;
    OracleOCIFailover appCallback = null;
    Object appCallbackObject = null;
    private Properties nativeInfo;
    ByteBuffer nioBufferForLob;
    boolean[] tagMatched;
    static final String CONNECT_DATA_KEYWORD = "CONNECT_DATA";
    static final int OCI_SESSRLS_DROPSESS = 1;
    static final int OCI_SESSRLS_RETAG = 2;

    protected T2CConnection(String ur, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, info, ext);
        this.allocQueryMetaDataBuffers();
    }

    @Override
    final void initializePassword(OpaqueString p) throws SQLException {
        this.password = p;
    }

    @Override
    OpaqueString password() throws SQLException {
        return this.password;
    }

    private void allocQueryMetaDataBuffers() {
        this.queryMetaData1Offset = 0;
        this.queryMetaData1 = new short[this.queryMetaData1Size * 16];
        this.queryMetaData2Offset = 0;
        this.queryMetaData2 = new byte[this.queryMetaData2Size];
        this.namedTypeAccessorByteLen = 0;
        this.refTypeAccessorByteLen = 0;
    }

    void reallocateQueryMetaData(int numColumns, int charSize) {
        this.queryMetaData1 = null;
        this.queryMetaData2 = null;
        this.queryMetaData1Size = Math.max(numColumns, this.queryMetaData1Size);
        this.queryMetaData2Size = Math.max(charSize, this.queryMetaData2Size);
        this.allocQueryMetaDataBuffers();
    }

    @Override
    protected void readConnectionProperties(String ul, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info) throws SQLException {
        super.readConnectionProperties(ul, info);
        this.database = this.translateConnStr(this.database);
        if (null != this.targetInstanceName && !"".equals(this.targetInstanceName)) {
            this.database = this.createNamedInstanceUrl(this.database, this.targetInstanceName);
        }
        this.readOCIConnectionPoolProperties(info);
    }

    private String translateConnStr(String database) throws SQLException {
        if (database == null || database.equals("")) {
            return database;
        }
        if (database.indexOf(41) != -1) {
            return database;
        }
        if ((database = database.trim()).startsWith("//") || database.matches("[[\\w-]\\.]*:[\\d]*/[[\\w\\$\\#]\\.]*(?i)(:[\\w]*)?(?-i)")) {
            database = database.replaceAll("#", "\\\\#");
            try {
                NameResolver nr = NameResolverFactory.getNameResolver(null, "", "");
                return nr.resolveName(database);
            }
            catch (Exception e) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67, database).fillInStackTrace();
            }
        }
        return this.resolveSimple(database);
    }

    private String resolveSimple(String database) throws SQLException {
        int fColon = 0;
        int sColon = 0;
        int tColon = 0;
        String serverMode = null;
        boolean ipV6LiteralFormat = false;
        if (database.indexOf(91) != -1) {
            fColon = database.indexOf(93);
            if (fColon == -1) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67, database).fillInStackTrace();
            }
            ipV6LiteralFormat = true;
        }
        if ((fColon = database.indexOf(58, fColon)) == -1) {
            return database;
        }
        sColon = database.indexOf(58, fColon + 1);
        if (sColon == -1) {
            return database;
        }
        tColon = database.indexOf(58, sColon + 1);
        if (tColon != -1) {
            serverMode = database.substring(tColon);
        } else {
            tColon = sColon;
        }
        if (database.indexOf(58, tColon + 1) != -1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67, database).fillInStackTrace();
        }
        String host = null;
        host = ipV6LiteralFormat ? database.substring(1, fColon - 1) : database.substring(0, fColon);
        String port = database.substring(fColon + 1, sColon);
        String sid = serverMode == null ? database.substring(sColon + 1, database.length()) : database.substring(sColon + 1, tColon);
        String translate_database = serverMode == null ? "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + port + "))(CONNECT_DATA=(SID=" + sid + ")))" : "(DESCRIPTION=(ADDRESS=(PROTOCOL=tcp)(HOST=" + host + ")(PORT=" + port + "))(CONNECT_DATA=(SID=" + sid + ")(SERVER=" + serverMode + ")))";
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "resolveSimple", "translate_database={0}", (String)null, (Throwable)null, (Object)translate_database);
        return translate_database;
    }

    private String createNamedInstanceUrl(String url, String targetInstanceName) {
        StringBuffer urlBuf = new StringBuffer(url);
        int keywordIndex = urlBuf.indexOf(CONNECT_DATA_KEYWORD);
        if (keywordIndex != -1) {
            int equalSignIndex = urlBuf.indexOf("=", keywordIndex + CONNECT_DATA_KEYWORD.length());
            if (equalSignIndex != -1) {
                urlBuf.insert(equalSignIndex + 1, "(INSTANCE_NAME=" + targetInstanceName + ")");
            } else {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "createNamedInstanceUrl", "equal sign not found", null, null);
            }
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "createNamedInstanceUrl", "CONNECT_DATA keyword not found", null, null);
        }
        String updatedUrl = urlBuf.toString();
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "createNamedInstanceUrl", "updatedUrl={0}", (String)null, (Throwable)null, (Object)updatedUrl);
        return updatedUrl;
    }

    @Override
    protected void logon(AbstractConnectionBuilder<?, ?> builder) throws SQLException {
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary();
        }
        this.initCredentials(null);
        this.tagMatched = new boolean[]{false};
        if (this.database == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 64).fillInStackTrace();
        }
        byte[] outByteArray = new byte[256];
        if (this.ociConnectionPoolIsPooling) {
            this.processOCIConnectionPooling();
        } else {
            int outType;
            byte[] nlsterritory;
            long OCISvcCtxHandle = this.ociSvcCtxHandle;
            long OCIEnvHandle = this.ociEnvHandle;
            long OCIErrHandle = this.ociErrHandle;
            if (OCISvcCtxHandle != 0L && OCIEnvHandle != 0L) {
                if (this.ociDriverCharset == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89).fillInStackTrace();
                }
                this.m_clientCharacterSet = new Integer(this.ociDriverCharset).shortValue();
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                long[] nativeConnectionFlags = new long[]{this.defaultLobPrefetchSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, this.enableOCIFAN ? 1 : 0, this.ociExternalAuthentication ? 1 : 0};
                this.sqlWarning = this.checkError(this.t2cUseConnection(this.m_nativeState, OCIEnvHandle, OCISvcCtxHandle, OCIErrHandle, outByteArray, nativeConnectionFlags), this.sqlWarning);
                this.conversion = new DBConversion((short)(nativeConnectionFlags[2] & 0xFFFFL), this.m_clientCharacterSet, (short)(nativeConnectionFlags[3] & 0xFFFFL));
                this.byteAlign = (byte)(nativeConnectionFlags[4] & 0xFFL);
                this.timeZoneVersionNumber = (int)nativeConnectionFlags[5];
                if (nativeConnectionFlags[6] != 0L) {
                    this.useOCIDefaultDefines = true;
                }
                this.tagMatched[0] = nativeConnectionFlags[7] != 0L;
                this.varTypeMaxLenCompat = (int)nativeConnectionFlags[8];
                return;
            }
            if (this.internalLogon == null) {
                this.logon_mode = 0;
            } else if (this.internalLogon.equalsIgnoreCase("SYSDBA")) {
                this.logon_mode = 2;
            } else if (this.internalLogon.equalsIgnoreCase("SYSOPER")) {
                this.logon_mode = 4;
            } else if (this.internalLogon.equalsIgnoreCase("SYSASM")) {
                this.logon_mode = 32768;
            } else if (this.internalLogon.equalsIgnoreCase("SYSBACKUP")) {
                this.logon_mode = 131072;
            } else if (this.internalLogon.equalsIgnoreCase("SYSDG")) {
                this.logon_mode = 262144;
            } else if (this.internalLogon.equalsIgnoreCase("SYSKM")) {
                this.logon_mode = 524288;
            }
            byte[] l_userName = null;
            byte[] l_proxyClientName = null;
            byte[] l_password = null;
            byte[] l_connectionClass = EMPTY_BYTES;
            byte[] l_drcpTagName = EMPTY_BYTES;
            String newPassword = this.newPasswordValue.get();
            byte[] newPasswordBytes = EMPTY_BYTES;
            byte[] editionNameBytes = EMPTY_BYTES;
            byte[] driverNameAttributeBytes = EMPTY_BYTES;
            this.m_clientCharacterSet = this.nlsLangBackdoor ? T2CConnection.getDriverCharSetIdFromNLS_LANG() : T2CConnection.getClientCharSetId();
            if (newPassword != null) {
                newPasswordBytes = DBConversion.stringToDriverCharBytes(newPassword, this.m_clientCharacterSet);
            }
            if (this.editionName != null) {
                editionNameBytes = DBConversion.stringToDriverCharBytes(this.editionName, this.m_clientCharacterSet);
            }
            if (this.driverNameAttribute == null) {
                String namedVersion = "jdbcoci : " + BuildInfo.getDriverVersion();
                driverNameAttributeBytes = DBConversion.stringToDriverCharBytes(namedVersion, this.m_clientCharacterSet);
            } else {
                driverNameAttributeBytes = DBConversion.stringToDriverCharBytes(this.driverNameAttribute, this.m_clientCharacterSet);
            }
            l_userName = this.userName == null ? EMPTY_BYTES : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            l_proxyClientName = this.proxyClientName == null ? EMPTY_BYTES : DBConversion.stringToDriverCharBytes(this.proxyClientName, this.m_clientCharacterSet);
            l_password = this.password == null || this.password.isNull() ? EMPTY_BYTES : DBConversion.stringToDriverCharBytes(this.password.get().trim(), this.m_clientCharacterSet);
            int purity = 0;
            if (this.isDRCPConnection(this.url)) {
                this.drcpEnabled = true;
                if (this.drcpConnectionClass != null) {
                    this.drcpConnectionClass = this.drcpConnectionClass.trim();
                }
            }
            if (this.drcpEnabled) {
                if (this.drcpConnectionClass != null && !this.drcpConnectionClass.isEmpty()) {
                    l_connectionClass = DBConversion.stringToDriverCharBytes(this.drcpConnectionClass, this.m_clientCharacterSet);
                }
                if (this.drcpConnectionPurity != null) {
                    if (this.drcpConnectionPurity.equals("NEW")) {
                        purity = 1;
                    } else if (this.drcpConnectionPurity.equals("SELF")) {
                        purity = 2;
                    } else {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 297).fillInStackTrace();
                    }
                }
            }
            if (this.drcpTagName != null) {
                l_drcpTagName = DBConversion.stringToDriverCharBytes(this.drcpTagName, this.m_clientCharacterSet);
            }
            byte[] l_database = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
            String s = null;
            s = CharacterSetMetaData.getNLSLanguage(Locale.getDefault(Locale.Category.FORMAT));
            byte[] nlslanguage = s != null ? s.getBytes() : null;
            s = CharacterSetMetaData.getNLSTerritory(Locale.getDefault(Locale.Category.FORMAT));
            byte[] byArray = nlsterritory = s != null ? s.getBytes() : null;
            if (nlslanguage == null || nlsterritory == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176).fillInStackTrace();
            }
            TimeZone tz = TimeZone.getDefault();
            Object defaultTimeZone = tz.getID();
            if (!ZONEIDMAP.isValidRegion((String)defaultTimeZone) || !this.timezoneAsRegion) {
                int tzOffset = tz.getOffset(System.currentTimeMillis());
                int hr = tzOffset / 3600000;
                int mi = tzOffset / 60000 % 60;
                defaultTimeZone = (hr < 0 ? "" + hr : "+" + hr) + (mi < 10 ? ":0" + mi : ":" + mi);
            }
            T2CConnection.doSetSessionTimeZone((String)defaultTimeZone);
            this.sessionTimeZone = defaultTimeZone;
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            long[] nativeConnectionFlags = new long[]{this.defaultLobPrefetchSize, this.prelimAuth ? 1 : 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, this.enableOCIFAN ? 1 : 0, this.ociExternalAuthentication ? 1 : 0};
            this.sqlWarning = this.m_nativeState == 0L ? this.checkError(this.t2cCreateState(l_userName, l_userName.length, l_proxyClientName, l_proxyClientName.length, l_password, l_password.length, newPasswordBytes, newPasswordBytes.length, editionNameBytes, editionNameBytes.length, driverNameAttributeBytes, driverNameAttributeBytes.length, l_database, l_database.length, this.drcpEnabled, l_connectionClass, l_connectionClass.length, purity, l_drcpTagName, l_drcpTagName.length, this.m_clientCharacterSet, this.logon_mode, nlslanguage, nlsterritory, outByteArray, nativeConnectionFlags), this.sqlWarning) : this.checkError(this.t2cLogon(this.m_nativeState, l_userName, l_userName.length, l_proxyClientName, l_proxyClientName.length, l_password, l_password.length, newPasswordBytes, newPasswordBytes.length, editionNameBytes, editionNameBytes.length, driverNameAttributeBytes, driverNameAttributeBytes.length, l_database, l_database.length, this.drcpEnabled, l_connectionClass, l_connectionClass.length, purity, l_drcpTagName, l_drcpTagName.length, this.logon_mode, nlslanguage, nlsterritory, outByteArray, nativeConnectionFlags), this.sqlWarning);
            if (this.drcpEnabled) {
                this.drcpState = OracleConnection.DRCPState.ATTACHED_IMPLICIT;
            }
            this.conversion = new DBConversion((short)(nativeConnectionFlags[2] & 0xFFFFL), this.m_clientCharacterSet, (short)(nativeConnectionFlags[3] & 0xFFFFL));
            this.byteAlign = (byte)(nativeConnectionFlags[4] & 0xFFL);
            this.timeZoneVersionNumber = (int)nativeConnectionFlags[5];
            if (nativeConnectionFlags[6] != 0L) {
                this.useOCIDefaultDefines = true;
            }
            this.tagMatched[0] = nativeConnectionFlags[7] != 0L;
            this.varTypeMaxLenCompat = (int)nativeConnectionFlags[8];
            int offset = 0;
            String instanceStartTime = null;
            while ((outType = this.readShort(outByteArray, offset)) != 0) {
                int outLength = this.readShort(outByteArray, offset += 2);
                offset += 2;
                switch (outType) {
                    case 1: {
                        this.databaseUniqueIdentifier = new String(outByteArray, offset, outLength);
                        offset += outLength;
                        break;
                    }
                    case 2: {
                        instanceStartTime = new String(outByteArray, offset, outLength);
                        offset += outLength;
                    }
                }
            }
            if (this.databaseUniqueIdentifier != null) {
                String versionString = cachedVersionTable.get(this.databaseUniqueIdentifier + instanceStartTime);
                if (versionString == null) {
                    cachedVersionTable.put(this.databaseUniqueIdentifier + instanceStartTime, String.valueOf(this.getVersionNumber()));
                } else {
                    this.versionNumber = Short.parseShort(versionString);
                    this.t2cSetCachedServerVersion(this.m_nativeState, this.versionNumber);
                }
            }
        }
    }

    @Override
    final CompletionStage<Void> logonAsync(AbstractConnectionBuilder<?, ?> builder) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous connection is not supported by the Type 2 OCI driver"));
    }

    int readShort(byte[] buffer, int offset) {
        return (buffer[offset] & 0xFF) << 8 | buffer[offset + 1] & 0xFF;
    }

    @Override
    protected void logoff() throws SQLException {
        try {
            if (this.getLifecycle() == 8 || this.getLifecycle() == 2) {
                this.checkError(this.t2cLogoff(this.m_nativeState));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.m_nativeState = 0L;
    }

    @Override
    final CompletionStage<Void> logoffAsync(ThrowingRunnable<SQLException> startCallback) {
        return CompletableFuture.failedStage(new UnsupportedOperationException("Type 2 OCI connections do not support asynchronous close"));
    }

    @Override
    public void open(OracleStatement stmt) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] l_sqlString = stmt.sqlObject.getSql(stmt.processEscapes, stmt.convertNcharLiterals).getBytes();
            this.checkError(this.t2cCreateStatement(this.m_nativeState, 0L, l_sqlString, l_sqlString.length, stmt, false, stmt.rowPrefetch));
        }
    }

    @Override
    OracleStatement createImplicitResultSetStatement(OracleStatement parent) throws SQLException {
        T2CStatement stmt = new T2CStatement(this, OracleResultSet.ResultSetType.UNKNOWN);
        this.checkError(this.t2cGetImplicitResultSetStatement(this.m_nativeState, parent.c_state, stmt));
        stmt.needToParse = false;
        stmt.isOpen = true;
        stmt.processEscapes = false;
        stmt.sqlKind = OracleStatement.SqlKind.SELECT;
        stmt.prepareForNewResults(true, false, true);
        parent.addImplicitResultSetStmt(stmt);
        return stmt;
    }

    @Override
    void cancelOperationOnServer(boolean isStatementCancel) throws SQLException {
        this.checkError(this.t2cCancel(this.m_nativeState));
    }

    native int t2cAbort(long var1);

    @Override
    void doAbort() throws SQLException {
        this.checkError(this.t2cAbort(this.m_nativeState));
    }

    native int t2cBeginRequest(long var1);

    @Override
    public void beginRequest() throws SQLException {
        if (this.drcpEnabled) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            super.beginRequest();
            this.checkError(this.t2cBeginRequest(this.m_nativeState));
        }
    }

    native int t2cEndRequest(long var1);

    @Override
    public void endRequest(boolean implicit) throws SQLException {
        if (this.drcpEnabled) {
            return;
        }
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checkError(this.t2cEndRequest(this.m_nativeState));
            super.endRequest(implicit);
        }
    }

    @Override
    void setDriverSpecificAutoCommit(boolean on) throws SQLException {
        this.checkError(this.t2cSetAutoCommit(this.m_nativeState, on));
        this.autocommit = on;
    }

    @Override
    protected void doSetAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autoCommitSpecCompliant && !this.getAutoCommit() && autoCommit) {
            this.commit();
        }
        this.setDriverSpecificAutoCommit(autoCommit);
    }

    @Override
    protected void doCommit(int flags) throws SQLException {
        this.checkError(this.t2cCommit(this.m_nativeState, flags));
    }

    @Override
    final CompletionStage<Void> doCommitAsync(int flags, ErrorSet continueOnErrorSet) {
        return CompletableFuture.failedStage(new UnsupportedOperationException("Asynchronous commit is not supported by the Type 2 OCI driver"));
    }

    @Override
    protected void doRollback() throws SQLException {
        this.checkError(this.t2cRollback(this.m_nativeState));
    }

    @Override
    final CompletionStage<Void> doRollbackAsync(ErrorSet continueOnErrorSet) {
        return CompletableFuture.failedStage(new UnsupportedOperationException("Asynchronous rollback is not supported by the Type 2 OCI driver"));
    }

    @Override
    int doPingDatabase() throws SQLException {
        this.assertLockHeldByCurrentThread();
        if (this.drcpEnabled && this.drcpState == OracleConnection.DRCPState.DETACHED) {
            this.attachServerConnection();
        }
        if (this.t2cPingDatabase(this.m_nativeState) == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    protected String doGetDatabaseProductVersion() throws SQLException {
        long[] serverVersionRet = new long[1];
        return this.doGetDatabaseProductVersion(serverVersionRet);
    }

    private String doGetDatabaseProductVersion(long[] serverVersionRet) throws SQLException {
        byte[] l_version = this.t2cGetProductionVersion(this.m_nativeState, serverVersionRet);
        return this.conversion.CharBytesToString(l_version, l_version.length);
    }

    @Override
    protected short doGetVersionNumber() throws SQLException {
        short version_num = 0;
        try {
            long[] serverVersionRet = new long[]{0L};
            String ver_str = this.doGetDatabaseProductVersion(serverVersionRet);
            version_num = (short)serverVersionRet[0];
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return version_num;
    }

    @Override
    protected int doGetMajorVersionNumber() throws SQLException {
        this.requireOpenConnection();
        int version_num = 0;
        try {
            version_num = this.t2cGetMajorVersionNumber(this.m_nativeState);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return version_num;
    }

    @Override
    protected int doGetMinorVersionNumber() throws SQLException {
        this.requireOpenConnection();
        int version_num = 0;
        try {
            version_num = this.t2cGetMinorVersionNumber(this.m_nativeState);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return version_num;
    }

    @Override
    public ClobDBAccess createClobDBAccess() {
        return this;
    }

    @Override
    public BlobDBAccess createBlobDBAccess() {
        return this;
    }

    @Override
    public BfileDBAccess createBfileDBAccess() {
        return this;
    }

    protected SQLWarning checkError(int errStatus) throws SQLException {
        return this.checkError(errStatus, null, 0L, null);
    }

    protected SQLWarning checkError(int errStatus, long cStateStatement, OracleSql sqlObject) throws SQLException {
        return this.checkError(errStatus, null, cStateStatement, sqlObject);
    }

    protected SQLWarning checkError(int errStatus, SQLWarning warning) throws SQLException {
        return this.checkError(errStatus, warning, 0L, null);
    }

    protected SQLWarning checkError(int errStatus, SQLWarning warning, long cStateStatement, OracleSql sqlObject) throws SQLException {
        switch (errStatus) {
            case 0: {
                break;
            }
            case -1: 
            case 1: {
                T2CError l_error = new T2CError();
                int l_status = -1;
                if (this.getLifecycle() != 1 && this.getLifecycle() != 16) {
                    if (this.fatalErrorNumber != 0) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 269).fillInStackTrace();
                    }
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
                }
                l_status = this.t2cDescribeError(this.m_nativeState, l_error, l_error.m_errorMessage, cStateStatement);
                String l_reason = null;
                if (l_status != -1) {
                    int msgLength;
                    for (msgLength = 0; msgLength < l_error.m_errorMessage.length && l_error.m_errorMessage[msgLength] != 0; ++msgLength) {
                    }
                    if (this.conversion == null) {
                        throw new Error("conversion == null");
                    }
                    if (l_error == null) {
                        throw new Error("l_error == null");
                    }
                    l_reason = this.conversion.CharBytesToString(l_error.m_errorMessage, msgLength, true);
                }
                DBConversion savedConversion = null;
                switch (l_error.m_errorNumber) {
                    case 28: 
                    case 600: 
                    case 1012: 
                    case 1041: {
                        this.internalClose();
                        break;
                    }
                    case 902: 
                    case 21700: {
                        this.removeAllDescriptor();
                        break;
                    }
                    case 3113: 
                    case 3114: {
                        this.setUsable(false);
                        savedConversion = this.conversion;
                        this.close();
                        break;
                    }
                    case -6: {
                        l_error.m_errorNumber = 3113;
                    }
                }
                if (l_status == -1) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Fetch error message failed!").fillInStackTrace();
                }
                if (errStatus == -1) {
                    SQLException sqlException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), l_reason, l_error.m_errorNumber).fillInStackTrace();
                    if (l_error.m_errorPosition >= 0) {
                        int msgLength;
                        for (msgLength = 0; msgLength < l_error.m_errorMessage.length && l_error.m_errorMessage[msgLength] != 0; ++msgLength) {
                        }
                        if (this.conversion == null) {
                            this.conversion = savedConversion;
                        }
                        String errorMsg = this.conversion.CharBytesToString(l_error.m_errorMessage, msgLength, true);
                        sqlException.initCause(new OracleDatabaseException(l_error.m_errorPosition, l_error.m_errorNumber, errorMsg, sqlObject.actualSql, sqlObject.originalSql));
                    }
                    throw sqlException;
                }
                warning = DatabaseError.addSqlWarning(warning, l_reason, l_error.m_errorNumber);
                break;
            }
            case -4: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 254).fillInStackTrace();
            }
        }
        return warning;
    }

    @Override
    OracleStatement RefCursorBytesToStatement(byte[] bytes, OracleStatement parent) throws SQLException {
        T2CStatement stmt = new T2CStatement(this, OracleResultSet.ResultSetType.UNKNOWN);
        stmt.needToParse = false;
        stmt.serverCursor = true;
        stmt.isOpen = true;
        stmt.processEscapes = false;
        stmt.prepareForNewResults(true, false, true);
        if (this.useOCIDefaultDefines) {
            stmt.savedRowPrefetch = this.defaultRowPrefetch;
            stmt.rowPrefetch = 1;
        }
        stmt.sqlObject.initialize("select unknown as ref cursor from whatever");
        stmt.sqlKind = OracleStatement.SqlKind.SELECT;
        this.checkError(this.t2cCreateStatement(this.m_nativeState, parent.c_state, bytes, bytes.length, stmt, true, this.defaultRowPrefetch));
        parent.addChild(stmt);
        return stmt;
    }

    @Override
    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean value = false;
            if (otype != null) {
                String[] schema = new String[1];
                String[] type = new String[1];
                SQLName.parse(otypeADT.getFullName(), schema, type, true);
                String fullname = "\"" + schema[0] + "\".\"" + type[0] + "\"";
                byte[] utf8bytes = this.conversion.StringToCharBytes(fullname);
                int formOfUse = this.t2cGetFormOfUse(this.m_nativeState, otype, utf8bytes, utf8bytes.length, attrIndex);
                if (formOfUse < 0) {
                    this.checkError(formOfUse);
                }
                otype.setForm(formOfUse);
            }
        }
    }

    @Override
    public long getTdoCState(String schemaName, String typeName) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            String fullNameWithQuotes = "\"" + schemaName + "\".\"" + typeName + "\"";
            byte[] dbcsbytes = this.conversion.StringToCharBytes(fullNameWithQuotes);
            int[] err = new int[1];
            long tdoCState = this.t2cGetTDO(this.m_nativeState, dbcsbytes, dbcsbytes.length, err);
            if (tdoCState == 0L) {
                this.checkError(err[0]);
            }
            long l = tdoCState;
            return l;
        }
    }

    @Override
    public long getTdoCState(String fullNameWithQuotes) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] dbcsbytes = this.conversion.StringToCharBytes(fullNameWithQuotes);
            int[] err = new int[1];
            long tdoCState = this.t2cGetTDO(this.m_nativeState, dbcsbytes, dbcsbytes.length, err);
            if (tdoCState == 0L) {
                this.checkError(err[0]);
            }
            long l = tdoCState;
            return l;
        }
    }

    @Override
    @Deprecated
    @Blind(value=PropertiesBlinder.class)
    public Properties getDBAccessProperties() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Properties properties = this.getOCIHandles();
            return properties;
        }
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getOCIHandles() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (this.nativeInfo == null) {
                long[] handles = new long[3];
                this.checkError(this.t2cGetHandles(this.m_nativeState, handles));
                this.nativeInfo = new Properties();
                this.nativeInfo.put("OCIEnvHandle", String.valueOf(handles[0]));
                this.nativeInfo.put("OCISvcCtxHandle", String.valueOf(handles[1]));
                this.nativeInfo.put("OCIErrHandle", String.valueOf(handles[2]));
                this.nativeInfo.put("ClientCharSet", String.valueOf(this.m_clientCharacterSet));
            }
            Properties properties = this.nativeInfo;
            return properties;
        }
    }

    @Override
    @Blind(value=PropertiesBlinder.class)
    public Properties getServerSessionInfo() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (this.sessionProperties == null) {
                this.sessionProperties = new Properties();
            }
            if (this.getVersionNumber() < 10200) {
                if (this.ociConnectionPoolLogonMode != "connection_pool") {
                    this.queryFCFProperties();
                }
            } else {
                this.checkError(T2CConnection.t2cGetServerSessionInfo(this.m_nativeState, this.sessionProperties));
            }
            Properties properties = this.sessionProperties;
            return properties;
        }
    }

    @Override
    public byte getInstanceProperty(OracleConnection.InstanceProperty whatProperty) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte ret = 0;
            if (whatProperty == OracleConnection.InstanceProperty.ASM_VOLUME_SUPPORTED) {
                ret = this.t2cGetAsmVolProperty(this.m_nativeState);
            } else if (whatProperty == OracleConnection.InstanceProperty.INSTANCE_TYPE) {
                ret = this.t2cGetInstanceType(this.m_nativeState);
            }
            byte by = ret;
            return by;
        }
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getConnectionPoolInfo() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            Properties info = new Properties();
            this.checkError(this.t2cGetConnPoolInfo(this.m_nativeState, info));
            Properties properties = info;
            return properties;
        }
    }

    public void setConnectionPoolInfo(int cpool_min, int cpool_max, int cpool_incr, int cpool_timeout, int cpool_nowait, int cpool_dist_txn) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checkError(this.t2cSetConnPoolInfo(this.m_nativeState, cpool_min, cpool_max, cpool_incr, cpool_timeout, cpool_nowait, cpool_dist_txn));
        }
    }

    public void ociPasswordChange(String user, @Blind String oldPassword, @Blind String newPassword) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            byte[] l_userName = user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(user, this.m_clientCharacterSet);
            byte[] l_oldPwd = oldPassword == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(oldPassword, this.m_clientCharacterSet);
            byte[] l_newPwd = newPassword == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(newPassword, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cPasswordChange(this.m_nativeState, l_userName, l_userName.length, l_oldPwd, l_oldPwd.length, l_newPwd, l_newPwd.length), this.sqlWarning);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOCIConnectionPooling() throws SQLException {
        this.requireOpenConnection();
        T2CConnection m_conn_pool = null;
        if (this.ociConnectionPoolLogonMode == "connection_pool") {
            this.m_clientCharacterSet = this.nlsLangBackdoor ? T2CConnection.getDriverCharSetIdFromNLS_LANG() : T2CConnection.getClientCharSetId();
        } else {
            m_conn_pool = (T2CConnection)this.ociConnectionPoolObject;
            this.m_clientCharacterSet = m_conn_pool.m_clientCharacterSet;
        }
        byte[] l_userName = null;
        byte[] l_password = this.password == null || this.password.isNull() ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.password.get().trim(), this.m_clientCharacterSet);
        byte[] l_editionName = this.editionName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.editionName, this.m_clientCharacterSet);
        byte[] l_driverNameAttribute = DBConversion.stringToDriverCharBytes((String)(this.driverNameAttribute == null ? "jdbcoci : " + BuildInfo.getDriverVersion() : this.driverNameAttribute), this.m_clientCharacterSet);
        byte[] l_database = DBConversion.stringToDriverCharBytes(this.database, this.m_clientCharacterSet);
        byte[] nlslanguage = CharacterSetMetaData.getNLSLanguage(Locale.getDefault(Locale.Category.FORMAT)).getBytes();
        byte[] nlsterritory = CharacterSetMetaData.getNLSTerritory(Locale.getDefault(Locale.Category.FORMAT)).getBytes();
        if (nlslanguage == null || nlsterritory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176).fillInStackTrace();
        }
        long[] nativeConnectionFlags = new long[]{this.defaultLobPrefetchSize, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, this.ociExternalAuthentication ? 1 : 0};
        if (this.ociConnectionPoolLogonMode == "connection_pool") {
            l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.logon_mode = 5;
            if (this.getLifecycle() != 1) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 0, "Internal Error: ").fillInStackTrace();
            int[] p = new int[6];
            OracleOCIConnectionPool.readPoolConfig(this.ociConnectionPoolMinLimit, this.ociConnectionPoolMaxLimit, this.ociConnectionPoolIncrement, this.ociConnectionPoolTimeout, this.ociConnectionPoolNoWait, this.ociConnectionPoolTransactionDistributed, p);
            this.sqlWarning = this.checkError(this.t2cCreateConnPool(l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.m_clientCharacterSet, this.logon_mode, p[0], p[1], p[2], p[3], p[4], p[5]), this.sqlWarning);
            this.versionNumber = (short)10000;
        } else if (this.ociConnectionPoolLogonMode == "connpool_connection") {
            this.logon_mode = 6;
            l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_editionName, l_editionName.length, l_driverNameAttribute, l_driverNameAttribute.length, l_database, l_database.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, null, 0, nlslanguage, nlsterritory, nativeConnectionFlags), this.sqlWarning);
        } else if (this.ociConnectionPoolLogonMode == "connpool_alias_connection") {
            this.logon_mode = 8;
            byte[] connection_id = null;
            connection_id = (byte[])this.ociConnectionPoolConnID;
            l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_editionName, l_editionName.length, l_driverNameAttribute, l_driverNameAttribute.length, l_database, l_database.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, connection_id, connection_id == null ? 0 : connection_id.length, nlslanguage, nlsterritory, nativeConnectionFlags), this.sqlWarning);
        } else {
            if (this.ociConnectionPoolLogonMode != "connpool_proxy_connection") throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "connection-pool-logon").fillInStackTrace();
            this.logon_mode = 7;
            String proxyType = this.ociConnectionPoolProxyType;
            int num_proxy_roles = this.ociConnectionPoolProxyNumRoles;
            String[] proxy_roles = null;
            if (num_proxy_roles > 0) {
                proxy_roles = (String[])this.ociConnectionPoolProxyRoles;
            }
            byte[] proxy_un = null;
            byte[] proxy_pd = null;
            byte[] proxy_dn = null;
            byte[] proxy_cf = null;
            int proxy_type = 0;
            if (proxyType == "proxytype_user_name") {
                proxy_type = 1;
                String p = this.ociConnectionPoolProxyUserName;
                if (p != null) {
                    proxy_un = p.getBytes();
                }
                if ((p = this.ociConnectionPoolProxyPassword.get()) != null) {
                    proxy_pd = p.getBytes();
                }
            } else if (proxyType == "proxytype_distinguished_name") {
                proxy_type = 2;
                String p = this.ociConnectionPoolProxyDistinguishedName;
                if (p != null) {
                    proxy_dn = p.getBytes();
                }
            } else {
                if (proxyType != "proxytype_certificate") throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 107).fillInStackTrace();
                proxy_type = 3;
                proxy_cf = (byte[])this.ociConnectionPoolProxyCertificate;
            }
            l_userName = this.userName == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_editionName, l_editionName.length, l_driverNameAttribute, l_driverNameAttribute.length, l_database, l_database.length, this.logon_mode, proxy_type, num_proxy_roles, proxy_roles, proxy_un, proxy_un == null ? 0 : proxy_un.length, proxy_pd, proxy_pd == null ? 0 : proxy_pd.length, proxy_dn, proxy_dn == null ? 0 : proxy_dn.length, proxy_cf, proxy_cf == null ? 0 : proxy_cf.length, null, 0, nlslanguage, nlsterritory, nativeConnectionFlags), this.sqlWarning);
        }
        this.conversion = new DBConversion((short)(nativeConnectionFlags[2] & 0xFFFFL), this.m_clientCharacterSet, (short)(nativeConnectionFlags[3] & 0xFFFFL));
        this.byteAlign = (byte)(nativeConnectionFlags[4] & 0xFFL);
        this.timeZoneVersionNumber = (int)nativeConnectionFlags[5];
        if (nativeConnectionFlags[6] != 0L) {
            this.useOCIDefaultDefines = true;
        }
        this.tagMatched[0] = nativeConnectionFlags[7] != 0L;
        this.varTypeMaxLenCompat = (int)nativeConnectionFlags[8];
    }

    @Override
    public boolean isDescriptorSharable(OracleConnection conn) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Monitor.CloseableLock connLock = conn.acquireCloseableLock();
            try {
                boolean bl;
                T2CConnection c1 = this;
                PhysicalConnection c2 = (PhysicalConnection)conn.getPhysicalConnection();
                boolean bl2 = bl = c1 == c2;
                if (connLock != null) {
                    connLock.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (connLock != null) {
                    try {
                        connLock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public String getNetConnectionId() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.ociConnectionPoolIsPooling) {
                String string = null;
                return string;
            }
            int bufferCapacity = 33;
            byte[] buffer = new byte[33];
            int[] bufferSize = new int[1];
            this.checkError(this.t2cGetNetConnectionId(this.m_nativeState, buffer, 33, bufferSize));
            String string = new String(buffer, 0, bufferSize[0] - 1, StandardCharsets.US_ASCII);
            return string;
        }
    }

    native int t2cBlobRead(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, boolean var10, ByteBuffer var11);

    native int t2cClobRead(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, boolean var10, boolean var11, ByteBuffer var12);

    native int t2cBlobWrite(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, byte[][] var10);

    native int t2cClobWrite(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, byte[][] var10, boolean var11);

    native long t2cLobGetLength(long var1, byte[] var3, int var4);

    native int t2cBfileOpen(long var1, byte[] var3, int var4, byte[][] var5);

    native int t2cBfileIsOpen(long var1, byte[] var3, int var4, boolean[] var5);

    native int t2cBfileExists(long var1, byte[] var3, int var4, boolean[] var5);

    native String t2cBfileGetName(long var1, byte[] var3, int var4);

    native String t2cBfileGetDirAlias(long var1, byte[] var3, int var4);

    native int t2cBfileClose(long var1, byte[] var3, int var4, byte[][] var5);

    native int t2cLobGetChunkSize(long var1, byte[] var3, int var4);

    native int t2cLobTrim(long var1, int var3, long var4, byte[] var6, int var7, byte[][] var8);

    native int t2cLobCreateTemporary(long var1, int var3, boolean var4, int var5, short var6, byte[][] var7);

    native int t2cLobFreeTemporary(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    native int t2cLobIsTemporary(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int t2cLobOpen(long var1, int var3, byte[] var4, int var5, int var6, byte[][] var7);

    native int t2cLobIsOpen(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int t2cLobClose(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    private long lobLength(byte[] locator) throws SQLException {
        long result = 0L;
        result = this.t2cLobGetLength(this.m_nativeState, locator, locator.length);
        this.checkError((int)result);
        return result;
    }

    private int blobRead(byte[] locator, long offset, int amount, byte[] buffer, boolean enableNio, ByteBuffer nioBuffer) throws SQLException {
        int result = 0;
        result = this.t2cBlobRead(this.m_nativeState, locator, locator.length, offset, amount, buffer, buffer.length, enableNio, nioBuffer);
        this.checkError(result);
        return result;
    }

    private int blobWrite(byte[] locator, long offset, byte[] buffer, byte[][] newLocatorHolder, int bytesOffset, int amount) throws SQLException {
        int result = 0;
        result = this.t2cBlobWrite(this.m_nativeState, locator, locator.length, offset, amount, buffer, bytesOffset, newLocatorHolder);
        this.checkError(result);
        return result;
    }

    private int clobWrite(byte[] locator, long offset, char[] buffer, byte[][] newLocatorHolder, boolean isNclob, int charsOffset, int amount) throws SQLException {
        int result = 0;
        result = this.t2cClobWrite(this.m_nativeState, locator, locator.length, offset, amount, buffer, charsOffset, newLocatorHolder, isNclob);
        this.checkError(result);
        return result;
    }

    private int lobGetChunkSize(byte[] locator) throws SQLException {
        int result = 0;
        result = this.t2cLobGetChunkSize(this.m_nativeState, locator, locator.length);
        this.checkError(result);
        return result;
    }

    @Override
    public long length(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            long l = this.lobLength(locator);
            return l;
        }
    }

    @Override
    public long position(OracleBfile bfile, Datum bfileDatum, byte[] pattern, long start) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (start < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
            }
            long result = LobPlsqlUtil.hasPattern(bfile, bfileDatum, pattern, start);
            long l = result = result == 0L ? -1L : result;
            return l;
        }
    }

    @Override
    public long position(OracleBfile bfile, Datum bfileDatum, Datum pattern, long start) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (start < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
            }
            long result = LobPlsqlUtil.isSubLob(bfile, bfileDatum, pattern, start);
            long l = result = result == 0L ? -1L : result;
            return l;
        }
    }

    @Override
    public int getBytes(OracleBfile bfile, long offset, int amount, byte[] buffer) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (offset < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
            }
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            if (amount <= 0 || buffer == null) {
                int n = 0;
                return n;
            }
            if (amount > buffer.length) {
                amount = buffer.length;
            }
            if (this.useNio) {
                int sizeOfBuffer = buffer.length;
                if (this.nioBufferForLob == null || this.nioBufferForLob.capacity() < sizeOfBuffer) {
                    this.nioBufferForLob = ByteBuffer.allocateDirect(sizeOfBuffer);
                } else {
                    this.nioBufferForLob.rewind();
                }
            }
            int returnValue = this.blobRead(locator, offset, amount, buffer, this.useNio, this.nioBufferForLob);
            if (this.useNio) {
                this.nioBufferForLob.get(buffer);
            }
            int n = returnValue;
            return n;
        }
    }

    @Override
    public String getName(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            String fileName = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            fileName = this.t2cBfileGetName(this.m_nativeState, locator, locator.length);
            this.checkError(fileName.length());
            String string = fileName;
            return string;
        }
    }

    @Override
    public String getDirAlias(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            String aliasName = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            aliasName = this.t2cBfileGetDirAlias(this.m_nativeState, locator, locator.length);
            this.checkError(aliasName.length());
            String string = aliasName;
            return string;
        }
    }

    @Override
    public void openFile(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cBfileOpen(this.m_nativeState, locator, locator.length, newLocatorHolder));
            bfile.setLocator(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public boolean isFileOpen(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cBfileIsOpen(this.m_nativeState, locator, locator.length, flagHolder));
            boolean bl = flagHolder[0];
            return bl;
        }
    }

    @Override
    public boolean fileExists(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cBfileExists(this.m_nativeState, locator, locator.length, flagHolder));
            boolean bl = flagHolder[0];
            return bl;
        }
    }

    @Override
    public void closeFile(OracleBfile bfile) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cBfileClose(this.m_nativeState, locator, locator.length, newLocatorHolder));
            bfile.setLocator(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public void openLob(OracleBfile lob, int mode) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobOpen(this.m_nativeState, 114, locator, locator.length, mode, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public void closeLob(OracleBfile lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobClose(this.m_nativeState, 114, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public boolean isOpenLob(OracleBfile lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsOpen(this.m_nativeState, 114, locator, locator.length, flagHolder));
            boolean bl = flagHolder[0];
            return bl;
        }
    }

    @Override
    public InputStream newInputStream(OracleBfile bfile, int chunkSize, long pos) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pos == 0L) {
                OracleBlobInputStream oracleBlobInputStream = new OracleBlobInputStream(bfile, chunkSize);
                return oracleBlobInputStream;
            }
            OracleBlobInputStream oracleBlobInputStream = new OracleBlobInputStream(bfile, chunkSize, pos);
            return oracleBlobInputStream;
        }
    }

    @Override
    public InputStream newConversionInputStream(OracleBfile bfile, int conversionType) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleConversionInputStream result;
            this.checkTrue(bfile != null && bfile.shareBytes() != null, 54);
            OracleConversionInputStream oracleConversionInputStream = result = new OracleConversionInputStream(this.conversion, bfile.getBinaryStream(), conversionType, (Monitor)this.getPhysicalConnection());
            return oracleConversionInputStream;
        }
    }

    @Override
    public Reader newConversionReader(OracleBfile bfile, int conversionType) throws SQLException {
        this.checkTrue(bfile != null && bfile.shareBytes() != null, 54);
        OracleConversionReader result = new OracleConversionReader(this.conversion, bfile.getBinaryStream(), conversionType, this.getPhysicalConnection());
        return result;
    }

    @Override
    public long length(OracleBlob blob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            long l = this.lobLength(locator);
            return l;
        }
    }

    @Override
    public final CompletionStage<Long> lengthAsync(OracleBlob blob) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous blob length access is not supported by the Type 2 OCI driver"));
    }

    @Override
    public long position(OracleBlob blob, Datum blobDatum, byte[] pattern, long start) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            if (start < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
            }
            long result = LobPlsqlUtil.hasPattern(blob, blobDatum, pattern, start);
            long l = result = result == 0L ? -1L : result;
            return l;
        }
    }

    @Override
    public long position(OracleBlob blob, Datum blobDatum, Datum pattern, long start) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            this.checkTrue(pattern != null && pattern.shareBytes() != null, 54);
            if (start < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
            }
            long result = LobPlsqlUtil.isSubLob(blob, blobDatum, pattern, start);
            long l = result = result == 0L ? -1L : result;
            return l;
        }
    }

    @Override
    public int getBytes(OracleBlob blob, long offset, int amount, byte[] buffer) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (offset < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
            }
            byte[] locator = null;
            int result = 0;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            if (amount <= 0 || buffer == null) {
                int n = 0;
                return n;
            }
            if (amount > buffer.length) {
                amount = buffer.length;
            }
            long lobLength = -1L;
            if (blob.isActivePrefetch()) {
                lobLength = blob.length();
                OracleLargeObject.PrefetchData<byte[]> prefetchData = blob.getPrefetchData();
                if (prefetchData != null && prefetchData.length() > 0 && offset > 0L && offset <= (long)prefetchData.length()) {
                    result += prefetchData.copy((int)offset - 1, buffer, 0, amount);
                }
            }
            if (result < amount && (lobLength == -1L || offset - 1L + (long)result < lobLength)) {
                byte[] buffer2 = buffer;
                int result2 = result;
                int bytesToRead = (lobLength > 0L && lobLength < (long)amount ? (int)lobLength : amount) - result;
                if (result > 0) {
                    buffer2 = new byte[bytesToRead];
                }
                if (this.useNio) {
                    int sizeOfBuffer = buffer.length;
                    if (this.nioBufferForLob == null || this.nioBufferForLob.capacity() < sizeOfBuffer) {
                        this.nioBufferForLob = ByteBuffer.allocateDirect(sizeOfBuffer);
                    } else {
                        this.nioBufferForLob.rewind();
                    }
                }
                result += this.blobRead(locator, offset + (long)result, bytesToRead, buffer2, this.useNio, this.nioBufferForLob);
                if (this.useNio) {
                    this.nioBufferForLob.get(buffer2);
                }
                if (result2 > 0) {
                    System.arraycopy(buffer2, 0, buffer, result2, buffer2.length);
                }
            }
            int n = result;
            return n;
        }
    }

    @Override
    public int putBytes(OracleBlob blob, long offset, byte[] buffer, int bytesOffset, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checkTrue(offset != 0L || length > 0, 68);
            this.checkTrue(offset >= 0L, 68);
            if (buffer == null || buffer.length == 0 || length <= 0) {
                int n = 0;
                return n;
            }
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            this.assertNotNull(blob.shareBytes(), "putBytes");
            byte[][] newLocatorHolder = new byte[1][];
            blob.setActivePrefetch(false);
            blob.clearCachedData();
            int ret = this.blobWrite(locator, offset, buffer, newLocatorHolder, bytesOffset, length);
            blob.setLocator(newLocatorHolder[0]);
            int n = ret;
            return n;
        }
    }

    @Override
    public int getChunkSize(OracleBlob blob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            int n = this.lobGetChunkSize(locator);
            return n;
        }
    }

    @Override
    public void trim(OracleBlob lob, long newlen) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            this.assertNotNull(lob.shareBytes(), "trim");
            byte[][] newLocatorHolder = new byte[1][];
            lob.setActivePrefetch(false);
            lob.clearCachedData();
            this.checkError(this.t2cLobTrim(this.m_nativeState, 113, newlen, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public BLOB createTemporaryBlob(Connection conn, boolean cache, int duration) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            BLOB lob = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            lob = new BLOB((PhysicalConnection)conn);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobCreateTemporary(this.m_nativeState, 113, cache, duration, (short)0, newLocatorHolder));
            this.addTemporaryLob(lob.getInternal());
            lob.setShareBytes(newLocatorHolder[0]);
            BLOB bLOB = lob;
            return bLOB;
        }
    }

    @Override
    public void freeTemporary(OracleBlob temp_lob, Datum temp_lob_datum, boolean fromObject) throws SQLException {
        block10: {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                try {
                    byte[] locator = null;
                    this.checkTrue(this.getLifecycle() == 1, 8);
                    this.checkTrue(temp_lob != null && (locator = temp_lob.shareBytes()) != null, 54);
                    this.assertNotNull(temp_lob.shareBytes(), "freeTemporary");
                    this.removeFromTemporaryLobs(temp_lob);
                    byte[][] newLocatorHolder = new byte[1][];
                    this.checkError(this.t2cLobFreeTemporary(this.m_nativeState, 113, locator, locator.length, newLocatorHolder));
                    temp_lob.setShareBytes(newLocatorHolder[0]);
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == 64201) {
                        if (fromObject) {
                            LobPlsqlUtil.freeTemporaryLob(this, temp_lob_datum, 2004);
                        }
                        break block10;
                    }
                    throw ex;
                }
            }
        }
    }

    @Override
    public boolean isTemporary(OracleBlob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            this.assertNotNull(lob.shareBytes(), "isTemporary");
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsTemporary(this.m_nativeState, 113, locator, locator.length, flagHolder));
            boolean bl = flagHolder[0];
            return bl;
        }
    }

    @Override
    public short getDuration(OracleBlob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            short s = -1;
            return s;
        }
    }

    @Override
    public void openLob(OracleBlob blob, int mode) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(blob != null && (locator = blob.shareBytes()) != null, 54);
            this.assertNotNull(blob.shareBytes(), "open");
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobOpen(this.m_nativeState, 113, locator, locator.length, mode, newLocatorHolder));
            blob.setShareBytes(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public void closeLob(OracleBlob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            this.assertNotNull(lob.shareBytes(), "close");
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobClose(this.m_nativeState, 113, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public final CompletionStage<Void> closeLobAsync(OracleBlob blob) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous blob close is not supported by the Type 2 OCI driver"));
    }

    @Override
    public boolean isOpenLob(OracleBlob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            this.assertNotNull(lob.shareBytes(), "isOpen");
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsOpen(this.m_nativeState, 113, locator, locator.length, flagHolder));
            boolean bl = flagHolder[0];
            return bl;
        }
    }

    @Override
    public InputStream newInputStream(OracleBlob blob, int chunkSize, long pos) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            InputStream inputStream = this.newInputStream(blob, chunkSize, pos, false);
            return inputStream;
        }
    }

    @Override
    public InputStream newInputStream(OracleBlob blob, int chunkSize, long pos, boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pos == 0L) {
                OracleBlobInputStream oracleBlobInputStream = new OracleBlobInputStream(blob, chunkSize, isInternal);
                return oracleBlobInputStream;
            }
            OracleBlobInputStream oracleBlobInputStream = new OracleBlobInputStream(blob, chunkSize, pos, isInternal);
            return oracleBlobInputStream;
        }
    }

    @Override
    public InputStream newInputStream(OracleBlob blob, int chunkSize, long pos, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            InputStream inputStream = this.newInputStream(blob, chunkSize, pos, length, false);
            return inputStream;
        }
    }

    @Override
    public InputStream newInputStream(OracleBlob blob, int chunkSize, long pos, long length, boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleBlobInputStream oracleBlobInputStream = new OracleBlobInputStream(blob, chunkSize, pos, length, isInternal);
            return oracleBlobInputStream;
        }
    }

    @Override
    public OutputStream newOutputStream(OracleBlob blob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pos == 0L) {
                if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
                OracleBlobOutputStream oracleBlobOutputStream = new OracleBlobOutputStream(blob, chunkSize);
                return oracleBlobOutputStream;
            }
            OracleBlobOutputStream oracleBlobOutputStream = new OracleBlobOutputStream(blob, chunkSize, pos);
            return oracleBlobOutputStream;
        }
    }

    public InputStream newConversionInputStream(OracleBlob blob, int conversionType) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            InputStream inputStream = this.newConversionInputStream(blob, conversionType, false);
            return inputStream;
        }
    }

    @Override
    public InputStream newConversionInputStream(OracleBlob blob, int conversionType, boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleConversionInputStream result;
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            OracleConversionInputStream oracleConversionInputStream = result = new OracleConversionInputStream(this.conversion, blob.binaryStreamValue(isInternal), conversionType, (Monitor)this.getPhysicalConnection());
            return oracleConversionInputStream;
        }
    }

    public Reader newConversionReader(OracleBlob blob, int conversionType) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Reader reader = this.newConversionReader(blob, conversionType, false);
            return reader;
        }
    }

    @Override
    public Reader newConversionReader(OracleBlob blob, int conversionType, boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleConversionReader result;
            this.checkTrue(blob != null && blob.shareBytes() != null, 54);
            OracleConversionReader oracleConversionReader = result = new OracleConversionReader(this.conversion, blob.binaryStreamValue(isInternal), conversionType, this.getPhysicalConnection());
            return oracleConversionReader;
        }
    }

    @Override
    public long length(OracleClob clob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.assertNotNull(clob.shareBytes(), "length");
            byte[] locator = clob.getLocator();
            this.checkTrue(locator != null, 54);
            long l = this.lobLength(locator);
            return l;
        }
    }

    @Override
    public final CompletionStage<Long> lengthAsync(OracleClob clob) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous clob length access is not supported by the Type 2 OCI driver"));
    }

    @Override
    public long position(OracleClob clob, String pattern, long start) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pattern == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(clob != null && clob.shareBytes() != null, 54);
            if (start < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
            }
            char[] chars = new char[pattern.length()];
            pattern.getChars(0, chars.length, chars, 0);
            long result = LobPlsqlUtil.hasPattern(clob, chars, start);
            long l = result = result == 0L ? -1L : result;
            return l;
        }
    }

    @Override
    public long position(OracleClob clob, OracleClob pattern, long start) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(clob != null && clob.shareBytes() != null, 54);
            this.checkTrue(pattern != null && pattern.shareBytes() != null, 54);
            if (start < 1L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "position()").fillInStackTrace();
            }
            long result = LobPlsqlUtil.isSubLob(clob, pattern, start);
            long l = result = result == 0L ? -1L : result;
            return l;
        }
    }

    @Override
    public int getChars(OracleClob clob, long offset, int amount, char[] buffer) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
            this.assertNotNull(clob.shareBytes(), "getChars");
            if (amount <= 0 || buffer == null) {
                int n = 0;
                return n;
            }
            if (amount > buffer.length) {
                amount = buffer.length;
            }
            int result = 0;
            long lobLength = -1L;
            if (clob.isActivePrefetch()) {
                lobLength = clob.length();
                OracleLargeObject.PrefetchData<char[]> prefetchedChars = clob.getPrefetchData();
                if (prefetchedChars != null && offset <= (long)prefetchedChars.length()) {
                    result += prefetchedChars.copy((int)offset - 1, buffer, 0, amount);
                }
            }
            if (result < amount && (lobLength == -1L || offset - 1L + (long)result < lobLength)) {
                char[] buffer2 = buffer;
                int result2 = result;
                int bytesToRead = (lobLength > 0L && lobLength < (long)amount ? (int)lobLength : amount) - result;
                if (result > 0) {
                    buffer2 = new char[bytesToRead];
                }
                if (this.useNio) {
                    int sizeOfBuffer = buffer.length * 2;
                    if (this.nioBufferForLob == null || this.nioBufferForLob.capacity() < sizeOfBuffer) {
                        this.nioBufferForLob = ByteBuffer.allocateDirect(sizeOfBuffer);
                    } else {
                        this.nioBufferForLob.rewind();
                    }
                }
                result += this.t2cClobRead(this.m_nativeState, locator, locator.length, offset + (long)result, bytesToRead, buffer2, buffer2.length, clob.isNCLOB(), this.useNio, this.nioBufferForLob);
                if (this.useNio) {
                    ByteBuffer b = this.nioBufferForLob.order(ByteOrder.LITTLE_ENDIAN);
                    CharBuffer c = b.asCharBuffer();
                    c.get(buffer2);
                }
                if (result2 > 0) {
                    System.arraycopy(buffer2, 0, buffer, result2, buffer2.length);
                }
                this.checkError(result);
            }
            int n = result;
            return n;
        }
    }

    @Override
    public int putChars(OracleClob clob, long offset, char[] buffer, int charsOffset, int length) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(offset >= 0L, 68);
            this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
            this.assertNotNull(clob.shareBytes(), "putChars");
            if (buffer == null || length <= 0) {
                int n = 0;
                return n;
            }
            byte[][] newLocatorHolder = new byte[1][];
            clob.setActivePrefetch(false);
            clob.clearCachedData();
            int result = this.clobWrite(locator, offset, buffer, newLocatorHolder, clob.isNCLOB(), charsOffset, length);
            clob.setLocator(newLocatorHolder[0]);
            int n = result;
            return n;
        }
    }

    @Override
    public int getChunkSize(OracleClob clob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
            int n = this.lobGetChunkSize(locator);
            return n;
        }
    }

    @Override
    public void trim(OracleClob clob, long newlen) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(clob != null && (locator = clob.shareBytes()) != null, 54);
            this.assertNotNull(clob.shareBytes(), "trim");
            byte[][] newLocatorHolder = new byte[1][];
            clob.setActivePrefetch(false);
            clob.clearCachedData();
            this.checkError(this.t2cLobTrim(this.m_nativeState, 112, newlen, locator, locator.length, newLocatorHolder));
            clob.setShareBytes(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public CLOB createTemporaryClob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            CLOB lob = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            lob = form_of_use == 1 ? new CLOB((PhysicalConnection)conn) : new NCLOB((PhysicalConnection)conn);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobCreateTemporary(this.m_nativeState, 112, cache, duration, form_of_use, newLocatorHolder));
            this.addTemporaryLob(lob.getInternal());
            lob.setShareBytes(newLocatorHolder[0]);
            CLOB cLOB = lob;
            return cLOB;
        }
    }

    @Override
    public void freeTemporary(OracleClob temp_lob, Datum temp_lob_datum, boolean fromObject) throws SQLException {
        block10: {
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                try {
                    byte[] locator = null;
                    this.checkTrue(this.getLifecycle() == 1, 8);
                    this.checkTrue(temp_lob != null && (locator = temp_lob.shareBytes()) != null, 54);
                    this.removeFromTemporaryLobs(temp_lob);
                    byte[][] newLocatorHolder = new byte[1][];
                    this.checkError(this.t2cLobFreeTemporary(this.m_nativeState, 112, locator, locator.length, newLocatorHolder));
                    temp_lob.setShareBytes(newLocatorHolder[0]);
                }
                catch (SQLException ex) {
                    if (ex.getErrorCode() == 64201) {
                        if (fromObject) {
                            LobPlsqlUtil.freeTemporaryLob(this, temp_lob_datum, 2005);
                        }
                        break block10;
                    }
                    throw ex;
                }
            }
        }
    }

    @Override
    public boolean isTemporary(OracleClob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsTemporary(this.m_nativeState, 112, locator, locator.length, flagHolder));
            boolean bl = flagHolder[0];
            return bl;
        }
    }

    @Override
    public short getDuration(OracleClob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            short s = -1;
            return s;
        }
    }

    @Override
    public void openLob(OracleClob lob, int mode) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobOpen(this.m_nativeState, 112, locator, locator.length, mode, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public void closeLob(OracleClob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            byte[][] newLocatorHolder = new byte[1][];
            this.checkError(this.t2cLobClose(this.m_nativeState, 112, locator, locator.length, newLocatorHolder));
            lob.setShareBytes(newLocatorHolder[0]);
            return;
        }
    }

    @Override
    public final CompletionStage<Void> closeLobAsync(OracleClob clob) {
        return CompletionStageUtil.failedStage(new UnsupportedOperationException("Asynchronous clob close is not supported by the Type 2 OCI driver"));
    }

    @Override
    public boolean isOpenLob(OracleClob lob) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] locator = null;
            this.checkTrue(this.getLifecycle() == 1, 8);
            this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
            boolean[] flagHolder = new boolean[1];
            this.checkError(this.t2cLobIsOpen(this.m_nativeState, 112, locator, locator.length, flagHolder));
            boolean bl = flagHolder[0];
            return bl;
        }
    }

    @Override
    public InputStream newInputStream(OracleClob clob, int chunkSize, long pos) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            InputStream inputStream = this.newInputStream(clob, chunkSize, pos, false);
            return inputStream;
        }
    }

    @Override
    public InputStream newInputStream(OracleClob clob, int chunkSize, long pos, boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pos == 0L) {
                OracleClobInputStream oracleClobInputStream = new OracleClobInputStream(clob, chunkSize, isInternal);
                return oracleClobInputStream;
            }
            OracleClobInputStream oracleClobInputStream = new OracleClobInputStream(clob, chunkSize, pos, isInternal);
            return oracleClobInputStream;
        }
    }

    @Override
    public OutputStream newOutputStream(OracleClob clob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pos == 0L) {
                if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
                OracleClobOutputStream oracleClobOutputStream = new OracleClobOutputStream(clob, chunkSize);
                return oracleClobOutputStream;
            }
            OracleClobOutputStream oracleClobOutputStream = new OracleClobOutputStream(clob, chunkSize, pos);
            return oracleClobOutputStream;
        }
    }

    @Override
    public Reader newReader(OracleClob clob, int chunkSize, long pos) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pos == 0L) {
                OracleClobReader oracleClobReader = new OracleClobReader(clob, chunkSize);
                return oracleClobReader;
            }
            OracleClobReader oracleClobReader = new OracleClobReader(clob, chunkSize, pos);
            return oracleClobReader;
        }
    }

    @Override
    public Reader newReader(OracleClob clob, int chunkSize, long pos, long length) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            OracleClobReader oracleClobReader = new OracleClobReader(clob, chunkSize, pos, length);
            return oracleClobReader;
        }
    }

    @Override
    public Writer newWriter(OracleClob clob, int chunkSize, long pos, boolean zeroInvalid) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (pos == 0L) {
                if (zeroInvalid & this.lobStreamPosStandardCompliant) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
                OracleClobWriter oracleClobWriter = new OracleClobWriter(clob, chunkSize);
                return oracleClobWriter;
            }
            OracleClobWriter oracleClobWriter = new OracleClobWriter(clob, chunkSize, pos);
            return oracleClobWriter;
        }
    }

    @Override
    public void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.appCallback = cbk;
            this.appCallbackObject = obj;
            this.checkError(this.t2cRegisterTAFCallback(this.m_nativeState));
        }
    }

    int callTAFCallbackMethod(int type, int event) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int retCode = 0;
            if (this.appCallback != null) {
                retCode = this.appCallback.callbackFn(this, this.appCallbackObject, type, event);
            }
            int n = retCode;
            return n;
        }
    }

    int callPDBChangeCallbackMethod(int mode) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int retCode = 0;
            try {
                this.onPDBChange(null);
                NTFPDBChangeEvent pdbChangeEvent = new NTFPDBChangeEvent(this);
                this.notify(pdbChangeEvent);
            }
            catch (SQLException sqex) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "callPDBChangeCallbackMethod", "callPDBChangeCallbackMethod(): {0}", (String)null, (Throwable)null, (Object)sqex.getMessage());
                retCode = -1;
            }
            int n = retCode;
            return n;
        }
    }

    @Override
    void onPDBChange(OracleStatement catalyst) throws SQLException {
        super.onPDBChange(catalyst);
    }

    @Override
    public boolean isValidCursorId(int cursorId) {
        return true;
    }

    @Override
    boolean isValidLight(int timeout) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.checkAndDrain()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    boolean drainOnInbandNotification() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean valid = this.t2cIsServerStatusValid(this.m_nativeState);
            if (!valid) {
                this.closeConnectionSafely();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public int getHeapAllocSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            int size = this.t2cGetHeapAllocSize(this.m_nativeState);
            if (size < 0) {
                if (size == -999) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89).fillInStackTrace();
            }
            int n = size;
            return n;
        }
    }

    @Override
    public int getOCIEnvHeapAllocSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            int size = this.t2cGetOciEnvHeapAllocSize(this.m_nativeState);
            if (size < 0) {
                if (size == -999) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
                }
                this.checkError(size);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89).fillInStackTrace();
            }
            int n = size;
            return n;
        }
    }

    public static final short getClientCharSetId() {
        return 871;
    }

    public static short getDriverCharSetIdFromNLS_LANG() throws SQLException {
        short driverCharSetId;
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary();
        }
        if ((driverCharSetId = T2CConnection.t2cGetDriverCharSetFromNlsLang()) < 0) {
            throw (SQLException)DatabaseError.createSqlException(null, 8).fillInStackTrace();
        }
        return driverCharSetId;
    }

    @Override
    void doProxySession(int type, @Blind(value=PropertiesBlinder.class) Properties prop) throws SQLException {
        String[] strRoles;
        byte[] editionNameBytes;
        byte[][] roles = null;
        int numProxyRoles = 0;
        this.savedUser = this.userName;
        this.userName = null;
        byte[] cfBytes = editionNameBytes = new byte[0];
        byte[] dnBytes = editionNameBytes;
        byte[] pwdBytes = editionNameBytes;
        byte[] userBytes = editionNameBytes;
        switch (type) {
            case 1: {
                this.userName = prop.getProperty("PROXY_USER_NAME");
                String pwd = prop.getProperty("PROXY_USER_PASSWORD");
                if (this.userName != null) {
                    userBytes = DBConversion.stringToDriverCharBytes(this.userName, this.m_clientCharacterSet);
                }
                if (pwd == null) break;
                pwdBytes = DBConversion.stringToDriverCharBytes(pwd, this.m_clientCharacterSet);
                break;
            }
            case 2: {
                String distName = prop.getProperty("PROXY_DISTINGUISHED_NAME");
                if (distName == null) break;
                dnBytes = DBConversion.stringToDriverCharBytes(distName, this.m_clientCharacterSet);
                break;
            }
            case 3: {
                Object certif = prop.get("PROXY_CERTIFICATE");
                cfBytes = (byte[])certif;
            }
        }
        if (this.editionName != null) {
            editionNameBytes = DBConversion.stringToDriverCharBytes(this.editionName, this.m_clientCharacterSet);
        }
        if ((strRoles = (String[])prop.get("PROXY_ROLES")) != null) {
            numProxyRoles = strRoles.length;
            roles = new byte[numProxyRoles][];
            for (int i = 0; i < numProxyRoles; ++i) {
                if (strRoles[i] == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 150).fillInStackTrace();
                }
                roles[i] = DBConversion.stringToDriverCharBytes(strRoles[i], this.m_clientCharacterSet);
            }
        }
        this.currentSchema = null;
        this.sqlWarning = this.checkError(this.t2cDoProxySession(this.m_nativeState, type, userBytes, userBytes.length, pwdBytes, pwdBytes.length, dnBytes, dnBytes.length, cfBytes, cfBytes.length, editionNameBytes, editionNameBytes.length, numProxyRoles, roles), this.sqlWarning);
        this.isProxy = true;
    }

    @Override
    void closeProxySession() throws SQLException {
        this.checkError(this.t2cCloseProxySession(this.m_nativeState));
        this.currentSchema = null;
        this.userName = this.savedUser;
    }

    @Override
    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        int numColumns;
        boolean tryAgain;
        String tableName = info.getTableName();
        byte[] bytesTableName = DBConversion.stringToDriverCharBytes(tableName, this.m_clientCharacterSet);
        do {
            tryAgain = false;
            numColumns = T2CConnection.t2cDescribeTable(this.m_nativeState, bytesTableName, bytesTableName.length, this.queryMetaData1, this.queryMetaData2, this.queryMetaData1Offset, this.queryMetaData2Offset, this.queryMetaData1Size, this.queryMetaData2Size);
            if (numColumns == -1) {
                this.checkError(numColumns);
            }
            if (numColumns != T2CStatement.T2C_EXTEND_BUFFER) continue;
            tryAgain = true;
            this.reallocateQueryMetaData(this.queryMetaData1Size * 2, this.queryMetaData2Size * 2);
        } while (tryAgain);
        this.processDescribeTableData(numColumns, info);
    }

    private void processDescribeTableData(int numColumns, AutoKeyInfo info) throws SQLException {
        short[] s = this.queryMetaData1;
        byte[] c = this.queryMetaData2;
        int currentShort = this.queryMetaData1Offset;
        int currentChar = this.queryMetaData2Offset;
        info.allocateSpaceForDescribedData(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            short type = s[currentShort + 0];
            short columnNameLen = s[currentShort + 6];
            String columnName = T2CConnection.bytes2String(c, currentChar, columnNameLen, this.conversion);
            short maxLength = s[currentShort + 1];
            short maxCharLength = s[currentShort + 11];
            boolean nullable = s[currentShort + 2] != 0;
            short formOfUse = s[currentShort + 5];
            short precision = s[currentShort + 3];
            short scale = s[currentShort + 4];
            short typeNameLen = s[currentShort + 13];
            boolean columnInvisible = s[currentShort + 14] != 0;
            boolean columnJSON = s[currentShort + 15] != 0;
            currentChar += columnNameLen;
            currentShort += 16;
            String typeName = null;
            if (typeNameLen > 0) {
                typeName = T2CConnection.bytes2String(c, currentChar, typeNameLen, this.conversion);
                currentChar += typeNameLen;
            }
            String domainName = null;
            String domainSchema = null;
            Map<String, String> annotations = null;
            info.fillDescribedData(i, columnName, type, maxCharLength > 0 ? maxCharLength : maxLength, nullable, formOfUse, precision, scale, typeName, domainName, domainSchema, annotations);
        }
    }

    @Override
    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        if (this.m_nativeState != 0L) {
            this.checkError(this.t2cSetApplicationContext(this.m_nativeState, nameSpace, attribute, value));
        }
    }

    @Override
    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        if (this.m_nativeState != 0L) {
            this.checkError(this.t2cClearAllApplicationContext(this.m_nativeState, nameSpace));
        }
    }

    @Override
    void doStartup(int mode) throws SQLException {
        this.checkError(this.t2cStartupDatabase(this.m_nativeState, mode, null));
    }

    @Override
    void doStartup(int mode, String pfileName) throws SQLException {
        this.checkError(this.t2cStartupDatabase(this.m_nativeState, mode, pfileName));
    }

    @Override
    void doShutdown(int mode) throws SQLException {
        this.checkError(this.t2cShutdownDatabase(this.m_nativeState, mode));
    }

    private static final void loadNativeLibrary() throws SQLException {
        if (!isLibraryLoaded) {
            try (Monitor.CloseableLock lock = LOAD_LIBRARY_MONITOR.acquireCloseableLock();){
                if (!isLibraryLoaded) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            System.loadLibrary(T2CConnection.OCILIBRARY);
                            int libraryVersion = T2CConnection.getLibraryVersionNumber();
                            if ((long)libraryVersion != JDBC_OCI_LIBRARY_VERSION) {
                                throw new Error("Incompatible version of libocijdbc[Jdbc:" + JDBC_OCI_LIBRARY_VERSION + ", Jdbc-OCI:" + libraryVersion);
                            }
                            return null;
                        }
                    });
                    isLibraryLoaded = true;
                }
            }
        }
    }

    private final void checkTrue(boolean assertion, int errCode) throws SQLException {
        if (!assertion) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), errCode).fillInStackTrace();
        }
    }

    @Override
    boolean useLittleEndianSetCHARBinder() throws SQLException {
        return this.t2cPlatformIsLittleEndian(this.m_nativeState);
    }

    @Override
    public void getPropertyForPooledConnection(OraclePooledConnection pc) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            super.getPropertyForPooledConnection(pc, this.password.get());
        }
    }

    static final char[] getCharArray(String s) {
        char[] r = null;
        if (s == null) {
            r = new char[]{};
        } else {
            r = new char[s.length()];
            s.getChars(0, s.length(), r, 0);
        }
        return r;
    }

    static String bytes2String(byte[] bytes, int offset, int size, DBConversion conversion) throws SQLException {
        byte[] tmp = new byte[size];
        System.arraycopy(bytes, offset, tmp, 0, size);
        return conversion.CharBytesToString(tmp, size);
    }

    void disableNio() {
        this.useNio = false;
    }

    @Override
    public boolean isConnectionBigTZTC() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.checkTrue(this.getLifecycle() == 1, 8);
            boolean bl = this.t2cIsServerBigTZTC(this.m_nativeState);
            return bl;
        }
    }

    private static void doSetSessionTimeZone(String defaultTimeZone) throws SQLException {
        try (Monitor.CloseableLock lock = SET_TIMEZONE_MONITOR.acquireCloseableLock();){
            T2CConnection.t2cSetSessionTimeZone(defaultTimeZone);
        }
    }

    @Override
    public void incrementTempLobReferenceCount(byte[] locator) throws SQLException {
    }

    @Override
    public int decrementTempLobReferenceCount(byte[] locator) throws SQLException {
        return 0;
    }

    @Override
    void releaseConnectionToPool() throws SQLException {
        if (!this.drcpEnabled || this.drcpState == OracleConnection.DRCPState.DETACHED) {
            return;
        }
        this.drcpState = OracleConnection.DRCPState.DETACHED;
        this.closeStatements(false);
        this.purgeStatementCache();
        int mode = 0;
        byte[] l_drcpTagName = EMPTY_BYTES;
        if (this.drcpTagName != null) {
            this.tagMatched[0] = false;
            l_drcpTagName = DBConversion.stringToDriverCharBytes(this.drcpTagName, this.m_clientCharacterSet);
            mode = 2;
        } else {
            this.tagMatched[0] = true;
        }
        this.checkError(this.t2cCloseDrcpConnection(this.m_nativeState, l_drcpTagName, l_drcpTagName.length, mode), this.sqlWarning);
    }

    @Override
    boolean reusePooledConnection() throws SQLException {
        if (this.drcpState == OracleConnection.DRCPState.DETACHED) {
            this.drcpState = OracleConnection.DRCPState.ATTACHED_EXPLICIT;
            byte[] l_drcpTagName = EMPTY_BYTES;
            if (this.drcpTagName != null) {
                l_drcpTagName = DBConversion.stringToDriverCharBytes(this.drcpTagName, this.m_clientCharacterSet);
            }
            this.checkError(this.t2cOpenDrcpConnection(this.m_nativeState, l_drcpTagName, l_drcpTagName.length, this.tagMatched, this.ociExternalAuthentication), this.sqlWarning);
            this.resetAfterReusePooledConnection();
        }
        return this.tagMatched[0];
    }

    @Override
    public boolean needToPurgeStatementCache() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            if (!this.drcpEnabled) {
                boolean bl = true;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.requireOpenConnection();
            byte[] bCurrentSchema = new byte[258];
            if (this.currentSchema == null && this.getVersionNumber() < 11100) {
                String tmpSchemaName = super.getCurrentSchema();
            } else {
                String tmpSchemaName;
                int bCurrentSchemaLen = this.t2cGetSchemaName(this.m_nativeState, bCurrentSchema);
                this.checkError(bCurrentSchemaLen);
                if (bCurrentSchemaLen > 0) {
                    tmpSchemaName = this.conversion.CharBytesToString(bCurrentSchema, bCurrentSchemaLen);
                } else {
                    tmpSchemaName = super.getCurrentSchema();
                    if (tmpSchemaName == null || tmpSchemaName.length() == 0) {
                        tmpSchemaName = this.userName;
                    }
                }
                this.currentSchema = tmpSchemaName;
            }
            String string = this.currentSchema;
            return string;
        }
    }

    @Override
    String getAuditBanner() throws SQLException {
        this.requireOpenConnection();
        String tmpAuditBanner = null;
        if (this.getVersionNumber() >= 11100) {
            T2CBanner auditBanner = new T2CBanner(this.conversion);
            this.checkError(this.t2cGetAuditBanner(this.m_nativeState, auditBanner));
            tmpAuditBanner = auditBanner.getBanner();
        }
        return tmpAuditBanner;
    }

    @Override
    String getAccessBanner() throws SQLException {
        this.requireOpenConnection();
        String tmpAccessBanner = null;
        if (this.getVersionNumber() >= 11100) {
            T2CBanner accessBanner = new T2CBanner(this.conversion);
            this.checkError(this.t2cGetAccessBanner(this.m_nativeState, accessBanner));
            tmpAccessBanner = accessBanner.getBanner();
        }
        return tmpAccessBanner;
    }

    static native int getLibraryVersionNumber();

    static native short t2cGetServerSessionInfo(long var0, Properties var2);

    static native short t2cGetDriverCharSetFromNlsLang();

    native int t2cDescribeError(long var1, T2CError var3, byte[] var4, long var5);

    native boolean t2cIsServerStatusValid(long var1);

    native boolean t2cIsServerBigTZTC(long var1);

    native int t2cCreateState(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, byte[] var13, int var14, boolean var15, byte[] var16, int var17, int var18, byte[] var19, int var20, short var21, int var22, byte[] var23, byte[] var24, byte[] var25, long[] var26);

    native int t2cLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, byte[] var13, int var14, byte[] var15, int var16, boolean var17, byte[] var18, int var19, int var20, byte[] var21, int var22, int var23, byte[] var24, byte[] var25, byte[] var26, long[] var27);

    private native int t2cLogoff(long var1);

    private native int t2cCancel(long var1);

    private native byte t2cGetAsmVolProperty(long var1);

    private native byte t2cGetInstanceType(long var1);

    private native int t2cCreateStatement(long var1, long var3, byte[] var5, int var6, OracleStatement var7, boolean var8, int var9);

    private native int t2cSetAutoCommit(long var1, boolean var3);

    private native int t2cCommit(long var1, int var3);

    private native int t2cRollback(long var1);

    private native int t2cPingDatabase(long var1);

    private native byte[] t2cGetProductionVersion(long var1, long[] var3);

    private native int t2cGetVersionNumber(long var1);

    private native int t2cGetDefaultStreamChunkSize(long var1);

    native int t2cGetFormOfUse(long var1, OracleTypeCLOB var3, byte[] var4, int var5, int var6);

    native long t2cGetTDO(long var1, byte[] var3, int var4, int[] var5);

    native int t2cCreateConnPool(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, short var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    native int t2cConnPoolLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, byte[] var11, int var12, int var13, int var14, int var15, String[] var16, byte[] var17, int var18, byte[] var19, int var20, byte[] var21, int var22, byte[] var23, int var24, byte[] var25, int var26, byte[] var27, byte[] var28, long[] var29);

    native int t2cGetConnPoolInfo(long var1, Properties var3);

    native int t2cSetConnPoolInfo(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    native int t2cPasswordChange(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    protected native byte[] t2cGetConnectionId(long var1);

    native int t2cGetNetConnectionId(long var1, byte[] var3, int var4, int[] var5);

    native int t2cGetHandles(long var1, long[] var3);

    native int t2cUseConnection(long var1, long var3, long var5, long var7, byte[] var9, long[] var10);

    native boolean t2cPlatformIsLittleEndian(long var1);

    native int t2cRegisterTAFCallback(long var1);

    native int t2cGetHeapAllocSize(long var1);

    native int t2cGetOciEnvHeapAllocSize(long var1);

    native int t2cDoProxySession(long var1, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, byte[] var10, int var11, byte[] var12, int var13, int var14, byte[][] var15);

    native int t2cCloseProxySession(long var1);

    static native int t2cDescribeTable(long var0, byte[] var2, int var3, short[] var4, byte[] var5, int var6, int var7, int var8, int var9);

    native int t2cSetApplicationContext(long var1, String var3, String var4, String var5);

    native int t2cClearAllApplicationContext(long var1, String var3);

    native int t2cStartupDatabase(long var1, int var3, String var4);

    native int t2cShutdownDatabase(long var1, int var3);

    static native void t2cSetSessionTimeZone(String var0);

    native int t2cCloseDrcpConnection(long var1, byte[] var3, int var4, int var5);

    native int t2cOpenDrcpConnection(long var1, byte[] var3, int var4, boolean[] var5, boolean var6);

    native int t2cSetCachedServerVersion(long var1, short var3);

    native int t2cGetImplicitResultSetStatement(long var1, long var3, OracleStatement var5);

    native int t2cGetSchemaName(long var1, byte[] var3);

    native int t2cGetAccessBanner(long var1, T2CBanner var3);

    native int t2cGetAuditBanner(long var1, T2CBanner var3);

    native int t2cGetMajorVersionNumber(long var1);

    native int t2cGetMinorVersionNumber(long var1);

    static {
        LOAD_LIBRARY_MONITOR = Monitor.newInstance();
        SET_TIMEZONE_MONITOR = Monitor.newInstance();
        cachedVersionTable = new Hashtable<String, String>();
    }
}

