/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.jdbc.driver.cli.Argument;
import oracle.jdbc.driver.cli.Command;
import oracle.jdbc.driver.cli.CommandContext;
import oracle.jdbc.driver.cli.OptionParser;

public class CliParser {
    public CommandContext parse(Command command, String[] args) throws Exception {
        HashMap<String, List<String>> parsedOptions = new HashMap<String, List<String>>();
        ArrayList<String> parsedArguments = new ArrayList<String>();
        try {
            this.processArguments(command, args, parsedOptions, parsedArguments);
            CommandContext context = new CommandContext(parsedOptions, parsedArguments);
            return context;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    private void processArguments(Command command, String[] args, Map<String, List<String>> parsedOptions, List<String> parsedArguments) throws Exception {
        int i;
        int currentArgumentIndex = 0;
        int n = i = command.getName().equals("") ? 0 : 1;
        while (i < args.length) {
            String arg = args[i].trim();
            if (arg.startsWith("--")) {
                boolean hasValue = OptionParser.parseLongOption(arg.substring(2), command, parsedOptions, args, i);
                if (hasValue) {
                    ++i;
                }
            } else if (arg.startsWith("-")) {
                boolean hasValue = OptionParser.parseShortOption(arg.substring(1), command, parsedOptions, args, i);
                if (hasValue) {
                    ++i;
                }
            } else {
                List<Argument> expectedArguments = command.getExpectedArguments();
                if (currentArgumentIndex < expectedArguments.size()) {
                    parsedArguments.add(arg);
                    ++currentArgumentIndex;
                } else {
                    throw new Exception("Unexpected argument: " + arg);
                }
            }
            ++i;
        }
    }
}

