/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.jdbc.driver.cli.Command;
import oracle.jdbc.driver.cli.Option;
import oracle.jdbc.driver.cli.ValuedOption;

class OptionParser {
    OptionParser() {
    }

    public static boolean parseLongOption(String arg, Command command, Map<String, List<String>> parsedOptions, String[] args, int i) throws Exception {
        Option option = OptionParser.findOptionByLongName(command, arg);
        if (option != null) {
            if (option instanceof ValuedOption) {
                return OptionParser.handleValuedOption((ValuedOption)option, parsedOptions, args, i);
            }
            parsedOptions.put(option.getLongName(), new ArrayList());
            return false;
        }
        throw new Exception("Unknown option: --" + arg);
    }

    public static boolean parseShortOption(String arg, Command command, Map<String, List<String>> parsedOptions, String[] args, int i) throws Exception {
        for (int j = 0; j < arg.length(); ++j) {
            String shortOption = String.valueOf(arg.charAt(j));
            Option option = OptionParser.findOptionByShortName(command, shortOption);
            if (option != null) {
                if (option instanceof ValuedOption && arg.length() == 1) {
                    return OptionParser.handleValuedOption((ValuedOption)option, parsedOptions, args, i);
                }
            } else {
                throw new Exception("Unknown short option: -" + shortOption);
            }
            parsedOptions.put(option.getLongName(), new ArrayList());
        }
        return false;
    }

    private static Option findOptionByLongName(Command command, String longName) {
        return command.getExpectedOptions().stream().filter(o -> o.getLongName() != null && o.getLongName().equals(longName)).findFirst().orElse(null);
    }

    private static Option findOptionByShortName(Command command, String shortName) {
        return command.getExpectedOptions().stream().filter(o -> o.getShortName() != null && o.getShortName().equals(shortName)).findFirst().orElse(null);
    }

    private static boolean handleValuedOption(ValuedOption option, Map<String, List<String>> parsedOptions, String[] args, int i) throws Exception {
        if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
            String value = args[++i];
            parsedOptions.computeIfAbsent(option.getLongName(), k -> new ArrayList()).add(value);
            return true;
        }
        throw new Exception("Option --" + option.getLongName() + " requires a value.");
    }
}

