/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.utils;

import java.util.function.Supplier;
import oracle.jdbc.driver.utils.CheckedExceptionHandler;

@FunctionalInterface
public interface ThrowingSupplier<T, E extends Throwable>
extends Supplier<T> {
    public T getOrThrow() throws E;

    @Override
    default public T get() {
        try {
            return this.getOrThrow();
        }
        catch (Throwable throwable) {
            throw CheckedExceptionHandler.toRuntimeException(throwable);
        }
    }
}

