/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.config;

import edu.internet2.middleware.grouperClient.config.ConfigPropertiesCascadeUtils;
import edu.internet2.middleware.grouperClient.config.db.ConfigDatabaseLogic;
import edu.internet2.middleware.grouperClient.util.GrouperClientLog;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ConfigPropertiesCascadeBase {
    private static final String EL_CONFIG_SUFFIX = ".elConfig";
    private static final Log LOG = LogFactory.getLog(ConfigPropertiesCascadeBase.class);
    private static Map<Class<? extends ConfigPropertiesCascadeBase>, ConfigPropertiesCascadeBase> configSingletonFromClass = null;
    private static ThreadLocal<Map<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>>> propertiesThreadLocalOverrideMap = null;
    private static Map<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>> propertiesOverrideMap = null;
    private Properties properties = new Properties();
    private long createdTime = System.currentTimeMillis();
    private long lastCheckedTime = System.currentTimeMillis();
    private Integer timeToCheckConfigSeconds = null;
    private static Map<Class<? extends ConfigPropertiesCascadeBase>, ConfigPropertiesCascadeBase> configFileCache = null;
    private static ThreadLocal<Boolean> inDatabaseConfig = new InheritableThreadLocal<Boolean>();
    private static String encoding = null;
    private List<ConfigFile> configFiles = null;
    private static Pattern substitutePattern = Pattern.compile("\\$\\$([^\\s\\$]+?)\\$\\$");
    private static Set<String> whitelistConfigVariables = GrouperClientUtils.toSet("newline", "subjectName", "reportConfigName", "reportLink");

    public static void assignInitted() {
        configSingletonFromClass = null;
        configFileCache = null;
        ConfigPropertiesCascadeBase.clearCache();
    }

    protected Properties internalProperties() {
        return this.properties;
    }

    protected static <T extends ConfigPropertiesCascadeBase> T retrieveConfig(Class<T> configClass) {
        ConfigPropertiesCascadeBase configPropertiesCascadeBase;
        if (configSingletonFromClass == null) {
            configSingletonFromClass = new HashMap<Class<? extends ConfigPropertiesCascadeBase>, ConfigPropertiesCascadeBase>();
        }
        if ((configPropertiesCascadeBase = configSingletonFromClass.get(configClass)) == null) {
            configPropertiesCascadeBase = (ConfigPropertiesCascadeBase)ConfigPropertiesCascadeUtils.newInstance(configClass, true);
            configSingletonFromClass.put(configClass, configPropertiesCascadeBase);
        }
        return (T)configPropertiesCascadeBase.retrieveFromConfigFileOrCache();
    }

    protected Class<?> getClassInSiblingJar() {
        return null;
    }

    protected abstract String getSecondsToCheckConfigKey();

    public static void clearCache() {
        ConfigPropertiesCascadeBase.clearCacheThisOnly();
        ConfigDatabaseLogic.clearCache();
    }

    public static void clearCacheThisOnly() {
        if (configFileCache != null) {
            configFileCache.clear();
        }
    }

    public abstract void clearCachedCalculatedValues();

    public Map<String, String> propertiesThreadLocalOverrideMap() {
        Map<String, String> propertiesOverrideMapLocal;
        Map<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>> overrideMap;
        if (propertiesThreadLocalOverrideMap == null) {
            propertiesThreadLocalOverrideMap = new ThreadLocal();
        }
        if ((overrideMap = propertiesThreadLocalOverrideMap.get()) == null) {
            overrideMap = new HashMap<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>>();
            propertiesThreadLocalOverrideMap.set(overrideMap);
        }
        if ((propertiesOverrideMapLocal = overrideMap.get(this.getClass())) == null) {
            propertiesOverrideMapLocal = new HashMap<String, String>();
            overrideMap.put(this.getClass(), propertiesOverrideMapLocal);
        }
        return propertiesOverrideMapLocal;
    }

    public Set<String> propertyNames() {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.addAll(this.propertiesHelper(false).keySet());
        return result;
    }

    public Map<String, String> propertiesOverrideMap() {
        Map<String, String> overrideMap;
        if (propertiesOverrideMap == null) {
            propertiesOverrideMap = new LinkedHashMap<Class<? extends ConfigPropertiesCascadeBase>, Map<String, String>>();
        }
        if ((overrideMap = propertiesOverrideMap.get(this.getClass())) == null) {
            overrideMap = new LinkedHashMap<String, String>();
            propertiesOverrideMap.put(this.getClass(), overrideMap);
        }
        return overrideMap;
    }

    public Properties properties() {
        return this.propertiesHelper(true);
    }

    private static void assignProperty(Properties properties, String propertyName, String propertyValue) {
        if (propertyName == null) {
            return;
        }
        if (propertyName.endsWith(EL_CONFIG_SUFFIX)) {
            properties.remove(GrouperClientUtils.stripEnd(propertyName, EL_CONFIG_SUFFIX));
        } else {
            properties.remove(propertyName + EL_CONFIG_SUFFIX);
        }
        properties.put(propertyName, propertyValue);
    }

    protected Properties propertiesHelper(boolean setValues) {
        String value;
        Properties tempResult = new Properties();
        tempResult.putAll((Map<?, ?>)this.properties);
        Map<String, String> localPropertiesOverrideMap = this.propertiesOverrideMap();
        for (String key : localPropertiesOverrideMap.keySet()) {
            ConfigPropertiesCascadeBase.assignProperty(tempResult, key, ConfigPropertiesCascadeUtils.defaultString(localPropertiesOverrideMap.get(key)));
        }
        localPropertiesOverrideMap = this.propertiesThreadLocalOverrideMap();
        for (String key : localPropertiesOverrideMap.keySet()) {
            ConfigPropertiesCascadeBase.assignProperty(tempResult, key, ConfigPropertiesCascadeUtils.defaultString(localPropertiesOverrideMap.get(key)));
        }
        Properties result = new Properties();
        for (String string : tempResult.keySet()) {
            String string2 = value = setValues ? tempResult.getProperty(string) : "";
            if (string.endsWith(EL_CONFIG_SUFFIX)) continue;
            result.put(string, ConfigPropertiesCascadeUtils.defaultString(value));
        }
        for (String string : tempResult.keySet()) {
            String string3 = value = setValues ? tempResult.getProperty(string) : "";
            if (!string.endsWith(EL_CONFIG_SUFFIX)) continue;
            if (setValues) {
                value = ConfigPropertiesCascadeUtils.substituteExpressionLanguage(value, null, true, true, true, false);
            }
            String string4 = string.substring(0, string.length() - EL_CONFIG_SUFFIX.length());
            result.put(string4, ConfigPropertiesCascadeUtils.defaultString(value));
        }
        this.substituteLocalReferences(result);
        return result;
    }

    protected void substituteLocalReferences(Properties result) {
        for (Object e : new LinkedHashSet<Object>(result.keySet())) {
            String newValue;
            String value = result.getProperty((String)e);
            if (GrouperClientUtils.equals(value, newValue = this.substituteLocalReferencesOneField(result, value))) continue;
            result.put(e, newValue);
        }
    }

    public String propertyValueStringRequired(String key) {
        return this.propertyValueString(key, null, true).getTheValue();
    }

    public String propertyValueString(String key, String defaultValue) {
        return this.propertyValueString(key, defaultValue, false).getTheValue();
    }

    public String propertyValueString(String key) {
        return this.propertyValueString(key, null, false).getTheValue();
    }

    protected PropertyValueResult propertyValueString(String key, String defaultValue, boolean required) {
        if (key.endsWith(EL_CONFIG_SUFFIX)) {
            throw new RuntimeException("Why does key end in suffix??? .elConfig, " + key);
        }
        return this.propertyValueStringHelper(key, defaultValue, required);
    }

    protected PropertyValueResult propertyValueStringHelper(String key, String defaultValue, boolean required) {
        String value;
        PropertyValueResult elPropertyValueResult;
        if (!key.endsWith(EL_CONFIG_SUFFIX) && (elPropertyValueResult = this.propertyValueStringHelper(key + EL_CONFIG_SUFFIX, null, false)).isHasKey()) {
            String result = ConfigPropertiesCascadeUtils.substituteExpressionLanguage(elPropertyValueResult.getTheValue(), null, true, true, true, false);
            PropertyValueResult propertyValueResult = new PropertyValueResult(result, true);
            return propertyValueResult;
        }
        boolean hasKey = false;
        Map<String, String> overrideMap = this.propertiesThreadLocalOverrideMap();
        hasKey = overrideMap == null ? false : overrideMap.containsKey(key);
        String string = value = hasKey ? overrideMap.get(key) : null;
        if (!hasKey) {
            overrideMap = this.propertiesOverrideMap();
            hasKey = overrideMap == null ? null : Boolean.valueOf(overrideMap.containsKey(key));
            String string2 = value = hasKey ? overrideMap.get(key) : null;
        }
        if (!hasKey) {
            hasKey = this.properties.containsKey(key);
            String string3 = value = hasKey ? this.properties.getProperty(key) : null;
        }
        if (!required && !hasKey) {
            return new PropertyValueResult(defaultValue, false);
        }
        if (required && !hasKey) {
            String error = "Cant find property: " + key + " in properties file: " + this.getMainConfigClasspath() + ", it is required";
            throw new RuntimeException(error);
        }
        value = ConfigPropertiesCascadeUtils.trim(value);
        value = ConfigPropertiesCascadeBase.substituteCommonVars(value);
        value = this.substituteLocalReferencesOneField(this, value);
        if (!required && ConfigPropertiesCascadeUtils.isBlank(value)) {
            return new PropertyValueResult(null, true);
        }
        if (required && ConfigPropertiesCascadeUtils.isBlank(value)) {
            String error = "Property " + key + " in properties file: " + this.getMainConfigClasspath() + ", has a blank value, it is required";
            throw new RuntimeException(error);
        }
        return new PropertyValueResult(value, true);
    }

    protected static String substituteCommonVars(String string) {
        if (string == null) {
            return string;
        }
        if (string.indexOf(36) < 0) {
            return string;
        }
        string = ConfigPropertiesCascadeUtils.replace(string, "$space$", " ");
        string = ConfigPropertiesCascadeUtils.replace(string, "$newline$", "\n");
        return string;
    }

    long getCreatedTime() {
        return this.createdTime;
    }

    long getLastCheckedTime() {
        return this.lastCheckedTime;
    }

    protected Integer getTimeToCheckConfigSeconds() {
        return this.timeToCheckConfigSeconds;
    }

    public static boolean isInDatabase() {
        Boolean isInDatabase = inDatabaseConfig.get();
        return isInDatabase != null && isInDatabase != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String encoding() {
        if (encoding != null) return encoding;
        Class<ConfigPropertiesCascadeBase> clazz = ConfigPropertiesCascadeBase.class;
        synchronized (ConfigPropertiesCascadeBase.class) {
            if (encoding != null) return encoding;
            String configEncodingKey = "grouperClient.config.encoding";
            try {
                Properties properties = ConfigPropertiesCascadeBase.propertiesFromResourceName("grouper.client.properties", false, ConfigPropertiesCascadeBase.class);
                if (properties != null && properties.contains(configEncodingKey)) {
                    encoding = properties.getProperty(configEncodingKey);
                } else {
                    properties = ConfigPropertiesCascadeBase.propertiesFromResourceName("grouper.client.base.properties", false, ConfigPropertiesCascadeBase.class);
                    if (properties != null && properties.contains(configEncodingKey)) {
                        encoding = properties.getProperty(configEncodingKey);
                    }
                }
            }
            catch (RuntimeException e) {
                LOG.error("Trouble finding " + configEncodingKey, e);
            }
            if (!GrouperClientUtils.isBlank(encoding)) return encoding;
            encoding = "UTF-8";
            // ** MonitorExit[var0] (shouldn't be in output)
            return encoding;
        }
    }

    protected ConfigPropertiesCascadeBase retrieveFromConfigFiles() {
        return this.retrieveFromConfigFiles(true);
    }

    public ConfigPropertiesCascadeBase retrieveFromConfigFiles(boolean includeBaseConfig) {
        Properties mainExampleConfigFile;
        Properties mainConfigFile = ConfigPropertiesCascadeBase.propertiesFromResourceName(this.getMainConfigClasspath(), false, this.getClassInSiblingJar());
        String secondsToCheckConfigString = null;
        String overrideFullConfig = null;
        if (mainConfigFile != null) {
            overrideFullConfig = mainConfigFile.getProperty(this.getHierarchyConfigKey());
            secondsToCheckConfigString = mainConfigFile.getProperty(this.getSecondsToCheckConfigKey());
        }
        if ((ConfigPropertiesCascadeUtils.isBlank(overrideFullConfig) || ConfigPropertiesCascadeUtils.isBlank(secondsToCheckConfigString)) && (mainExampleConfigFile = ConfigPropertiesCascadeBase.propertiesFromResourceName(this.getMainExampleConfigClasspath(), false, this.getClassInSiblingJar())) != null) {
            if (ConfigPropertiesCascadeUtils.isBlank(overrideFullConfig)) {
                overrideFullConfig = mainExampleConfigFile.getProperty(this.getHierarchyConfigKey());
            }
            if (ConfigPropertiesCascadeUtils.isBlank(secondsToCheckConfigString)) {
                secondsToCheckConfigString = mainExampleConfigFile.getProperty(this.getSecondsToCheckConfigKey());
            }
        }
        if (ConfigPropertiesCascadeUtils.isBlank(overrideFullConfig)) {
            throw new RuntimeException("Cant find the hierarchy config key: " + this.getHierarchyConfigKey() + " in config files: " + this.getMainConfigClasspath() + " or " + this.getMainExampleConfigClasspath());
        }
        if (ConfigPropertiesCascadeUtils.isBlank(secondsToCheckConfigString)) {
            throw new RuntimeException("Cant find the seconds to check config key: " + this.getSecondsToCheckConfigKey() + " in config files: " + this.getMainConfigClasspath() + " or " + this.getMainExampleConfigClasspath());
        }
        ConfigPropertiesCascadeBase result = (ConfigPropertiesCascadeBase)ConfigPropertiesCascadeUtils.newInstance(this.getClass(), true);
        try {
            result.timeToCheckConfigSeconds = ConfigPropertiesCascadeUtils.intValue(secondsToCheckConfigString);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid integer seconds to check config config value: " + secondsToCheckConfigString + ", key: " + this.getSecondsToCheckConfigKey() + " in config files: " + this.getMainConfigClasspath() + " or " + this.getMainExampleConfigClasspath());
        }
        List<String> overrideConfigStringList = ConfigPropertiesCascadeUtils.splitTrimToList(overrideFullConfig, ",");
        result.configFiles = new ArrayList<ConfigFile>();
        boolean isFirst = true;
        for (String overrideConfigString : overrideConfigStringList) {
            String resource;
            Object url;
            if (!includeBaseConfig && isFirst && overrideConfigString.toLowerCase().contains("base")) {
                isFirst = false;
                continue;
            }
            isFirst = false;
            ConfigFile configFile = new ConfigFile(overrideConfigString);
            result.configFiles.add(configFile);
            boolean replaceWithBlank = false;
            if (configFile.getConfigFileType() == ConfigFileType.CLASSPATH && (GrouperClientUtils.equals(overrideConfigString, "classpath:grouper.properties") || GrouperClientUtils.equals(overrideConfigString, "classpath:grouper-loader.properties") || GrouperClientUtils.equals(overrideConfigString, "classpath:grouper-ui.properties") || GrouperClientUtils.equals(overrideConfigString, "classpath:grouper-ws.properties") || GrouperClientUtils.equals(overrideConfigString, "classpath:grouper.cache.properties") || GrouperClientUtils.equals(overrideConfigString, "classpath:subject.properties") || GrouperClientUtils.equals(overrideConfigString, "classpath:grouperText/grouper.text.en.us.properties") || GrouperClientUtils.equals(overrideConfigString, "classpath:grouperText/grouper.text.fr.fr.properties")) && (url = GrouperClientUtils.computeUrl(resource = GrouperClientUtils.stripPrefix(overrideConfigString, "classpath:"), true)) == null) {
                replaceWithBlank = true;
            }
            String configFileContents = replaceWithBlank ? "" : configFile.retrieveContents(this);
            configFile.setContents(configFileContents);
            try {
                configFile.setProperties(new Properties());
                configFile.getProperties().load(new StringReader(configFileContents));
                url = configFile.getProperties().keySet().iterator();
                while (url.hasNext()) {
                    Object key = url.next();
                    String keyString = (String)key;
                    ConfigPropertiesCascadeBase.assignProperty(result.properties, keyString, configFile.getProperties().getProperty(keyString));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Problem loading properties: " + overrideConfigString, e);
            }
        }
        return result;
    }

    public List<ConfigFile> internalRetrieveConfigFiles() {
        return this.configFiles;
    }

    protected static void logInfo(String logMessage, Throwable t) {
        if (LOG != null && LOG.isInfoEnabled()) {
            LOG.info(logMessage, t);
        }
    }

    protected static void logError(String logMessage, Throwable t) {
        if (LOG != null) {
            LOG.error(logMessage, t);
        } else {
            System.err.println("ERROR: " + logMessage);
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConfigPropertiesCascadeBase retrieveFromConfigFileOrCache() {
        boolean isDebugEnabled = false;
        if (LOG != null) {
            isDebugEnabled = LOG instanceof GrouperClientLog ? ((GrouperClientLog)LOG).isEnclosedLogDebugEnabled() : LOG.isDebugEnabled();
        }
        LinkedHashMap<String, Object> debugMap = LOG != null && isDebugEnabled ? new LinkedHashMap<String, Object>() : null;
        try {
            ConfigPropertiesCascadeBase configObject;
            if (configFileCache == null) {
                if (LOG != null && isDebugEnabled) {
                    debugMap.put("configFileCache", null);
                }
                configFileCache = new HashMap<Class<? extends ConfigPropertiesCascadeBase>, ConfigPropertiesCascadeBase>();
            }
            if ((configObject = configFileCache.get(this.getClass())) == null) {
                if (LOG != null && isDebugEnabled) {
                    debugMap.put("configObject", null);
                }
                if (LOG != null && isDebugEnabled) {
                    debugMap.put("mainConfigClasspath", this.getMainConfigClasspath());
                }
                configObject = this.retrieveFromConfigFiles();
                configFileCache.put(this.getClass(), configObject);
            } else if (configObject.needToCheckIfFilesNeedReloading()) {
                if (LOG != null && isDebugEnabled) {
                    debugMap.put("needToCheckIfFilesNeedReloading", true);
                }
                GrouperClientUtils.sleep(Math.round(Math.random() * 100.0));
                configObject = configFileCache.get(this.getClass());
                if (configObject.needToCheckIfFilesNeedReloading()) {
                    if (LOG != null && isDebugEnabled) {
                        debugMap.put("needToCheckIfFilesNeedReloading2", true);
                    }
                    if (configObject.filesNeedReloadingBasedOnContents()) {
                        if (LOG != null && isDebugEnabled) {
                            debugMap.put("filesNeedReloadingBasedOnContents", true);
                        }
                        configObject = this.retrieveFromConfigFiles();
                        configFileCache.put(this.getClass(), configObject);
                    }
                }
            }
            ConfigPropertiesCascadeBase configPropertiesCascadeBase = configObject;
            return configPropertiesCascadeBase;
        }
        finally {
            if (LOG != null && isDebugEnabled && debugMap.size() > 0) {
                LOG.debug(ConfigPropertiesCascadeUtils.mapToString(debugMap));
            }
        }
    }

    protected boolean needToCheckIfFilesNeedReloading() {
        long lastCheckedTimeLocal = this.getLastCheckedTime();
        int timeToCheckSeconds = this.getTimeToCheckConfigSeconds();
        if (timeToCheckSeconds < 0) {
            return false;
        }
        return System.currentTimeMillis() - lastCheckedTimeLocal > (long)(timeToCheckSeconds * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean filesNeedReloadingBasedOnContents() {
        try {
            for (ConfigFile configFile : this.configFiles) {
                if (ConfigPropertiesCascadeUtils.equals(configFile.getContents(), configFile.retrieveContents(this))) continue;
                ConfigPropertiesCascadeBase.logInfo("Contents changed for config file, reloading: " + configFile.getOriginalConfig(), null);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            ConfigPropertiesCascadeBase.logError("Error checking for changes in configs (will use previous version): " + this.getMainConfigClasspath(), e);
        }
        finally {
            this.lastCheckedTime = System.currentTimeMillis();
        }
        return false;
    }

    public String getMainConfigFileName() {
        String configFileClasspath = this.getMainConfigClasspath();
        if (configFileClasspath.contains("/")) {
            configFileClasspath = GrouperClientUtils.substringAfterLast(configFileClasspath, "/");
        }
        return configFileClasspath;
    }

    protected abstract String getMainConfigClasspath();

    protected abstract String getHierarchyConfigKey();

    protected abstract String getMainExampleConfigClasspath();

    public boolean propertyValueBoolean(String key, boolean defaultValue) {
        return this.propertyValueBoolean(key, defaultValue, false);
    }

    public boolean containsKey(String key) {
        return this.propertyValueString(key, null, false).isHasKey();
    }

    public Boolean propertyValueBoolean(String key) {
        return this.propertyValueBoolean(key, null, false);
    }

    protected Boolean propertyValueBoolean(String key, Boolean defaultValue, boolean required) {
        String value = this.propertyValueString(key, null, false).getTheValue();
        if (ConfigPropertiesCascadeUtils.isBlank(value) && !required) {
            return defaultValue;
        }
        if (ConfigPropertiesCascadeUtils.isBlank(value) && required) {
            throw new RuntimeException("Cant find boolean property " + key + " in properties file: " + this.getMainConfigClasspath() + ", it is required, expecting true or false");
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("t".equalsIgnoreCase(value)) {
            return true;
        }
        if ("f".equalsIgnoreCase(value)) {
            return false;
        }
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value)) {
            return false;
        }
        if ("y".equalsIgnoreCase(value)) {
            return true;
        }
        if ("n".equalsIgnoreCase(value)) {
            return false;
        }
        throw new RuntimeException("Invalid boolean value: '" + value + "' for property: " + key + " in properties file: " + this.getMainConfigClasspath() + ", expecting true or false");
    }

    protected Integer propertyValueInt(String key, Integer defaultValue, boolean required) {
        String value = this.propertyValueString(key, null, false).getTheValue();
        if (ConfigPropertiesCascadeUtils.isBlank(value) && !required) {
            return defaultValue;
        }
        if (ConfigPropertiesCascadeUtils.isBlank(value) && required) {
            throw new RuntimeException("Cant find integer property " + key + " in config file: " + this.getMainConfigClasspath() + ", it is required");
        }
        try {
            return ConfigPropertiesCascadeUtils.intValue(value);
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid integer value: '" + value + "' for property: " + key + " in config file: " + this.getMainConfigClasspath() + " in properties file");
        }
    }

    public boolean propertyValueBooleanRequired(String key) {
        return this.propertyValueBoolean(key, false, true);
    }

    public int propertyValueIntRequired(String key) {
        return this.propertyValueInt(key, -1, true);
    }

    public int propertyValueInt(String key, int defaultValue) {
        return this.propertyValueInt(key, defaultValue, false);
    }

    public Integer propertyValueInt(String key) {
        return this.propertyValueInt(key, null, false);
    }

    protected static Properties propertiesFromResourceName(String resourceName, boolean exceptionIfNotExist) {
        return ConfigPropertiesCascadeBase.propertiesFromResourceName(resourceName, exceptionIfNotExist, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties propertiesFromResourceName(String resourceName, boolean exceptionIfNotExist, Class<?> classInSiblingJar) {
        Properties properties = new Properties();
        URL url = null;
        try {
            url = ConfigPropertiesCascadeUtils.computeUrl(resourceName, true);
        }
        catch (Exception e) {
            ConfigPropertiesCascadeBase.logInfo("Problem loading config file: " + resourceName, e);
        }
        if (url == null) {
            File jarFile = classInSiblingJar == null ? null : ConfigPropertiesCascadeUtils.jarFile(classInSiblingJar);
            File parentDir = jarFile == null ? null : jarFile.getParentFile();
            String fileName = parentDir == null ? null : ConfigPropertiesCascadeUtils.stripLastSlashIfExists(ConfigPropertiesCascadeUtils.fileCanonicalPath(parentDir)) + File.separator + resourceName;
            File configFile = fileName == null ? null : new File(fileName);
            FileInputStream inputStream = null;
            try {
                if (configFile != null && configFile.exists() && configFile.isFile()) {
                    Object theLog;
                    inputStream = new FileInputStream(configFile);
                    properties.load(inputStream);
                    if (LOG != null && LOG.isDebugEnabled() || GrouperClientLog.debugToConsoleByFlag()) {
                        theLog = "Reading resource: " + resourceName + ", from: " + ConfigPropertiesCascadeUtils.fileCanonicalPath(configFile);
                        if (LOG != null && LOG.isDebugEnabled()) {
                            LOG.debug(theLog);
                        }
                        if (GrouperClientLog.debugToConsoleByFlag()) {
                            System.err.println((String)theLog);
                        }
                    }
                    theLog = properties;
                    ConfigPropertiesCascadeUtils.closeQuietly(inputStream);
                    return theLog;
                }
                ConfigPropertiesCascadeUtils.closeQuietly(inputStream);
            }
            catch (Exception e2) {
                if (LOG != null && LOG.isDebugEnabled()) {
                    LOG.debug("Error reading from file for resource: " + resourceName + ", file: " + fileName, e2);
                }
            }
            finally {
                ConfigPropertiesCascadeUtils.closeQuietly(inputStream);
            }
        }
        if (url == null && exceptionIfNotExist) {
            throw new RuntimeException("Problem loading config file: " + resourceName);
        }
        if (url == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            properties.load(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem loading config file: " + resourceName, e);
        }
        finally {
            ConfigPropertiesCascadeUtils.closeQuietly(inputStream);
        }
        return properties;
    }

    public boolean assertPropertyValueRequired(String key) {
        String value = this.propertyValueString(key);
        if (!ConfigPropertiesCascadeUtils.isBlank(value)) {
            return true;
        }
        String error = "Cant find property " + key + " in resource: " + this.getMainConfigClasspath() + ", it is required";
        System.err.println("Grouper error: " + error);
        LOG.error(error);
        return false;
    }

    public boolean assertPropertyValueBoolean(String key, boolean required) {
        if (required && !this.assertPropertyValueRequired(key)) {
            return false;
        }
        String value = this.propertyValueString(key);
        if (!required && ConfigPropertiesCascadeUtils.isBlank(value)) {
            return true;
        }
        try {
            ConfigPropertiesCascadeUtils.booleanValue(value);
            return true;
        }
        catch (Exception exception) {
            String error = "Expecting true or false property " + key + " in resource: " + this.getMainConfigClasspath() + ", but is '" + value + "'";
            System.err.println("Grouper error: " + error);
            LOG.error(error);
            return false;
        }
    }

    public boolean assertPropertyValueClass(String key, Class<?> classType, boolean required) {
        if (required && !this.assertPropertyValueRequired(key)) {
            return false;
        }
        String value = this.propertyValueString(key);
        if (!required && ConfigPropertiesCascadeUtils.isBlank(value)) {
            return true;
        }
        String extraError = "";
        for (String classValue : value.split(",")) {
            try {
                Class theClass = ConfigPropertiesCascadeUtils.forName(classValue.trim());
                if (classType.isAssignableFrom(theClass)) continue;
                extraError = extraError + " does not derive from class: " + classType.getSimpleName();
            }
            catch (Exception e) {
                extraError = ", " + ConfigPropertiesCascadeUtils.getFullStackTrace(e);
            }
        }
        if (extraError.isEmpty()) {
            return true;
        }
        String error = "Cant process property " + key + " in resource: " + this.getMainConfigClasspath() + ", the current value is '" + value + "', which should be of type: " + classType.getName() + extraError;
        System.err.println("Grouper error: " + error);
        LOG.error(error);
        return false;
    }

    public Map<String, String> propertiesMap(Pattern pattern) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String key : this.propertyNames()) {
            if (!pattern.matcher(key).matches()) continue;
            result.put(key, this.propertyValueString(key));
        }
        return result;
    }

    protected String substituteLocalReferencesOneField(Object thePropertiesOrConfigPropertiesCascadeBase, String value) {
        String newValue;
        for (int i = 0; i < 20 && !GrouperClientUtils.equals(value, newValue = this.substituteLocalReferencesOneSubstitution(thePropertiesOrConfigPropertiesCascadeBase, value)); ++i) {
            value = newValue;
        }
        return value;
    }

    protected String substituteLocalReferencesOneSubstitution(Object thePropertiesOrConfigPropertiesCascadeBase, String value) {
        if (GrouperClientUtils.isBlank(value) || !value.contains("$$")) {
            return value;
        }
        Properties theProperties = null;
        ConfigPropertiesCascadeBase configPropertiesCascadeBase = null;
        if (thePropertiesOrConfigPropertiesCascadeBase instanceof Properties) {
            theProperties = (Properties)thePropertiesOrConfigPropertiesCascadeBase;
        } else {
            configPropertiesCascadeBase = (ConfigPropertiesCascadeBase)thePropertiesOrConfigPropertiesCascadeBase;
        }
        Matcher matcher = substitutePattern.matcher(value);
        StringBuilder result = new StringBuilder();
        int index = 0;
        while (matcher.find()) {
            result.append(value.substring(index, matcher.start()));
            String variable = matcher.group(1);
            index = matcher.end();
            boolean hasProperty = false;
            String propertyValue = null;
            if (theProperties != null) {
                hasProperty = theProperties.containsKey(variable);
                if (hasProperty) {
                    propertyValue = theProperties.getProperty(variable);
                }
            } else {
                PropertyValueResult propertyValueResult = configPropertiesCascadeBase.propertyValueString(variable, null, false);
                hasProperty = propertyValueResult.isHasKey();
                if (hasProperty) {
                    propertyValue = propertyValueResult.getTheValue();
                }
            }
            if (!hasProperty) {
                if (!whitelistConfigVariables.contains(variable)) {
                    LOG.debug("Cant find text for variable: '" + variable + "'");
                }
                propertyValue = "$$" + variable + "$$";
            } else {
                propertyValue = GrouperClientUtils.defaultString(propertyValue);
            }
            result.append(propertyValue);
        }
        result.append(value.substring(index, value.length()));
        return result.toString();
    }

    public boolean hasExpressionLanguage(String propertyName) {
        ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>(this.internalRetrieveConfigFiles());
        Collections.reverse(configFiles);
        String elKey = propertyName + EL_CONFIG_SUFFIX;
        Map<String, String> overrideMap = this.propertiesThreadLocalOverrideMap();
        if (overrideMap.containsKey(elKey)) {
            return true;
        }
        overrideMap = this.propertiesOverrideMap();
        if (overrideMap.containsKey(elKey)) {
            return true;
        }
        for (ConfigFile configFile : configFiles) {
            Properties properties = configFile.getProperties();
            if (!properties.containsKey(elKey)) continue;
            return true;
        }
        return false;
    }

    public String rawExpressionLanguage(String propertyName) {
        ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>(this.internalRetrieveConfigFiles());
        Collections.reverse(configFiles);
        String elKey = propertyName + EL_CONFIG_SUFFIX;
        Map<String, String> overrideMap = this.propertiesThreadLocalOverrideMap();
        if (overrideMap.containsKey(elKey)) {
            return overrideMap.get(elKey);
        }
        overrideMap = this.propertiesOverrideMap();
        if (overrideMap.containsKey(elKey)) {
            return overrideMap.get(elKey);
        }
        for (ConfigFile configFile : configFiles) {
            Properties properties = configFile.getProperties();
            if (!properties.containsKey(elKey)) continue;
            return properties.getProperty(elKey);
        }
        return null;
    }

    public static class ConfigFile {
        private Properties properties;
        private String originalConfig;
        private String contents = null;
        private ConfigFileType configFileType;
        private String configFileTypeConfig;

        public Properties getProperties() {
            return this.properties;
        }

        public void setProperties(Properties properties1) {
            this.properties = properties1;
        }

        public String getOriginalConfig() {
            return this.originalConfig;
        }

        public String getContents() {
            return this.contents;
        }

        public void setContents(String contents1) {
            this.contents = contents1;
        }

        public String retrieveContents(ConfigPropertiesCascadeBase configPropertiesCascadeBase) {
            String string;
            InputStream inputStream;
            block5: {
                inputStream = null;
                inputStream = this.configFileType.inputStream(this.configFileTypeConfig, configPropertiesCascadeBase);
                if (inputStream == null) break block5;
                String string2 = ConfigPropertiesCascadeUtils.toString(inputStream, ConfigPropertiesCascadeBase.encoding());
                ConfigPropertiesCascadeUtils.closeQuietly(inputStream);
                return string2;
            }
            try {
                string = "";
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Problem reading config: '" + this.originalConfig + "'", e);
                }
                catch (Throwable throwable) {
                    ConfigPropertiesCascadeUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            ConfigPropertiesCascadeUtils.closeQuietly(inputStream);
            return string;
        }

        public ConfigFile(String configFileFullConfig) {
            this.originalConfig = configFileFullConfig;
            int colonIndex = configFileFullConfig.indexOf(58);
            if (colonIndex == -1) {
                throw new RuntimeException("Config file spec needs the type of config and a colon, e.g. file:/some/path/config.properties  '" + configFileFullConfig + "'");
            }
            String configFileTypeString = ConfigPropertiesCascadeUtils.trim(ConfigPropertiesCascadeUtils.prefixOrSuffix(configFileFullConfig, ":", true));
            if (ConfigPropertiesCascadeUtils.isBlank(configFileTypeString)) {
                throw new RuntimeException("Config file spec needs the type of config and a colon, e.g. file:/some/path/config.properties  '" + configFileFullConfig + "'");
            }
            try {
                this.configFileType = ConfigFileType.valueOfIgnoreCase(configFileTypeString);
            }
            catch (Exception e) {
                throw new RuntimeException("Config file spec needs the type of config and a colon, e.g. file:/some/path/config.properties  '" + configFileFullConfig + "', " + e.getMessage(), e);
            }
            this.configFileTypeConfig = ConfigPropertiesCascadeUtils.trim(ConfigPropertiesCascadeUtils.prefixOrSuffix(configFileFullConfig, ":", false));
        }

        public ConfigFileType getConfigFileType() {
            return this.configFileType;
        }

        public String getConfigFileTypeConfig() {
            return this.configFileTypeConfig;
        }
    }

    protected static enum ConfigFileType {
        DATABASE{

            @Override
            public InputStream inputStream(String configFileTypeConfig, ConfigPropertiesCascadeBase configPropertiesCascadeBase) {
                String mainConfigFileName = configPropertiesCascadeBase.getMainConfigFileName();
                return ConfigDatabaseLogic.retrieveConfigInputStream(mainConfigFileName);
            }
        }
        ,
        FILE{

            @Override
            public InputStream inputStream(String configFileTypeConfig, ConfigPropertiesCascadeBase configPropertiesCascadeBase) {
                File file = new File(configFileTypeConfig);
                if (!file.exists() || !file.isFile()) {
                    throw new RuntimeException("Cant find config file from filesystem path: " + configFileTypeConfig);
                }
                try {
                    return new FileInputStream(file);
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem reading config file from filesystem path: " + file.getAbsolutePath(), e);
                }
            }
        }
        ,
        CLASSPATH{

            @Override
            public InputStream inputStream(String configFileTypeConfig, ConfigPropertiesCascadeBase configPropertiesCascadeBase) {
                Class<?> classInJar;
                URL url = ConfigPropertiesCascadeUtils.computeUrl(configFileTypeConfig, true);
                Exception exception = null;
                if (url != null) {
                    try {
                        return url.openStream();
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                }
                if ((classInJar = configPropertiesCascadeBase.getClassInSiblingJar()) != null) {
                    File configFile;
                    File jarFile = classInJar == null ? null : ConfigPropertiesCascadeUtils.jarFile(classInJar);
                    File parentDir = jarFile == null ? null : jarFile.getParentFile();
                    String fileName = parentDir == null ? null : ConfigPropertiesCascadeUtils.stripLastSlashIfExists(ConfigPropertiesCascadeUtils.fileCanonicalPath(parentDir)) + File.separator + configFileTypeConfig;
                    File file = configFile = fileName == null ? null : new File(fileName);
                    if (configFile != null && configFile.exists() && configFile.isFile()) {
                        try {
                            return new FileInputStream(configFile);
                        }
                        catch (Exception e) {
                            ConfigPropertiesCascadeBase.logError("Cant read config file: " + configFile.getAbsolutePath(), e);
                        }
                    }
                }
                throw new RuntimeException("Cant find config file from classpath: " + configFileTypeConfig, exception);
            }
        };


        public abstract InputStream inputStream(String var1, ConfigPropertiesCascadeBase var2);

        public static ConfigFileType valueOfIgnoreCase(String string) {
            return ConfigPropertiesCascadeUtils.enumValueOfIgnoreCase(ConfigFileType.class, string, false);
        }
    }

    static class PropertyValueResult {
        private String theValue;
        private boolean hasKey;

        public PropertyValueResult(String theValue1, boolean hasKey1) {
            this.theValue = theValue1;
            this.hasKey = hasKey1;
        }

        public String getTheValue() {
            return this.theValue;
        }

        public void setTheValue(String theValue1) {
            this.theValue = theValue1;
        }

        public boolean isHasKey() {
            return this.hasKey;
        }

        public void setHasKey(boolean hasKey1) {
            this.hasKey = hasKey1;
        }
    }
}

