/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.examples;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.util.GrouperClientXstreamUtils;
import edu.internet2.middleware.grouperClient.ws.beans.WsAddMemberResult;
import edu.internet2.middleware.grouperClient.ws.beans.WsAddMemberResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAddMemberRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestResultProblem;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.XStream;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.CompactWriter;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.Header;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpClient;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpException;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.UsernamePasswordCredentials;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.auth.AuthScope;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.methods.PostMethod;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.methods.StringRequestEntity;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.params.DefaultHttpParams;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WsExample {
    private static HttpClient httpClient() {
        HttpClient httpClient = new HttpClient();
        DefaultHttpParams.getDefaultParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
        httpClient.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials("mchyzer", "xxxxxx");
        httpClient.getState().setCredentials(new AuthScope("localhost", 8092), defaultcreds);
        return httpClient;
    }

    private static PostMethod postMethod() {
        PostMethod method = new PostMethod("http://localhost:8092/grouper-ws/servicesRest/v1_4_000/groups/aStem%3AaGroup/members");
        method.setRequestHeader("Connection", "close");
        return method;
    }

    private static String marshalObject(XStream xStream, Object object) {
        StringWriter stringWriter = new StringWriter();
        xStream.marshal(object, new CompactWriter(stringWriter));
        String requestDocument = stringWriter.toString();
        return requestDocument;
    }

    private static PostMethod postMethod(XStream xStream, Object objectToMarshall) throws UnsupportedEncodingException, HttpException, IOException {
        String contentType = "text/xml";
        HttpClient httpClient = WsExample.httpClient();
        PostMethod method = WsExample.postMethod();
        String requestDocument = WsExample.marshalObject(xStream, objectToMarshall);
        method.setRequestEntity(new StringRequestEntity(requestDocument, contentType, "UTF-8"));
        httpClient.executeMethod(method);
        return method;
    }

    public static void main(String[] args) {
        Map<String, String> argMap = GrouperClientUtils.argMap(args);
        HashMap<String, String> argMapNotUsed = new HashMap<String, String>(argMap);
        String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", true);
        String subjectIds = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "subjectIds", false);
        List<String> subjectIdsList = GrouperClientUtils.splitTrimToList(subjectIds, ",");
        String subjectIdentifiers = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "subjectIdentifiers", false);
        List<String> subjectIdentifiersList = GrouperClientUtils.splitTrimToList(subjectIdentifiers, ",");
        String sourceIds = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "sourceIds", false);
        List<String> sourceIdsList = GrouperClientUtils.splitTrimToList(sourceIds, ",");
        boolean replaceAllExisting = GrouperClientUtils.argMapBoolean(argMap, argMapNotUsed, "replaceAllExisting", false, false);
        String response = WsExample.addMember(groupName, subjectIdsList, subjectIdentifiersList, sourceIdsList, replaceAllExisting);
        System.out.println(response);
    }

    public static String addMember(String groupName, List<String> subjectIds, List<String> subjectIdentifiers, List<String> sourceIds, boolean replaceAllExisting) {
        StringBuilder result = new StringBuilder();
        try {
            WsRestAddMemberRequest addMember = new WsRestAddMemberRequest();
            WsSubjectLookup actAsSubject = new WsSubjectLookup("GrouperSystem", null, null);
            addMember.setActAsSubjectLookup(actAsSubject);
            addMember.setReplaceAllExisting(replaceAllExisting ? "T" : "F");
            int subjectIdLength = GrouperClientUtils.length(subjectIds);
            int subjectIdentifierLength = GrouperClientUtils.length(subjectIdentifiers);
            int sourceIdLength = GrouperClientUtils.length(sourceIds);
            if (subjectIdLength == 0 && subjectIdentifierLength == 0) {
                throw new RuntimeException("Cant pass no subject ids and no subject identifiers!");
            }
            if (subjectIdLength != 0 && subjectIdentifierLength != 0) {
                throw new RuntimeException("Cant pass subject ids and subject identifiers! (pass one of the other)");
            }
            if (sourceIdLength > 0 && sourceIdLength != subjectIdLength && sourceIdLength != subjectIdentifierLength) {
                throw new RuntimeException("If source ids are passed in, you must pass the same number as subjectIds or subjectIdentifiers");
            }
            int subjectsLength = Math.max(subjectIdLength, subjectIdentifierLength);
            WsSubjectLookup[] subjectLookups = new WsSubjectLookup[subjectsLength];
            for (int i = 0; i < subjectsLength; ++i) {
                subjectLookups[i] = new WsSubjectLookup();
                if (subjectIdLength > 0) {
                    subjectLookups[i].setSubjectId(subjectIds.get(i));
                }
                if (subjectIdentifierLength > 0) {
                    subjectLookups[i].setSubjectIdentifier(subjectIdentifiers.get(i));
                }
                if (sourceIdLength <= 0) continue;
                subjectLookups[i].setSubjectSourceId(sourceIds.get(i));
            }
            addMember.setSubjectLookups(subjectLookups);
            GrouperTestClientWs grouperClientWs = new GrouperTestClientWs();
            WsAddMemberResults wsAddMemberResults = (WsAddMemberResults)grouperClientWs.executeService(addMember);
            String resultMessage = wsAddMemberResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(resultMessage);
            int index = 0;
            for (WsAddMemberResult wsAddMemberResult : wsAddMemberResults.getResults()) {
                result.append("Index " + index + ": success: " + wsAddMemberResult.getResultMetadata().getSuccess() + ": code: " + wsAddMemberResult.getResultMetadata().getResultCode() + ": " + wsAddMemberResult.getWsSubject().getId() + "\n");
                ++index;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    public static class GrouperTestClientWs {
        private XStream xStream = GrouperClientXstreamUtils.retrieveXstream();
        private PostMethod method;
        private String response;
        private boolean success = false;
        private String resultCode = null;

        public Object executeService(Object toSend) throws UnsupportedEncodingException, HttpException, IOException {
            String successString;
            this.method = WsExample.postMethod(this.xStream, toSend);
            Header successHeader = this.method.getResponseHeader("X-Grouper-success");
            String string = successString = successHeader == null ? null : successHeader.getValue();
            if (GrouperClientUtils.isBlank(successString)) {
                throw new RuntimeException("Web service did not even respond!");
            }
            this.success = "T".equals(successString);
            this.resultCode = this.method.getResponseHeader("X-Grouper-resultCode").getValue();
            this.response = GrouperClientUtils.responseBodyAsString(this.method);
            Object resultObject = this.xStream.fromXML(this.response);
            if (resultObject instanceof WsRestResultProblem) {
                throw new RuntimeException(((WsRestResultProblem)resultObject).getResultMetadata().getResultMessage());
            }
            return resultObject;
        }

        public void handleFailure(String resultMessage) {
            if (!this.success) {
                throw new RuntimeException("Bad response from web service: resultCode: " + this.resultCode + ", " + resultMessage);
            }
        }
    }
}

