/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJob;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GcGrouperSyncHeartbeat {
    private boolean interrupted;
    private boolean fullSync = false;
    private boolean done;
    private GcGrouperSyncJob gcGrouperSyncJob;
    private Thread thread = null;
    private boolean started = false;
    private boolean paused = false;
    private List<Runnable> heartbeatLogics = Collections.synchronizedList(new ArrayList());
    private static final Log LOG = LogFactory.getLog(GcGrouperSyncHeartbeat.class);

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public boolean isFullSync() {
        return this.fullSync;
    }

    public void setFullSync(boolean fullSync1) {
        this.fullSync = fullSync1;
    }

    public void setDone(boolean done1) {
        this.done = done1;
    }

    public GcGrouperSyncJob getGcGrouperSyncJob() {
        return this.gcGrouperSyncJob;
    }

    public void setGcGrouperSyncJob(GcGrouperSyncJob gcGrouperSyncJob1) {
        this.gcGrouperSyncJob = gcGrouperSyncJob1;
    }

    public synchronized void runHeartbeatThread() {
        if (this.started) {
            throw new RuntimeException("This is already started!");
        }
        this.started = true;
        if (this.gcGrouperSyncJob == null) {
            throw new RuntimeException("Need to get job!");
        }
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        long loopStarted = System.currentTimeMillis();
                        for (int i = 0; i < 60; ++i) {
                            if (GcGrouperSyncHeartbeat.this.done) {
                                return;
                            }
                            if (System.currentTimeMillis() - loopStarted > 60000L) break;
                            Thread.sleep(1000L);
                            if (!GcGrouperSyncHeartbeat.this.done) continue;
                            return;
                        }
                        if (GcGrouperSyncHeartbeat.this.paused) continue;
                        GcGrouperSyncHeartbeat gcGrouperSyncHeartbeat = GcGrouperSyncHeartbeat.this;
                        // MONITORENTER : gcGrouperSyncHeartbeat
                        if (GcGrouperSyncHeartbeat.this.done) {
                            // MONITOREXIT : gcGrouperSyncHeartbeat
                            return;
                        }
                        boolean shouldKeepRunning = GcGrouperSyncHeartbeat.this.gcGrouperSyncJob.assignHeartbeatAndCheckForPendingJobs(GcGrouperSyncHeartbeat.this.fullSync);
                        for (Runnable heartbeatLogic : GcGrouperSyncHeartbeat.this.heartbeatLogics) {
                            heartbeatLogic.run();
                        }
                        if (!shouldKeepRunning) {
                            GcGrouperSyncHeartbeat.this.interrupted = true;
                        }
                        // MONITOREXIT : gcGrouperSyncHeartbeat
                        continue;
                        break;
                    }
                }
                catch (InterruptedException loopStarted) {
                    return;
                }
                catch (Exception e) {
                    LOG.error("Error assigning status and logging", e);
                    return;
                }
                finally {
                    GcGrouperSyncHeartbeat.this.interrupted = true;
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread1) {
        this.thread = thread1;
    }

    public void addHeartbeatLogic(Runnable heartbeatLogic) {
        this.heartbeatLogics.add(heartbeatLogic);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setPaused(boolean paused1) {
        this.paused = paused1;
    }

    public static void endAndWaitForThread(GcGrouperSyncHeartbeat gcGrouperSyncHeartbeat) {
        if (gcGrouperSyncHeartbeat != null) {
            gcGrouperSyncHeartbeat.setDone(true);
            if (gcGrouperSyncHeartbeat.getThread() != null) {
                try {
                    gcGrouperSyncHeartbeat.getThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GrouperClientUtils.join(gcGrouperSyncHeartbeat.getThread());
            }
        }
    }
}

