/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.GcDbVersionable;
import edu.internet2.middleware.grouperClient.jdbc.GcPersist;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableClass;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableField;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableHelper;
import edu.internet2.middleware.grouperClient.jdbc.GcSqlAssignPrimaryKey;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncJobState;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.builder.EqualsBuilder;
import java.sql.Timestamp;
import java.util.List;
import java.util.Random;

@GcPersistableClass(tableName="grouper_sync_job", defaultFieldPersist=GcPersist.doPersist)
public class GcGrouperSyncJob
implements GcSqlAssignPrimaryKey,
GcDbVersionable {
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSyncJob dbVersion = null;
    private Integer percentComplete;
    private String quartzJobName;
    private String errorMessage;
    private Timestamp errorTimestamp;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private GcGrouperSync grouperSync;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private String connectionName;
    private Timestamp heartbeat;
    @GcPersistableField(primaryKey=true, primaryKeyManuallyAssigned=false)
    private String id;
    private String syncType;
    private String grouperSyncId;
    @GcPersistableField(columnName="job_state")
    private String jobStateDb;
    private Timestamp lastSyncTimestamp;
    private Long lastSyncIndex;
    private Timestamp lastTimeWorkWasDone;
    private Timestamp lastUpdated;

    @Override
    public void dbVersionReset() {
        this.dbVersion = this.clone();
    }

    @Override
    public boolean dbVersionDifferent() {
        return !this.equalsDeep(this.dbVersion);
    }

    @Override
    public void dbVersionDelete() {
        this.dbVersion = null;
    }

    public GcGrouperSyncJob clone() {
        GcGrouperSyncJob gcGrouperSyncJob = new GcGrouperSyncJob();
        gcGrouperSyncJob.errorMessage = this.errorMessage;
        gcGrouperSyncJob.errorTimestamp = this.errorTimestamp;
        gcGrouperSyncJob.grouperSyncId = this.grouperSyncId;
        gcGrouperSyncJob.heartbeat = this.heartbeat;
        gcGrouperSyncJob.id = this.id;
        gcGrouperSyncJob.jobStateDb = this.jobStateDb;
        gcGrouperSyncJob.lastSyncIndex = this.lastSyncIndex;
        gcGrouperSyncJob.lastSyncTimestamp = this.lastSyncTimestamp;
        gcGrouperSyncJob.lastTimeWorkWasDone = this.lastTimeWorkWasDone;
        gcGrouperSyncJob.percentComplete = this.percentComplete;
        gcGrouperSyncJob.quartzJobName = this.quartzJobName;
        gcGrouperSyncJob.syncType = this.syncType;
        return gcGrouperSyncJob;
    }

    public boolean equalsDeep(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GcGrouperSyncJob)) {
            return false;
        }
        GcGrouperSyncJob other = (GcGrouperSyncJob)obj;
        return new EqualsBuilder().append(this.errorMessage, other.errorMessage).append(this.errorTimestamp, other.errorTimestamp).append(this.grouperSyncId, other.grouperSyncId).append(this.heartbeat, other.heartbeat).append(this.id, other.id).append(this.jobStateDb, other.jobStateDb).append(this.lastSyncIndex, other.lastSyncIndex).append(this.lastSyncTimestamp, other.lastSyncTimestamp).append(this.lastTimeWorkWasDone, other.lastTimeWorkWasDone).append(this.percentComplete, other.percentComplete).append(this.quartzJobName, other.quartzJobName).append(this.syncType, other.syncType).isEquals();
    }

    public boolean isHeartBeatAlive() {
        return this.getHeartbeat() != null && System.currentTimeMillis() - this.getHeartbeat().getTime() < 90000L;
    }

    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    public void setPercentComplete(Integer percentComplete1) {
        this.percentComplete = percentComplete1;
    }

    public String getQuartzJobName() {
        return this.quartzJobName;
    }

    public void setQuartzJobName(String quartzJobName1) {
        this.quartzJobName = quartzJobName1;
    }

    public static void reset() {
        try {
            new GcDbAccess().connectionName("grouper").sql("select * from " + GcPersistableHelper.tableName(GcGrouperSyncJob.class) + " where 1 != 1").select(Integer.class);
        }
        catch (Exception e) {
            return;
        }
        new GcDbAccess().connectionName("grouper").sql("delete from " + GcPersistableHelper.tableName(GcGrouperSyncJob.class)).executeSql();
    }

    public void storePrepare() {
        this.lastUpdated = new Timestamp(System.currentTimeMillis());
        this.connectionName = GcGrouperSync.defaultConnectionName(this.connectionName);
        this.errorMessage = GrouperClientUtils.abbreviate(this.errorMessage, 3700);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage1) {
        this.errorMessage = errorMessage1;
    }

    public Timestamp getErrorTimestamp() {
        return this.errorTimestamp;
    }

    public void setErrorTimestamp(Timestamp errorTimestamp1) {
        this.errorTimestamp = errorTimestamp1;
    }

    public GcGrouperSync getGrouperSync() {
        return this.grouperSync;
    }

    public void setGrouperSync(GcGrouperSync gcGrouperSync) {
        this.grouperSync = gcGrouperSync;
        this.grouperSyncId = gcGrouperSync == null ? null : gcGrouperSync.getId();
        this.connectionName = gcGrouperSync == null ? this.connectionName : gcGrouperSync.getConnectionName();
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName1) {
        this.connectionName = connectionName1;
    }

    public static void main(String[] args) {
        System.out.println("none");
        for (GcGrouperSyncJob theGcGrouperSyncJob : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSyncJob.class)) {
            System.out.println(theGcGrouperSyncJob.toString());
        }
        GcGrouperSync gcGrouperSync = new GcGrouperSync();
        gcGrouperSync.setSyncEngine("temp");
        gcGrouperSync.setProvisionerName("myJob");
        gcGrouperSync.getGcGrouperSyncDao().store();
        GcGrouperSyncJob gcGrouperSyncJob = new GcGrouperSyncJob();
        gcGrouperSyncJob.setGrouperSync(gcGrouperSync);
        gcGrouperSyncJob.setJobState(GcGrouperSyncJobState.running);
        gcGrouperSyncJob.setLastSyncIndex(135L);
        gcGrouperSyncJob.setLastTimeWorkWasDone(new Timestamp(System.currentTimeMillis() + 2000L));
        gcGrouperSyncJob.setSyncType("testSyncType");
        gcGrouperSync.getGcGrouperSyncJobDao().internal_jobStore(gcGrouperSyncJob);
        System.out.println("stored");
        gcGrouperSyncJob = gcGrouperSync.getGcGrouperSyncJobDao().jobRetrieveBySyncType("testSyncType");
        System.out.println(gcGrouperSyncJob);
        gcGrouperSyncJob.setJobState(GcGrouperSyncJobState.notRunning);
        gcGrouperSync.getGcGrouperSyncJobDao().internal_jobStore(gcGrouperSyncJob);
        System.out.println("updated");
        for (GcGrouperSyncJob theGcGrouperSyncStatus : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSyncJob.class)) {
            System.out.println(theGcGrouperSyncStatus.toString());
        }
        gcGrouperSync.getGcGrouperSyncJobDao().jobDelete(gcGrouperSyncJob, false);
        System.out.println("deleted");
        for (GcGrouperSyncJob theGcGrouperSyncStatus : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSyncJob.class)) {
            System.out.println(theGcGrouperSyncStatus.toString());
        }
        System.out.println("retrieveOrCreate");
        gcGrouperSyncJob = gcGrouperSync.getGcGrouperSyncJobDao().jobRetrieveOrCreateBySyncType("testSyncType");
        System.out.println(gcGrouperSyncJob);
        System.out.println("retrieve");
        gcGrouperSyncJob = gcGrouperSync.getGcGrouperSyncJobDao().jobRetrieveBySyncType("testSyncType");
        System.out.println(gcGrouperSyncJob);
        System.out.println("retrieveOrCreate");
        gcGrouperSyncJob = gcGrouperSync.getGcGrouperSyncJobDao().jobRetrieveOrCreateBySyncType("testSyncType");
        System.out.println(gcGrouperSyncJob);
        System.out.println("deleted");
        gcGrouperSync.getGcGrouperSyncJobDao().jobDelete(gcGrouperSyncJob, false);
        gcGrouperSync.getGcGrouperSyncDao().delete();
        for (GcGrouperSyncJob theGcGrouperSyncStatus : new GcDbAccess().connectionName("grouper").selectList(GcGrouperSyncJob.class)) {
            System.out.println(theGcGrouperSyncStatus.toString());
        }
    }

    private static GcGrouperSyncJob retrieveJobBySyncType(List<GcGrouperSyncJob> gcGrouperSyncJobs, String syncType) {
        for (GcGrouperSyncJob gcGrouperSyncJob : GrouperClientUtils.nonNull(gcGrouperSyncJobs)) {
            if (!GrouperClientUtils.equals(syncType, gcGrouperSyncJob.getSyncType())) continue;
            return gcGrouperSyncJob;
        }
        return null;
    }

    public String toString() {
        return GrouperClientUtils.toStringReflection(this);
    }

    public Timestamp getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(Timestamp heartbeat1) {
        this.heartbeat = heartbeat1;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id1) {
        this.id = id1;
    }

    public String getSyncType() {
        return this.syncType;
    }

    public void setSyncType(String syncType) {
        this.syncType = syncType;
    }

    public String getGrouperSyncId() {
        return this.grouperSyncId;
    }

    public void setGrouperSyncId(String grouperSyncId1) {
        this.grouperSyncId = grouperSyncId1;
        if (this.grouperSync == null || !GrouperClientUtils.equals(this.grouperSync.getId(), grouperSyncId1)) {
            this.grouperSync = null;
        }
    }

    public String getJobStateDb() {
        return this.jobStateDb;
    }

    public GcGrouperSyncJobState getJobState() {
        return GcGrouperSyncJobState.valueOfIgnoreCase(this.jobStateDb);
    }

    public void setJobState(GcGrouperSyncJobState gcGrouperSyncJobState) {
        this.jobStateDb = gcGrouperSyncJobState == null ? null : gcGrouperSyncJobState.name();
    }

    public void setJobStateDb(String jobState1) {
        this.jobStateDb = jobState1;
    }

    public Timestamp getLastSyncTimestamp() {
        return this.lastSyncTimestamp;
    }

    public void setLastSyncTimestamp(Timestamp lastSyncTimestamp1) {
        this.lastSyncTimestamp = lastSyncTimestamp1;
    }

    public Long getLastSyncIndex() {
        return this.lastSyncIndex;
    }

    public void setLastSyncIndex(Long lastSyncIndexOrMillis1) {
        this.lastSyncIndex = lastSyncIndexOrMillis1;
    }

    public Timestamp getLastTimeWorkWasDone() {
        return this.lastTimeWorkWasDone;
    }

    public void setLastTimeWorkWasDone(Timestamp lastTimeWorkWasDone1) {
        this.lastTimeWorkWasDone = lastTimeWorkWasDone1;
    }

    public Timestamp getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Timestamp lastUpdated1) {
        this.lastUpdated = lastUpdated1;
    }

    @Override
    public boolean gcSqlAssignNewPrimaryKeyForInsert() {
        if (this.id != null) {
            return false;
        }
        this.id = GrouperClientUtils.uuid();
        return true;
    }

    public boolean assignHeartbeatAndCheckForPendingJobs(boolean isLargeJob) {
        List<GcGrouperSyncJob> allGcGrouperSyncJobs = this.getGrouperSync().getGcGrouperSyncJobDao().internal_jobRetrieveFromDbAll();
        GcGrouperSyncJob gcGrouperSyncJob = GcGrouperSyncJob.retrieveJobBySyncType(allGcGrouperSyncJobs, this.syncType);
        if (gcGrouperSyncJob == null) {
            throw new RuntimeException("Why is this job not found????");
        }
        gcGrouperSyncJob.setHeartbeat(new Timestamp(System.currentTimeMillis()));
        gcGrouperSyncJob.setJobState(GcGrouperSyncJobState.running);
        this.grouperSync.getGcGrouperSyncJobDao().internal_jobStore(gcGrouperSyncJob);
        for (GcGrouperSyncJob currentGrouperSyncJob : GrouperClientUtils.nonNull(allGcGrouperSyncJobs)) {
            if (GrouperClientUtils.equals(currentGrouperSyncJob.getSyncType(), this.syncType) || currentGrouperSyncJob.getHeartbeat() == null || System.currentTimeMillis() - currentGrouperSyncJob.getHeartbeat().getTime() > 90000L) continue;
            if (GcGrouperSyncJobState.running == currentGrouperSyncJob.getJobState() && !isLargeJob) {
                return false;
            }
            if (GcGrouperSyncJobState.pending != currentGrouperSyncJob.getJobState() || isLargeJob) continue;
            return false;
        }
        return true;
    }

    public void assignHeartbeatAndEndJob() {
        this.setHeartbeat(new Timestamp(System.currentTimeMillis()));
        this.setJobState(GcGrouperSyncJobState.notRunning);
        this.grouperSync.getGcGrouperSyncJobDao().internal_jobStore(this);
    }

    public void waitForRelatedJobsToFinishThenRun(boolean goToPendingFirstAkaLargeJob) {
        List<GcGrouperSyncJob> allGcGrouperSyncJobs = this.grouperSync.getGcGrouperSyncJobDao().internal_jobRetrieveFromDbAll();
        for (int i = 0; i < allGcGrouperSyncJobs.size(); ++i) {
            GcGrouperSyncJob current = allGcGrouperSyncJobs.get(i);
            if (!GrouperClientUtils.equals(this.getId(), current.getId())) continue;
            allGcGrouperSyncJobs.set(i, this);
        }
        this.waitForRelatedJobsToFinishThenRunHelper(allGcGrouperSyncJobs, goToPendingFirstAkaLargeJob);
    }

    private void waitForRelatedJobsToFinishThenRunHelper(List<GcGrouperSyncJob> allGcGrouperSyncJobs, boolean goToPendingFirstAkaLargeJob) {
        String syncType = this.getSyncType();
        if (this.getJobState() == GcGrouperSyncJobState.running && this.isHeartBeatAlive()) {
            return;
        }
        if (goToPendingFirstAkaLargeJob) {
            this.setJobState(GcGrouperSyncJobState.pending);
            this.setHeartbeat(new Timestamp(System.currentTimeMillis()));
            this.grouperSync.getGcGrouperSyncJobDao().internal_jobStore(this);
            GrouperClientUtils.sleep(500 + new Random().nextInt(500));
            allGcGrouperSyncJobs = this.grouperSync.getGcGrouperSyncJobDao().internal_jobRetrieveFromDbAll();
        }
        int sleepSeconds = 15;
        long started = System.currentTimeMillis();
        do {
            int runningOrPendingCount = 0;
            for (GcGrouperSyncJob currentGrouperSyncJob : GrouperClientUtils.nonNull(allGcGrouperSyncJobs)) {
                if (GrouperClientUtils.equals(currentGrouperSyncJob.getSyncType(), syncType) || currentGrouperSyncJob.getHeartbeat() == null || System.currentTimeMillis() - currentGrouperSyncJob.getHeartbeat().getTime() > 90000L) continue;
                if (GcGrouperSyncJobState.running == currentGrouperSyncJob.getJobState()) {
                    ++runningOrPendingCount;
                    continue;
                }
                if (GcGrouperSyncJobState.pending != currentGrouperSyncJob.getJobState() || goToPendingFirstAkaLargeJob) continue;
                ++runningOrPendingCount;
            }
            if (runningOrPendingCount == 0) {
                this.setJobState(GcGrouperSyncJobState.running);
                this.setHeartbeat(new Timestamp(System.currentTimeMillis()));
                this.grouperSync.getGcGrouperSyncJobDao().internal_jobStore(this);
                return;
            }
            if (sleepSeconds > 60) {
                this.setJobState(GcGrouperSyncJobState.notRunning);
            }
            this.setHeartbeat(new Timestamp(System.currentTimeMillis()));
            this.grouperSync.getGcGrouperSyncJobDao().internal_jobStore(this);
            GrouperClientUtils.sleep(sleepSeconds * 1000 + new Random().nextInt(5000));
            if (sleepSeconds > 60 || goToPendingFirstAkaLargeJob) {
                this.setJobState(GcGrouperSyncJobState.pending);
            }
            this.setHeartbeat(new Timestamp(System.currentTimeMillis()));
            this.grouperSync.getGcGrouperSyncJobDao().internal_jobStore(this);
            if (goToPendingFirstAkaLargeJob) {
                GrouperClientUtils.sleep(500 + new Random().nextInt(500));
            }
            if (sleepSeconds < 120) {
                sleepSeconds *= 2;
            }
            if (sleepSeconds > 120) {
                sleepSeconds = 120;
            }
            allGcGrouperSyncJobs = this.grouperSync.getGcGrouperSyncJobDao().internal_jobRetrieveFromDbAll();
        } while (System.currentTimeMillis() - started <= 86400000L);
        throw new RuntimeException("Job cannot start for a day! " + this.connectionName + ", " + this.grouperSync.getSyncEngine() + ", " + this.grouperSync.getProvisionerName() + ", " + syncType);
    }
}

