/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc.tableSync;

import edu.internet2.middleware.grouperClient.jdbc.GcDbAccess;
import edu.internet2.middleware.grouperClient.jdbc.GcPersist;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableField;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSync;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncLog;
import edu.internet2.middleware.grouperClient.jdbc.tableSync.GcGrouperSyncMember;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class GcGrouperSyncMemberDao {
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncMember> internalCacheSyncMembers = new HashMap<String, GcGrouperSyncMember>();
    @GcPersistableField(persist=GcPersist.dontPersist)
    private Map<String, GcGrouperSyncMember> internalCacheSyncMembersById = new HashMap<String, GcGrouperSyncMember>();
    private GcGrouperSync gcGrouperSync;
    @GcPersistableField(persist=GcPersist.dontPersist)
    private boolean memberRetrievedAllObjectsFromDb = false;

    public GcGrouperSyncMember memberCreateByMemberId(String memberId) {
        GcGrouperSyncMember gcGrouperSyncMember = this.internal_memberCreateByMemberIdHelper(memberId);
        this.internal_memberStore(gcGrouperSyncMember);
        this.gcGrouperSync.addObjectCreatedCount(1);
        this.internal_memberCacheAdd(gcGrouperSyncMember);
        return gcGrouperSyncMember;
    }

    public GcGrouperSyncMember internal_memberCreateByMemberIdHelper(String memberId) {
        GcGrouperSyncMember gcGrouperSyncMember = new GcGrouperSyncMember();
        gcGrouperSyncMember.setGrouperSync(this.getGcGrouperSync());
        gcGrouperSyncMember.setMemberId(memberId);
        return gcGrouperSyncMember;
    }

    public int memberDelete(Collection<GcGrouperSyncMember> gcGrouperSyncMembers, boolean deleteMemberships, boolean deleteLogs) {
        int[] rowDeleteCounts;
        int count = 0;
        if (GrouperClientUtils.length(gcGrouperSyncMembers) == 0) {
            return 0;
        }
        ArrayList<List<Object>> batchBindVars = new ArrayList<List<Object>>();
        HashSet<String> memberSyncIds = new HashSet<String>();
        for (GcGrouperSyncMember gcGrouperSyncMember : gcGrouperSyncMembers) {
            ArrayList<String> currentBindVarRow = new ArrayList<String>();
            currentBindVarRow.add(gcGrouperSyncMember.getId());
            batchBindVars.add(currentBindVarRow);
            memberSyncIds.add(gcGrouperSyncMember.getId());
            this.internal_memberCacheDelete(gcGrouperSyncMember);
        }
        String connectionName = gcGrouperSyncMembers.iterator().next().getConnectionName();
        if (deleteLogs) {
            count += this.getGcGrouperSync().getGcGrouperSyncLogDao().internal_logDeleteBatchByOwnerIds(memberSyncIds);
        }
        if (deleteMemberships) {
            count += this.getGcGrouperSync().getGcGrouperSyncMembershipDao().membershipDeleteBySyncMemberIds(memberSyncIds, deleteLogs);
        }
        for (int rowDeleteCount : rowDeleteCounts = new GcDbAccess().connectionName(connectionName).sql("delete from grouper_sync_member where id = ?").batchBindVars(batchBindVars).batchSize(this.getGcGrouperSync().batchSize()).executeBatchSql()) {
            count += rowDeleteCount;
        }
        return count;
    }

    public int memberDelete(GcGrouperSyncMember gcGrouperSyncMember, boolean deleteMemberships, boolean deleteLogs) {
        if (gcGrouperSyncMember == null) {
            return 0;
        }
        this.internal_memberCacheDelete(gcGrouperSyncMember);
        int count = 0;
        if (deleteLogs) {
            count += this.getGcGrouperSync().getGcGrouperSyncLogDao().logDeleteByOwnerId(gcGrouperSyncMember.getId());
        }
        if (deleteMemberships) {
            count += this.getGcGrouperSync().getGcGrouperSyncMembershipDao().membershipDeleteBySyncMemberId(gcGrouperSyncMember.getId(), deleteLogs);
        }
        int rowDeleteCount = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_member where id = ?").bindVars(gcGrouperSyncMember.getId()).executeSql();
        return count += rowDeleteCount;
    }

    public int memberDeleteAll(boolean deleteMemberships, boolean deleteLogs) {
        this.internalCacheSyncMembers.clear();
        this.internalCacheSyncMembersById.clear();
        int rowDeleteCount = 0;
        if (deleteLogs) {
            rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where grouper_sync_owner_id in ( select id from grouper_sync_member gsg where gsg.grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
        }
        if (deleteMemberships) {
            if (deleteLogs) {
                rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_log where grouper_sync_owner_id in ( select id from grouper_sync_membership gsm where gsm.grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
            }
            rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_membership where grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
        }
        return rowDeleteCount += new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("delete from grouper_sync_member where grouper_sync_id = ?)").bindVars(this.getGcGrouperSync().getId()).executeSql();
    }

    public List<GcGrouperSyncMember> memberRetrieveAll() {
        if (!this.memberRetrievedAllObjectsFromDb) {
            for (GcGrouperSyncMember gcGrouperSyncMember : this.internal_memberRetrieveFromDbAll()) {
                this.internal_memberCacheAdd(gcGrouperSyncMember);
            }
            this.memberRetrievedAllObjectsFromDb = true;
        }
        return new ArrayList<GcGrouperSyncMember>(this.internalCacheSyncMembers.values());
    }

    public GcGrouperSyncMember memberRetrieveByMemberId(String memberId) {
        GcGrouperSyncMember gcGrouperSyncMember = this.internalCacheSyncMembers.get(memberId);
        if (gcGrouperSyncMember == null) {
            gcGrouperSyncMember = this.internal_memberRetrieveFromDbByMemberId(memberId);
        }
        return gcGrouperSyncMember;
    }

    public Map<String, GcGrouperSyncMember> memberRetrieveByMemberIds(Collection<String> grouperMemberIdsCollection) {
        HashMap<String, GcGrouperSyncMember> result = new HashMap<String, GcGrouperSyncMember>();
        HashSet<String> memberIdsToGetFromDb = new HashSet<String>();
        for (String memberId : GrouperClientUtils.nonNull(grouperMemberIdsCollection)) {
            GcGrouperSyncMember gcGrouperSyncMember = this.internalCacheSyncMembers.get(memberId);
            if (gcGrouperSyncMember != null) {
                result.put(memberId, gcGrouperSyncMember);
                continue;
            }
            memberIdsToGetFromDb.add(memberId);
        }
        if (memberIdsToGetFromDb.size() > 0) {
            Map<String, GcGrouperSyncMember> fromDb = this.internal_memberRetrieveFromDbByMemberIds(memberIdsToGetFromDb);
            result.putAll(fromDb);
        }
        return result;
    }

    public GcGrouperSyncMember memberRetrieveById(String gcGrouperSyncMemberId) {
        GcGrouperSyncMember gcGrouperSyncMember = this.internalCacheSyncMembersById.get(gcGrouperSyncMemberId);
        if (gcGrouperSyncMember == null) {
            gcGrouperSyncMember = this.internal_memberRetrieveFromDbById(gcGrouperSyncMemberId);
        }
        return gcGrouperSyncMember;
    }

    public GcGrouperSyncMember memberRetrieveOrCreateByMemberId(String memberId) {
        GcGrouperSyncMember gcGrouperSyncMember = this.memberRetrieveByMemberId(memberId);
        if (gcGrouperSyncMember == null) {
            gcGrouperSyncMember = this.memberCreateByMemberId(memberId);
        }
        return gcGrouperSyncMember;
    }

    public Map<String, GcGrouperSyncMember> memberRetrieveOrCreateByMemberIds(Collection<String> grouperMemberIdsCollection) {
        Map<String, GcGrouperSyncMember> result = this.memberRetrieveByMemberIds(grouperMemberIdsCollection);
        if (GrouperClientUtils.length(grouperMemberIdsCollection) == 0 || grouperMemberIdsCollection.size() == result.size()) {
            return result;
        }
        HashSet<String> memberIdsToCreate = new HashSet<String>(grouperMemberIdsCollection);
        memberIdsToCreate.removeAll(result.keySet());
        HashSet<GcGrouperSyncMember> syncMembersToStore = new HashSet<GcGrouperSyncMember>();
        for (String memberIdToCreate : memberIdsToCreate) {
            GcGrouperSyncMember gcGrouperSyncMember = this.internal_memberCreateByMemberIdHelper(memberIdToCreate);
            result.put(memberIdToCreate, gcGrouperSyncMember);
            syncMembersToStore.add(gcGrouperSyncMember);
        }
        int changes = this.internal_memberStore(syncMembersToStore);
        this.gcGrouperSync.addObjectCreatedCount(changes);
        for (GcGrouperSyncMember gcGrouperSyncMember : syncMembersToStore) {
            this.internal_memberCacheAdd(gcGrouperSyncMember);
        }
        return result;
    }

    public GcGrouperSyncLog memberCreateLog(GcGrouperSyncMember gcGrouperSyncMember) {
        return this.gcGrouperSync.getGcGrouperSyncLogDao().logCreateByOwnerId(gcGrouperSyncMember.getId());
    }

    private void internal_memberCacheAdd(GcGrouperSyncMember gcGrouperSyncMember) {
        if (gcGrouperSyncMember.getMemberId() != null) {
            this.internalCacheSyncMembers.put(gcGrouperSyncMember.getMemberId(), gcGrouperSyncMember);
        }
        if (gcGrouperSyncMember.getId() != null) {
            this.internalCacheSyncMembersById.put(gcGrouperSyncMember.getId(), gcGrouperSyncMember);
        }
    }

    public void internal_memberCacheDelete(GcGrouperSyncMember gcGrouperSyncMember) {
        if (gcGrouperSyncMember.getMemberId() != null) {
            this.internalCacheSyncMembers.remove(gcGrouperSyncMember.getMemberId());
        }
        if (gcGrouperSyncMember.getId() != null) {
            this.internalCacheSyncMembersById.remove(gcGrouperSyncMember.getId());
        }
    }

    public List<GcGrouperSyncMember> internal_memberRetrieveFromDbAll() {
        this.internalCacheSyncMembers.clear();
        this.internalCacheSyncMembersById.clear();
        List<GcGrouperSyncMember> gcGrouperSyncMemberList = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_member where grouper_sync_id = ?").addBindVar(this.getGcGrouperSync().getId()).selectList(GcGrouperSyncMember.class);
        for (GcGrouperSyncMember gcGrouperSyncMember : gcGrouperSyncMemberList) {
            gcGrouperSyncMember.setGrouperSync(this.getGcGrouperSync());
            this.internal_memberCacheAdd(gcGrouperSyncMember);
        }
        return gcGrouperSyncMemberList;
    }

    public GcGrouperSyncMember internal_memberRetrieveFromDbByMemberId(String memberId) {
        GcGrouperSyncMember gcGrouperSyncMember = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_member where grouper_sync_id = ? and member_id = ?").addBindVar(this.getGcGrouperSync().getId()).addBindVar(memberId).select(GcGrouperSyncMember.class);
        if (gcGrouperSyncMember != null) {
            gcGrouperSyncMember.setGrouperSync(this.getGcGrouperSync());
            this.internal_memberCacheAdd(gcGrouperSyncMember);
        }
        return gcGrouperSyncMember;
    }

    public Map<String, GcGrouperSyncMember> internal_memberRetrieveFromDbByMemberIds(Collection<String> grouperMemberIdsCollection) {
        HashMap<String, GcGrouperSyncMember> result = new HashMap<String, GcGrouperSyncMember>();
        if (GrouperClientUtils.length(grouperMemberIdsCollection) == 0) {
            return result;
        }
        ArrayList<String> memberIdsList = new ArrayList<String>(grouperMemberIdsCollection);
        int batchSize = this.getGcGrouperSync().maxBindVarsInSelect();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(memberIdsList, batchSize);
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<String> batchOfMemberIds = GrouperClientUtils.batchList(memberIdsList, batchSize, batchIndex);
            String sql = "select * from grouper_sync_member where grouper_sync_id = ? and member_id in ( " + GrouperClientUtils.appendQuestions(batchOfMemberIds.size()) + ")";
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql(sql).addBindVar(this.getGcGrouperSync().getId());
            for (String memberId : batchOfMemberIds) {
                gcDbAccess.addBindVar(memberId);
            }
            List<GcGrouperSyncMember> gcGrouperSyncMembers = gcDbAccess.selectList(GcGrouperSyncMember.class);
            for (GcGrouperSyncMember gcGrouperSyncMember : GrouperClientUtils.nonNull(gcGrouperSyncMembers)) {
                result.put(gcGrouperSyncMember.getMemberId(), gcGrouperSyncMember);
                gcGrouperSyncMember.setGrouperSync(this.getGcGrouperSync());
                this.internal_memberCacheAdd(gcGrouperSyncMember);
            }
        }
        return result;
    }

    public GcGrouperSyncMember internal_memberRetrieveFromDbById(String gcGrouperSyncMemberId) {
        GcGrouperSyncMember gcGrouperSyncMember = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql("select * from grouper_sync_member where id = ?").addBindVar(gcGrouperSyncMemberId).select(GcGrouperSyncMember.class);
        if (gcGrouperSyncMember != null) {
            gcGrouperSyncMember.setGrouperSync(this.getGcGrouperSync());
            this.internal_memberCacheAdd(gcGrouperSyncMember);
        }
        return gcGrouperSyncMember;
    }

    public Map<String, GcGrouperSyncMember> internal_memberRetrieveFromDbByIds(Collection<String> syncMemberIdsCollection) {
        HashMap<String, GcGrouperSyncMember> result = new HashMap<String, GcGrouperSyncMember>();
        if (GrouperClientUtils.length(syncMemberIdsCollection) == 0) {
            return result;
        }
        ArrayList<String> syncIdsList = new ArrayList<String>(syncMemberIdsCollection);
        int batchSize = this.getGcGrouperSync().maxBindVarsInSelect();
        int numberOfBatches = GrouperClientUtils.batchNumberOfBatches(syncIdsList, batchSize);
        for (int batchIndex = 0; batchIndex < numberOfBatches; ++batchIndex) {
            List<String> batchOfSyncIds = GrouperClientUtils.batchList(syncIdsList, batchSize, batchIndex);
            String sql = "select * from grouper_sync_member where grouper_sync_id = ? and id in ( " + GrouperClientUtils.appendQuestions(batchOfSyncIds.size()) + ")";
            GcDbAccess gcDbAccess = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).sql(sql).addBindVar(this.getGcGrouperSync().getId());
            for (String memberId : batchOfSyncIds) {
                gcDbAccess.addBindVar(memberId);
            }
            List<GcGrouperSyncMember> gcGrouperSyncMembers = gcDbAccess.selectList(GcGrouperSyncMember.class);
            for (GcGrouperSyncMember gcGrouperSyncMember : GrouperClientUtils.nonNull(gcGrouperSyncMembers)) {
                result.put(gcGrouperSyncMember.getId(), gcGrouperSyncMember);
                gcGrouperSyncMember.setGrouperSync(this.getGcGrouperSync());
                this.internal_memberCacheAdd(gcGrouperSyncMember);
            }
        }
        return result;
    }

    public GcGrouperSync getGcGrouperSync() {
        return this.gcGrouperSync;
    }

    public void setGcGrouperSync(GcGrouperSync gcGrouperSync) {
        this.gcGrouperSync = gcGrouperSync;
    }

    public int internal_memberStoreAll() {
        return this.internal_memberStore(this.internalCacheSyncMembers.values());
    }

    public int internal_memberStore(Collection<GcGrouperSyncMember> gcGrouperSyncMembers) {
        if (GrouperClientUtils.length(gcGrouperSyncMembers) == 0) {
            return 0;
        }
        int batchSize = this.getGcGrouperSync().batchSize();
        ArrayList<GcGrouperSyncMember> gcGrouperSyncMembersList = new ArrayList<GcGrouperSyncMember>(gcGrouperSyncMembers);
        for (GcGrouperSyncMember gcGrouperSyncMember : GrouperClientUtils.nonNull(gcGrouperSyncMembers)) {
            gcGrouperSyncMember.storePrepare();
        }
        int changes = new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).storeBatchToDatabase(gcGrouperSyncMembersList, batchSize);
        for (GcGrouperSyncMember gcGrouperSyncMember : GrouperClientUtils.nonNull(gcGrouperSyncMembers)) {
            this.internal_memberCacheAdd(gcGrouperSyncMember);
        }
        return changes;
    }

    public void internal_memberStore(GcGrouperSyncMember gcGrouperSyncMember) {
        gcGrouperSyncMember.storePrepare();
        new GcDbAccess().connectionName(this.getGcGrouperSync().getConnectionName()).storeToDatabase(gcGrouperSyncMember);
    }
}

