/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignAttributeBatchEntry;
import edu.internet2.middleware.grouperClient.ws.beans.WsAssignAttributesBatchResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestAssignAttributesBatchRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcAssignAttributesBatch {
    private Set<WsAssignAttributeBatchEntry> assignAttributeBatchEntries = new LinkedHashSet<WsAssignAttributeBatchEntry>();
    private String clientVersion;
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private GcTransactionType txType;

    public GcAssignAttributesBatch addAssignAttributeBatchEntry(WsAssignAttributeBatchEntry wsAssignAttributeBatchEntry) {
        this.assignAttributeBatchEntries.add(wsAssignAttributeBatchEntry);
        return this;
    }

    public GcAssignAttributesBatch assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcAssignAttributesBatch addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcAssignAttributesBatch addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcAssignAttributesBatch assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.length(this.assignAttributeBatchEntries) == 0) {
            throw new RuntimeException("you need to pass in at least one assignAttributeBatchEntry: " + this);
        }
    }

    public GcAssignAttributesBatch addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcAssignAttributesBatch assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcAssignAttributesBatch assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsAssignAttributesBatchResults execute() {
        this.validate();
        WsAssignAttributesBatchResults wsAssignAttributesBatchResults = null;
        try {
            WsRestAssignAttributesBatchRequest assignAttributesBatch = new WsRestAssignAttributesBatchRequest();
            assignAttributesBatch.setActAsSubjectLookup(this.actAsSubject);
            assignAttributesBatch.setWsAssignAttributeBatchEntries(GrouperClientUtils.toArray(this.assignAttributeBatchEntries, WsAssignAttributeBatchEntry.class));
            if (this.includeGroupDetail != null) {
                assignAttributesBatch.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                assignAttributesBatch.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.params.size() > 0) {
                assignAttributesBatch.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            if (this.subjectAttributeNames.size() > 0) {
                assignAttributesBatch.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            assignAttributesBatch.setTxType(this.txType == null ? null : this.txType.name());
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsAssignAttributesBatchResults = (WsAssignAttributesBatchResults)grouperClientWs.executeService("attributeAssignments", assignAttributesBatch, "assignAttributesBatch", this.clientVersion, false);
            String resultMessage = wsAssignAttributesBatchResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsAssignAttributesBatchResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsAssignAttributesBatchResults;
    }

    public GcAssignAttributesBatch assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }
}

