/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.config;

import edu.internet2.middleware.grouperClient.jdbc.GcJdbcConnectionBean;
import edu.internet2.middleware.grouperClient.jdbc.GcJdbcConnectionProvider;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.lang3.StringUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class NonPooledConnectionProvider
implements GcJdbcConnectionProvider {
    private boolean connectionReadOnly;
    private String dbUrl;
    private String dbUser;
    private String dbPassword;
    private Boolean readOnly;
    private boolean readOnlyDefault;
    private static Log log = LogFactory.getLog(NonPooledConnectionProvider.class);

    @Override
    public GcJdbcConnectionBean connectionBean() {
        try {
            Connection connection = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPassword);
            connection.setAutoCommit(false);
            connection.setReadOnly(this.connectionReadOnly);
            return new NonPooledConnectionBean(connection);
        }
        catch (SQLException sqlException) {
            throw new RuntimeException(sqlException);
        }
    }

    @Override
    public void init(Properties properties, String sourceId, String driver, Integer maxActive, int defaultMaxActive, Integer maxIdle, int defaultMaxIdle, Integer maxWaitSeconds, int defaultMaxWaitSeconds, String theDbUrl, String theDbUser, String theDbPassword, Boolean readOnly, boolean readOnlyDefault, String jdbcConfigId) {
        if (!StringUtils.isBlank(jdbcConfigId)) {
            throw new RuntimeException("Cannot pass in jdbcConfigId for NonPooledConnectionBean, its only valid for GrouperJdbcConnectionProvider!");
        }
        try {
            Class.forName(driver).newInstance();
            log.debug("Loading JDBC driver: " + driver);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error loading JDBC driver: " + driver, ex);
        }
        log.debug("JDBC driver loaded. " + driver);
        this.dbUrl = theDbUrl;
        this.dbUser = theDbUser;
        this.dbPassword = theDbPassword;
        this.connectionReadOnly = GrouperClientUtils.defaultIfNull(readOnly, readOnlyDefault);
    }

    @Override
    public boolean requiresJdbcConfigInSourcesXml() {
        return true;
    }

    public static class NonPooledConnectionBean
    implements GcJdbcConnectionBean {
        private Connection connection;

        public NonPooledConnectionBean(Connection theConnection) {
            this.connection = theConnection;
        }

        @Override
        public Connection connection() throws SQLException {
            return this.connection;
        }

        @Override
        public void doneWithConnection() {
        }

        @Override
        public void doneWithConnectionError(Throwable t) {
            throw new RuntimeException(t);
        }

        @Override
        public void doneWithConnectionFinally() {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException ex) {
                    log.info("Error while closing JDBC Connection.", ex);
                }
            }
        }
    }
}

