/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.jdbc;

import edu.internet2.middleware.grouperClient.collections.MultiKey;
import edu.internet2.middleware.grouperClient.jdbc.GcPersist;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableClass;
import edu.internet2.middleware.grouperClient.jdbc.GcPersistableField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GcPersistableHelper {
    private static Map<String, String> oracleStandardNameFromJavaCache = new HashMap<String, String>();
    private static Map<Field, String> columnNameCache = new HashMap<Field, String>();
    private static Map<Class<?>, List<Field>> hierarchicalFieldsCache = new HashMap();
    private static Map<MultiKey, Boolean> isSelectCache = new HashMap<MultiKey, Boolean>();
    private static Map<MultiKey, Boolean> isPersistCache = new HashMap<MultiKey, Boolean>();
    private static Map<Class<?>, Field[]> primaryKeyFieldCache = new HashMap();
    private static Map<Class<? extends Object>, List<Field>> compoundPrimaryKeyFieldsCache = new HashMap<Class<? extends Object>, List<Field>>();

    public static String oracleStandardNameFromJava(String javaName) {
        String resultString = oracleStandardNameFromJavaCache.get(javaName);
        if (resultString == null) {
            if (javaName == null || 0 == "".compareTo(javaName)) {
                return javaName;
            }
            StringBuilder result = new StringBuilder();
            if (javaName.indexOf(".") > -1) {
                javaName = javaName.substring(javaName.lastIndexOf(".") + 1, javaName.length());
            }
            result.append(javaName.charAt(0));
            for (int i = 1; i < javaName.length(); ++i) {
                char currChar = javaName.charAt(i);
                if (currChar >= 'A' && currChar <= 'Z') {
                    result.append("_");
                }
                result.append(currChar);
            }
            resultString = result.toString().toUpperCase();
            oracleStandardNameFromJavaCache.put(javaName, resultString);
        }
        return resultString;
    }

    public static String columnName(Field field) {
        String columnName = columnNameCache.get(field);
        if (columnName == null) {
            GcPersistableField persistable = GcPersistableHelper.findPersistableAnnotation(field);
            columnName = persistable != null && !"".equals(persistable.columnName()) ? persistable.columnName() : GcPersistableHelper.oracleStandardNameFromJava(field.getName());
            columnNameCache.put(field, columnName);
        }
        return columnName;
    }

    public static boolean isPrimaryKey(Field field) {
        GcPersistableField persistable = GcPersistableHelper.findPersistableAnnotation(field);
        return persistable != null ? persistable.primaryKey() : false;
    }

    public static boolean isCompoundPrimaryKey(Field field) {
        GcPersistableField persistable = GcPersistableHelper.findPersistableAnnotation(field);
        return persistable != null ? persistable.compoundPrimaryKey() : false;
    }

    public static String tableName(Class<? extends Object> clazz) {
        GcPersistableClass persistableClass = GcPersistableHelper.findPersistableClassAnnotation(clazz);
        if (persistableClass != null && !"".equals(persistableClass.tableName())) {
            return persistableClass.tableName();
        }
        return GcPersistableHelper.oracleStandardNameFromJava(clazz.getName());
    }

    public static boolean defaultUpdate(Class<? extends Object> clazz) {
        GcPersistableClass persistableClass = GcPersistableHelper.findPersistableClassAnnotation(clazz);
        if (persistableClass != null) {
            return persistableClass.defaultUpdate();
        }
        return false;
    }

    public static boolean hasPersistableAnnotation(Class<? extends Object> clazz) {
        GcPersistableClass persistable = GcPersistableHelper.findPersistableClassAnnotation(clazz);
        if (persistable != null) {
            return true;
        }
        for (Field field : GcPersistableHelper.heirarchicalFields(clazz)) {
            if (!field.isAnnotationPresent(GcPersistableField.class)) continue;
            return true;
        }
        return false;
    }

    public static List<Field> heirarchicalFields(Class<?> clazz) {
        List<Field> result = hierarchicalFieldsCache.get(clazz);
        if (result == null) {
            result = GcPersistableHelper.heirarchicalFields(clazz, null);
            hierarchicalFieldsCache.put(clazz, result);
        }
        return result;
    }

    private static List<Field> heirarchicalFields(Class<?> clazz, List<Field> heirarchicalFields) {
        if (heirarchicalFields == null) {
            heirarchicalFields = new ArrayList<Field>();
        }
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            heirarchicalFields.add(field);
        }
        if (clazz.getSuperclass() != null) {
            GcPersistableHelper.heirarchicalFields(clazz.getSuperclass(), heirarchicalFields);
        }
        return heirarchicalFields;
    }

    public static boolean isSelect(Field field, Class<?> clazz) {
        MultiKey multiKey = new MultiKey(field, clazz);
        Boolean result = isSelectCache.get(multiKey);
        if (result == null) {
            if (Modifier.isStatic(field.getModifiers())) {
                result = false;
            }
            if (result == null) {
                GcPersistableField persistable;
                GcPersist classLevelPersist = null;
                GcPersistableClass persistableClass = GcPersistableHelper.findPersistableClassAnnotation(clazz);
                if (persistableClass != null) {
                    classLevelPersist = persistableClass.defaultFieldPersist();
                }
                if ((persistable = GcPersistableHelper.findPersistableAnnotation(field)) != null) {
                    result = persistable.persist().shouldSelect(classLevelPersist, persistable);
                }
                if (result == null && classLevelPersist != null) {
                    result = classLevelPersist.shouldSelect(null, persistable);
                }
            }
            if (result == null) {
                result = true;
            }
            isSelectCache.put(multiKey, result);
        }
        return result;
    }

    public static boolean isPersist(Field field, Class<?> clazz) {
        MultiKey multiKey = new MultiKey(field, clazz);
        Boolean result = isPersistCache.get(multiKey);
        if (result == null) {
            if (Modifier.isStatic(field.getModifiers())) {
                result = false;
            }
            if (result == null) {
                GcPersistableField persistable;
                GcPersist classLevelPersist = null;
                GcPersistableClass persistableClass = GcPersistableHelper.findPersistableClassAnnotation(clazz);
                if (persistableClass != null) {
                    classLevelPersist = persistableClass.defaultFieldPersist();
                }
                if ((persistable = GcPersistableHelper.findPersistableAnnotation(field)) != null) {
                    result = persistable.persist().shouldPersist(classLevelPersist, persistable);
                }
                if (result == null && classLevelPersist != null) {
                    result = classLevelPersist.shouldPersist(null, persistable);
                }
            }
            if (result == null) {
                result = true;
            }
            isPersistCache.put(multiKey, result);
        }
        return result;
    }

    public static GcPersistableClass findPersistableClassAnnotation(Class<? extends Object> clazz) {
        GcPersistableClass result = clazz.getAnnotation(GcPersistableClass.class);
        if (result != null) {
            return result;
        }
        for (Class<? extends Object> superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            result = superClass.getAnnotation(GcPersistableClass.class);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static GcPersistableField findPersistableAnnotation(Field field) {
        return field.getAnnotation(GcPersistableField.class);
    }

    public static Field primaryKeyField(Class<? extends Object> clazz) {
        Field[] resultArray = primaryKeyFieldCache.get(clazz);
        if (resultArray == null) {
            resultArray = new Field[1];
            boolean foundField = false;
            for (Field field : GcPersistableHelper.heirarchicalFields(clazz)) {
                if (!GcPersistableHelper.isPrimaryKey(field)) continue;
                resultArray[0] = field;
                foundField = true;
                break;
            }
            if (!foundField && GcPersistableHelper.findPersistableClassAnnotation(clazz).hasNoPrimaryKey()) {
                foundField = true;
            }
            if (!foundField && GcPersistableHelper.compoundPrimaryKeyFields(clazz).size() > 0) {
                foundField = true;
            }
            if (!foundField) {
                throw new RuntimeException("No field with a " + GcPersistableField.class.getSimpleName() + " annotation with a primary key field can be found!");
            }
            primaryKeyFieldCache.put(clazz, resultArray);
        }
        return resultArray[0];
    }

    public static List<Field> compoundPrimaryKeyFields(Class<? extends Object> clazz) {
        List<Field> result = compoundPrimaryKeyFieldsCache.get(clazz);
        if (result == null) {
            result = new ArrayList<Field>();
            for (Field field : GcPersistableHelper.heirarchicalFields(clazz)) {
                if (!GcPersistableHelper.isCompoundPrimaryKey(field)) continue;
                result.add(field);
            }
            compoundPrimaryKeyFieldsCache.put(clazz, result);
        }
        return result;
    }

    public static String primaryKeySequenceName(Field primaryKeyField) {
        GcPersistableField persistable = GcPersistableHelper.findPersistableAnnotation(primaryKeyField);
        if (persistable == null) {
            throw new RuntimeException("The field " + primaryKeyField + " does not have the annotation " + GcPersistableField.class.getSimpleName() + " set!");
        }
        if (!persistable.primaryKey()) {
            throw new RuntimeException("The field " + primaryKeyField + " does not have the primary key property set on the annotation " + GcPersistableField.class.getSimpleName() + "!");
        }
        if ("".equals(persistable.primaryKeySequenceName())) {
            throw new RuntimeException("The field " + primaryKeyField + " does not have the primary key sequence property set on the annotation " + GcPersistableField.class.getSimpleName() + "!");
        }
        return persistable.primaryKeySequenceName();
    }

    public static boolean primaryKeyManuallyAssigned(Field primaryKeyField) {
        GcPersistableField persistable = GcPersistableHelper.findPersistableAnnotation(primaryKeyField);
        if (persistable == null) {
            throw new RuntimeException("The field " + primaryKeyField + " does not have the annotation " + GcPersistableField.class.getSimpleName() + " set!");
        }
        if (!persistable.primaryKey()) {
            throw new RuntimeException("The field " + primaryKeyField + " does not have the primary key property set on the annotation " + GcPersistableField.class.getSimpleName() + "!");
        }
        return persistable.primaryKeyManuallyAssigned() || persistable.compoundPrimaryKey();
    }
}

