/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.json;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.core.util.FastStack;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.core.util.Primitives;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.core.util.QuickWriter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriter;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;

public class JsonHierarchicalStreamWriter
implements ExtendedHierarchicalStreamWriter {
    private final QuickWriter writer;
    private final FastStack elementStack = new FastStack(16);
    private final char[] lineIndenter;
    private int depth;
    private boolean readyForNewLine;
    private boolean tagIsEmpty;
    private String newLine;

    public JsonHierarchicalStreamWriter(Writer writer, char[] lineIndenter, String newLine) {
        this.writer = new QuickWriter(writer);
        this.lineIndenter = lineIndenter;
        this.newLine = newLine;
    }

    public JsonHierarchicalStreamWriter(Writer writer, char[] lineIndenter) {
        this(writer, lineIndenter, "\n");
    }

    public JsonHierarchicalStreamWriter(Writer writer, String lineIndenter, String newLine) {
        this(writer, lineIndenter.toCharArray(), newLine);
    }

    public JsonHierarchicalStreamWriter(Writer writer, String lineIndenter) {
        this(writer, lineIndenter.toCharArray());
    }

    public JsonHierarchicalStreamWriter(Writer writer) {
        this(writer, new char[]{' ', ' '});
    }

    @Override
    public void startNode(String name) {
        this.startNode(name, null);
    }

    @Override
    public void startNode(String name, Class clazz) {
        Node currNode = (Node)this.elementStack.peek();
        if (currNode == null) {
            this.writer.write("{");
        }
        if (currNode != null && currNode.fieldAlready) {
            this.writer.write(",");
            this.readyForNewLine = true;
        }
        this.tagIsEmpty = false;
        this.finishTag();
        if (currNode == null || currNode.clazz == null || currNode.clazz != null && !currNode.isCollection) {
            if (currNode != null && !currNode.fieldAlready) {
                this.writer.write("{");
                this.readyForNewLine = true;
                this.finishTag();
            }
            this.writer.write("\"");
            this.writer.write(name);
            this.writer.write("\": ");
        }
        if (this.isCollection(clazz)) {
            this.writer.write("[");
            this.readyForNewLine = true;
        }
        if (currNode != null) {
            currNode.fieldAlready = true;
        }
        this.elementStack.push(new Node(name, clazz));
        ++this.depth;
        this.tagIsEmpty = true;
    }

    @Override
    public void setValue(String text) {
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
        this.finishTag();
        this.writeText(this.writer, text);
    }

    @Override
    public void addAttribute(String key, String value) {
        Node currNode = (Node)this.elementStack.peek();
        if (currNode == null || !currNode.isCollection) {
            this.startNode('@' + key, String.class);
            this.tagIsEmpty = false;
            this.writeText(value, String.class);
            this.endNode();
        }
    }

    protected void writeAttributeValue(QuickWriter writer, String text) {
        this.writeText(text, null);
    }

    protected void writeText(QuickWriter writer, String text) {
        Node foo = (Node)this.elementStack.peek();
        this.writeText(text, foo.clazz);
    }

    private void writeText(String text, Class clazz) {
        if (this.needsQuotes(clazz)) {
            this.writer.write("\"");
        }
        if ((clazz == Character.class || clazz == Character.TYPE) && "".equals(text)) {
            text = "\u0000";
        }
        int length = text.length();
        block4: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\"': {
                    this.writer.write("\\\"");
                    continue block4;
                }
                case '\\': {
                    this.writer.write("\\\\");
                    continue block4;
                }
                default: {
                    if (c > '\u001f') {
                        this.writer.write(c);
                        continue block4;
                    }
                    this.writer.write("\\u");
                    String hex = "000" + Integer.toHexString(c);
                    this.writer.write(hex.substring(hex.length() - 4));
                }
            }
        }
        if (this.needsQuotes(clazz)) {
            this.writer.write("\"");
        }
    }

    private boolean isCollection(Class clazz) {
        return clazz != null && (Collection.class.isAssignableFrom(clazz) || clazz.isArray() || Map.class.isAssignableFrom(clazz) || Map.Entry.class.isAssignableFrom(clazz));
    }

    private boolean needsQuotes(Class clazz) {
        clazz = clazz != null && clazz.isPrimitive() ? clazz : Primitives.unbox(clazz);
        return clazz == null || clazz == Character.TYPE;
    }

    @Override
    public void endNode() {
        --this.depth;
        Node node = (Node)this.elementStack.pop();
        if (node.clazz != null && node.isCollection) {
            if (node.fieldAlready) {
                this.readyForNewLine = true;
            }
            this.finishTag();
            this.writer.write("]");
        } else if (this.tagIsEmpty) {
            this.readyForNewLine = false;
            this.writer.write("{}");
            this.finishTag();
        } else {
            this.finishTag();
            if (node.fieldAlready) {
                this.writer.write("}");
            }
        }
        this.readyForNewLine = true;
        if (this.depth == 0) {
            this.writer.write("}");
            this.writer.flush();
        }
    }

    private void finishTag() {
        if (this.readyForNewLine) {
            this.endOfLine();
        }
        this.readyForNewLine = false;
        this.tagIsEmpty = false;
    }

    protected void endOfLine() {
        this.writer.write(this.newLine);
        for (int i = 0; i < this.depth; ++i) {
            this.writer.write(this.lineIndenter);
        }
    }

    @Override
    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @Override
    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }

    public class Node {
        public final String name;
        public final Class clazz;
        public boolean fieldAlready;
        public boolean isCollection;

        public Node(String name, Class clazz) {
            this.name = name;
            this.clazz = clazz;
            this.isCollection = JsonHierarchicalStreamWriter.this.isCollection(clazz);
        }
    }
}

