/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.alias.ClassMapper;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.CannotResolveClassException;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.Mapper;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.Arrays;
import java.util.Collection;

public class ArrayMapper
extends MapperWrapper {
    private static final Collection BOXED_TYPES = Arrays.asList(Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class);

    public ArrayMapper(Mapper wrapped) {
        super(wrapped);
    }

    public ArrayMapper(ClassMapper wrapped) {
        this((Mapper)wrapped);
    }

    @Override
    public String serializedClass(Class type) {
        StringBuffer arraySuffix = new StringBuffer();
        while (type.isArray()) {
            type = type.getComponentType();
            arraySuffix.append("-array");
        }
        String name = this.boxedTypeName(type);
        if (name == null) {
            name = super.serializedClass(type);
        }
        if (arraySuffix.length() > 0) {
            return name + arraySuffix;
        }
        return name;
    }

    @Override
    public Class realClass(String elementName) {
        int dimensions = 0;
        while (elementName.endsWith("-array")) {
            elementName = elementName.substring(0, elementName.length() - 6);
            ++dimensions;
        }
        if (dimensions > 0) {
            Class componentType = this.primitiveClassNamed(elementName);
            if (componentType == null) {
                componentType = super.realClass(elementName);
            }
            try {
                return this.arrayType(dimensions, componentType);
            }
            catch (ClassNotFoundException e) {
                throw new CannotResolveClassException(elementName + " : " + e.getMessage());
            }
        }
        return super.realClass(elementName);
    }

    private Class arrayType(int dimensions, Class componentType) throws ClassNotFoundException {
        StringBuffer className = new StringBuffer();
        for (int i = 0; i < dimensions; ++i) {
            className.append('[');
        }
        if (componentType.isPrimitive()) {
            className.append(this.charThatJavaUsesToRepresentPrimitiveArrayType(componentType));
            return Class.forName(className.toString());
        }
        className.append('L').append(componentType.getName()).append(';');
        return Class.forName(className.toString(), false, componentType.getClassLoader());
    }

    private Class primitiveClassNamed(String name) {
        return name.equals("void") ? Void.TYPE : (name.equals("boolean") ? Boolean.TYPE : (name.equals("byte") ? Byte.TYPE : (name.equals("char") ? Character.TYPE : (name.equals("short") ? Short.TYPE : (name.equals("int") ? Integer.TYPE : (name.equals("long") ? Long.TYPE : (name.equals("float") ? Float.TYPE : (name.equals("double") ? Double.TYPE : null))))))));
    }

    private char charThatJavaUsesToRepresentPrimitiveArrayType(Class primvCls) {
        return (char)(primvCls == Boolean.TYPE ? 90 : (primvCls == Byte.TYPE ? 66 : (primvCls == Character.TYPE ? 67 : (primvCls == Short.TYPE ? 83 : (primvCls == Integer.TYPE ? 73 : (primvCls == Long.TYPE ? 74 : (primvCls == Float.TYPE ? 70 : (primvCls == Double.TYPE ? 68 : 0))))))));
    }

    private String boxedTypeName(Class type) {
        return BOXED_TYPES.contains(type) ? type.getName() : null;
    }
}

