/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper;

import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.alias.ClassMapper;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.Mapper;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FieldAliasingMapper
extends MapperWrapper {
    protected final Map fieldToAliasMap = new HashMap();
    protected final Map aliasToFieldMap = new HashMap();
    protected final Set fieldsToOmit = new HashSet();

    public FieldAliasingMapper(Mapper wrapped) {
        super(wrapped);
    }

    public FieldAliasingMapper(ClassMapper wrapped) {
        this((Mapper)wrapped);
    }

    public void addFieldAlias(String alias, Class type, String fieldName) {
        this.fieldToAliasMap.put(this.key(type, fieldName), alias);
        this.aliasToFieldMap.put(this.key(type, alias), fieldName);
    }

    private Object key(Class type, String name) {
        return type.getName() + ':' + name;
    }

    @Override
    public String serializedMember(Class type, String memberName) {
        String alias = this.getMember(type, memberName, this.fieldToAliasMap);
        if (alias == null) {
            return super.serializedMember(type, memberName);
        }
        return alias;
    }

    @Override
    public String realMember(Class type, String serialized) {
        String real = this.getMember(type, serialized, this.aliasToFieldMap);
        if (real == null) {
            return super.realMember(type, serialized);
        }
        return real;
    }

    private String getMember(Class type, String name, Map map) {
        String member = null;
        for (Class declaringType = type; member == null && declaringType != Object.class; declaringType = declaringType.getSuperclass()) {
            member = (String)map.get(this.key(declaringType, name));
        }
        return member;
    }

    @Override
    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
        return !this.fieldsToOmit.contains(this.key(definedIn, fieldName));
    }

    public void omitField(Class definedIn, String fieldName) {
        this.fieldsToOmit.add(this.key(definedIn, fieldName));
    }
}

