/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.morphString;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.codec.binary.Base64;
import edu.internet2.middleware.morphString.Morph;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    private static final ThreadLocal<Crypto> threadLocalCrypto = new ThreadLocal();
    private SecretKeySpec key;
    private Cipher cipher = null;
    private static boolean warned = false;

    public static Crypto getThreadLocalCrypto() {
        Crypto crypto = threadLocalCrypto.get();
        if (crypto == null) {
            crypto = new Crypto();
            threadLocalCrypto.set(crypto);
        }
        return crypto;
    }

    public static byte[] generateKeyBytes(String cipherName, Integer keybits) {
        KeyGenerator keyGenerator = null;
        cipherName = cipherName == null ? "AES" : cipherName;
        try {
            keyGenerator = KeyGenerator.getInstance(cipherName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to create KeyGenerator for cipherName=" + cipherName, e);
        }
        keyGenerator.init(keybits == null ? 128 : keybits);
        SecretKey secretKey = keyGenerator.generateKey();
        byte[] keyBytes = secretKey.getEncoded();
        return keyBytes;
    }

    public Cipher createDefaultCipher() {
        try {
            return Cipher.getInstance("AES");
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to create the default cipher!", x);
        }
    }

    public Crypto() {
        this(Morph.key());
    }

    public Crypto(String theKey) {
        this.init(theKey);
    }

    protected void init(String secret) {
        if (GrouperClientUtils.isBlank(secret)) {
            throw new NullPointerException("Must supply a non blank encrypt.key");
        }
        StringBuilder secretBuilder = new StringBuilder(secret);
        if (!warned && secret.length() < 8) {
            System.out.println("morphString warning: secret.key in morphString.properties should be at least 8 chars");
            warned = true;
        }
        while (secretBuilder.length() < 16) {
            secretBuilder.append("x");
        }
        if (secretBuilder.length() > 16) {
            while (secretBuilder.length() < 32) {
                secretBuilder.append("x");
            }
        }
        if (secretBuilder.length() > 32) {
            secretBuilder.delete(32, secretBuilder.length());
        }
        secret = secretBuilder.toString();
        this.key = new SecretKeySpec(secret.getBytes(), "AES");
        this.cipher = this.createDefaultCipher();
    }

    public String encrypt(String clearText) {
        byte[] input = clearText.getBytes();
        try {
            this.initCipher(true);
            byte[] output = this.cipher.doFinal(input);
            byte[] encoded = Base64.encodeBase64(output);
            return new String(encoded);
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to encrypt string", x);
        }
    }

    public String decrypt(String cipherText) {
        try {
            byte[] cipherBytes = cipherText.getBytes();
            byte[] decodedBytes = Base64.decodeBase64(cipherBytes);
            this.initCipher(false);
            byte[] clearBytes = this.cipher.doFinal(decodedBytes);
            return new String(clearBytes);
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to decrypt the cipherText", x);
        }
    }

    private void initCipher(boolean encrypt) {
        try {
            if (encrypt) {
                this.cipher.init(1, this.key);
            } else {
                this.cipher.init(2, this.key);
            }
        }
        catch (Exception x) {
            throw new RuntimeException("Failed to init cipher for " + (encrypt ? "encrypt" : "decrypt"), x);
        }
    }

    public InputStream encrypt(InputStream in) {
        this.initCipher(true);
        return new CipherInputStream(in, this.cipher);
    }

    public InputStream decrypt(InputStream in) {
        this.initCipher(false);
        return new CipherInputStream(in, this.cipher);
    }

    public OutputStream encrypt(OutputStream out) {
        this.initCipher(true);
        return new CipherOutputStream(out, this.cipher);
    }

    public OutputStream decrypt(OutputStream out) {
        this.initCipher(false);
        return new CipherOutputStream(out, this.cipher);
    }
}

