/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.attribute;

import edu.psu.swe.scim.spec.validator.Urn;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class AttributeReference
implements Serializable {
    private static final long serialVersionUID = -3559538009692681470L;
    @Urn
    String urn;
    String[] attributeName;

    protected AttributeReference() {
    }

    public AttributeReference(String attributeReference) {
        String substringBeforeLast = StringUtils.substringBeforeLast((String)attributeReference, (String)":");
        String substringAfterLast = StringUtils.substringAfterLast((String)attributeReference, (String)":");
        if (StringUtils.isEmpty((CharSequence)substringAfterLast)) {
            this.urn = null;
            this.attributeName = this.parseAttributeName(substringBeforeLast);
        } else {
            this.urn = substringBeforeLast;
            this.attributeName = this.parseAttributeName(substringAfterLast);
        }
    }

    public AttributeReference(String urn, String attributeName) {
        this.urn = urn;
        this.attributeName = this.parseAttributeName(attributeName);
    }

    private String[] parseAttributeName(String attributeName) {
        return StringUtils.split((String)attributeName, (String)".");
    }

    public String getFullAttributeName() {
        return StringUtils.join((Object[])this.attributeName, (String)".");
    }

    public String getFullyQualifiedAttributeName() {
        StringBuilder sb = new StringBuilder();
        if (this.urn != null) {
            sb.append(this.urn);
        }
        if (this.urn != null && this.attributeName != null) {
            sb.append(":");
        }
        if (this.attributeName != null) {
            sb.append(StringUtils.join((Object[])this.attributeName, (String)"."));
        }
        return sb.toString();
    }

    public String getAttributeBase() {
        return (this.urn != null ? this.urn + ":" : "") + (this.attributeName != null ? StringUtils.join((Object[])this.attributeName, (String)".", (int)0, (int)(this.attributeName.length - 1)) : "");
    }

    public String getUrn() {
        return this.urn;
    }

    public String[] getAttributeName() {
        return this.attributeName;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public void setAttributeName(String[] attributeName) {
        this.attributeName = attributeName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeReference)) {
            return false;
        }
        AttributeReference other = (AttributeReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$urn = this.getUrn();
        String other$urn = other.getUrn();
        if (this$urn == null ? other$urn != null : !this$urn.equals(other$urn)) {
            return false;
        }
        return Arrays.deepEquals(this.getAttributeName(), other.getAttributeName());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AttributeReference;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $urn = this.getUrn();
        result = result * 59 + ($urn == null ? 43 : $urn.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAttributeName());
        return result;
    }

    public String toString() {
        return "AttributeReference(urn=" + this.getUrn() + ", attributeName=" + Arrays.deepToString(this.getAttributeName()) + ")";
    }
}

