/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.data;

import edu.psu.swe.scim.server.filter.FilterParser;
import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.filter.ExpressionBuildingListener;
import edu.psu.swe.scim.spec.protocol.filter.ValueFilterExpression;
import edu.psu.swe.scim.spec.protocol.filter.ValuePathExpression;
import java.util.List;
import org.antlr.v4.runtime.Token;

public class PatchPathListener
extends ExpressionBuildingListener {
    private AttributeReference attributeReference;
    private ValueFilterExpression valueFilter;
    private String[] subAttributes;

    @Override
    public void exitPatchPath(FilterParser.PatchPathContext ctx) {
        List<Token> subAttributeTokens;
        super.exitPatchPath(ctx);
        Token attributeReferenceToken = ctx.attrPath;
        if (attributeReferenceToken != null) {
            String attrPath = attributeReferenceToken.getText();
            this.attributeReference = new AttributeReference(attrPath);
        }
        if ((subAttributeTokens = ctx.subAttr) != null) {
            this.subAttributes = new String[subAttributeTokens.size()];
            int i = 0;
            for (Token subAttributeToken : subAttributeTokens) {
                String subAttr = subAttributeToken.getText();
                this.subAttributes[i] = subAttr.substring(1);
                ++i;
            }
        }
    }

    @Override
    public void exitValuePath(FilterParser.ValuePathContext ctx) {
        super.exitValuePath(ctx);
        ValuePathExpression valuePathExpression = (ValuePathExpression)this.getFilterExpression();
        this.attributeReference = valuePathExpression.getAttributePath();
        this.valueFilter = valuePathExpression.getValueFilter();
    }

    public AttributeReference getAttributeReference() {
        return this.attributeReference;
    }

    public ValueFilterExpression getValueFilter() {
        return this.valueFilter;
    }

    public String[] getSubAttributes() {
        return this.subAttributes;
    }
}

